/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"


static GnomeCmdStringDialogClass *parent_class = NULL;



static void
on_ok (gchar *string, GnomeCmdCvsCheckoutDialog *dialog)
{
}


/*******************************
 * Gtk class implementation
 *******************************/

static void
destroy (GtkObject *object)
{
	if (GTK_OBJECT_CLASS (parent_class)->destroy)
		(*GTK_OBJECT_CLASS (parent_class)->destroy) (object);
}


static void
map (GtkWidget *widget)
{
	if (GTK_WIDGET_CLASS (parent_class)->map != NULL)
		GTK_WIDGET_CLASS (parent_class)->map (widget);
}


static void
class_init (GnomeCmdCvsCheckoutDialogClass *class)
{
	GtkObjectClass *object_class;
	GtkWidgetClass *widget_class;

	object_class = GTK_OBJECT_CLASS (class);
	widget_class = GTK_WIDGET_CLASS (class);

	parent_class = gtk_type_class (gnome_cmd_string_dialog_get_type ());
	object_class->destroy = destroy;
	widget_class->map = map;
}


static void
init (GnomeCmdCvsCheckoutDialog *dialog)
{
}




/***********************************
 * Public functions
 ***********************************/

GtkWidget*
gnome_cmd_cvs_checkout_dialog_new ()
{	
	GnomeCmdCvsCheckoutDialog *dialog = gtk_type_new (gnome_cmd_cvs_checkout_dialog_get_type ());

	gnome_cmd_string_dialog_set_title (GNOME_CMD_STRING_DIALOG (dialog), _("CVS Checkout"));
	gnome_cmd_string_dialog_set_prompt (GNOME_CMD_STRING_DIALOG (dialog), _("Enter the name of the module"));
	gnome_cmd_string_dialog_set_pixmap (GNOME_CMD_STRING_DIALOG (dialog), PIXMAP_CVS_FISH_SMALL);
	gnome_cmd_string_dialog_set_ok_cb (GNOME_CMD_STRING_DIALOG (dialog), (GnomeStringCallback)on_ok);
	
	return GTK_WIDGET (dialog);
}



GtkType
gnome_cmd_cvs_checkout_dialog_get_type         (void)
{
	static GtkType dlg_type = 0;

	if (dlg_type == 0)
	{
		GtkTypeInfo dlg_info =
		{
			"GnomeCmdCvsCheckoutDialog",
			sizeof (GnomeCmdCvsCheckoutDialog),
			sizeof (GnomeCmdCvsCheckoutDialogClass),
			(GtkClassInitFunc) class_init,
			(GtkObjectInitFunc) init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		dlg_type = gtk_type_unique (gnome_cmd_string_dialog_get_type (), &dlg_info);
	}
	return dlg_type;
}

