/* RecordingReader.c generated by valac, the Vala compiler
 * generated from RecordingReader.vala, do not modify */

/*
 * Copyright (C) 2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <time.h>


#define DVB_IO_TYPE_RECORDING_READER (dvb_io_recording_reader_get_type ())
#define DVB_IO_RECORDING_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReader))
#define DVB_IO_RECORDING_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReaderClass))
#define DVB_IO_IS_RECORDING_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_RECORDING_READER))
#define DVB_IO_IS_RECORDING_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_RECORDING_READER))
#define DVB_IO_RECORDING_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReaderClass))

typedef struct _DVBioRecordingReader DVBioRecordingReader;
typedef struct _DVBioRecordingReaderClass DVBioRecordingReaderClass;
typedef struct _DVBioRecordingReaderPrivate DVBioRecordingReaderPrivate;

#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_RECORDING (dvb_recording_get_type ())
#define DVB_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDING, DVBRecording))
#define DVB_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDING, DVBRecordingClass))
#define DVB_IS_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDING))
#define DVB_IS_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDING))
#define DVB_RECORDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDING, DVBRecordingClass))

typedef struct _DVBRecording DVBRecording;
typedef struct _DVBRecordingClass DVBRecordingClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _DVBioRecordingReader {
	GObject parent_instance;
	DVBioRecordingReaderPrivate * priv;
};

struct _DVBioRecordingReaderClass {
	GObjectClass parent_class;
};

struct _DVBioRecordingReaderPrivate {
	GFile* _directory;
	DVBRecordingsStore* _store;
};


static gpointer dvb_io_recording_reader_parent_class = NULL;

GType dvb_io_recording_reader_get_type (void);
GType dvb_recordings_store_get_type (void);
#define DVB_IO_RECORDING_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReaderPrivate))
enum  {
	DVB_IO_RECORDING_READER_DUMMY_PROPERTY,
	DVB_IO_RECORDING_READER_DIRECTORY,
	DVB_IO_RECORDING_READER_STORE
};
#define DVB_IO_RECORDING_READER_ATTRS G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_NAME
DVBioRecordingReader* dvb_io_recording_reader_new (GFile* recordingsbasedir, DVBRecordingsStore* recstore);
DVBioRecordingReader* dvb_io_recording_reader_construct (GType object_type, GFile* recordingsbasedir, DVBRecordingsStore* recstore);
GFile* dvb_io_recording_reader_get_directory (DVBioRecordingReader* self);
static gboolean dvb_io_recording_reader_restore_from_dir (DVBioRecordingReader* self, GFile* recordingsbasedir);
gboolean dvb_io_recording_reader_load_into (DVBioRecordingReader* self);
static gboolean dvb_io_recording_reader_is_readable_dir (GFile* directory);
GType dvb_recording_get_type (void);
DVBRecording* dvb_io_recording_reader_deserialize (DVBioRecordingReader* self, GFile* file, GError** error);
DVBRecordingsStore* dvb_io_recording_reader_get_store (DVBioRecordingReader* self);
gboolean dvb_recordings_store_add_and_monitor (DVBRecordingsStore* self, DVBRecording* rec);
DVBRecording* dvb_recording_new (void);
DVBRecording* dvb_recording_construct (GType object_type);
void dvb_recording_set_Id (DVBRecording* self, guint32 value);
void dvb_recording_set_ChannelName (DVBRecording* self, const char* value);
void dvb_recording_set_Location (DVBRecording* self, GFile* value);
void dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result);
void dvb_recording_set_StartTime (DVBRecording* self, struct tm* value);
void dvb_recording_set_Length (DVBRecording* self, gint64 value);
void dvb_recording_set_Name (DVBRecording* self, const char* value);
void dvb_recording_set_Description (DVBRecording* self, const char* value);
static void dvb_io_recording_reader_set_directory (DVBioRecordingReader* self, GFile* value);
static void dvb_io_recording_reader_set_store (DVBioRecordingReader* self, DVBRecordingsStore* value);
static void dvb_io_recording_reader_finalize (GObject* obj);
static void dvb_io_recording_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_io_recording_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



DVBioRecordingReader* dvb_io_recording_reader_construct (GType object_type, GFile* recordingsbasedir, DVBRecordingsStore* recstore) {
	DVBioRecordingReader * self;
	g_return_val_if_fail (recordingsbasedir != NULL, NULL);
	g_return_val_if_fail (recstore != NULL, NULL);
	self = (DVBioRecordingReader*) g_object_new (object_type, "directory", recordingsbasedir, "store", recstore, NULL);
	return self;
}


DVBioRecordingReader* dvb_io_recording_reader_new (GFile* recordingsbasedir, DVBRecordingsStore* recstore) {
	return dvb_io_recording_reader_construct (DVB_IO_TYPE_RECORDING_READER, recordingsbasedir, recstore);
}


gboolean dvb_io_recording_reader_load_into (DVBioRecordingReader* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!g_file_query_exists (self->priv->_directory, NULL)) {
		char* _tmp0_;
		g_debug ("RecordingReader.vala:45: Directory %s does not exist", _tmp0_ = g_file_get_path (self->priv->_directory));
		_g_free0 (_tmp0_);
		result = FALSE;
		return result;
	}
	result = dvb_io_recording_reader_restore_from_dir (self, self->priv->_directory);
	return result;
}


static gboolean dvb_io_recording_reader_is_readable_dir (GFile* directory) {
	gboolean result = FALSE;
	GError * _inner_error_;
	GFileInfo* info;
	g_return_val_if_fail (directory != NULL, FALSE);
	_inner_error_ = NULL;
	info = NULL;
	{
		GFileInfo* _tmp0_;
		GFileInfo* _tmp1_;
		_tmp0_ = g_file_query_info (directory, DVB_IO_RECORDING_READER_ATTRS, 0, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		info = (_tmp1_ = _tmp0_, _g_object_unref0 (info), _tmp1_);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("RecordingReader.vala:57: Could not retrieve attributes: %s", e->message);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (info);
			return result;
		}
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	if (g_file_info_get_file_type (info) != G_FILE_TYPE_DIRECTORY) {
		char* _tmp2_;
		g_critical ("RecordingReader.vala:62: %s is not a directory", _tmp2_ = g_file_get_path (directory));
		_g_free0 (_tmp2_);
		result = FALSE;
		_g_object_unref0 (info);
		return result;
	}
	if (!g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_READ)) {
		char* _tmp3_;
		g_critical ("RecordingReader.vala:67: Cannot read %s", _tmp3_ = g_file_get_path (directory));
		_g_free0 (_tmp3_);
		result = FALSE;
		_g_object_unref0 (info);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (info);
	return result;
}


static gboolean dvb_io_recording_reader_restore_from_dir (DVBioRecordingReader* self, GFile* recordingsbasedir) {
	gboolean result = FALSE;
	GError * _inner_error_;
	GFileEnumerator* files;
	gboolean success;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (recordingsbasedir != NULL, FALSE);
	_inner_error_ = NULL;
	if (!dvb_io_recording_reader_is_readable_dir (recordingsbasedir)) {
		result = FALSE;
		return result;
	}
	files = NULL;
	{
		GFileEnumerator* _tmp0_;
		GFileEnumerator* _tmp1_;
		_tmp0_ = g_file_enumerate_children (recordingsbasedir, DVB_IO_RECORDING_READER_ATTRS, 0, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		files = (_tmp1_ = _tmp0_, _g_object_unref0 (files), _tmp1_);
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("RecordingReader.vala:83: Could not read directory: %s", e->message);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (files);
			return result;
		}
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (files);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	success = TRUE;
	{
		GFileInfo* childinfo;
		childinfo = NULL;
		while (TRUE) {
			GFileInfo* _tmp2_;
			GFileInfo* _tmp3_;
			guint32 type;
			GFile* child;
			_tmp2_ = g_file_enumerator_next_file (files, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (childinfo);
				goto __catch11_g_error;
			}
			if (!((childinfo = (_tmp3_ = _tmp2_, _g_object_unref0 (childinfo), _tmp3_)) != NULL)) {
				break;
			}
			type = g_file_info_get_attribute_uint32 (childinfo, G_FILE_ATTRIBUTE_STANDARD_TYPE);
			child = g_file_get_child (recordingsbasedir, g_file_info_get_name (childinfo));
			switch (type) {
				case G_FILE_TYPE_DIRECTORY:
				{
					dvb_io_recording_reader_restore_from_dir (self, child);
					break;
				}
				case G_FILE_TYPE_REGULAR:
				{
					if (_vala_strcmp0 (g_file_info_get_name (childinfo), "info.rec") == 0) {
						DVBRecording* rec;
						rec = NULL;
						{
							DVBRecording* _tmp4_;
							DVBRecording* _tmp5_;
							_tmp4_ = dvb_io_recording_reader_deserialize (self, child, &_inner_error_);
							if (_inner_error_ != NULL) {
								goto __catch13_g_error;
							}
							rec = (_tmp5_ = _tmp4_, _g_object_unref0 (rec), _tmp5_);
						}
						goto __finally13;
						__catch13_g_error:
						{
							GError * e;
							e = _inner_error_;
							_inner_error_ = NULL;
							{
								g_critical ("RecordingReader.vala:108: Could not deserialize recording: %s", e->message);
								_g_error_free0 (e);
							}
						}
						__finally13:
						if (_inner_error_ != NULL) {
							_g_object_unref0 (rec);
							_g_object_unref0 (child);
							_g_object_unref0 (childinfo);
							goto __catch11_g_error;
						}
						if (rec != NULL) {
							char* _tmp6_;
							g_debug ("RecordingReader.vala:113: Restored recording from %s", _tmp6_ = g_file_get_path (child));
							_g_free0 (_tmp6_);
							dvb_recordings_store_add_and_monitor (self->priv->_store, rec);
						}
						_g_object_unref0 (rec);
					}
					break;
				}
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (childinfo);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("RecordingReader.vala:124: %s", e->message);
			success = FALSE;
			_g_error_free0 (e);
		}
	}
	__finally11:
	{
		{
			g_file_enumerator_close (files, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch12_g_error;
			}
		}
		goto __finally12;
		__catch12_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("RecordingReader.vala:130: Could not close file: %s", e->message);
				success = FALSE;
				_g_error_free0 (e);
			}
		}
		__finally12:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (files);
		}
	}
	if (_inner_error_ != NULL) {
		_g_object_unref0 (files);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = success;
	_g_object_unref0 (files);
	return result;
}


DVBRecording* dvb_io_recording_reader_deserialize (DVBioRecordingReader* self, GFile* file, GError** error) {
	DVBRecording* result = NULL;
	GError * _inner_error_;
	GFileInputStream* _tmp0_;
	GFileInputStream* _tmp1_;
	GDataInputStream* _tmp2_;
	GDataInputStream* reader;
	char* line;
	gsize len = 0UL;
	gint line_number;
	DVBRecording* rec;
	GString* description;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_inner_error_ = NULL;
	_tmp0_ = g_file_read (file, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	reader = (_tmp2_ = g_data_input_stream_new ((GInputStream*) (_tmp1_ = _tmp0_)), _g_object_unref0 (_tmp1_), _tmp2_);
	line = NULL;
	line_number = 0;
	rec = dvb_recording_new ();
	description = g_string_new ("");
	while (TRUE) {
		char* _tmp3_;
		char* _tmp4_;
		_tmp3_ = g_data_input_stream_read_line (reader, &len, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (reader);
			_g_free0 (line);
			_g_object_unref0 (rec);
			_g_string_free0 (description);
			return NULL;
		}
		if (!((line = (_tmp4_ = _tmp3_, _g_free0 (line), _tmp4_)) != NULL)) {
			break;
		}
		switch (line_number) {
			case 0:
			{
				dvb_recording_set_Id (rec, (guint32) atoi (line));
				break;
			}
			case 1:
			{
				dvb_recording_set_ChannelName (rec, line);
				break;
			}
			case 2:
			{
				GFile* _tmp5_;
				_tmp5_ = NULL;
				if (len == 0) {
					GFile* _tmp6_;
					_tmp5_ = (_tmp6_ = NULL, _g_object_unref0 (_tmp5_), _tmp6_);
				} else {
					GFile* _tmp7_;
					_tmp5_ = (_tmp7_ = g_file_new_for_path (line), _g_object_unref0 (_tmp5_), _tmp7_);
				}
				dvb_recording_set_Location (rec, _tmp5_);
				_g_object_unref0 (_tmp5_);
				break;
			}
			case 3:
			{
				{
					gint year;
					gint month;
					gint day;
					gint hour;
					gint minute;
					gboolean _tmp8_ = FALSE;
					gboolean _tmp9_ = FALSE;
					gboolean _tmp10_ = FALSE;
					gboolean _tmp11_ = FALSE;
					year = 0;
					month = 0;
					day = 0;
					hour = 0;
					minute = 0;
					sscanf (line, "%d-%d-%d %d:%d", &year, &month, &day, &hour, &minute);
					if (year >= 1900) {
						_tmp11_ = month >= 1;
					} else {
						_tmp11_ = FALSE;
					}
					if (_tmp11_) {
						_tmp10_ = day >= 1;
					} else {
						_tmp10_ = FALSE;
					}
					if (_tmp10_) {
						_tmp9_ = hour >= 0;
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						_tmp8_ = minute >= 0;
					} else {
						_tmp8_ = FALSE;
					}
					if (_tmp8_) {
						struct tm _tmp12_ = {0};
						struct tm _tmp13_;
						dvb_recording_set_StartTime (rec, (_tmp13_ = (dvb_utils_create_time (year, month, day, hour, minute, 0, &_tmp12_), _tmp12_), &_tmp13_));
					}
					break;
				}
			}
			case 4:
			{
				dvb_recording_set_Length (rec, (gint64) atoi (line));
				break;
			}
			case 5:
			{
				const char* _tmp14_;
				_tmp14_ = NULL;
				if (len == 0) {
					_tmp14_ = NULL;
				} else {
					_tmp14_ = line;
				}
				dvb_recording_set_Name (rec, _tmp14_);
				break;
			}
			default:
			{
				g_string_append (description, line);
				break;
			}
		}
		line_number++;
	}
	g_input_stream_close ((GInputStream*) reader, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (reader);
		_g_free0 (line);
		_g_object_unref0 (rec);
		_g_string_free0 (description);
		return NULL;
	}
	dvb_recording_set_Description (rec, description->str);
	result = rec;
	_g_object_unref0 (reader);
	_g_free0 (line);
	_g_string_free0 (description);
	return result;
}


GFile* dvb_io_recording_reader_get_directory (DVBioRecordingReader* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_directory;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_io_recording_reader_set_directory (DVBioRecordingReader* self, GFile* value) {
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_directory = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_directory), _tmp0_);
	g_object_notify ((GObject *) self, "directory");
}


DVBRecordingsStore* dvb_io_recording_reader_get_store (DVBioRecordingReader* self) {
	DVBRecordingsStore* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_store;
	return result;
}


static void dvb_io_recording_reader_set_store (DVBioRecordingReader* self, DVBRecordingsStore* value) {
	DVBRecordingsStore* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_store = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_store), _tmp0_);
	g_object_notify ((GObject *) self, "store");
}


static void dvb_io_recording_reader_class_init (DVBioRecordingReaderClass * klass) {
	dvb_io_recording_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBioRecordingReaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_io_recording_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_io_recording_reader_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_io_recording_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_RECORDING_READER_DIRECTORY, g_param_spec_object ("directory", "directory", "directory", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_RECORDING_READER_STORE, g_param_spec_object ("store", "store", "store", DVB_TYPE_RECORDINGS_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_io_recording_reader_instance_init (DVBioRecordingReader * self) {
	self->priv = DVB_IO_RECORDING_READER_GET_PRIVATE (self);
}


static void dvb_io_recording_reader_finalize (GObject* obj) {
	DVBioRecordingReader * self;
	self = DVB_IO_RECORDING_READER (obj);
	_g_object_unref0 (self->priv->_directory);
	_g_object_unref0 (self->priv->_store);
	G_OBJECT_CLASS (dvb_io_recording_reader_parent_class)->finalize (obj);
}


GType dvb_io_recording_reader_get_type (void) {
	static volatile gsize dvb_io_recording_reader_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_io_recording_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBioRecordingReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_io_recording_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBioRecordingReader), 0, (GInstanceInitFunc) dvb_io_recording_reader_instance_init, NULL };
		GType dvb_io_recording_reader_type_id;
		dvb_io_recording_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBioRecordingReader", &g_define_type_info, 0);
		g_once_init_leave (&dvb_io_recording_reader_type_id__volatile, dvb_io_recording_reader_type_id);
	}
	return dvb_io_recording_reader_type_id__volatile;
}


static void dvb_io_recording_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBioRecordingReader * self;
	self = DVB_IO_RECORDING_READER (object);
	switch (property_id) {
		case DVB_IO_RECORDING_READER_DIRECTORY:
		g_value_set_object (value, dvb_io_recording_reader_get_directory (self));
		break;
		case DVB_IO_RECORDING_READER_STORE:
		g_value_set_object (value, dvb_io_recording_reader_get_store (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_io_recording_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBioRecordingReader * self;
	self = DVB_IO_RECORDING_READER (object);
	switch (property_id) {
		case DVB_IO_RECORDING_READER_DIRECTORY:
		dvb_io_recording_reader_set_directory (self, g_value_get_object (value));
		break;
		case DVB_IO_RECORDING_READER_STORE:
		dvb_io_recording_reader_set_store (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




