/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* channel-list.h
 *
 * Copyright (C) 2005 Takuo KITAME.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * Author: Takuo KITAME.
 *
 */

#ifndef __CHANNEL_LIST_H__
#define __CHANNEL_LIST_H__

#include <gnome.h>
#include <glade/glade.h>

class ChannelList
{
public:
	ChannelList (GtkWidget *, GtkWindow *);
	~ChannelList (void) {
		debug_print (1, "Delete object: ChannelList");
		g_object_unref (popup_xml);
	}

	void setInfo (ChanInfo *);
	void deleteInfo (ChanInfo *);

	Channel *selectedChannel (void);
	GtkTreeSelection *getSelection () { return selection ; }

	/* Callbacks */
	static void play_cb (GtkWidget *, ChannelList *);
	static void info_cb (GtkWidget *, ChannelList *);
	static void url_cb  (GtkWidget *, ChannelList *);
	static void bump_cb (GtkWidget *, ChannelList *);
	static void stop_cb (GtkWidget *, ChannelList *);
	
	/* Actions */
	void playSelected (gboolean);
	void infoSelected (void);
	void urlSelected (void);
	void bumpSelected (void);
	void stopSelected (void);
	Channel *getPopupChannel (void);
	GtkWidget *getMenuItem (const gchar *name) {
		return glade_xml_get_widget (popup_xml, name); };
	void popupSignalConnect (const gchar *handler,
				 GCallback callback, gpointer data) {
		glade_xml_signal_connect_data (popup_xml, handler, callback, data);
	};

private:
	GtkWindow *parent;
	GladeXML *popup_xml;
	GtkTreeSelection *selection;
	GtkTreeView *treeview;
};

#endif
