/* $Id: rbgnome-util.c,v 1.2 2001/02/18 12:28:56 igarashi Exp $ */

#include "rbgnome.h"

static VALUE
rbgnome_libdir_file(self, filename)
    VALUE self, filename;
{
    char *file;
    VALUE ret;
    file = gnome_libdir_file(STR2CSTR(filename));
    ret = file != NULL ? rb_str_new2(file) : Qnil;
    g_free(file);
    return ret;
}

static VALUE
rbgnome_datadir_file(self, filename)
    VALUE self, filename;
{
    char *file;
    VALUE ret;
    file = gnome_datadir_file(STR2CSTR(filename));
    ret = file != NULL ? rb_str_new2(file) : Qnil;
    g_free(file);
    return ret;
}

static VALUE
rbgnome_sound_file(self, filename)
    VALUE self, filename;
{
    char *file;
    VALUE ret;
    file = gnome_sound_file(STR2CSTR(filename));
    ret = file != NULL ? rb_str_new2(file) : Qnil;
    g_free(file);
    return ret;
}

static VALUE
rbgnome_pixmap_file(self, filename)
    VALUE self, filename;
{
    char *file;
    VALUE ret;
    file = gnome_pixmap_file(STR2CSTR(filename));
    ret = file != NULL ? rb_str_new2(file) : Qnil;
    g_free(file);
    return ret;
}

static VALUE
rbgnome_config_file(self, filename)
    VALUE self, filename;
{
    char *file;
    VALUE ret;
    file = gnome_config_file(STR2CSTR(filename));
    ret = file != NULL ? rb_str_new2(file) : Qnil;
    g_free(file);
    return ret;
}

static VALUE
rbgnome_unconditional_libdir_file(self, filename)
    VALUE self, filename;
{
    char *file;
    VALUE ret;
    file = gnome_unconditional_libdir_file(STR2CSTR(filename));
    ret = file != NULL ? rb_str_new2(file) : Qnil;
    g_free(file);
    return ret;
}

static VALUE
rbgnome_unconditional_datadir_file(self, filename)
    VALUE self, filename;
{
    char *file;
    VALUE ret;
    file = gnome_unconditional_datadir_file(STR2CSTR(filename));
    ret = file != NULL ? rb_str_new2(file) : Qnil;
    g_free(file);
    return ret;
}

static VALUE
rbgnome_unconditional_sound_file(self, filename)
    VALUE self, filename;
{
    char *file;
    VALUE ret;
    file = gnome_unconditional_sound_file(STR2CSTR(filename));
    ret = file != NULL ? rb_str_new2(file) : Qnil;
    g_free(file);
    return ret;
}

static VALUE
rbgnome_unconditional_pixmap_file(self, filename)
    VALUE self, filename;
{
    char *file;
    VALUE ret;
    file = gnome_unconditional_pixmap_file(STR2CSTR(filename));
    ret = file != NULL ? rb_str_new2(file) : Qnil;
    g_free(file);
    return ret;
}

static VALUE
rbgnome_unconditional_config_file(self, filename)
    VALUE self, filename;
{
    char *file;
    VALUE ret;
    file = gnome_unconditional_config_file(STR2CSTR(filename));
    ret = file != NULL ? rb_str_new2(file) : Qnil;
    g_free(file);
    return ret;
}

void
Init_gnome_util()
{
    rb_define_module_function(mGnome, "libdir_file", rbgnome_libdir_file, 1);
    rb_define_module_function(mGnome, "datadir_file", rbgnome_datadir_file, 1);
    rb_define_module_function(mGnome, "sound_file", rbgnome_sound_file, 1);
    rb_define_module_function(mGnome, "pixmap_file", rbgnome_pixmap_file, 1);
    rb_define_module_function(mGnome, "config_file", rbgnome_config_file, 1);

    rb_define_module_function(mGnome, "unconditional_libdir_file",
			      rbgnome_unconditional_libdir_file, 1);
    rb_define_module_function(mGnome, "unconditional_datadir_file",
			      rbgnome_unconditional_datadir_file, 1);
    rb_define_module_function(mGnome, "unconditional_sound_file",
			      rbgnome_unconditional_sound_file, 1);
    rb_define_module_function(mGnome, "unconditional_pixmap_file",
			      rbgnome_unconditional_pixmap_file, 1);
    rb_define_module_function(mGnome, "unconditional_config_file",
			      rbgnome_unconditional_config_file, 1);
}

