/**
 ** dnd.c - drag and drop code
 **
 ** See GNOME documentation for more details.
 **
 ** Copyright (C) 2000 Matthew Pratt <mattpratt@yahoo.com>
 **
 ** This software is licensed under the terms of the GNU General 
 ** Public License (GPL). Please see the file LICENSE for details.
 **/ 

#include "gnomp3.h"
#include "playlist.h"
#include "song_list.h"
#include "utility.h"
#include "mp3info.h"
#include "mp3_control.h"

static GtkTargetEntry target_table[] = {
         { "text/uri-list", 0, 0 }
};


/* 
 * callback executed when a drop is recieved on the mp3 player. If a file is 
 * described then it is played 
*/
static void  
mp3_control_drop_received  (GtkWidget          *widget,
			    GdkDragContext     *context,
			    gint                x,
			    gint                y,
			    GtkSelectionData   *data,
			    guint               info,
			    guint               time)
{
    static MP3 mp3;

    g_print("Got: %s\n", data->data);
  
    if( !strncmp( data->data, "file:", 5) ){
	data->data += 5;
	g_strstrip(data->data);
	mp3.filename = data->data;
	//mp3_control_unhilight_playing();
	//FIXME mp3play_song(&mp3, 0);
  }

}

/* 
 * callback executed when a drop is recieved on the playlist. If a file is 
 * described then it is added to the playlist 
 */
static void  
playlist_drop_received  (GtkWidget          *widget,
			 GdkDragContext     *context,
			 gint                x,
			 gint                y,
			 GtkSelectionData   *data,
			 guint               info,
			 guint               time)
{
  char *ptr;
  char **tokens;
  int i;
  GList *mp3_node;
  
  g_print("Got: %s\n", data->data);

  tokens = g_strsplit( data->data, "\n", 0 ); 
  
  for( i = 0; tokens[i]; i++ ){
    ptr = tokens[i];
    if( !strncmp( ptr, "file:", 5) ){
      ptr += 5;
      g_strstrip(ptr);
      
      mp3_node = mp3list_search(mp3list, ptr);
      if(mp3_node)
	  playlist_add_row(mp3_node->data);

      /* FIXME what to do with song not in mp3list e.g. from GMC*/
    }
  }

  g_strfreev( tokens );
}

/* 
 * callback executed when a drag is started within one of gnomp3's lists. The
 * selected songs in the list are formed into a URI used for the drop 
 */
static void  
gnomp3_darg_data_get (GtkWidget          *widget,
		      GdkDragContext     *context,
		      GtkSelectionData   *selection_data,
		      guint               info,
		      guint               time,
		      gpointer            data)
{
    char *uri, *old_uri;
    GList *selection;
    GtkCListRow *clist_row;
    MP3 *mp3;
    
    uri = g_strdup("");
    selection = GTK_CLIST(widget)->selection;
    
    while(selection){
	
	if( GTK_IS_CTREE(widget)){
	    clist_row = selection->data;
	    mp3 = GTK_CTREE_ROW(clist_row)->row.data;
	}else if( GTK_IS_CLIST(widget) ){
	    mp3 = gtk_clist_get_row_data( GTK_CLIST(widget),
				      (int)selection->data );
	}else{
	    return;
	}
	
	old_uri = uri;
	uri = g_strconcat( old_uri, "file:", mp3->filename, "\n", NULL );
	g_free (old_uri);
	
	selection = selection->next;
    }
    
    gtk_selection_data_set (selection_data,
			    selection_data->target,
			    8, uri, strlen(uri));
}

/* 
 * initialise and connect all the signals needed to make DragNDrop work 
 */
void gnomp3_dnd_setup()
{

  /* play list drops */
  gtk_drag_dest_set (gnomp3.play_clist,
		     GTK_DEST_DEFAULT_ALL,
		     target_table, 1,
		     GDK_ACTION_COPY);
  gtk_signal_connect (GTK_OBJECT (gnomp3.play_clist), "drag_data_received",
		      GTK_SIGNAL_FUNC (playlist_drop_received),
		      NULL);
  /* mp3 player drops */
  gtk_drag_dest_set (gnomp3.mp3_control_frame,
		     GTK_DEST_DEFAULT_ALL,
		     target_table, 1,
		     GDK_ACTION_COPY);
  gtk_signal_connect (GTK_OBJECT (gnomp3.mp3_control_frame), "drag_data_received",
		      GTK_SIGNAL_FUNC (mp3_control_drop_received),
		      NULL);

  /* other list drags */
  gtk_drag_source_set (gnomp3.song_ctree ,GDK_BUTTON2_MASK,
		       target_table, 1, GDK_ACTION_COPY);
  gtk_signal_connect (GTK_OBJECT (gnomp3.song_ctree), "drag_data_get",
		      GTK_SIGNAL_FUNC (gnomp3_darg_data_get),
		      NULL);
  gtk_drag_source_set (gnomp3.search_clist ,GDK_BUTTON2_MASK,
		       target_table, 1, GDK_ACTION_COPY);
  gtk_signal_connect (GTK_OBJECT (gnomp3.search_clist), "drag_data_get",
		      GTK_SIGNAL_FUNC (gnomp3_darg_data_get),
		      NULL);
  gtk_drag_source_set (gnomp3.all_clist ,GDK_BUTTON2_MASK,
		       target_table, 1, GDK_ACTION_COPY);
  gtk_signal_connect (GTK_OBJECT (gnomp3.all_clist), "drag_data_get",
		      GTK_SIGNAL_FUNC (gnomp3_darg_data_get),
		      NULL);
  gtk_drag_source_set (gnomp3.time_clist ,GDK_BUTTON2_MASK,
		       target_table, 1, GDK_ACTION_COPY);
  gtk_signal_connect (GTK_OBJECT (gnomp3.time_clist), "drag_data_get",
		      GTK_SIGNAL_FUNC (gnomp3_darg_data_get),
		      NULL);
  gtk_drag_source_set (gnomp3.dir_clist ,GDK_BUTTON2_MASK,
		       target_table, 1, GDK_ACTION_COPY);
  gtk_signal_connect (GTK_OBJECT (gnomp3.dir_clist), "drag_data_get",
		      GTK_SIGNAL_FUNC (gnomp3_darg_data_get),
		      NULL);
}







