#include "gnomp3.h"
#include "mp3list.h"
#include "utility.h"
#include "genre.h"
#include <ctype.h>

void mp3_properties_load_dialog(GtkWidget *w, gpointer data)
{
    GladeXML *xml;
    GtkCListRow *clist_row;
    MP3 *mp3 = NULL;
    char *genre;

    if(!GTK_CLIST(data)->selection)
	return;

    if( GTK_IS_CTREE(data)){
	mp3 = GTK_CTREE_ROW(GTK_CLIST(data)->selection->data)->row.data;
    }else if( GTK_IS_CLIST(data) ){
	clist_row = g_list_nth( GTK_CLIST(data)->row_list, 
				(int)GTK_CLIST(data)->selection->data )->data;
	mp3 = clist_row->data;
    }
    if(!mp3){
	return;
    }

    xml = glade_xml_new( gnomp3.glade_file, "mp3_dialog");
    if(!xml) {
	g_warning("We could not load the main_window interface!");
	return;
    }
 
    gtk_label_set_text( GTK_LABEL(glade_xml_get_widget(xml, "p_filename")),
			mp3->filename);
    gtk_label_set_text( GTK_LABEL(glade_xml_get_widget(xml, "p_song_name")),
			mp3->display_name);
    gtk_label_set_text( GTK_LABEL(glade_xml_get_widget(xml, "p_directory")),
			mp3->album_name);
    gtk_label_set_text( GTK_LABEL(glade_xml_get_widget(xml, "p_play_time")),
			mp3list_build_time(mp3));
    gtk_label_set_text( GTK_LABEL(glade_xml_get_widget(xml, "p_file_time")),
			g_strchomp (ctime(&mp3->file_time)));
    gtk_label_set_text( GTK_LABEL(glade_xml_get_widget(xml, "p_no_plays")),
			itoa(mp3->no_plays));
    if(mp3->row_playlist != -1 )
	gtk_label_set_text( GTK_LABEL(glade_xml_get_widget(xml, "p_row")),
			    itoa(mp3->row_playlist));

    if ( mp3->id3_genre <= sizeof(genre_table)/sizeof(*genre_table) ) 
	genre = genre_table[mp3->id3_genre];
    else 
	genre = "Unknown";
    
    gtk_entry_set_text( GTK_ENTRY(glade_xml_get_widget(xml, "i_title")),
			mp3->id3_title );
    gtk_entry_set_text( GTK_ENTRY(glade_xml_get_widget(xml, "i_artist")),
			mp3->id3_artist );
    gtk_entry_set_text( GTK_ENTRY(glade_xml_get_widget(xml, "i_album")),
			mp3->id3_album );
    gtk_entry_set_text( GTK_ENTRY(glade_xml_get_widget(xml, "i_year")),
			mp3->id3_year );
    gtk_entry_set_text( GTK_ENTRY(glade_xml_get_widget(xml, "i_genre")),
			genre );
    gtk_entry_set_text( GTK_ENTRY(glade_xml_get_widget(xml, "i_comment")),
			mp3->id3_comment );

    glade_xml_signal_autoconnect(xml);
    gtk_object_unref(GTK_OBJECT(xml));
}

void mp3_properties_goto_playlist_row(GtkWidget *label)
{
    char *text;
    gtk_label_get(GTK_LABEL(label), &text);
    if(isdigit(text[0])){
	gtk_clist_moveto(GTK_CLIST(gnomp3.play_clist), atoi(text), 0, 0.5, 0.5);
    }
}
