/**
 ** playlist.c - playlist loading/saving and UI functions
 **
 ** Copyright (C) 2000 Matthew Pratt <mattpratt@yahoo.com>
 **
 ** This software is licensed under the terms of the GNU General 
 ** Public License (GPL). Please see the file LICENSE for details.
 **/ 

#include "gnomp3.h"
#include "utility.h"
#include "mp3info.h"
#include "playlist.h"
#include "rule_list.h"
#include "mp3list.h"
#include "dynamic_list.h"

#include <sys/types.h>
#include <dirent.h>


/* 
 *scnas the playlist directory for playlist files. Any found are added to the
 * dropdown menu of the playlist combo 
 */
void playlist_scan()
{
    DIR *dir;
    struct dirent *dir_ent;
    GList *glist=NULL;
    
    if( gnomp3.playlist_dir[strlen(gnomp3.playlist_dir)-1] == '/' )
	gnomp3.playlist_dir[strlen(gnomp3.playlist_dir)-1] = 0;

    dir = opendir(gnomp3.playlist_dir);
    if( !dir ){
	gnome_ok_dialog("Could not open playlist directory");
	return;
    }
    
    glist = g_list_append(glist, "");
    glist = dynamic_list_add_names(glist);

    while( (dir_ent = readdir(dir)) != NULL ){
	if( dir_ent->d_name[0] != '.' ){
	    glist = g_list_append(glist, g_strdup(dir_ent->d_name) );
	}
    }
    closedir(dir);
    
    gtk_combo_set_popdown_strings( GTK_COMBO(gnomp3.playlist_combo), glist );
}

void playlist_combo_activated(GtkWidget *w, gpointer data)
{
    static char filename[MAX_PATH];
    strncpy( filename, gtk_entry_get_text( GTK_ENTRY(GTK_COMBO(gnomp3.playlist_combo)->entry)), sizeof(filename));

    playlist_load(gnomp3.playlist_dir, filename);
}

/* callback for the 'new playlist' toolbar button. */
void playlist_new_cb(GtkWidget *w, gpointer data)
{
    GList *list;

    playlist_clear_rules();
    gtk_clist_clear(  GTK_CLIST(gnomp3.play_clist) );
    list = g_list_copy(playlist);
    g_list_foreach( list, (GFunc)playlist_remove_row, NULL );
    g_list_free(list);
    gnomp3.playlist_loaded[0] = 0;
    gtk_entry_set_text( GTK_ENTRY(GTK_COMBO(gnomp3.playlist_combo)->entry), "");
}

/* callbcak for the 'save as' dialog */
void playlist_save_dialog_done(GtkWidget *w, gpointer data)
{
    playlist_save(gnomp3.playlist_dir, gtk_entry_get_text( GTK_ENTRY(w)));
}

/* 
 * callback for the 'save playlist' toolbar button. If the playlist has not
 * yet been given and name, a dialog is loaded and displayed 
 */
void playlist_save_cb(GtkWidget *w, gpointer data)
{
    printf("playlit: %s\n", gnomp3.playlist_loaded);
    if( gnomp3.playlist_loaded[0] != 0 &&
	!dynamic_list_find(gnomp3.playlist_loaded) ){

	playlist_save( gnomp3.playlist_dir, gnomp3.playlist_loaded);
    }else{
	GladeXML *xml;
	
	xml = glade_xml_new( gnomp3.glade_file, "save_dialog");
	if(!xml) {
	    g_warning("We could not load the main_window interface!");
	    return;
	}
	glade_xml_signal_autoconnect(xml);
	gtk_object_unref(GTK_OBJECT(xml)); 
    }
}

/* 
 * callback for the 'save as playlist' toolbar button or menu item. Dialog 
 * is loaded and displayed 
 */
void playlist_save_as_cb(GtkWidget *w, gpointer data)
{
    GladeXML *xml;
    
    xml = glade_xml_new( gnomp3.glade_file, "save_dialog");
    if(!xml) {
	g_warning("We could not load the main_window interface!");
	return;
    }
    
    glade_xml_signal_autoconnect(xml);
    gtk_object_unref(GTK_OBJECT(xml));
}

