# GNU Enterprise Forms - GTK UI Driver - Login Handler
#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: UILoginHandler.py 6851 2005-01-03 20:59:28Z jcater $

import gtk
import os.path
import types

from gnue.common.apps import GConfig, i18n
from gnue.common.datasources import GLoginHandler

# =============================================================================
# This class implements a login handler for GTK2 
# =============================================================================

class UILoginHandler (GLoginHandler.LoginHandler):

  # ---------------------------------------------------------------------------
  # Get input for all fields listed in loginData
  # ---------------------------------------------------------------------------

  def getLogin (self, loginData, error = None):
    (connection, description, fields) = loginData

    self.dialog = gtk.Dialog (u_("GNU Enterprise: Login to %s") % connection,
                              None, gtk.DIALOG_MODAL,
                              (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
                               gtk.STOCK_OK    ,  gtk.RESPONSE_OK))

    try:
      self.dialog.set_border_width (10)

      imageFile = gConfigForms('loginPNG')
      if not os.path.exists (imageFile):
        imageFile = os.path.join (os.path.normpath ( \
            GConfig.getInstalledBase ('forms_images', 'common_images')),
            gConfigForms ('loginPNG'))

      bmp = gtk.Image ()
      bmp.set_from_file (imageFile)
      self.dialog.vbox.pack_start (bmp)
      bmp.show ()

      text = u_('Login required for %(newline)s"%(description)s"') \
             % {'newline': len (description) and '\n' or '',
                'description': description or connection}
      label = gtk.Label (text)
      label.set_line_wrap (True)
      label.set_justify (gtk.JUSTIFY_CENTER)
      self.dialog.vbox.pack_start (label, True, True, 20)
      label.show ()

      table = gtk.Table (len (fields), 2)
      self.textEntries = []

      for ix in range (len (fields)):
        item = fields [ix]
        text = "%s" % item [1]
        if isinstance (text, types.StringType):
          text = unicode (text, i18n.encoding)
        label = gtk.Label (text)
        label.set_alignment (0, label.get_alignment () [1])
        table.attach (label, 0, 1, ix, ix + 1)
        label.show ()

        entry = gtk.Entry ()
        if item [2]:
          entry.set_visibility (0)
        table.attach (entry, 1, 2, ix, ix + 1)
        entry.connect ('key-press-event', self._keypress, ix + 1)
        entry.show ()

        self.textEntries.append (entry)

      table.show ()
      self.dialog.vbox.pack_start (table, True, True, 10)

      # Add an error text if given
      if error is not None:
        if isinstance (error, types.StringType):
          error = unicode (error, i18n.encoding)
        label = gtk.Label (error)
        label.set_line_wrap (True)
        label.modify_fg (gtk.STATE_NORMAL, gtk.gdk.color_parse ('red'))
        self.dialog.vbox.pack_start (label, True, True, 10)
        label.show ()

      # focus first entry
      self.textEntries [0].grab_focus ()
  
      self.dialog.set_position (1)  # for center
      self.dialog.show_all ()

      result = self.dialog.run ()
      self._completed = result == gtk.RESPONSE_OK
      if not self._completed:
        raise GLoginHandler.UserCanceledLogin

      result = {}
      for ix in range (len (fields)):
        text = unicode (self.textEntries [ix].get_text (), 'utf-8')
        result [fields [ix][0]] = text

    finally:
      self.dialog.destroy ()

    return result


  # ---------------------------------------------------------------------------
  # Keypress handler for moving the focus on enter-keys
  # ---------------------------------------------------------------------------

  def _keypress (self, widget, event, data):
    if event.type != gtk.gdk.KEY_PRESS:
      return

    if event.keyval == gtk.keysyms.Return and not event.state:
      if data < len (self.textEntries):
        self.textEntries [data].grab_focus ()
      else:
        self.dialog.response (gtk.RESPONSE_OK)


  # Hack for McMillan packaging on win32
  # TODO: do we need that?
  def getDummyLogin (self):
    pass
