#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# uidrivers/html/UIdriver.py
#
# DESCRIPTION:
#
# NOTES:
#

import sys
import string

from gnue.forms.uidrivers._base import Exceptions

from gnue.common import events
from gnue.common.apps import GConfig

from gnue.forms import VERSION
from gnue.forms.GFForm import *
from gnue.forms.uidrivers._commonGuiToolkit import UIdriver as commonToolkit

from gnue.forms.uidrivers.html.GFhtmlApp import *


class GFUserInterface(commonToolkit.GFUserInterface):

  def initialize(self):

    self._htmlapp = gethtmlApp(self)

    self.textWidth    = 12  # The pixel width of text inside a widget
    self.textHeight   = 24  # The pixel height of text inside a widget
    self.widgetWidth  = self.textWidth  # The pixel width of a 1 char widget (for things like buttons)
    self.widgetHeight = self.textHeight + 5  # The pixel height of a 1 char widget (for things like buttons)

  def _exit(self,formName):
    pass

  def mainLoop(self):
    self._htmlapp.MainLoop() # simply call the wxApp's MainLoop method

  def formAlert(self, event):
    pass
    
  def beginWait (self, event):
    pass

  def endWait (self, event):
    pass
