#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# DESCRIPTION:
# A wxPython based user interface driver for GNUe forms.
#
# NOTES:
#
# $Id: image.py 6851 2005-01-03 20:59:28Z jcater $

from wxPython.wx import *

from gnue.forms.uidrivers.wx.widgets._base import UIHelper
import Image

# =============================================================================
# Wrap an UI layer around a wx image
# =============================================================================
class UIImage(UIHelper):
  """
  Creates a single instance of an image.
  """

  # --------------------------------------------------------------------------
  # Create an image widget
  # --------------------------------------------------------------------------
  def _createWidget(self, event, spacer):
    """
    Creates a new StaticBitmap widget.
    """
    object = event.object

    png = wxEmptyBitmap(1, 1)

    self.pane = wxScrolledWindow(event.container, -1,
                                 wxPoint(self.itemX, self.itemY),
                                 wxSize(self.itemWidth, self.itemHeight))
    EVT_SIZE(self.pane, self.OnFrameSize)
    EVT_PAINT(self.pane, self.onPaint)

    imageWidth = png.GetWidth()
    imageHeight = png.GetHeight()
    self.imageWindow = wxStaticBitmap(self.pane, -1, png,
                               wxPoint(0, 0),
                               wxSize(imageWidth, imageHeight))
    self.fixScrollbars()

    return self.imageWindow


  # --------------------------------------------------------------------------
  # Handle image frame size change
  # --------------------------------------------------------------------------
  def OnFrameSize(self, event):
    """
    Handles image frame size changes.
    """
    pass
    #self.pane.SetSize(self.pane.GetClientSize())
    #self.fixScrollbars()


  # --------------------------------------------------------------------------
  # Handle image paint request
  # --------------------------------------------------------------------------
  def onPaint(self,event):
    """
    Handles image paint requests.
    """
    self.imageWindow.Refresh()


  # --------------------------------------------------------------------------
  # Make scrollbars good size and position
  # --------------------------------------------------------------------------
  def fixScrollbars(self):
    """
    Ensures that scrollbars are in good position and good size.
    """
    x1, y1 = self.pane.GetClientSizeTuple()
    x2, y2 = self.imageWindow.GetSizeTuple()
    if x1 < x2 or y1 < y2:
      self.pane.SetScrollbars(5, 5, x2/5, y2/5)
    else:
      self.pane.SetScrollbars(0, 0, 0, 0)


  # --------------------------------------------------------------------------
  # Set the widget's PIL
  # --------------------------------------------------------------------------
  def setValue(self, value, index=0, enabled=1):
    """
    Loads an image.
    """
    widget = self.widgets[index]
    widget.SetEvtHandlerEnabled(FALSE)

    scrx, scry = self.pane.GetClientSizeTuple()
    imgx, imgy = value.size
    gfObject = self._uiDriver._IdToGFObj[widget.GetId()]

    scalex = scaley = 1

    fit = gfObject.fit

    if fit == "auto":
      if float(scrx) / imgx < float(scry) / imgy:
        fit = "width"
      else:
        fit = "height"

    if fit == "width":
      scalex = scaley = float(scrx) / imgx
    elif fit == "height":
      scalex = scaley = float(scry) / imgy
    elif fit == "both":
      scalex = float(scrx) / imgx
      scaley = float(scry) / imgy

##    print "(%s, %s) (%s, %s)" % (scrx, scry, imgx, imgy)
##    print "(%s, %s)" % (abs(int(imgx*scalex)), abs(int(imgy*scaley)))
##    print "%s%% %s%%" % (scalex, scaley)

    if scalex != 1 or scaley != 1:
      value = value.resize((abs(int(imgx * (scalex))), abs(int(imgy * (scaley)))), Image.BICUBIC)

    # Convert the PIL Image to a wxBitmap
    wxImg = wxEmptyImage(value.size[0], value.size[1])
    wxImg.SetData(value.convert("RGB").tostring())
    image = wxImg.ConvertToBitmap()

    # Resize the bitmap holder to match the image size
    # and fix the scrollbars
    imageWidth = image.GetWidth()
    imageHeight = image.GetHeight()
    widget.SetSize(wxSize(imageWidth, imageHeight))
    self.fixScrollbars()

    # Load the new image
    widget.SetBitmap(image)
    widget.Enable(enabled)
    widget.SetEvtHandlerEnabled(TRUE)
    widget.Refresh()


# ----------------------------------------------------------------------------
# Configuration data
# ----------------------------------------------------------------------------
configuration = {
    'baseClass'  : UIImage,
    'provides'   : 'GFImage',
    'container'  : 0,
    }
