/*
**  Address.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Jonathan B. Leffert <jonathan@leffert.net>
**          Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "Address.h"

#import "GNUMailConstants.h"

@implementation Address

- (id) init
{
  self = [super init];

  name = nil;
  emailAddress = nil;
  lowercaseName = nil;

  return self;
}

- (void) dealloc
{
  RELEASE(name);
  RELEASE(emailAddress);
  RELEASE(lowercaseName);

  [super dealloc];
}

- (void) encodeWithCoder: (NSCoder *) theCoder
{
  [theCoder encodeObject: [self name]];
  [theCoder encodeObject: [self emailAddress]];
}

- (id) initWithCoder: (NSCoder *) theCoder
{
  self = [super init];

  lowercaseName = nil;
  
  [self setName: [theCoder decodeObject]];
  [self setEmailAddress: [theCoder decodeObject]];

  return self;
}

- (NSComparisonResult) compare: (Address *) theOtherAddress
{
  return [[self name] compare: [theOtherAddress name]];
}

- (BOOL) matchesFilterString: (NSString *) filterString
		orComponents: (NSArray *) filterStringComponents
{
  BOOL result = NO;

  if ( [[self lowercaseName] rangeOfString: filterString].length )
    {
      result = YES;
    }
  else
    {
      NSString *theComponent;
      BOOL tmpResult = YES;
      int i;
      
      for ( i = 0; i < [filterStringComponents count]; i++ )
	{
	  theComponent = [filterStringComponents objectAtIndex: i];
	  
	  if ( [theComponent length] && 
	       ! [[self lowercaseName] rangeOfString: theComponent].length )
	    {
	      tmpResult = NO;
	      break;
	    }
	}
      result = tmpResult;
    }
  
  return result;
}

- (NSString *) description
{
  return [NSString stringWithFormat: @"%@ <%@>",
		   [self name], [self emailAddress]];
}

- (NSString *) formattedAddress
{
  if ( [self name] && [[self name] length] )
    {
      if ( [self emailAddress] && [[self emailAddress] length] )
	{
	  return [NSString stringWithFormat: @"%@ <%@>",
			   [self name], [self emailAddress]];
	}
    }
  else if ( [self emailAddress] && [[self emailAddress] length] )
    {
      return [self emailAddress];
    }

  return @"";
}

//
// class methods
//

+ (id) address
{
  Address *a = [[self alloc] init];

  return AUTORELEASE(a);
}

//
// access/mutation methods
//

- (NSString *) name
{
  return name;
}

- (void) setName: (NSString *) theName
{
  RETAIN(theName);
  RELEASE(name);
  name = theName;

  [self setLowercaseName: [[self name] lowercaseString]];
}

- (NSString *) emailAddress
{
  return emailAddress;
}

- (void) setEmailAddress: (NSString *) theAddress
{
  RETAIN(theAddress);
  RELEASE(emailAddress);
  emailAddress = theAddress;
}

- (NSString *) lowercaseName
{
  return lowercaseName;
}

- (void) setLowercaseName: (NSString *) theName
{
  RETAIN(theName);
  RELEASE(lowercaseName);
  lowercaseName = theName;
}

- (int) compareAccordingToName: (Address *) anAddress
{
  int order = [name compare: [anAddress name]];
  
  if ( NSOrderedSame == order )
    {
      return [emailAddress compare: [anAddress emailAddress]];
    }
  
  return order;
}

@end
