/*
**  BounceWindow.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import "BounceWindow.h"

#import "GNUMailConstants.h"
#import "LabelWidget.h"

@implementation BounceWindow

- (void) dealloc
{
  NSLog(@"BounceWindow: -dealloc");

  RELEASE(icon);
  RELEASE(sendButton);
  RELEASE(addressesButton);
  RELEASE(cancelButton);

  RELEASE(toField);
  RELEASE(ccField);
  RELEASE(bccField);
  
  RELEASE(personalProfilePopUpButton);
  RELEASE(transportMethodPopUpButton);

  [super dealloc];
}

- (void) layoutWindow
{
  LabelWidget *toLabel, *ccLabel, *bccLabel, *fromLabel, *usingLabel;
  
  icon = [[NSButton alloc] initWithFrame: NSMakeRect(4,90,16,16)];
  [icon setTitle: @""];
  [icon setImagePosition: NSImageOnly];
  [icon setImage: [NSImage imageNamed: @"anim-logo-1.tiff"]];
  [icon setBordered: NO];
  [icon setEnabled: NO];
  [icon setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: icon];

  // Our buttons
  sendButton = [[NSButton alloc] initWithFrame:NSMakeRect(24,90,64,64)];
  [sendButton setTitle: _(@"Send")];
  [sendButton setFont:[NSFont systemFontOfSize: 8]];
  [sendButton setTarget: [self windowController]];
  [sendButton setAction:@selector(send:)];
  [sendButton setImagePosition: NSImageAbove];
  [sendButton setImage: [NSImage imageNamed: @"MailIcon_send.tiff"]];
  [sendButton setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:sendButton];
  
  addressesButton = [[NSButton alloc] initWithFrame:NSMakeRect(98,90,64,64)];
  [addressesButton setTitle: _(@"Addresses")];
  [addressesButton setFont:[NSFont systemFontOfSize: 8]];
  [addressesButton setTarget: [NSApp delegate]];
  [addressesButton setAction: @selector(showAddressBook:)];
  [addressesButton setImagePosition: NSImageAbove];
  [addressesButton setImage: [NSImage imageNamed: @"MailIcon_addresses.tiff"]];
  [addressesButton setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:addressesButton];

  cancelButton = [[NSButton alloc] initWithFrame: NSMakeRect(172,90,64,64)];;
  [cancelButton setTitle: _(@"Cancel")];
  [cancelButton setFont:[NSFont systemFontOfSize: 8]];		     
  [cancelButton setButtonType:NSMomentaryPushButton];
  [cancelButton setTarget: self];
  [cancelButton setAction: @selector(performClose:)];
  [cancelButton setImagePosition: NSImageAbove];
  [cancelButton setImage: [NSImage imageNamed: @"MailIcon_stop.tiff"]];
  [cancelButton setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: cancelButton];

  // From
  fromLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(244,120,50,21) 
			   label: _(@"From:") ];
  [fromLabel setAutoresizingMask: NSViewMinXMargin|NSViewMaxXMargin|NSViewMinYMargin];
  [[self contentView] addSubview: fromLabel];
  
  personalProfilePopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(294,120,190,ButtonHeight)];
  [personalProfilePopUpButton setAutoresizingMask: NSViewMinXMargin|NSViewMinYMargin|NSViewWidthSizable];
  [personalProfilePopUpButton setTarget: [self windowController]];
  [personalProfilePopUpButton setAction: @selector(personalProfilesSelectionHasChanged:)];
  [[self contentView] addSubview: personalProfilePopUpButton];

  // Using
  usingLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(244,90,50,21) 
			   label: _(@"Using:") ];
  [usingLabel setAutoresizingMask: NSViewMinXMargin|NSViewMaxXMargin|NSViewMinYMargin];
  [[self contentView] addSubview: usingLabel];

  transportMethodPopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(294,90,190,ButtonHeight)];
  [transportMethodPopUpButton setAutoenablesItems: NO];
  [transportMethodPopUpButton setAutoresizingMask: NSViewMinXMargin|NSViewMinYMargin|NSViewWidthSizable];
  [transportMethodPopUpButton addItemWithTitle: @"smtp.server.com"];
  [[self contentView] addSubview: transportMethodPopUpButton];

  // To
  toLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(10,60,50,TextFieldHeight)
			 label: _(@"To:")];
  [toLabel setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: toLabel];

  toField = [[NSTextField alloc] initWithFrame: NSMakeRect(70,60,414,TextFieldHeight)];
  [toField setSelectable: YES];
  [toField setAutoresizingMask: NSViewMinYMargin|NSViewMaxYMargin|NSViewWidthSizable];
  [[self contentView] addSubview: toField];
  
  // Cc
  ccLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(10,35,50,TextFieldHeight)
			 label: _(@"Cc:")];
  [ccLabel setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: ccLabel];
  
  ccField = [[NSTextField alloc] initWithFrame: NSMakeRect(70,35,414,TextFieldHeight)];
  [ccField setSelectable: YES];
  [ccField setAutoresizingMask: NSViewMinYMargin|NSViewMaxYMargin|NSViewWidthSizable];
  [[self contentView] addSubview: ccField];

  // Bcc
  bccLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(10,10,50,TextFieldHeight)
			  label: _(@"Bcc:")];
  [bccLabel setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: bccLabel];

  bccField = [[NSTextField alloc] initWithFrame: NSMakeRect(70,10,414,TextFieldHeight)];
  [bccField setSelectable: YES];
  [bccField setAutoresizingMask: NSViewMinYMargin|NSViewMaxYMargin|NSViewWidthSizable];
  [[self contentView] addSubview: bccField];

  [self setMinSize: NSMakeSize(514,190)];
}

//
//access/mutation methods
//

- (NSButton *) icon
{
  return icon;
}

- (NSButton *) sendButton
{
  return sendButton;
}

- (NSButton *) addressesButton
{
  return addressesButton;
}

- (NSButton *) cancelButton
{
  return cancelButton;
}

- (NSTextField *) toField
{
  return toField;
}


- (NSTextField *) ccField
{
  return ccField;
}


- (NSTextField *) bccField
{
  return bccField;
}


- (NSPopUpButton *) personalProfilePopUpButton
{
  return personalProfilePopUpButton;
}


- (NSPopUpButton *) transportMethodPopUpButton
{
  return transportMethodPopUpButton;
}

@end





