/*
**  FilterEditorWindow.m
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import "FilterEditorWindow.h"

#import "GNUMailConstants.h"
#import "LabelWidget.h"

@implementation FilterEditorWindow

- (void) dealloc
{
  NSLog(@"FilterEditorWindow: -dealloc");
  
  RELEASE(descriptionField);
  RELEASE(activeButton);

  RELEASE(criteriaSourcePopUpButton);
  RELEASE(criteriaFindOperationPopUpButton);
  RELEASE(criteriaStringField);

  RELEASE(matrix);
  RELEASE(actionColorPopUpButton);
  RELEASE(actionFolderNamePopUpButton);
  RELEASE(actionEMailStringPopUpButton);
  RELEASE(actionEMailStringField);

  [super dealloc];
}

- (void) layoutWindow
{
  NSButton *okButton, *cancelButton;
  LabelWidget *descriptionLabel;
  
  NSButtonCell *cell;
  NSBox *box;
  
  
  descriptionLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(10,305,70,TextFieldHeight)
				  label: _(@"Description:")];
  [[self contentView] addSubview: descriptionLabel]; 

  descriptionField = [[NSTextField alloc] initWithFrame: NSMakeRect(90,305,300,TextFieldHeight)];
  [[self contentView] addSubview: descriptionField];

  activeButton = [[NSButton alloc] initWithFrame: NSMakeRect(410,302,70,ButtonHeight)];
  [activeButton setButtonType: NSSwitchButton];
  [activeButton setBordered: NO];
  [activeButton setTitle: _(@"Active")];
  [[self contentView] addSubview: activeButton];

  // The criteria box
  box = [[NSBox alloc] initWithFrame: NSMakeRect(10,230,480,65)];
  [box setTitle: _(@"Criteria")];
  [[self contentView] addSubview: box];
 

  criteriaSourcePopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(5,5,80,ButtonHeight)];
  [criteriaSourcePopUpButton addItemWithTitle: _(@"To")];
  [criteriaSourcePopUpButton addItemWithTitle: _(@"Cc")];
  [criteriaSourcePopUpButton addItemWithTitle: _(@"To or Cc")];
  [criteriaSourcePopUpButton addItemWithTitle: _(@"Subject")];
  [criteriaSourcePopUpButton addItemWithTitle: _(@"From")];
  [criteriaSourcePopUpButton addItemWithTitle: _(@"Expert...")];
  [criteriaSourcePopUpButton setTarget: [self windowController]];
  [criteriaSourcePopUpButton setAction: @selector(criteriaSourceSelectionHasChanged:)];
  [box addSubview: criteriaSourcePopUpButton];

  criteriaFindOperationPopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(90,5,130,ButtonHeight)];
  [criteriaFindOperationPopUpButton setAutoenablesItems: NO];
  [criteriaFindOperationPopUpButton addItemWithTitle: _(@"Contains")];
  [criteriaFindOperationPopUpButton addItemWithTitle: _(@"Is Equal")];
  [criteriaFindOperationPopUpButton addItemWithTitle: _(@"Has Prefix")];
  [criteriaFindOperationPopUpButton addItemWithTitle: _(@"Has Suffix")];
  [criteriaFindOperationPopUpButton addItemWithTitle: _(@"Match Expression")];
  [box addSubview: criteriaFindOperationPopUpButton];

  criteriaStringField = [[NSTextField alloc] initWithFrame: NSMakeRect(225,5,250,TextFieldHeight)];
  [criteriaStringField setEditable: YES];
  [box addSubview: criteriaStringField];

  RELEASE(box);

  // The action box
  box = [[NSBox alloc] initWithFrame: NSMakeRect(10,45,480,170)];
  [box setTitle: _(@"Action")];
  [[self contentView] addSubview: box];
  
  cell = [[NSButtonCell alloc] init];
  [cell setButtonType: NSSwitchButton];
  [cell setBordered: NO];
  [cell setImagePosition: NSImageLeft];

  matrix = [[NSMatrix alloc] initWithFrame:NSMakeRect(5,5,130,120)
			     mode: NSRadioModeMatrix
			     prototype: cell
			     numberOfRows: 4
			     numberOfColumns: 1];
  [matrix setTarget: [self windowController]];
  [matrix setIntercellSpacing: NSMakeSize(0, 5)];
  [matrix setAutosizesCells: NO];
  [matrix setAllowsEmptySelection: NO];
  RELEASE(cell);
  
  [[matrix cellAtRow: 0 column: 0] setTitle: _(@"Set the color to:")];
  [[matrix cellAtRow: 1 column: 0] setTitle: _(@"Transfer to mailbox:")];
  [[matrix cellAtRow: 2 column: 0] setTitle: _(@"Do...")];
  [[matrix cellAtRow: 3 column: 0] setTitle: _(@"Delete the message")];
  [box addSubview: matrix];

  actionColorPopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(145,110,125,ButtonHeight)];
  [actionColorPopUpButton setAutoenablesItems: NO];
  [actionColorPopUpButton addItemWithTitle: _(@"Blue")];
  [actionColorPopUpButton addItemWithTitle: _(@"Brown")];
  [actionColorPopUpButton addItemWithTitle: _(@"Cyan")];
  [actionColorPopUpButton addItemWithTitle: _(@"Dark Gray")];
  [actionColorPopUpButton addItemWithTitle: _(@"Green")];
  [actionColorPopUpButton addItemWithTitle: _(@"Magenta")];
  [actionColorPopUpButton addItemWithTitle: _(@"Orange")];
  [actionColorPopUpButton addItemWithTitle: _(@"Purple")];
  [actionColorPopUpButton addItemWithTitle: _(@"Red")];
  [actionColorPopUpButton addItemWithTitle: _(@"White")];
  [actionColorPopUpButton addItemWithTitle: _(@"Yellow")];
  [box addSubview: actionColorPopUpButton];

  actionFolderNamePopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(145,75,125,ButtonHeight)];
  [actionFolderNamePopUpButton setAutoenablesItems: NO];
  [box addSubview: actionFolderNamePopUpButton];

  actionEMailStringPopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(145,40,90,ButtonHeight)];
  [actionEMailStringPopUpButton setAutoenablesItems: NO];
  [actionEMailStringPopUpButton addItemWithTitle: _(@"Bounce to:")];
  [actionEMailStringPopUpButton addItemWithTitle: _(@"Forward to:")];
  [actionEMailStringPopUpButton addItemWithTitle: _(@"Reply to:")];
  [box addSubview: actionEMailStringPopUpButton];

  actionEMailStringField = [[NSTextField alloc] initWithFrame: NSMakeRect(245,40,110,TextFieldHeight)];
  [actionEMailStringField setEditable: YES];
  [box addSubview: actionEMailStringField];

  actionEMailStringButton = [[NSButton alloc] initWithFrame: NSMakeRect(365,38,100, ButtonHeight)];
  AUTORELEASE(actionEMailStringButton);
  [actionEMailStringButton setStringValue: _(@"Set message")];
  [actionEMailStringButton setTarget: [self windowController]];
  [actionEMailStringButton setAction: @selector(setMessage:)];
  [box addSubview: actionEMailStringButton];
  
  RELEASE(box);

  cancelButton = [[NSButton alloc] initWithFrame: NSMakeRect(265,10,60,ButtonHeight)];;
  AUTORELEASE(cancelButton);
  [cancelButton setButtonType:NSMomentaryPushButton];
  [cancelButton setTitle: _(@"Cancel")];
  [cancelButton setTarget: [self windowController]];
  [cancelButton setAction: @selector(cancelClicked:) ];
  [[self contentView] addSubview: cancelButton];

 
  okButton = [[NSButton alloc] initWithFrame: NSMakeRect(335,10,60,ButtonHeight)];
  AUTORELEASE(okButton);
  [okButton setButtonType: NSMomentaryPushButton];
  [okButton setKeyEquivalent: @"\r"];
  [okButton setImagePosition: NSImageRight];
  [okButton setImage: [NSImage imageNamed: @"common_ret"]];
  [okButton setAlternateImage: [NSImage imageNamed: @"common_retH"]];
  [okButton setTitle: _(@"OK")];
  [okButton setTarget: [self windowController]];
  [okButton setAction: @selector(okClicked:)];
  [[self contentView] addSubview: okButton];

  // We set the initial responder and the next key views
  [self setInitialFirstResponder: descriptionField];
  [descriptionField setNextKeyView: activeButton];
  [activeButton setNextKeyView: criteriaSourcePopUpButton];
  [criteriaSourcePopUpButton setNextKeyView: criteriaFindOperationPopUpButton];
  [criteriaFindOperationPopUpButton setNextKeyView: criteriaStringField];
  [criteriaStringField setNextKeyView: descriptionField];

  // FIXME
  [[matrix cellAtRow: 2 column: 0] setEnabled: NO];
  [actionEMailStringPopUpButton setEnabled: NO];
  [actionEMailStringField setEnabled: NO];
  [actionEMailStringButton setEnabled: NO];
}


//
// access/mutation methods
//

- (NSTextField *) descriptionField
{
  return descriptionField;
}

- (NSButton *) activeButton
{
  return activeButton;
}

- (NSPopUpButton *) criteriaSourcePopUpButton
{
  return criteriaSourcePopUpButton;
}

- (NSPopUpButton *) criteriaFindOperationPopUpButton
{
  return criteriaFindOperationPopUpButton;
}

- (NSTextField *) criteriaStringField
{
  return criteriaStringField;
}

- (NSMatrix *) matrix
{
  return matrix;
}

- (NSPopUpButton *) actionColorPopUpButton
{
  return actionColorPopUpButton;
}

- (NSPopUpButton *) actionFolderNamePopUpButton
{
  return actionFolderNamePopUpButton;
}

- (NSPopUpButton *) actionEMailStringPopUpButton
{
  return actionEMailStringPopUpButton;
}

- (NSTextField *) actionEMailStringField
{
  return actionEMailStringField;
}

- (NSButton *) actionEMailStringButton
{
  return actionEMailStringButton;
}


@end





