/*
**  FontsViewController.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Sir Raorn <raorn@binec.ru>
**          Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "FontsViewController.h"

#import "GNUMailConstants.h"

#ifndef MACOSX
#import "FontsView.h"
#endif

static FontsViewController *singleInstance = nil;

@implementation FontsViewController

- (id) initWithNibName: (NSString *) theName
{
  self = [super init];

#ifdef MACOSX
  
  if (! [NSBundle loadNibNamed: theName
		  owner: self] )
    {
      NSLog(@"Fatal error occured while loading the FontsView nib file");
      AUTORELEASE(self);
      return nil;
    }

  RETAIN(view);

#else
  // We link our view
  view = [[FontsView alloc] initWithParent: self];
  [view layoutView];

  // We link our outlets
  headerNameField = [view headerNameField];
  headerValueField = [view headerValueField];
  messageContentField = [view messageContentField];
#endif

  fontContainer = nil;
//  [view setNextResponder: self];
    
  // We get our defaults for this panel
  [self initializeFromDefaults];

  return self;
}

//
// action methods
//
- (void) changeFont: (id)sender
{
  NSFontManager *aFontManager;
  NSFont *aFont;

  //NSLog(@"changeFont:");

  if (fontContainer)
    {
      aFontManager = sender;

      aFont = [aFontManager convertFont: [fontContainer font]];
      [fontContainer setFont: aFont];

      [fontContainer setStringValue: [NSString stringWithFormat: @"%@ - %.1f PT",
                                               [[fontContainer font] fontName],
                                               [[fontContainer font] pointSize]]];
    }
}

- (IBAction) headerNameClicked: (id)sender
{
  NSFontPanel *aFontPanel;

  //NSLog(@"chooseFont:");

  fontContainer = headerNameField;

  aFontPanel = [NSFontPanel sharedFontPanel];
  [[NSFontManager sharedFontManager] setSelectedFont: [fontContainer font]
                                     isMultiple: NO];

  [aFontPanel orderFront: nil];
}

- (IBAction) headerValueClicked: (id)sender
{
  NSFontPanel *aFontPanel;

  //NSLog(@"chooseFont:");

  fontContainer = headerValueField;

  aFontPanel = [NSFontPanel sharedFontPanel];
  [[NSFontManager sharedFontManager] setSelectedFont: [fontContainer font]
                                     isMultiple: NO];

  [aFontPanel orderFront: nil];
}

- (IBAction) messageContentClicked: (id)sender
{
  NSFontPanel *aFontPanel;

  //NSLog(@"chooseFont:");

  fontContainer = messageContentField;

  aFontPanel = [NSFontPanel sharedFontPanel];
  [[NSFontManager sharedFontManager] setSelectedFont: [fontContainer font]
                                     isMultiple: NO];

  [aFontPanel orderFront: nil];
}


- (void) dealloc
{
  singleInstance = nil;
  RELEASE(view);

  [super dealloc];
}


//
// access methods
//

- (NSImage *) image
{
  NSBundle *aBundle;
  
  aBundle = [NSBundle bundleForClass: [self class]];
  
  return AUTORELEASE([[NSImage alloc] initWithContentsOfFile:
					[aBundle pathForResource: @"fonts" ofType: @"tiff"]]);
}

- (NSString *) name
{
  return _(@"Fonts");
}

- (NSView *) view
{
  return view;
}

- (BOOL) hasChangesPending
{
  return YES;
}


//
//
//
- (void) initializeFromDefaults
{
  if ( [[NSUserDefaults standardUserDefaults] objectForKey: @"TAG_FONT_NAME"] )
    {
      [headerNameField setFont: [NSFont fontWithName: [[NSUserDefaults standardUserDefaults] stringForKey: @"TAG_FONT_NAME"]
                                     size: [[NSUserDefaults standardUserDefaults] floatForKey: @"TAG_FONT_SIZE"]]];
    }
  else
    {
      [headerNameField setFont: [NSFont boldSystemFontOfSize: 0]];
    }

  [headerNameField setStringValue: [NSString stringWithFormat: @"%@ - %.1f PT",
                                        [[headerNameField font] fontName],
                                        [[headerNameField font] pointSize]]];

  if ( [[NSUserDefaults standardUserDefaults] objectForKey: @"HEADER_FONT_NAME"] )
    {
      [headerValueField setFont: [NSFont fontWithName: [[NSUserDefaults standardUserDefaults] stringForKey: @"HEADER_FONT_NAME"]
                                        size: [[NSUserDefaults standardUserDefaults] floatForKey: @"HEADER_FONT_SIZE"]]];
    }
  else
    {
      [headerValueField setFont: [NSFont systemFontOfSize: 0]];
    }

  [headerValueField setStringValue: [NSString stringWithFormat: @"%@ - %.1f PT",
                                        [[headerValueField font] fontName],
                                        [[headerValueField font] pointSize]]];

  if ( [[NSUserDefaults standardUserDefaults] objectForKey: @"MESSAGE_FONT_NAME"] )
    {
      [messageContentField setFont: [NSFont fontWithName: [[NSUserDefaults standardUserDefaults] stringForKey: @"MESSAGE_FONT_NAME"]
                                         size: [[NSUserDefaults standardUserDefaults] floatForKey: @"MESSAGE_FONT_SIZE"]]];
    }
  else
    {
      [messageContentField setFont: [NSFont userFixedPitchFontOfSize: 0]];
    }

  [messageContentField setStringValue: [NSString stringWithFormat: @"%@ - %.1f PT",
                                        [[messageContentField font] fontName],
                                        [[messageContentField font] pointSize]]];
}


- (void) saveChanges
{
  [[NSUserDefaults standardUserDefaults] setObject: [[headerNameField font] fontName]
                                         forKey: @"TAG_FONT_NAME"];
  [[NSUserDefaults standardUserDefaults] setFloat: [[headerNameField font] pointSize]
                                         forKey: @"TAG_FONT_SIZE"];

  [[NSUserDefaults standardUserDefaults] setObject: [[headerValueField font] fontName]
                                         forKey: @"HEADER_FONT_NAME"];
  [[NSUserDefaults standardUserDefaults] setFloat: [[headerValueField font] pointSize]
                                         forKey: @"HEADER_FONT_SIZE"];

  [[NSUserDefaults standardUserDefaults] setObject: [[messageContentField font] fontName]
                                         forKey: @"MESSAGE_FONT_NAME"];
  [[NSUserDefaults standardUserDefaults] setFloat: [[messageContentField font] pointSize]
                                         forKey: @"MESSAGE_FONT_SIZE"];
}

//
// class methods
//
+ (id) singleInstance
{
  if (! singleInstance)
    {
      singleInstance = [[FontsViewController alloc] initWithNibName: @"FontsView"];
    }

  return singleInstance;
}

@end
