/*
**  MimeTypeEditorWindowController.m
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "MimeTypeEditorWindowController.h"

#import "GNUMailConstants.h"
#import "MimeType.h"

#ifndef MACOSX
#import "MimeTypeEditorWindow.h"
#endif

#import "MimeTypeManager.h"

@implementation MimeTypeEditorWindowController

//
//
//
- (id) initWithWindowNibName: (NSString *) windowNibName
{
#ifdef MACOSX
  
  self = [super initWithWindowNibName: windowNibName];
  
#else
  MimeTypeEditorWindow *mimeTypeEditorWindow;

  mimeTypeEditorWindow = [[MimeTypeEditorWindow alloc] initWithContentRect: NSMakeRect(300,300,430,420)
						       styleMask: NSTitledWindowMask
						       backing: NSBackingStoreRetained
						       defer: NO];
 
  [super initWithWindow: mimeTypeEditorWindow];
  
  [mimeTypeEditorWindow layoutWindow];
  [mimeTypeEditorWindow setDelegate: self];

  // We link our outlets
  mimeTypeField = [mimeTypeEditorWindow mimeTypeField];
  fileExtensionsField = [mimeTypeEditorWindow fileExtensionsField];
  descriptionField = [mimeTypeEditorWindow descriptionField];
  dataHandlerCommandField = [mimeTypeEditorWindow dataHandlerCommandField];

  dataHandlerCommandButton = [mimeTypeEditorWindow dataHandlerCommandButton];
  needsTerminalButton = [mimeTypeEditorWindow dataHandlerCommandButton];
  iconButton = [mimeTypeEditorWindow iconButton];
  
  viewMatrix = [mimeTypeEditorWindow viewMatrix];
  actionMatrix = [mimeTypeEditorWindow actionMatrix];

  RELEASE(mimeTypeEditorWindow);
#endif

  [[self window] setTitle: _(@"Add a Mime-Type")];
  
  return self;
}


- (void) dealloc
{
  NSLog(@"MimeTypeEditorWindowController: -dealloc");

  RELEASE(mimeTypeManager);
  TEST_RELEASE(mimeType);
  
  [super dealloc];
}

//
// delegate methods
//

- (void) windowWillClose: (NSNotification *) theNotification
{
  //NSLog(@"MimeTypeEditorWindowController: -windowWillClose");
  
  AUTORELEASE(self);
}

- (void) windowDidLoad
{
  [self selectionHasChanged: nil];
}


//
// action methods
//
- (IBAction) okClicked: (id) sender
{
  MimeType *aMimeType;

  if ( [self mimeType] )
    {
      aMimeType = [self mimeType];
 
      [aMimeType setMimeType: [mimeTypeField stringValue] ];
      [aMimeType setFileExtensions: [fileExtensionsField stringValue] ];
      [aMimeType setDescription: [descriptionField stringValue] ];
      [aMimeType setView: [viewMatrix selectedRow] ];
      [aMimeType setAction: [actionMatrix selectedRow] ];
      [aMimeType setDataHandlerCommand: [dataHandlerCommandField stringValue] ];
      [aMimeType setNeedsTerminal: ([needsTerminalButton state] == NSOnState ? YES : NO)];
      [aMimeType setIcon: [iconButton image] ];
    }
  else
    {
      aMimeType = [[MimeType alloc] init];
      
      [aMimeType setMimeType: [mimeTypeField stringValue] ];
      [aMimeType setFileExtensions: [fileExtensionsField stringValue] ];
      [aMimeType setDescription: [descriptionField stringValue] ];
      [aMimeType setView: [viewMatrix selectedRow] ];
      [aMimeType setAction: [actionMatrix selectedRow] ];
      [aMimeType setDataHandlerCommand: [dataHandlerCommandField stringValue] ];
      [aMimeType setNeedsTerminal: ([needsTerminalButton state] == NSOnState ? YES : NO)];
      [aMimeType setIcon: [iconButton image] ];
      
      [mimeTypeManager addMimeType: aMimeType];
      RELEASE(aMimeType);
    }

  [NSApp stopModal];
  [self close];
}


- (IBAction) cancelClicked: (id) sender
{
  [NSApp abortModal];
  [self close];
}

- (IBAction) chooseDataHandlerCommand: (id) sender
{
  NSArray *filesToOpen;
  NSOpenPanel *anOpenPanel;
  NSString *fileName;
  int count, result;
  
  anOpenPanel = [NSOpenPanel openPanel];
  [anOpenPanel setAllowsMultipleSelection:NO];
  result = [anOpenPanel runModalForDirectory:NSHomeDirectory() file:nil types:nil];
  
  if (result == NSOKButton)
    {
      filesToOpen = [anOpenPanel filenames];
      count = [filesToOpen count];
      
      if (count > 0)
	{
	  fileName = [filesToOpen objectAtIndex:0];
	  [dataHandlerCommandField setStringValue: fileName];
	}
    }
}

- (IBAction) chooseIcon: (id) sender
{
  NSArray *filesToOpen;
  NSOpenPanel *anOpenPanel;
  NSString *fileName;
  int count, result;

  anOpenPanel = [NSOpenPanel openPanel];
  [anOpenPanel setAllowsMultipleSelection:NO];
  result = [anOpenPanel runModalForDirectory:NSHomeDirectory() file:nil types:nil];
  
  if (result == NSOKButton)
    {
      filesToOpen = [anOpenPanel filenames];
      count = [filesToOpen count];
      
      if (count > 0)
	{
	  NSImage *anImage;

	  fileName = [filesToOpen objectAtIndex:0];

	  anImage = [[NSImage alloc] initWithContentsOfFile: fileName];

	  if (anImage)
	    {
	      [anImage setDataRetained: YES];
	      [iconButton setImage: anImage];
	    }
	}
    }
}



- (IBAction) selectionHasChanged : (id) sender
{
  switch ( [actionMatrix selectedRow] )
    {

    case 0:
      [dataHandlerCommandField setEditable: NO];
      [dataHandlerCommandButton setEnabled: NO];
      [needsTerminalButton setEnabled: NO];
      break;
      
    case 1:
      [dataHandlerCommandField setEditable: YES];
      [dataHandlerCommandButton setEnabled: YES];
      [needsTerminalButton setEnabled: YES];
      break;
      
    default:
      break;
    } 
}

//
// access/mutation methods
//

- (void) setMimeTypeManager: (MimeTypeManager *) theMimeTypeManager
{
  RETAIN(theMimeTypeManager);
  RELEASE(mimeTypeManager);
  mimeTypeManager = theMimeTypeManager;
}

- (MimeTypeManager *) mimeTypeManager
{
  return mimeTypeManager;
}

- (void) setMimeType: (MimeType *) theMimeType
{
  if ( theMimeType )
    {
      RETAIN(theMimeType);
      RELEASE(mimeType);
      mimeType = theMimeType;
    
      [mimeTypeField setStringValue: ([mimeType mimeType] ? [mimeType mimeType] : @"")];
      [fileExtensionsField setStringValue: ([mimeType stringValueOfFileExtensions] ? [mimeType stringValueOfFileExtensions] : @"")];
      [descriptionField setStringValue: ([mimeType description] ? [mimeType description] : @"")];
      [viewMatrix selectCellAtRow: [mimeType view] column: 0];
      [actionMatrix selectCellAtRow: [mimeType action] column: 0];
      [dataHandlerCommandField setStringValue: ([mimeType dataHandlerCommand] ? [mimeType dataHandlerCommand] : @"")];
      [needsTerminalButton setState: ([mimeType needsTerminal] ? NSOnState : NSOffState)];
      [iconButton setImage: [mimeType icon]];

      [[self window] setTitle: _(@"Edit a Mime-Type")];
    }
  else
    {
      RELEASE(mimeType);
      mimeType = nil;
    }
}

- (MimeType *) mimeType
{
  return mimeType;
}

@end
