/*
**  ExtendedCell.m
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "ExtendedCell.h"

#import "GNUMailConstants.h"
#import <Pantomime/Flags.h>

@implementation ExtendedCell

- (id) init
{
  self = [super init];

  answered_flag = [NSImage imageNamed: @"answered-flag.tiff"];
  RETAIN(answered_flag);
  
  mime_flag = [NSImage imageNamed: @"mime-flag.tiff"];
  RETAIN(mime_flag);
  
  new_flag = [NSImage imageNamed: @"new-flag.tiff"];
  RETAIN(new_flag);

  flags = nil;
  isMimeMessage = NO;

  return self;
}

- (void) dealloc
{
  RELEASE(answered_flag);
  RELEASE(new_flag);

  [super dealloc];
}

- (void) setFlags: (Flags *) theFlags
{
  flags = theFlags;
}

- (void) setIsMimeMessage: (BOOL) aBOOL
{
  isMimeMessage = aBOOL;
}

- (void) drawWithFrame: (NSRect) cellFrame 
		inView: (NSView *) controlView
{
  if ( flags == nil )
    {
      return;
    }

  if ( [flags contain: RECENT] )
    {
      [new_flag compositeToPoint: NSMakePoint(4,cellFrame.origin.y + 12)
		operation: NSCompositeSourceAtop];

    }

  if ( isMimeMessage )
    {
      [mime_flag compositeToPoint: NSMakePoint(20,cellFrame.origin.y + 12)
		 operation: NSCompositeSourceAtop];
      
    }

  if ( [flags contain: ANSWERED] )
    {
      [answered_flag compositeToPoint: NSMakePoint(36,cellFrame.origin.y + 12)
		operation: NSCompositeSourceAtop];

    }

  [super drawInteriorWithFrame: cellFrame 
	 inView: controlView];
}

@end
