/*
**  Group.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

@class Address;

@interface Group: NSObject <NSCoding>
{
  NSString *name;
  NSMutableArray *addresses;
}

//
//
//
- (id) init;
- (id) initWithName: (NSString *) theName;

- (void) dealloc;

//
// Coding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder;
- (id) initWithCoder: (NSCoder *) theCoder;


//
// access/mutation methods
//
- (NSString *) name;
- (void) setName: (NSString *) theName;

- (Address *) addressAtIndex: (int) theIndex;

- (NSArray *) addresses;
- (void) setAddresses: (NSArray *) theAddresses;

- (void) addAddress: (Address *) theAddress;
- (void) removeAddress: (Address *) theAddress;
- (void) removeAllAddresses;

- (int) compareAccordingToName: (Group *) aGroup;

- (void) sort;

@end
