/*
**  IMAPMailWindow.m
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import "IMAPMailWindow.h"
#import "GNUMail.h"
#import "GNUMailConstants.h"

#import <Pantomime/IMAPFolder.h>
#import <Pantomime/IMAPStore.h>


@implementation IMAPMailWindow

//
//
//
- (void) dealloc
{
  NSLog(@"IMAPMailWindow: -dealloc");
  
  RELEASE(get);

  [super dealloc];
}


//
//
//
- (void) layoutWindow 
{
  NSRect bRect;

  [super layoutWindow];
  
  // We first move our buttons for making space for the get button
  bRect = [mailboxes frame];
  bRect.origin.x += 72;
  [mailboxes setFrame:bRect];

  bRect = [compose frame];
  bRect.origin.x += 72;
  [compose setFrame:bRect];

  bRect = [reply frame];
  bRect.origin.x += 72;
  [reply setFrame:bRect];

  bRect = [forward frame];
  bRect.origin.x += 72;
  [forward setFrame:bRect];

  bRect = [addresses frame];
  bRect.origin.x += 72;
  [addresses setFrame:bRect];

  bRect = [find frame];
  bRect.origin.x += 72;
  [find setFrame:bRect];

  // We then add the get button
  get = [[NSButton alloc] initWithFrame:NSMakeRect(168,520,64,64)];
  [get setTitle: _(@"Get")];
  [get setFont:[NSFont systemFontOfSize: 8]];
  [get setImagePosition: NSImageAbove];
  [get setImage: [NSImage imageNamed: @"MailIcon_retrieve.tiff"]];
  [get setTarget: [self windowController]];
  [get setAction: @selector(getNewMessages:)];
  [get setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:get];
}

//
// access/mutation methods
//

- (NSButton *) get
{
  return get;
}

@end
