/*
**  MimeTypeManager.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <Foundation/Foundation.h>

@class MimeType;
@class NSTableView;
@class NSTableColumn;

NSString *PathToMimeTypes();

@interface MimeTypeManager: NSObject <NSCoding>
{
  NSMutableArray *mimeTypes;
}

- (id) init;
- (void) dealloc;

- (BOOL) synchronize;

//
// NSCoding protocol
//

- (void) encodeWithCoder: (NSCoder *) theCoder;
- (id) initWithCoder: (NSCoder *) theCoder;

//
// access/mutation methods
//
- (MimeType *) mimeTypeAtIndex: (int) theIndex;
- (void) addMimeType: (MimeType *) theMimeType;
- (void) removeMimeType: (MimeType *) theMimeType;

- (NSArray *) mimeTypes;
- (void) setMimeTypes: (NSArray *) theMimeTypes;

- (MimeType *) bestMimeTypeForFileExtension: (NSString *) theFileExtension;
- (MimeType *) mimeTypeForFileExtension: (NSString *) theFileExtension;

- (MimeType *) mimeTypeFromString: (NSString *) theString;

//
// class methods
//

+ (id) mimeTypesFromDisk;

@end
