/*
**  NSRegEx.m
**
**  Copyright (c) 2001
**
**  Author: Francis Lachapelle <francis@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "NSRegEx.h"

#import "GNUMailConstants.h"

@implementation NSRegEx 


+ (NSArray *) matchString: (NSString *) theString
	     withPattern : (NSString *) thePattern
	  isCaseSensitive: (BOOL) caseSensitive
{
  int flags, offset, status;
  char *s, *error;

  regmatch_t rm[1];
  regex_t re;

  NSMutableArray *aMutableArray;
  NSRegExRange *aRange;

  flags = REG_EXTENDED;

  if (!caseSensitive)
    {
      flags |= REG_ICASE;
    }

  if (regcomp(&re, [thePattern cString], flags) != 0)
    {
      return [NSArray array];
    }

  s = (char*)[theString lossyCString];
  aMutableArray = [[NSMutableArray alloc] init];
  
  status = regexec(&re, s, 1, rm, 0);
  offset = 0;
 
  while (status == 0)
    {
      aRange = [[NSRegExRange alloc] initWithRangeLocation: offset + rm[0].rm_so
				     length: rm[0].rm_eo - rm[0].rm_so];
      
      [aMutableArray addObject: aRange];
      RELEASE(aRange);
      
      offset += rm[0].rm_eo;
      status = regexec(&re, s + offset, 1, rm, REG_NOTBOL);
    }

  if (status != 0) 
    {
      error = malloc(255*sizeof(char));
      regerror(status, &re, error, 255);
      //NSLog(@"error: %s\n", error);
    }

  return AUTORELEASE(aMutableArray);
}

@end
