/*
**  NewMailboxPanelController.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "NewMailboxPanelController.h"

#import "GNUMail.h"
#import "GNUMailConstants.h"
#import "MailboxManager.h"
#import "MailboxManagerController.h"
#import "Filter.h"
#import "FilterManager.h"

#ifndef MACOSX
#import "NewMailboxPanel.h"
#endif

#import "NSStringExtensions.h"

#import <Pantomime/LocalStore.h>

@implementation NewMailboxPanelController

- (id) initWithWindowNibName: (NSString *) windowNibName
{
#ifdef MACOSX
  
  self = [super initWithWindowNibName: windowNibName];
 
#else
  NewMailboxPanel *newMailboxPanel;

  newMailboxPanel =
    [[NewMailboxPanel alloc] initWithContentRect: NSMakeRect(200,200,300,105)
			     styleMask: (NSTitledWindowMask |
					 NSMiniaturizableWindowMask)
			     backing: NSBackingStoreBuffered
			     defer: YES];
  
  self = [super initWithWindow: newMailboxPanel];
  
  [newMailboxPanel layoutPanel];
  [newMailboxPanel setDelegate: self];
  
  // We link our outlets
  mailboxNameField = [newMailboxPanel mailboxNameField];
  
  RELEASE(newMailboxPanel);
#endif

  [[self window] setTitle: _(@"New Mailbox")];

  return self;
}


- (void) dealloc
{
  NSLog(@"NewMailboxPanelController: -dealloc");
  TEST_RELEASE(name);

  [super dealloc];
}


//
// action methods
//

- (IBAction) okClicked: (id) sender
{
  // If we are renaming a mailbox..
  if (name)
    {
      // We must be sure our names are different
      if (! [name isEqualToString: [[mailboxNameField stringValue] stringByTrimmingWhiteSpaces] ]) 
	{
	  // name is our old name while the content of our text field is the new
	  // mailbox name
	  if ( [[NSFileManager defaultManager] movePath: [path stringByAppendingPathComponent: name]
					       toPath: [path stringByAppendingPathComponent: 
							       [mailboxNameField stringValue]]
					       handler: nil] )
	    {
	      
              BOOL isDir;

	      // We also rename our cache
	      [[NSFileManager defaultManager] movePath: [NSString stringWithFormat: @"%@/.%@.cache", [self path], [self name]]
					      toPath: [NSString stringWithFormat: @"%@/.%@.cache", [self path], [mailboxNameField stringValue]]
					      handler: nil];
	      
              // We need to change the target of the filters
              // targetting this mailbox
              if ( [[NSFileManager defaultManager] fileExistsAtPath: PathToFilters()
                                                   isDirectory: &isDir] &&
                   ! isDir )
		{
		  FilterManager *aFilterManager;
		  Filter *aFilter;
		  int i;
		  
		  aFilterManager = [FilterManager filtersFromDisk];
		  RETAIN(aFilterManager);
		  
		  for (i = 0; i < [[aFilterManager filters] count]; i++)
		    {   
		      aFilter = [aFilterManager filterAtIndex: i];
		      
		      if ([aFilter action] == TRANSFER_TO_FOLDER)
			{
			  if ([[aFilter actionFolderName] isEqualToString: [self name]])
			    {
			      [aFilter setActionFolderName: [mailboxNameField stringValue]];
			    }
			}
		    }
		  
		  [aFilterManager synchronize];
		  RELEASE(aFilterManager);
		}

	      // We must refresh our outline view
	      [[self mailboxManagerController] reloadAllFolders];
	      [[[self mailboxManagerController] outlineView] reloadData];
	    }
	  else
	    {
	      NSRunInformationalAlertPanel(_(@"Error!"),
					   _(@"The mailbox rename operation failed."),
					   _(@"OK"),
					   NULL,
					   NULL,
					   NULL);
	    }
	}
    }
  else
    {
      LocalStore *localStore;
      
      localStore = [(GNUMail *)[NSApp delegate] localStore];
      
      if ( [localStore createFolderWithName: [mailboxNameField stringValue]] )
	{
	  [[self mailboxManagerController] reloadAllFolders];
	  [[[self mailboxManagerController] outlineView] reloadData];
	}
      else
	{
	  NSRunInformationalAlertPanel(_(@"Error!"),
				       _(@"The mailbox create operation failed."),
				       _(@"OK"),
				       NULL,
				       NULL,
				       NULL);
	}
    }
  
  [NSApp stopModal];
  [self close];
}


- (IBAction) cancelClicked: (id) sender
{
  [NSApp abortModal];
  [self close];
}

//
// delegate methods
//

- (void) windowWillClose: (NSNotification *) theNotification
{
  AUTORELEASE(self);
}

- (void) windowDidLoad
{
  name = nil;
}

//
// access/mutation methods
//

- (MailboxManagerController *) mailboxManagerController
{
  return mailboxManagerController;
}

//
// We must NOT retain the mailbox manager controller here.
//
- (void) setMailboxManagerController: (MailboxManagerController *) theMailboxManagerController
{
  mailboxManagerController = theMailboxManagerController;
}

- (NSString *) name
{
  return name;
}

- (void) setName: (NSString *) theName
{
  if (theName)
    {
      RETAIN(theName);
      RELEASE(name);
      name = theName;
      
      [mailboxNameField setStringValue: name];
    }
  else
    {
      RELEASE(name);
      name = nil;

      [mailboxNameField setStringValue: @""];
    }
}

- (NSString *) path
{
  return path;
}


- (void) setPath: (NSString *) thePath
{
  if (thePath)
    {
      RETAIN(thePath);
      RELEASE(path);
      path = thePath;
    }
  else
    {
      RELEASE(path);
      path = nil;
    }
}

@end
