/*
**  PasswordPanel.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import "PasswordPanel.h"
#import "GNUMailConstants.h"
#import "LabelWidget.h"

#import "GNUMailConstants.h"

@implementation PasswordPanel

- (void) dealloc
{
  NSLog(@"PasswordPanel: -dealloc");

  RELEASE(passwordSecureField);
  [super dealloc];
}

- (void) layoutPanel
{
  NSButton *okButton, *cancelButton, *iconButton;
  LabelWidget *passwordLabel;
  
  iconButton = [[NSButton alloc] initWithFrame: NSMakeRect(10,80,64,64)];
  [iconButton setTitle: @""];
  [iconButton setImagePosition: NSImageOnly];
  [iconButton setImage: [NSImage imageNamed: @"pgp-mail.tiff"]];
  [iconButton setBordered: NO];
  [iconButton setEnabled: NO];
  [[self contentView] addSubview: iconButton];
  RELEASE(iconButton);

  passwordLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(80,90,250,TextFieldHeight)
			       label: _(@"Please enter your password:")];
  [passwordLabel setFont: [NSFont systemFontOfSize: 14]];
  [[self contentView] addSubview: passwordLabel];
  
  passwordSecureField = [[NSSecureTextField alloc] initWithFrame: NSMakeRect(20,50,250,TextFieldHeight)];
  [passwordSecureField setSelectable: YES];
  [[self contentView] addSubview: passwordSecureField];
  
  cancelButton = [[NSButton alloc] initWithFrame: NSMakeRect(140,10,60,ButtonHeight)];
  [cancelButton setButtonType: NSMomentaryPushButton];
  [cancelButton setTitle: _(@"Cancel")];
  [cancelButton setTarget: [self windowController]];
  [cancelButton setAction: @selector(cancelClicked:)];
  [[self contentView] addSubview: cancelButton];
  RELEASE(cancelButton);

  okButton = [[NSButton alloc] initWithFrame:  NSMakeRect(210,10,60,ButtonHeight)];
  [okButton setButtonType: NSMomentaryPushButton];
  [okButton setKeyEquivalent: @"\r"];
  [okButton setImagePosition: NSImageRight];
  [okButton setImage: [NSImage imageNamed: @"common_ret"]];
  [okButton setAlternateImage: [NSImage imageNamed: @"common_retH"]];
  [okButton setTitle: _(@"OK")];
  [okButton setTarget: [self windowController]];
  [okButton setAction: @selector(okClicked:)];
  [[self contentView] addSubview:okButton];
  RELEASE(okButton);

  // We set the initial responder and the next key views
  [self setInitialFirstResponder: passwordSecureField];
  [passwordSecureField setNextKeyView: okButton];
  [okButton setNextKeyView: cancelButton];
  [cancelButton setNextKeyView: passwordSecureField];
}


//
// access/mutation methods
//
- (NSSecureTextField *) passwordSecureField;
{
  return passwordSecureField;
}

@end
