/*
**  Utilities.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _GNUMail_H_Utilities
#define _GNUMail_H_Utilities

#import <AppKit/AppKit.h>

@class Folder;
@class FolderNode;
@class FolderNodePopUpItem;
@class Message;
@class MimeMultipart;
@class NSView;
@class Part;
@class Store;
@class URLName;


//
// C functions
//
NSComparisonResult CompareVersion(NSString *theCurrentVersion, NSString *theLatestVersion);
NSString *GNUMailTemporaryDirectory();
NSString *GNUMailUserLibraryPath();
NSString *GNUMailVersion();

//
//
//
@interface Utilities: NSObject
{
}

+ (NSFont *) fontFromFamilyName: (NSString *) theName
			  trait: (int) theTrait
                           size: (int) theSize;

+ (void) appendAddress: (NSArray *) theAddress
           toTextField: (NSTextField *) theTextField;

+ (NSAttributedString *) attributedStringFromContentForPart: (Part *) thePart;

+ (NSAttributedString *) attributedStringFromHeadersForMessage: (Message *) theMessage
                                                showAllHeaders: (BOOL) showAllHeader
                                             useMailHeaderCell: (BOOL) useMailHeaderCell;

+ (NSAttributedString *) attributedStringWithString: (NSString *) theString
                                         attributes: (NSDictionary *) theAttributes;


+ (NSAttributedString *) bestRepresentationFromMultipartAlternative: (MimeMultipart *) theMimeMultipart;

+ (NSAttributedString *) bestRepresentationFromMultipartAppleDouble: (MimeMultipart *) theMimeMultipart;
                                                  
+ (NSAttributedString *) formattedAttributedStringFromAttributedString: (NSAttributedString *) theAttributedString;

+ (NSString *) encryptPassword: (NSString *) thePassword
                       withKey: (NSString *) theKey;
+ (NSString *) decryptPassword: (NSString *) thePassword
                       withKey: (NSString *) theKey;


//
//
//
+ (void) loadAccountsInPopUpButton: (NSPopUpButton *) thePopUpButton 
                            select: (NSString *) theAccount;
+ (void) loadTransportMethodsInPopUpButton: (NSPopUpButton *) thePopUpButton;


//
//
//
+ (NSString *)accountNameForFolder: (Folder *) theFolder;
+ (NSString *) accountNameForItemTitle: (NSString *) theString;
+ (NSString *) accountNameForTransportMethodItemTitle: (NSString *) theString;

+ (NSString *) accountNameForServerName: (NSString *) theServerName
                               username: (NSString *) theUsername;

+ (NSString *) defaultAccountName;

+ (id) windowForFolderName: (NSString *) theName
                     store: (Store *) theStore;

+ (FolderNode *) folderNodeForPath: (NSString *) thePath
                             using: (FolderNode *) rootNode
                         separator: (NSString *) theSeparator;

+ (FolderNode *) folderNodesFromFolders: (NSEnumerator *) theFolders
                              separator: (NSString *) theSeparator;


+ (NSString *) completePathForFolderNode: (FolderNode *) theFolderNode
                               separator: (NSString *) theSeparator;

+ (NSString *) pathOfFolderFromFolderNode: (FolderNode *) theFolderNode
                                separator: (NSString *) theSeparator;

+ (NSString *) flattenPathFromString: (NSString *) theString
                           separator: (NSString *) theSeparator;


+ (NSString *) storeKeyForFolderNode: (FolderNode *) theFolderNode
                          serverName: (NSString **) theServerName
                            username: (NSString **) theUsername;

+ (BOOL) URLWithString: (NSString *) theString
           matchFolder: (Folder *) theFolder;

+ (BOOL) stringValueOfURLName: (NSString *) theString
                    isEqualTo: (NSString *) theName;
+ (NSString *) stringValueOfURLNameFromFolder: (Folder *) theFolder;
+ (NSString *) stringValueOfURLNameFromFolderNode: (FolderNode *) theFolderNode
				       serverName: (NSString *) theServerName
                                         username: (NSString *) theUsername;

+ (FolderNode *) initializeFolderNodesUsingAccounts: (NSDictionary *) theAccounts;

+ (void) addItemsToPopUpButton: (NSPopUpButton *) thePopUpButton
              usingFolderNodes: (FolderNode *) theFolderNodes;

+ (void) addItem: (FolderNode *) theFolderNode
	   level: (int) theLevel
   toPopUpButton: (NSPopUpButton *) thePopUpButton;

+ (FolderNodePopUpItem *) folderNodePopUpItemForFolderNode: (FolderNode *) theFolderNode
                                               popUpButton: (NSPopUpButton *) thePopUpButton;

+ (FolderNodePopUpItem *) folderNodePopUpItemForURLNameAsString: (NSString *) theString
                                               usingFolderNodes: (FolderNode *) theFolderNodes
                                                    popUpButton: (NSPopUpButton *) thePopUpButton
                                                        account: (NSString *) theAccountName;

+ (NSString *) passwordForKey: (id) theKey
                         type: (int) theType
                       prompt: (BOOL) aBOOL;

+ (NSMutableDictionary *) passwordCache;

+ (void) replyToSender: (Message *) theMessage
                folder: (Folder *) theFolder
            replyToAll: (BOOL) theBOOL;

+ (void) forwardMessage: (Message *) theMessage;

+ (void) showMessage: (Message *) theMessage
              target: (NSTextView *) theTextView
      showAllHeaders: (BOOL) headersFlag;

+ (void) showMessageRawSource: (Message *)theMessage
                       target: (NSTextView *)theTextView;

+ (void) clickedOnCell: (id <NSTextAttachmentCell>) attachmentCell
	        inRect: (NSRect) cellFrame
               atIndex: (unsigned) charIndex
                sender: (id) sender;

+ (NSDictionary *) allEnabledAccounts;
+ (NSMutableArray *) quoteLevelColors;

@end

//
// Utilities private interface
//
@interface Utilities (Private)

+ (void) _savePanelDidEnd: (NSSavePanel *) theSavePanel
               returnCode: (int) theReturnCode
              contextInfo: (void *) theContextInfo;

+ (NSMutableAttributedString *) _quoteMessageContentFromAttributedString: (id) theAttributedString;
+ (void) _highlightAndActivateURLs: (NSTextView *) theTextView;

+ (NSString *) _guessAccountNameFromMessage: (Message *) theMessage;

+ (NSAttributedString *) _attributedStringFromTextForPart: (Part *) thePart;

+ (void) _launchExternalProgram: (NSDictionary *) theDictionary;

@end

#endif // _GNUMail_H_Utilities
