/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

#ifndef HOST_H
#define HOST_H

#include "lib.h"
#include "list.h"
#include "hash.h"

#define VPN_A    0x01
#define VPN_B    0x02
#define VPN_C    0x04
#define VPN_P    0x08
#define BAD_ADDR 0x80

#ifdef __cplusplus
extern "C" {
#endif

  extern eqhd_vendor evendors[];
  extern uint32 hlru_num;

  void fre_hen(host_entry **x, int bugnum);

  int host_class(uchar *ip);
  int can_connect(uchar *from_ip, uchar *to_ip);
  int host_ok_for_get(uchar *ip);
#define host_ok_for_gnet host_ok_for_get
  int host_ok_for_push(uchar *ip);
  int host_ok_for_either(uchar *ip);
  int host_ok_for_both(uchar *ip);
  int host_ok_for_neither(uchar *ip);

  int host_save(char *fname);
  int host_restore(char *fname);

  host_entry * host_add(host_entry *he);
  int host_find(uchar ip[4], uchar port[2]);
  int host_clear();
  void host_rmv_core(host_entry *h);
  int host_remove(uchar ip[4], uchar port[2]);
  int host_totals(uint *num, float64 *files, float64 *size);
  void clear_he(host_entry * he);
  int host_init();
  void host_get_lru(host_entry *he);
  void host_put_lru(host_entry *he);

  int host_lock();
  Gnut_Hash * host_retrieve();
  int host_unlock();

#ifdef __cplusplus
}
#endif

#endif
