/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

#ifndef GNUT_NET_H
#define GNUT_NET_H

#ifndef WIN32
# include <netdb.h>
#endif

#include "transfer.h"
#include "protocol.h"

#define MT_FOR_PUSH 1
#define MT_FOR_DOWNLOAD 2
#define MT_FOR_GNET 3

#ifdef __cplusplus
extern "C" {
#endif
 
  void fre_he(struct hostent **x, int bugnum);
  uchar *net_local_ip(void);
  int gnut_net_host(void);
  int net_init(char *iface);
  int timed_read(int sock, char *buf, int len, int secs);
  int timed_recv(int sock, char *buf, int len, int flags, int secs);
  int timed_connect(int sockfd, struct sockaddr *sa, int addrlen, int secs,
		    gnut_transfer *gt);
  int create_listen_socket(int * port);
  int read_line(int sock, char *buf, int len);
  struct hostent *gnut_hostent_copy(struct hostent *he);
  void gnut_hostent_delete(struct hostent *he);
  int make_connection(uchar *host, uint port, uchar ip[4], int for_transfer,
		      int type, gnut_transfer *gt, int *retry_enable);
  int send_packet(int sock, gnutella_packet * gpa);
  int read_packet(int sock, gnutella_packet * gpa);

#ifdef __cplusplus
}
#endif

#endif
