#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cli.h"
#include "lib.h"
#include "list.h"
#include "player.h"

static Gnut_List *player_list;

void play_init(void)
{
  char *d;

  player_list = 0;

#ifdef WIN32
  d = expand_path("players.ini");
#else
  d = expand_path("~/.gnut_players");
#endif
  if (d) {
    run_config_file(d, 1, 1, 0);
    fre_str(&d, 375);
  }

}

void player_add(char *mime_type, char *extension, char *program)
{
  player_t *player;

  player = (player_t *)ymaloc(sizeof(player_t), 304);

  player->mime_type = ystdup(mime_type, 451);
  player->extension = ystdup(extension, 452);
  player->program = program ? ystdup(program, 453) : 0;

  player_list = gnut_list_prepend(player_list, player);
}

void player_play(char *mime_type, char *filename)
{
  Gnut_List *list;
  player_t *player;
  char playbuffer[512];
  char *extptr;

  list = player_list;

  while (1) {
    if (!list) break;
    player = list->data;
    if (!player) break;

    if (player->program) {
      if (mime_type && strcmp(mime_type, player->mime_type)) {
	if ((strlen(player->program) + strlen(filename)) <512) {
	  sprintf(playbuffer, "%s \"%s\" &", player->program, filename);
	  system(playbuffer);
	}
	return;
      }
      
      extptr = strrchr(filename, '.');
      extptr++;
      if (*extptr) {
	if (!strcmp(extptr, player->extension)) {
	  if ((strlen(player->program) + strlen(filename)) <512) {
	    sprintf(playbuffer, "%s \"%s\" &", player->program, filename);
	    system(playbuffer);
	  }
	  return;
	}
      }
    }
    list = gnut_list_next(list);
  }
}

void player_foreach(int (*handler)(player_t *player, void *data), void *data)
{
 Gnut_List *list;
  player_t *player;

  list = player_list;

  while (1) {
    if (!list) break;
    player = list->data;
    if (!player) break;
	handler(player, data);
    list = gnut_list_next(list);
  }
}

static int player_writer(player_t *player, void *data)
{
	FILE *f;
	f = (FILE *)data;

	fprintf(f, "player mime_type %s extension %s player %s\n",
		player->mime_type,
		player->extension,
		player->program);
	return 0;
}


void player_save(void)
{
	FILE *f;
	char *d;
#ifdef WIN32
	f = fopen("players.ini", "w");
#else
	d = expand_path("~/.gnut_players");
	f = fopen(d, "w");
#endif
	if (f) {
		player_foreach(player_writer, (void *)f);
		fclose(f);
	}
}
