/* td.h, part of gnut

   Josh Pieper, (c) 2000
   Robert Munafo, (c) 2001

   This file is distributed under the GPL, see file COPYING for details
*/

#ifndef TD_H
#define TD_H

/* Sometimes, there are so many typedef's that are needed by more than
   one header file that there is no way to avoid circular include problems.
   Here is an example:

   a.h                                          b.h

   typedef struct {                             typedef struct {
     ...                                          ...
   } s_a;                                       } s_b;

   int foo(s_a * x, s_b * y);                   int bar(s_a * x, s_b *y);

   both header files defines functions that take a parameter whose type is
   defined in a.h and another parameter whose type is defined in b.h. There
   are many ways to resolve this circular dependency, including merging the
   header files into a single header file or creating a "typedefs" header
   file for each module (resulting in a total of 4 header files).

*/

/* level-1 system headers */
#include <netinet/in.h>
#include <pthread.h>

/* level-2 system headers */

/* There are NO local headers because this file is supposed to be the first
   local header, included by all the others */

/* Explicit length typedefs */
/* 'uchar' is for use when manipulating characters; 'uint8' and 'int8' are for
   the normal case of manipulating bytes of data defined to be 8 bits long,
   like the 4 bytes in an IPV4 address */
typedef unsigned char      uchar;
typedef          char       int8;
typedef unsigned char      uint8;
typedef          short      int16;
typedef unsigned short     uint16;
typedef          int        int32;
typedef unsigned int       uint32;
typedef          long long  int64;
typedef unsigned long long uint64;

typedef          float    float32;
typedef          double   float64;

/* Variable-length string */
typedef struct {
  uint32 vs_alloc;
  uint32 vs_used;
} varstring_alloc;

typedef struct {
  uint32 vs_alloc;
  uint32 vs_used;
  char   vs_data[1];
} varstring_data;

typedef struct {
  char * vcode;
  char * appname;
} eqhd_vendor;

typedef struct {
  uchar ip[4];
  uchar port_le[2];
  uint32  files;
  uint32  kbytes;
} host_entry;

typedef union {
  struct in_addr a;
  uchar          b[sizeof(struct in_addr)];
} ip_t; /* to ensure correct alignment on architectures that require it */

/* This structure is used to record an active search in progress. */
typedef struct _GnutSearch GnutSearch;
struct _GnutSearch {
  char       *guid;
  char       *query;
  int        responses;
  GnutSearch  *next;
};

typedef struct _Gnut_List Gnut_List;
struct _Gnut_List {
  void * data;
  Gnut_List * next;
};

typedef struct _Gnut_Queue Gnut_Queue;
struct _Gnut_Queue {
  Gnut_List *head;
  Gnut_List *tail;
  uint32 size;
};

/* Define the following to enable the packet_stats option */
/* #define MOREPACKETSTATS */

typedef struct {
  int gc_sock;  /* fd of the sock belonging to this connection */

  pthread_mutex_t out_q_mutex;
  Gnut_Queue *out_queue;    /* packets queued up to be sent */
  
  ip_t    ip;
  uint16  port;
  
  int     sent_packets;
  int     received_packets;
  int     dropped_packets;
  int     bad_packets;
  
  float64 snt_bytes;
  float64 rcv_bytes;
  
  /* the next couple are for rate control */
  float64 rate_snt_bytes;
  float64 rate_rcv_bytes;
  time_t  rate_start_time;

  int     routing_errors;

  int     seen_pong;
  
  /* type indicates whether this is an outgoing, or incoming
   * connection */
  int     ctype;
  
  /* the state indicates what state the connection is in, see
   * defines below for possible values */
  int     cstate;
  
  /* this index is used for user-interface purposes, it should
   * only be set by the ui... */
  int32   uindex;
  
  pthread_t tid;
#ifdef MOREPACKETSTATS
  int     packet_count[256];
  int     packet_byte_count[256];
  int     max_packet_size[256];
  int     ttl_count[256];

  int     out_packet_count[256];
  int     out_packet_byte_count[256];
  int     out_max_packet_size[256];
  int     out_ttl_count[256];
#endif
} gcs;

#endif

/* end of td.h */
