#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include "pthread.h"
#include "..\gnut_lib.h"

BOOL pthread_equal(pthread_t t1, pthread_t t2)
{
	return t1 == t2;
}

void pthread_mutex_lock(pthread_mutex_t *pmutex)
{
	WaitForSingleObject(*pmutex, INFINITE);
}

int pthread_mutex_trylock(pthread_mutex_t *pmutex)
{
	int ret;
	ret=WaitForSingleObject(*pmutex, 1);
	if (ret==WAIT_TIMEOUT) return -1;
	return 0;
}

void pthread_mutex_unlock(pthread_mutex_t *pmutex)
{
	ReleaseMutex(*pmutex);
}

void pthread_exit(void *val)
{
	ExitThread((DWORD) val);
}

void pthread_create(pthread_t *pt, void *pv, void * f(void *) ,void *pargs)
{
	DWORD id;
	*pt = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE) f, pargs, 0, &id);
}

void pthread_detach(pthread_t *pt)
{
	CloseHandle(*pt);

}

pthread_t pthread_self() 
{ 
	// this is only used for debugging, so it's okay to lie here
	return (pthread_t) GetCurrentThreadId();
}



void pthread_mutex_init(pthread_mutex_t *pmutex, void *pv)
{
	*pmutex = CreateMutex(NULL, FALSE, NULL);
}



int fcntl(int sock, int action, uint value)
{
	return ioctlsocket((HANDLE) sock, FIONBIO, &value);
}


/* Parse S into tokens separated by characters in DELIM.
   If S is NULL, the saved pointer in SAVE_PTR is used as
   the next starting point.  For example:
        char s[] = "-abc-=-def";
        char *sp;
        x = strtok_r(s, "-", &sp);      // x = "abc", sp = "=-def"
        x = strtok_r(NULL, "-=", &sp);  // x = "def", sp = NULL
        x = strtok_r(NULL, "=", &sp);   // x = NULL
                // s = "abc\0-def\0"
*/
char *
   strtok_r (s, delim, save_ptr)
/* [<][>][^][v][top][bottom][index][help] */
   char *s;
const char *delim;
char **save_ptr;
{
	char *token;

	if (s == NULL)
		s = *save_ptr;

  /* Scan leading delimiters.  */
	s += strspn (s, delim);
	if (*s == '\0')
		return NULL;

  /* Find the end of the token.  */
	token = s;
	s = strpbrk (token, delim);
	if (s == NULL)
	/* This token finishes the string.  */
		*save_ptr = strchr (token, '\0');
	else
	{
	  /* Terminate the token and make *SAVE_PTR point past it.  */
		*s = '\0';
		*save_ptr = s + 1;
	}
	return token;
}



/* file getopt.c                                                   */
/*                Author: Peter Wilson                             */
/*                        Catholic University and NIST             */
/*                        pwilson@cme.nist.gov                     */
/*                                                                 */
/* getopt()  from Don Libes "Obfuscated C" */


#include <stdio.h>

/* getopt()  -- parse command line arguments */
/* Original Author: AT&T */
/* This version from Don Libes "Obfuscated C and Other Mysteries" */
/*  John Wiley & Sons, 1993. Chapter 6 */


#define ERR(s, c)    if(opterr){\
     char errbuf[2];\
     errbuf[0] = c; errbuf[1] = '\n';\
     fprintf(stderr, argv[0], (unsigned)strlen(argv[0]));\
     fprintf(stderr, s, (unsigned)strlen(s));\
     fprintf(stderr, errbuf, 2);}

extern int strcmp();
extern char *strchr();

int opterr = 1;    /* getopt prints errors if this is one */
int optind = 1;    /* token pointer */
int optopt;        /* option character passed back to user */
char *optarg;      /* flag argument (or value) */

int  /* return option option character, EOF if no more or ? if problem */
getopt(argc, argv, opts)
int argc;
char **argv;
char *opts;          /* option string */
{
    static int sp = 1;   /* character index in current token */
    register char *cp;   /* pointer into current token */

    if(sp == 1)
          /* check for more flag-like tokens */
          if(optind >= argc ||
             argv[optind][0] != '-' || argv[optind][1] == '\0')
               return(EOF);
          else if(strcmp(argv[optind], "--") == 0) {
               optind++;
               return(EOF);
	  }
    optopt = argv[optind][sp];
    if(optopt == ':' || (cp=strchr(opts, optopt)) == 0) {
         ERR(": illegal option -- ", optopt);
         /* if no chars left in this token, move to next token */
         if(argv[optind][++sp] == '\0') {
              optind++;
              sp = 1;
	 }
         return('?');
       }

       if(*++cp == ':') {/* if a value is expected, get it */
            if(argv[optind][sp+1] != '\0')
                 /* flag value is rest of current token */
                 optarg = &argv[optind++][sp+1];
            else if(++optind >= argc) {
                 ERR(": option requires an argument -- ", optopt);
                 sp = 1;
                 return('?');
	       } else
                    /* flag value is next token */
                    optarg = argv[optind++];
              sp = 1;
	  } else {
               /* set up to look at next char in token, next time */
               if(argv[optind][++sp] == '\0') {
                    /* no m ore in current token, set up next token */
                    sp = 1;
                    optind++;
		  }
               optarg = 0;
	     }
         return(optopt); /* return current flag character found */
  }
   


