#include "main.h"
#include "goat.h"
#include "button.h"
#include "about.h"
#include "preferences.h"

extern GtkWidget *button_menu, *apple;
extern GnomeHelpMenuEntry help;
extern gint size_default, colour_default, panel_size;
extern gboolean default_sound, default_sticky, default_floating;
extern gchar *default_sound_file, *default_font_name,*pixmapdir;
/* extern Goat *goat_list_start; */
extern GList *goats;

void
create_button_menu()
{
  /* create non-panel button menu */

  GtkWidget *item, *my_goats_menu;

  button_menu = gtk_menu_new();

  my_goats_menu = gtk_menu_new();
  
  item = gtk_menu_item_new_with_label(_("Raise all"));
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(my_goats_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(my_goats),&goat_raise);

  item = gtk_menu_item_new_with_label(_("Lower all"));
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(my_goats_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(my_goats),&goat_lower);

  item = gtk_menu_item_new_with_label(_("Hide all"));
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(my_goats_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(my_goats),&goat_hide);

  item = gtk_menu_item_new_with_label(_("Show all"));
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(my_goats_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(my_goats),&goat_show);

  item = gtk_menu_item_new_with_label(_("Shade all"));
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(my_goats_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(my_goats),&goat_shade_note);

  item = gtk_menu_item_new_with_label(_("Unshade all"));
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(my_goats_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(my_goats),&goat_unshade_note);

  item = gtk_menu_item_new_with_label(_("Delete all"));
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(my_goats_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(my_goats),&goat_delete);

  item = gtk_menu_item_new_with_label(_("My Goats"));
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(button_menu),item);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), my_goats_menu);

  item = gtk_menu_item_new_with_label(_("Preferences"));
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(button_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(preferences_show),NULL);

  item = gtk_menu_item_new_with_label(_("Help"));
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(button_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(gnome_help_display),&help);

  item = gtk_menu_item_new_with_label(_("About"));
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(button_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(about_show),NULL);

  item = gtk_menu_item_new_with_label(_("Exit"));
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(button_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(main_exit_program),NULL);

}

void
applet_pressed(GtkWidget *widget)
{
    goat_create(-1,-1,size_default,size_default,_("Alarm Triggered!"),FALSE,0,
                    TRUE, default_sound, default_sound_file,NULL,colour_default,default_font_name, 
                    FALSE,default_sticky, default_floating, FALSE,0,"", FALSE);
}

void
icon_pressed(GtkWidget *widget, GdkEventButton *event)
{
  if (event->button == 1) applet_pressed(NULL);
  else if (event->button == 3) {
  gtk_menu_popup(GTK_MENU(button_menu),NULL,NULL,NULL,NULL,
                   event->button, event->time);
  }
}

void
my_goats(GtkWidget *widget, void *operation(GtkWidget *widget, Goat **goat))
{
   Goat *current;
   gint i;

   for (i=0; i < g_list_length(goats); i++) {
     current = g_list_nth_data(goats,i);
     operation(NULL, &current);
   }
}

gint
applet_entered(GtkWidget *widget, GdkEventCrossing *event)
{
  gchar *fname;

  fname = g_strdup_printf("%s%s",pixmapdir,"goats_focus.png");
  gnome_pixmap_load_file_at_size(GNOME_PIXMAP(apple), fname, 
				 panel_size-2, panel_size-2);
  g_free(fname);
  return FALSE;
}

gint
applet_left(GtkWidget *widget, GdkEventCrossing *event)
{
  gchar *fname;

  fname = g_strdup_printf("%s%s",pixmapdir,"goats.png");
  gnome_pixmap_load_file_at_size(GNOME_PIXMAP(apple), fname,
				 panel_size-2, panel_size-2);
  g_free(fname);
  return FALSE;
}
