indexing

	description: 

		"Scanners for an XML parser"

	implements: "XML 1.0 Second Edition - W3C Recommendation 6 October 2000 (referred as 'XML1.0')"
	noncompliance_unicode: "UTF8 is assumed and all chars >255 are assumed to be LETTERS"

	library: "Gobo Eiffel XML library"
	copyright: "Copyright (c) 2002-2003, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/06/26 20:08:34 $"
	revision: "$Revision: 1.12 $"

	-- TODO:
	-- system literal accepts non-CHAR
	-- use NOAPOSCHAR/NOQUOTCHAR for attribute value?

class XM_EIFFEL_SCANNER

inherit

	XM_EIFFEL_SCANNER_SKELETON
		redefine
			read_token
		end

creation

	make_scanner


feature -- Status report

	valid_start_condition (sc: INTEGER): BOOLEAN is
			-- Is `sc' a valid start condition?
		do
			Result := (INITIAL <= sc and sc <= dtd_ignore)
		end

feature {NONE} -- Implementation

	yy_build_tables is
			-- Build scanner tables.
		do
			yy_nxt ?= yy_nxt_template
			yy_chk ?= yy_chk_template
			yy_base ?= yy_base_template
			yy_def ?= yy_def_template
			yy_ec ?= yy_ec_template
			yy_meta ?= yy_meta_template
			yy_accept ?= yy_accept_template
		end

	yy_execute_action (yy_act: INTEGER) is
			-- Execute semantic action.
		do
if yy_act <= 72 then
if yy_act <= 36 then
if yy_act <= 18 then
if yy_act <= 9 then
if yy_act <= 5 then
if yy_act <= 3 then
if yy_act <= 2 then
if yy_act = 1 then
	yy_column := yy_column + 4
	yy_position := yy_position + 4
--|#line 130 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 130")
end
 
			set_last_token (COMMENT_START)
			push_start_condition (comment_state)
		
else
	yy_column := yy_column + 3
	yy_position := yy_position + 3
--|#line 138 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 138")
end

			set_last_token (COMMENT_END)
			pop_start_condition
		
end
else
	yy_column := yy_column + 2
	yy_position := yy_position + 2
--|#line 143 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 143")
end
 
			set_last_token (COMMENT_DASHDASH) -- conformance error XML1.0:2.5
			last_value := text
		
end
else
if yy_act = 4 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 148 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 148")
end

			set_last_token (CHARDATA)
			last_value := text
		
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 153 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 153")
end

			set_last_token (CHARDATA_UTF8)
			last_value := text
		
end
end
else
if yy_act <= 7 then
if yy_act = 6 then
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 158 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 158")
end

			set_last_token (CHARDATA)
			last_value := text
		
else
yy_set_line_column
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 169 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 169")
end

			set_last_token (XMLDECLARATION_START)
			push_start_condition (xmldeclaration)
		
end
else
if yy_act = 8 then
yy_set_line_column
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 174 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 174")
end

				-- "<?xml" matched by previous rule when allowed.
			set_last_token (PI_RESERVED)
		
else
	yy_column := yy_column + 2
	yy_position := yy_position + 2
--|#line 178 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 178")
end

				-- <?xml caught by previous rules.
			set_last_token (PI_START)
			push_start_condition (processinginstruction)
		
end
end
end
else
if yy_act <= 14 then
if yy_act <= 12 then
if yy_act <= 11 then
if yy_act = 10 then
	yy_column := yy_column + 2
	yy_position := yy_position + 2
--|#line 187 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 187")
end

			set_last_token (XMLDECLARATION_END)
			pop_start_condition
		
else
yy_set_line_column
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 193 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 193")
end

			set_last_token (XMLDECLARATION_VERSION)
		
end
else
	yy_column := yy_column + 3
	yy_position := yy_position + 3
--|#line 197 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 197")
end

			set_last_token (XMLDECLARATION_VERSION_10)
			last_value := text
		
end
else
if yy_act = 13 then
yy_set_line_column
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 203 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 203")
end

			set_last_token (XMLDECLARATION_STANDALONE) 
		
else
	yy_column := yy_column + 3
	yy_position := yy_position + 3
--|#line 207 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 207")
end

			set_last_token (XMLDECLARATION_STANDALONE_YES)
			last_value := text
		
end
end
else
if yy_act <= 16 then
if yy_act = 15 then
	yy_column := yy_column + 2
	yy_position := yy_position + 2
--|#line 212 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 212")
end

			set_last_token (XMLDECLARATION_STANDALONE_NO)
			last_value := text
		
else
yy_set_line_column
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 218 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 218")
end

			set_last_token (XMLDECLARATION_ENCODING)
		
end
else
if yy_act = 17 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 222 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 222")
end

			-- 'yes' 'no' '1.0' caught by previous rules
			set_last_token (XMLDECLARATION_ENCODING_VALUE)
			last_value := text
		
else
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 228 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 228")
end

			set_last_token (APOS)
		
end
end
end
end
else
if yy_act <= 27 then
if yy_act <= 23 then
if yy_act <= 21 then
if yy_act <= 20 then
if yy_act = 19 then
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 232 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 232")
end

			set_last_token (QUOT)
		
else
yy_set_line_column
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 236 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 236")
end
 
			set_last_token (SPACE) 
		
end
else
	yy_column := yy_column + 2
	yy_position := yy_position + 2
--|#line 243 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 243")
end

			set_last_token (PI_END)
			pop_start_condition
		
end
else
if yy_act = 22 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 247 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 247")
end

			set_last_token (PI_TARGET)
			last_value := text
		
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 252 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 252")
end

			set_last_token (PI_TARGET_UTF8)
			last_value := text
		
end
end
else
if yy_act <= 25 then
if yy_act = 24 then
yy_set_line_column
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 257 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 257")
end

			set_last_token (SPACE)
			last_value := text
		
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 261 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 261")
end

			set_last_token (CHARDATA)
			last_value := text
		
end
else
if yy_act = 26 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 265 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 265")
end

			set_last_token (CHARDATA_UTF8)
			last_value := text
		
else
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 270 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 270")
end
 
			set_last_token (CHARDATA) 
			last_value := text
		
end
end
end
else
if yy_act <= 32 then
if yy_act <= 30 then
if yy_act <= 29 then
if yy_act = 28 then
	yy_column := yy_column + 9
	yy_position := yy_position + 9
--|#line 278 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 278")
end

	set_last_token (CDATA_START)
	push_start_condition (cdata)

else
	yy_column := yy_column + 3
	yy_position := yy_position + 3
--|#line 285 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 285")
end
 
			set_last_token (CDATA_END) 
			pop_start_condition
		
end
else
yy_set_line_column
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 289 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 289")
end

				-- End of line handling XML1.0:2.11.
			set_last_token (CHARDATA)
			last_value := normalized_newline
		
end
else
if yy_act = 31 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 295 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 295")
end

			set_last_token (CHARDATA)
			last_value := text
		
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 299 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 299")
end

				-- Big chunks in `last_value'.
			set_last_token (CHARDATA_UTF8)
			last_value := text
		
end
end
else
if yy_act <= 34 then
if yy_act = 33 then
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 305 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 305")
end
 
			set_last_token (CHARDATA) 
			last_value := text
		
else
	yy_column := yy_column + 9
	yy_position := yy_position + 9
--|#line 311 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 311")
end

		set_last_token (DOCTYPE_START)
		push_start_condition (dtd_in)
	
end
else
if yy_act = 35 then
	yy_column := yy_column + 9
	yy_position := yy_position + 9
--|#line 318 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 318")
end
 set_last_token (DOCTYPE_REQUIRED) 
else
	yy_column := yy_column + 8
	yy_position := yy_position + 8
--|#line 319 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 319")
end
 set_last_token (DOCTYPE_IMPLIED) 
end
end
end
end
end
else
if yy_act <= 54 then
if yy_act <= 45 then
if yy_act <= 41 then
if yy_act <= 39 then
if yy_act <= 38 then
if yy_act = 37 then
	yy_column := yy_column + 6
	yy_position := yy_position + 6
--|#line 320 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 320")
end
 set_last_token (DOCTYPE_FIXED) 
else
	yy_column := yy_column + 5
	yy_position := yy_position + 5
--|#line 321 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 321")
end

			set_last_token (DOCTYPE_ATT_CDATA) 
			last_value := text
		
end
else
	yy_column := yy_column + 2
	yy_position := yy_position + 2
--|#line 325 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 325")
end

			set_last_token (DOCTYPE_ATT_ID) 
			last_value := text
		
end
else
if yy_act = 40 then
	yy_column := yy_column + 5
	yy_position := yy_position + 5
--|#line 329 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 329")
end

			set_last_token (DOCTYPE_ATT_IDREF)
			last_value := text
		
else
	yy_column := yy_column + 6
	yy_position := yy_position + 6
--|#line 333 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 333")
end

			set_last_token (DOCTYPE_ATT_IDREFS)
			last_value := text
		
end
end
else
if yy_act <= 43 then
if yy_act = 42 then
	yy_column := yy_column + 6
	yy_position := yy_position + 6
--|#line 337 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 337")
end

			set_last_token (DOCTYPE_ATT_ENTITY)
			last_value := text
		
else
	yy_column := yy_column + 8
	yy_position := yy_position + 8
--|#line 341 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 341")
end

			set_last_token (DOCTYPE_ATT_ENTITIES) 
			last_value := text
		
end
else
if yy_act = 44 then
	yy_column := yy_column + 7
	yy_position := yy_position + 7
--|#line 345 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 345")
end

			set_last_token (DOCTYPE_ATT_NMTOKEN) 
			last_value := text
		
else
	yy_column := yy_column + 8
	yy_position := yy_position + 8
--|#line 349 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 349")
end

			set_last_token (DOCTYPE_ATT_NMTOKENS)
			last_value := text
		
end
end
end
else
if yy_act <= 50 then
if yy_act <= 48 then
if yy_act <= 47 then
if yy_act = 46 then
	yy_column := yy_column + 8
	yy_position := yy_position + 8
--|#line 353 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 353")
end

			set_last_token (DOCTYPE_ATT_NOTATION)
			last_value := text
		
else
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 357 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 357")
end

			set_last_token (VALUE_START)
			push_start_condition (attribute_value_single)
		
end
else
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 361 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 361")
end

			set_last_token (VALUE_START)
			push_start_condition (attribute_value_double)
		
end
else
if yy_act = 49 then
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 369 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 369")
end

			set_last_token (DOCTYPE_DECLARATION_START)
			push_start_condition (doctype)
		
else
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 379 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 379")
end

			set_last_token (DOCTYPE_DECLARATION_START)
			push_start_condition (doctype) -- Same, but balances end.
		
end
end
else
if yy_act <= 52 then
if yy_act = 51 then
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 384 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 384")
end

			set_last_token (DOCTYPE_DECLARATION_END)
			pop_start_condition
		
else
	yy_column := yy_column + 9
	yy_position := yy_position + 9
--|#line 389 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 389")
end

			set_last_token (DOCTYPE_ELEMENT)
			push_start_condition (dtd_element)
		
end
else
if yy_act = 53 then
	yy_column := yy_column + 9
	yy_position := yy_position + 9
--|#line 393 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 393")
end

			set_last_token (DOCTYPE_ATTLIST)
			push_start_condition (dtd_attlist)
		
else
	yy_column := yy_column + 8
	yy_position := yy_position + 8
--|#line 397 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 397")
end

			set_last_token (DOCTYPE_ENTITY)
			push_start_condition (dtd_entity)
		
end
end
end
end
else
if yy_act <= 63 then
if yy_act <= 59 then
if yy_act <= 57 then
if yy_act <= 56 then
if yy_act = 55 then
	yy_column := yy_column + 10
	yy_position := yy_position + 10
--|#line 401 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 401")
end

			set_last_token (DOCTYPE_NOTATION)
			push_start_condition (dtd_notation)
		
else
	yy_column := yy_column + 6
	yy_position := yy_position + 6
--|#line 406 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 406")
end

			set_last_token (DOCTYPE_IGNORE)
			last_value := text
		
end
else
	yy_column := yy_column + 7
	yy_position := yy_position + 7
--|#line 411 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 411")
end

			set_last_token (DOCTYPE_INCLUDE)
			last_value := text
		
end
else
if yy_act = 58 then
	yy_column := yy_column + 3
	yy_position := yy_position + 3
--|#line 416 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 416")
end

			set_last_token (DOCTYPE_CONDITIONAL_START)
		
else
	yy_column := yy_column + 3
	yy_position := yy_position + 3
--|#line 420 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 420")
end

			set_last_token (DOCTYPE_CONDITIONAL_END)
		
end
end
else
if yy_act <= 61 then
if yy_act = 60 then
	yy_column := yy_column + 3
	yy_position := yy_position + 3
--|#line 427 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 427")
end

			set_last_token (DOCTYPE_CONDITIONAL_START)
			push_start_condition (dtd_ignore) -- Self, for exit.
		
else
	yy_column := yy_column + 3
	yy_position := yy_position + 3
--|#line 432 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 432")
end

			set_last_token (DOCTYPE_CONDITIONAL_END)
			pop_start_condition
		
end
else
if yy_act = 62 then
	yy_column := yy_column + 4
	yy_position := yy_position + 4
--|#line 437 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 437")
end

			set_last_token (CHARDATA)
		
else
	yy_column := yy_column + 7
	yy_position := yy_position + 7
--|#line 444 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 444")
end
 set_last_token (DOCTYPE_PCDATA) 
end
end
end
else
if yy_act <= 68 then
if yy_act <= 66 then
if yy_act <= 65 then
if yy_act = 64 then
	yy_column := yy_column + 5
	yy_position := yy_position + 5
--|#line 446 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 446")
end

			set_last_token (DOCTYPE_ELEMENT_EMPTY)
			last_value := text
		
else
	yy_column := yy_column + 3
	yy_position := yy_position + 3
--|#line 451 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 451")
end

			set_last_token (DOCTYPE_ELEMENT_ANY)
			last_value := text
		
end
else
	yy_column := yy_column + 5
	yy_position := yy_position + 5
--|#line 459 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 459")
end

			set_last_token (DOCTYPE_NDATA)
			last_value := text
		
end
else
if yy_act = 67 then
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 467 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 467")
end
 
			set_last_token (DOCTYPE_END)
			pop_start_condition
		
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 472 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 472")
end
 
			set_last_token (NAME) 
			last_value := text
		
end
end
else
if yy_act <= 70 then
if yy_act = 69 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 476 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 476")
end
 
			set_last_token (NAME_UTF8) 
			last_value := text
		
else
yy_set_line_column
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 480 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 480")
end

			set_last_token (SPACE)
		
end
else
if yy_act = 71 then
yy_set_line_column
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 497 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 497")
end

			set_last_token (DOCTYPE_SYSTEM)
			last_value := system_literal_text
		
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 502 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 502")
end

			set_last_token (DOCTYPE_SYSTEM_UTF8)
			last_value := system_literal_text
		
end
end
end
end
end
end
else
if yy_act <= 108 then
if yy_act <= 90 then
if yy_act <= 81 then
if yy_act <= 77 then
if yy_act <= 75 then
if yy_act <= 74 then
if yy_act = 73 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 507 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 507")
end

			set_last_token (DOCTYPE_SYSTEM_UTF8)
			last_value := system_literal_text
		
else
yy_set_line_column
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 512 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 512")
end

			set_last_token (DOCTYPE_PUBLIC)
			last_value := system_literal_text
		
end
else
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 521 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 521")
end
 set_last_token (DOCTYPE_GROUP_OR) 
end
else
if yy_act = 76 then
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 522 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 522")
end
 set_last_token (DOCTYPE_GROUP_SEQ) 
else
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 523 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 523")
end
 set_last_token (DOCTYPE_GROUP_START) 
end
end
else
if yy_act <= 79 then
if yy_act = 78 then
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 524 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 524")
end
 set_last_token (DOCTYPE_GROUP_END) 
else
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 525 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 525")
end
 set_last_token (DOCTYPE_GROUP_ZEROONE) 
end
else
if yy_act = 80 then
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 526 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 526")
end
 set_last_token (DOCTYPE_GROUP_ANY) 
else
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 527 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 527")
end
 set_last_token (DOCTYPE_GROUP_ONEMORE) 
end
end
end
else
if yy_act <= 86 then
if yy_act <= 84 then
if yy_act <= 83 then
if yy_act = 82 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 529 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 529")
end

			set_last_token (NMTOKEN) 
			last_value := text
		
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 533 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 533")
end

			set_last_token (NMTOKEN_UTF8) 
			last_value := text
		
end
else
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 541 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 541")
end
 
			set_last_token (DOCTYPE_PERCENT) 
		
end
else
if yy_act = 85 then
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 544 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 544")
end

			set_last_token (VALUE_START)
			push_start_condition (entity_value_single)
		
else
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 548 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 548")
end

			set_last_token (VALUE_START)
			push_start_condition (entity_value_double)
		
end
end
else
if yy_act <= 88 then
if yy_act = 87 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 556 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 556")
end

			set_last_token (DOCTYPE_PEREFERENCE)
			last_value := text_substring (2, text_count - 1)
		
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 561 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 561")
end

			set_last_token (DOCTYPE_PEREFERENCE_UTF8)
			last_value := text_substring (2, text_count - 1)
		
end
else
if yy_act = 89 then
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 565 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 565")
end

			set_last_token (ENTITY_INVALID)
		
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 572 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 572")
end

			set_last_token (ENTITYVALUE_PEREFERENCE)
			last_value := text_substring (2, text_count - 1)
		
end
end
end
end
else
if yy_act <= 99 then
if yy_act <= 95 then
if yy_act <= 93 then
if yy_act <= 92 then
if yy_act = 91 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 576 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 576")
end

			set_last_token (ENTITYVALUE_PEREFERENCE_UTF8)
			last_value := text_substring (2, text_count - 1)
		
else
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 584 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 584")
end

			set_last_token (ENTITY_INVALID)
		
end
else
	yy_column := yy_column + 2
	yy_position := yy_position + 2
--|#line 591 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 591")
end

	set_last_token (TAG_START_END)
	push_start_condition (tag)

end
else
if yy_act = 94 then
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 596 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 596")
end

	set_last_token (TAG_START)
	push_start_condition (tag)

else
yy_set_line_column
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 603 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 603")
end

			set_last_token (TAG_END_EMPTY)
			pop_start_condition
		
end
end
else
if yy_act <= 97 then
if yy_act = 96 then
yy_set_line_column
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 608 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 608")
end
 
			set_last_token (TAG_END) 
			pop_start_condition
		
else
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 614 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 614")
end

			 set_last_token (TAG_NAME_COLON) 
		
end
else
if yy_act = 98 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 617 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 617")
end
 
			set_last_token (TAG_NAME_FIRST)
			last_value := text
		
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 621 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 621")
end
 
			set_last_token (TAG_NAME_FIRST_UTF8)
			last_value := text
		
end
end
end
else
if yy_act <= 104 then
if yy_act <= 102 then
if yy_act <= 101 then
if yy_act = 100 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 625 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 625")
end
 
			set_last_token (TAG_NAME_ATOM) 
			last_value := text
		
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 629 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 629")
end
 
			set_last_token (TAG_NAME_ATOM_UTF8) 
			last_value := text
		
end
else
yy_set_line_column
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 633 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 633")
end

			set_last_token (SPACE) 
		
end
else
if yy_act = 103 then
yy_set_line_column
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 636 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 636")
end

			set_last_token (EQ) 
		
else
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 640 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 640")
end
 
			set_last_token (VALUE_START) 
			push_start_condition (attribute_value_single)
		
end
end
else
if yy_act <= 106 then
if yy_act = 105 then
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 644 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 644")
end

			set_last_token (VALUE_START)
			push_start_condition (attribute_value_double)
		
else
	yy_column := yy_column + 6
	yy_position := yy_position + 6
--|#line 657 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 657")
end

				set_last_token (CHARDATA)
				last_value := "%'"
			
end
else
if yy_act = 107 then
	yy_column := yy_column + 6
	yy_position := yy_position + 6
--|#line 661 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 661")
end

				set_last_token (CHARDATA)
				last_value := "%""
			
else
	yy_column := yy_column + 4
	yy_position := yy_position + 4
--|#line 665 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 665")
end

				set_last_token (CHARDATA)
				last_value := "<"
			
end
end
end
end
end
else
if yy_act <= 126 then
if yy_act <= 117 then
if yy_act <= 113 then
if yy_act <= 111 then
if yy_act <= 110 then
if yy_act = 109 then
	yy_column := yy_column + 4
	yy_position := yy_position + 4
--|#line 669 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 669")
end

				set_last_token (CHARDATA)
				last_value := ">"
			
else
	yy_column := yy_column + 5
	yy_position := yy_position + 5
--|#line 673 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 673")
end

				set_last_token (CHARDATA)
				last_value := "&"
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 681 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 681")
end
 
				set_last_token (CONTENT_ENTITY) 
				last_value := text_substring (2, text_count - 1)
			
end
else
if yy_act = 112 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 685 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 685")
end
 
				set_last_token (CONTENT_ENTITY_UTF8) 
				last_value := text_substring (2, text_count - 1)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 693 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 693")
end
 
				set_last_token (CHARDATA) -- Bypassed
				last_value := text
			
end
end
else
if yy_act <= 115 then
if yy_act = 114 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 697 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 697")
end
 
				set_last_token (CHARDATA_UTF8) -- Bypassed
				last_value := text
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 704 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 704")
end

			set_last_token (CHARDATA)
			last_value := text
		
end
else
if yy_act = 116 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 712 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 712")
end
 
				set_last_token (ATTRIBUTE_ENTITY)
				last_value := text_substring (2, text_count - 1)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 716 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 716")
end
 
				set_last_token (ATTRIBUTE_ENTITY_UTF8)
				last_value := text_substring (2, text_count - 1)
			
end
end
end
else
if yy_act <= 122 then
if yy_act <= 120 then
if yy_act <= 119 then
if yy_act = 118 then
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 721 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 721")
end

			set_last_token (ATTRIBUTE_LT) -- Conformance error.
			last_value := text
		
else
	yy_line := yy_line + 1
	yy_column := 1
	yy_position := yy_position + 2
--|#line 725 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 725")
end

				-- XML1.0:3.3.3 Attribute value normalization.
			set_last_token (CHARDATA)
			if has_normalized_newline then
				last_value := two_normalized_spaces
			else
				last_value := normalized_space
			end
		
end
else
yy_set_line_column
	yy_position := yy_position + 1
--|#line 734 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 734")
end

				-- XML1.0:3.3.3 Attribute value normalization.
			set_last_token (CHARDATA)
			last_value := normalized_space
		
end
else
if yy_act = 121 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 739 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 739")
end

			set_last_token (CHARDATA)
			last_value := text
		
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 743 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 743")
end

			set_last_token (CHARDATA_UTF8)
			last_value := text
		
end
end
else
if yy_act <= 124 then
if yy_act = 123 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 751 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 751")
end
 
			character_entity.from_decimal (text_substring (3, text_count - 1))
			if character_entity.is_valid then
				if character_entity.is_ascii then
					set_last_token (CHARDATA)
				else
					set_last_token (CHARDATA_UTF8)
				end
				last_value := character_entity.to_utf8
			else
				set_last_token (ENTITY_INVALID)
			end
		
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 765 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 765")
end

			character_entity.from_hexadecimal (text_substring (4, text_count - 1))
			if character_entity.is_valid then
				if character_entity.is_ascii then
					set_last_token (CHARDATA)
				else
					set_last_token (CHARDATA_UTF8)
				end
				last_value := character_entity.to_utf8
			else
				set_last_token (ENTITY_INVALID)
			end
		
end
else
if yy_act = 125 then
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 780 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 780")
end

			set_last_token (ENTITY_INVALID)
			last_value := text
		
else
yy_set_line_column
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 788 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 788")
end

				-- End of line handling XML1.0:2.11.
			set_last_token (CHARDATA)
			last_value := normalized_newline
		
end
end
end
end
else
if yy_act <= 135 then
if yy_act <= 131 then
if yy_act <= 129 then
if yy_act <= 128 then
if yy_act = 127 then
yy_set_line_column
	yy_position := yy_position + 1
--|#line 793 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 793")
end

			set_last_token (CHARDATA)
			last_value := text
		
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 797 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 797")
end

			set_last_token (CHARDATA)
			last_value := text
		
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 801 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 801")
end

			set_last_token (CHARDATA_UTF8)
			last_value := text
		
end
else
if yy_act = 130 then
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 809 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 809")
end
 
			set_last_token (VALUE_END) 
			pop_start_condition
		
else
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 813 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 813")
end

			set_last_token (CHARDATA) 
			last_value := text
		
end
end
else
if yy_act <= 133 then
if yy_act = 132 then
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 821 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 821")
end

			set_last_token (VALUE_END)
			pop_start_condition
		
else
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 825 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 825")
end

			set_last_token (CHARDATA) 
			last_value := text
		
end
else
if yy_act = 134 then
	yy_column := yy_column + 3
	yy_position := yy_position + 3
--|#line 833 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 833")
end

		-- XML1.0:14 ]]> not allowed in markup.
	last_token := CONTENT_CONDITIONAL_END
	last_value := text

else
	yy_line := yy_line + 1
	yy_column := 1
	yy_position := yy_position + 2
--|#line 839 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 839")
end

		-- End of line handling XML1.0:2.11.
	set_last_token (SPACE)
	last_value := normalized_newline

end
end
end
else
if yy_act <= 139 then
if yy_act <= 137 then
if yy_act = 136 then
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 845 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 845")
end
 
	set_last_token (SPACE) 
	last_value := normalized_newline

else
	yy_line := yy_line + 1
	yy_column := 1
	yy_position := yy_position + 1
--|#line 850 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 850")
end

	set_last_token (SPACE) 
	last_value := normalized_newline

end
else
if yy_act = 138 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 855 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 855")
end

		-- Space not matched by newline normalization.
	set_last_token (SPACE)
	last_value := text

else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 861 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 861")
end
 
	set_last_token (CHARDATA)
	last_value := text

end
end
else
if yy_act <= 141 then
if yy_act = 140 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
	yy_position := yy_position + yy_end - yy_start - yy_more_len
--|#line 866 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 866")
end
 
	set_last_token (CHARDATA_UTF8)
	last_value := text

else
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 871 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 871")
end

	set_last_token (CHARDATA)
	last_value := text

end
else
if yy_act = 142 then
	yy_column := yy_column + 1
	yy_position := yy_position + 1
--|#line 876 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 876")
end

		-- Default rule.
	set_last_token (INPUT_INVALID)
	last_value := text

else
yy_set_line_column
	yy_position := yy_position + 1
--|#line 0 "xm_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'xm_eiffel_scanner.l' at line 0")
end
last_token := yyError_token
fatal_error ("scanner jammed")
end
end
end
end
end
end
end
		end

	yy_execute_eof_action (yy_sc: INTEGER) is
			-- Execute EOF semantic action.
		do
			terminate
		end

feature {NONE} -- Table templates

	yy_nxt_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		local
			an_array: ARRAY [INTEGER]
		once
			create an_array.make (0, 4815)
			yy_nxt_template_1 (an_array)
			yy_nxt_template_2 (an_array)
			Result := yy_fixed_array (an_array)
		end

	yy_nxt_template_1 (an_array: ARRAY [INTEGER]) is
		do
			yy_array_subcopy (an_array, <<
			    0,   36,   37,   38,   39,   37,  183,  183,  346,  183,
			  183,   41,  796,   36,   36,  796,  796,   36,   36,  796,
			   36,  796,   50,  223,  223,  223,  223,  202,   36,  411,
			   50,   42,  796,  796,   36,   36,  204,   51,   36,   36,
			   36,  203,   80,   81,  796,   51,  132,  132,  566,  412,
			  132,  132,  618,  796,  619,  204,  223,  223,  223,  223,
			   43,  145,  145,   36,   36,   36,   36,   36,   36,  413,
			  796,  796,   36,  566,   80,   81,  242,  242,  242,  242,
			  242,  242,  242,  242,   36,   36,   36,   44,   45,   46,
			   47,   48,   36,   37,   38,   39,   37,  209,  209,   82,

			  221,  221,   41,   36,   36,   36,   52,   53,   54,   55,
			   56,   36,   36,   36,   52,   53,   54,   55,   56,  206,
			  206,  206,   42,   36,   36,   36,   83,   84,   85,   86,
			   87,   82,  186,  187,  188,  189,  190,  208,  208,  208,
			  210,  210,  210,  212,  213,  214,  215,  216,  218,  218,
			  218,   43,  220,  220,  220,   36,   36,   36,   83,   84,
			   85,   86,   87,  212,  213,  214,  215,  216,  222,  222,
			  222,  237,  237,  237,  784,   36,   36,   36,   44,   45,
			   46,   47,   48,   36,   57,   58,   57,   57,   59,   59,
			   59,   59,   59,   59,   59,   59,   59,   59,   59,   59,

			   59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
			   59,   60,   59,   59,   59,   59,   61,   60,   60,   60,
			   60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
			   60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
			   59,   59,   59,   60,   60,   60,   60,   60,   60,   60,
			   60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
			   60,   60,   60,   60,   60,   59,   36,   36,   36,   62,
			   63,   64,   65,   66,   36,   67,   68,   67,   67,   36,
			   69,   36,   36,   36,   36,   70,   36,   36,   36,   36,
			   36,   71,   36,   36,   71,   72,   71,   71,   71,   71,

			   71,   71,   36,   36,   36,   36,   36,   73,   71,   71,
			   71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
			   71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
			   71,   36,   36,   36,   36,   71,   71,   71,   71,   74,
			   71,   71,   71,   71,   71,   75,   71,   71,   71,   71,
			   76,   71,   71,   77,   71,   78,   36,   36,   36,   36,
			   36,   36,   36,   36,   36,   36,   88,   89,   88,   88,
			   36,   90,   36,   36,   36,   36,   91,   36,   36,   36,
			   36,   36,   92,   92,   93,   92,   92,   92,   92,   92,
			   92,   92,   92,   94,   36,   36,   95,   96,   36,   97,

			   97,   97,   97,   97,   97,   97,   97,   97,   97,   97,
			   97,   97,   97,   97,   97,   97,   97,   97,   97,   97,
			   97,   97,   36,   36,   36,   97,   97,   97,   97,   97,
			   97,   97,   97,   97,   97,   97,   97,   97,   97,   97,
			   97,   97,   97,   97,   97,   97,   97,   36,   36,   36,
			   36,   98,   99,  100,  101,  102,   36,  103,  104,  105,
			  103,  779,  107,  163,  164,  566,  108,  109,  165,  401,
			  163,  164,  402,  170,  777,  165,  171,   36,  172,  175,
			  170,  240,  240,  171,  776,  172,  110,  239,  239,  239,
			  567,  153,  775,  166,  762,  167,  762,   36,  153,  168,

			  166,  761,  167,  169,   36,  458,  168,  176,  459,  132,
			  169,  262,  262,  173,  191,  760,  132,  241,  241,  241,
			  173,  259,  259,  259,   36,   36,   36,  175,  261,  261,
			  261,   36,  759,   36,  284,  284,  177,  306,  306,   36,
			   36,   36,  111,  112,  113,  114,  115,   36,  103,  104,
			  105,  103,  661,  107,  758,  176,  662,  108,  109,  640,
			   36,   36,   36,  178,  179,  180,  181,  182,  193,  225,
			  226,  227,  228,  229,  194,  755,  195,  110,  263,  263,
			  263,  196,  331,  331,  177,  252,  253,  254,  255,  256,
			  281,  281,  281,  197,  198,  199,  200,  201,  264,  264,

			  264,  264,  269,  270,  271,  272,  273,  754,   36,   36,
			   36,  178,  179,  180,  181,  182,  265,  266,  266,  266,
			  266,  276,  277,  278,  279,  280,  191,  750,  266,  267,
			   36,   36,   36,  111,  112,  113,  114,  115,   36,  103,
			  104,  105,  103,  749,  116,  283,  283,  283,  108,  117,
			  744,  264,  264,  264,  264,  285,  285,  285,  288,  289,
			  290,  291,  292,  303,  303,  303,  321,  648,  110,  265,
			  305,  305,  305,  307,  307,  307,  328,  328,  328,  648,
			  294,  266,  267,  330,  330,  330,  295,  743,  296,  332,
			  332,  332,  648,  297,  310,  311,  312,  313,  314,  316,

			  317,  318,  319,  320,  649,  298,  299,  300,  301,  302,
			  333,  333,  333,  333,  333,  333,  333,  333,  352,  352,
			  352,   36,   36,   36,  111,  112,  113,  114,  115,   36,
			  103,  104,  105,  103,  349,  116,  347,  355,  355,  108,
			  117,  350,  348,  375,  375,  323,  324,  325,  326,  327,
			  335,  336,  337,  338,  339,  354,  354,  354,  370,  110,
			  341,  342,  343,  344,  345,  371,  742,  341,  342,  343,
			  344,  345,  341,  342,  343,  344,  345,  356,  356,  356,
			  391,  391,  341,  342,  343,  344,  345,  359,  360,  361,
			  362,  363,  365,  366,  367,  368,  369,  741,  365,  366,

			  367,  368,  369,  372,  372,  372,  365,  366,  367,  368,
			  369,  380,   36,   36,   36,  111,  112,  113,  114,  115,
			   36,  118,  119,  120,  118,  381,  107,  382,  738,  122,
			  123,  109,  374,  374,  374,  376,  376,  376,  377,  385,
			  383,  378,  384,  388,  388,  388,  390,  390,  390,  379,
			  392,  392,  392,  186,  187,  188,  189,  190,  209,  209,
			  365,  366,  367,  368,  369,  365,  366,  367,  368,  369,
			  206,  206,  206,  208,  208,  208,  365,  366,  367,  368,
			  369,  365,  366,  367,  368,  369,  409,  409,  341,  342,
			  343,  344,  345,  210,  210,  210,  406,  406,  406,  408,

			  408,  408,  737,   36,   36,   36,  124,  125,  126,  127,
			  128,   36,  118,  119,  120,  118,  414,  107,  221,  221,
			  122,  123,  109,  393,  393,  393,  393,  393,  393,  393,
			  393,  410,  410,  410,  186,  187,  188,  189,  190,  206,
			  206,  206,  415,  206,  206,  206,  417,  417,  417,  418,
			  418,  418,  212,  213,  214,  215,  216,  218,  218,  218,
			  220,  220,  220,  222,  222,  222,  212,  213,  214,  215,
			  216,  218,  218,  218,  218,  218,  218,  420,  420,  420,
			  421,  421,  421,  394,  223,  223,  223,  223,  225,  226,
			  227,  228,  229,  736,   36,   36,   36,  124,  125,  126,

			  127,  128,   36,  118,  119,  120,  118,  735,  116,  425,
			  425,  122,  123,  117,  422,  422,  422,  424,  424,  424,
			  426,  426,  426,  237,  237,  237,  428,  428,  428,  429,
			  429,  430,  430,  430,  237,  237,  237,  237,  237,  237,
			  431,  431,  431,  432,  432,  432,  242,  242,  242,  242,
			  252,  253,  254,  255,  256,  259,  259,  259,  261,  261,
			  261,  262,  262,  263,  263,  263,  252,  253,  254,  255,
			  256,  259,  259,  259,  259,  259,  259,  439,  439,  439,
			  440,  440,  440,  444,  444,   36,   36,   36,  124,  125,
			  126,  127,  128,   36,  118,  119,  120,  118,  731,  116,

			  448,  448,  122,  123,  117,  264,  264,  264,  264,  266,
			  266,  266,  266,  269,  270,  271,  272,  273,  441,  441,
			  441,  306,  306,  265,  443,  443,  443,  445,  445,  445,
			  276,  277,  278,  279,  280,  266,  267,  281,  281,  281,
			  447,  447,  447,  449,  449,  449,  276,  277,  278,  279,
			  280,  281,  281,  281,  281,  281,  281,  450,  450,  450,
			  451,  451,  451,  288,  289,  290,  291,  292,  303,  303,
			  303,  305,  305,  305,  466,  466,   36,   36,   36,  124,
			  125,  126,  127,  128,   36,  129,  130,  129,  129,   36,
			   36,   36,   36,  131,   36,   36,   36,   36,   36,   36,

			   36,   36,   36,   36,   36,   36,   36,   36,   36,   36,
			   36,   36,  132,   36,  133,   36,  134,   36,  132,  132,
			  132,  132,  132,  132,  132,  132,  135,  132,  132,  132,
			  132,  132,  136,  132,  132,  137,  132,  132,  132,  132,
			  132,  138,   36,  139,  132,  132,  132,  132,  132,  132,
			  132,  132,  132,  132,  132,  132,  132,  132,  132,  132,
			  132,  132,  132,  132,  132,  132,   36,   36,   36,   36,
			  140,  141,  142,  143,  144,   36,  129,  130,  129,  129,
			   36,   36,  146,   36,  131,   36,   36,  147,  148,  149,
			  150,  151,  152,  152,   36,  152,  152,  152,  152,  152,

			  152,  152,  152,  153,   36,   36,   36,  134,  154,  155,
			  153,  153,  153,  156,  153,  153,  153,  153,  153,  153,
			  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,
			  153,  153,   36,   36,   36,  153,  153,  153,  153,  153,
			  153,  153,  153,  153,  153,  153,  153,  153,  153,  153,
			  153,  153,  153,  153,  153,  153,  153,  157,   36,   36,
			   36,  158,  159,  160,  161,  162,  224,  224,  224,  224,
			  224,  224,  224,  224,  224,  224,  224,  224,  331,  331,
			  224,  307,  307,  307,  463,  463,  463,  465,  465,  465,
			  224,  224,  224,  224,  467,  467,  467,  288,  289,  290,

			  291,  292,  303,  303,  303,  303,  303,  303,  468,  468,
			  468,  469,  469,  469,  328,  328,  328,  730,  224,  224,
			  224,  310,  311,  312,  313,  314,  330,  330,  330,  332,
			  332,  332,  476,  476,  476,  478,  478,  478,  479,  479,
			  480,  480,  480,  224,  489,  489,  489,  231,  232,  233,
			  234,  235,  796,  393,  393,  393,  481,  393,  393,  393,
			  393,  729,  192,  192,  725,  192,  192,  192,  192,  192,
			  192,  192,  192,  724,  395,  491,  491,  491,  492,  492,
			  493,  493,  493,  310,  311,  312,  313,  314,  328,  328,
			  328,  328,  328,  328,  494,  494,  494,  495,  495,  495,

			  333,  333,  333,  333,  502,  502,  502,  504,  504,  504,
			  505,  505,  723,  482,  506,  506,  506,  341,  342,  343,
			  344,  345,  352,  352,  352,  508,  508,  508,  509,  509,
			  518,  396,  397,  398,  399,  400,  224,  224,  224,  224,
			  224,  224,  224,  224,  224,  224,  224,  224,  722,  517,
			  224,  510,  510,  510,  411,  515,  516,  352,  352,  352,
			  224,  224,  224,  224,  721,  341,  342,  343,  344,  345,
			  720,  511,  352,  352,  352,  512,  341,  342,  343,  344,
			  345,  526,  526,  513,  520,  520,  520,  719,  224,  224,
			  224,  521,  521,  521,  514,  341,  342,  343,  344,  345,

			  341,  342,  343,  344,  345,  718,  341,  342,  343,  344,
			  345,  530,  530,  224,  523,  523,  523,  231,  232,  233,
			  234,  235,  422,  422,  422,  422,  422,  422,  422,  422,
			  422,  422,  422,  422,  553,  553,  422,  359,  360,  361,
			  362,  363,  525,  525,  525,  533,  422,  422,  422,  422,
			  527,  527,  527,  365,  366,  367,  368,  369,  372,  372,
			  372,  529,  529,  529,  531,  531,  531,  365,  366,  367,
			  368,  369,  581,  581,  422,  422,  422,  717,  532,  372,
			  372,  372,  539,  365,  366,  367,  368,  369,  372,  372,
			  372,  534,  534,  534,  535,  535,  535,  593,  593,  422,

			  388,  388,  388,  231,  232,  233,  234,  235,  796,  365,
			  366,  367,  368,  369,  540,  716,  544,  541,  293,  293,
			  710,  293,  293,  293,  293,  293,  293,  293,  293,  542,
			  452,  388,  388,  388,  365,  366,  367,  368,  369,  543,
			  547,  547,  547,  548,  548,  548,  603,  603,  365,  366,
			  367,  368,  369,  365,  366,  367,  368,  369,  406,  406,
			  406,  560,  709,  365,  366,  367,  368,  369,  341,  342,
			  343,  344,  345,  365,  366,  367,  368,  369,  552,  552,
			  552,  554,  554,  554,  406,  406,  406,  453,  454,  455,
			  456,  457,  315,  315,  708,  315,  315,  315,  315,  315,

			  315,  315,  315,  707,  470,  393,  393,  393,  393,  393,
			  393,  393,  393,  702,  549,  406,  406,  406,  396,  397,
			  398,  399,  400,  561,  561,  561,  562,  562,  562,  206,
			  206,  206,  206,  206,  206,  218,  218,  218,  218,  218,
			  218,  225,  226,  227,  228,  229,  422,  422,  422,  422,
			  422,  422,  568,  568,  568,  569,  569,  569,  237,  237,
			  237,  471,  472,  473,  474,  475,  796,  237,  237,  237,
			  570,  570,  570,  571,  571,  571,  322,  322,  701,  322,
			  322,  322,  322,  322,  322,  322,  322,  700,  483,  237,
			  237,  237,  237,  237,  237,  259,  259,  259,  259,  259,

			  259,  269,  270,  271,  272,  273,  441,  441,  441,  441,
			  441,  441,  575,  575,  575,  576,  576,  576,  281,  281,
			  281,  281,  281,  281,  577,  577,  577,  578,  578,  578,
			  281,  281,  281,  281,  281,  281,  463,  463,  463,  580,
			  580,  580,  582,  582,  582,  484,  485,  486,  487,  488,
			  334,  334,  588,  334,  334,  334,  334,  334,  334,  334,
			  334,  699,  496,  463,  463,  463,  463,  463,  463,  589,
			  589,  589,  590,  590,  590,  303,  303,  303,  303,  303,
			  303,  476,  476,  476,  592,  592,  592,  594,  594,  594,
			  595,  476,  476,  476,  476,  476,  476,  596,  596,  596,

			  597,  597,  597,  489,  489,  489,  602,  602,  602,  453,
			  454,  455,  456,  457,  604,  604,  604,  605,  698,  497,
			  498,  499,  500,  501,  393,  393,  393,  393,  598,  393,
			  393,  599,  612,  549,  489,  489,  489,  489,  489,  489,
			  606,  606,  606,  607,  607,  607,  698,  471,  472,  473,
			  474,  475,  328,  328,  328,  328,  328,  328,  502,  502,
			  502,  609,  609,  609,  610,  610,  611,  611,  611,  502,
			  502,  502,  621,  697,  484,  485,  486,  487,  488,  502,
			  502,  502,  613,  613,  613,  614,  614,  614,  622,  497,
			  498,  499,  500,  501,  352,  352,  352,  352,  352,  352,

			  615,  615,  615,  616,  616,  616,  623,  624,  352,  352,
			  352,  341,  342,  343,  344,  345,  352,  352,  352,  359,
			  360,  361,  362,  363,  523,  523,  523,  523,  523,  523,
			  341,  342,  343,  344,  345,  626,  626,  626,  627,  627,
			  627,  341,  342,  343,  344,  345,  630,  635,  341,  342,
			  343,  344,  345,  372,  372,  372,  372,  372,  372,  628,
			  628,  628,  629,  629,  629,  365,  366,  367,  368,  369,
			  372,  372,  372,  372,  372,  372,  634,  636,  637,  638,
			  365,  366,  367,  368,  369,  388,  388,  388,  388,  388,
			  388,  365,  366,  367,  368,  369,  406,  406,  406,  406,

			  406,  406,  639,  641,  641,  641,  642,  642,  642,  696,
			  365,  366,  367,  368,  369,  781,  781,  365,  366,  367,
			  368,  369,  406,  406,  406,  365,  366,  367,  368,  369,
			  695,  365,  366,  367,  368,  369,  341,  342,  343,  344,
			  345,  406,  406,  406,  422,  422,  422,  422,  422,  422,
			  237,  237,  237,  237,  237,  237,  441,  441,  441,  441,
			  441,  441,  281,  281,  281,  281,  281,  281,  463,  463,
			  463,  463,  463,  463,  653,  653,  653,  654,  654,  654,
			  463,  463,  463,  463,  463,  463,  476,  476,  476,  476,
			  476,  476,  658,  658,  658,  659,  659,  659,  476,  476,

			  476,  476,  476,  476,  393,  393,  393,  393,  393,  393,
			  393,  393,  694,  660,  393,  393,  393,  393,  393,  393,
			  393,  393,  693,  660,  489,  489,  489,  489,  489,  489,
			  663,  663,  663,  664,  664,  664,  489,  489,  489,  489,
			  489,  489,  502,  502,  502,  502,  502,  502,  665,  665,
			  665,  666,  666,  666,  502,  502,  502,  502,  502,  502,
			  352,  352,  352,  352,  352,  352,  671,  689,  673,  674,
			  523,  523,  523,  688,  672,  523,  523,  523,  372,  372,
			  372,  372,  372,  372,  680,  406,  406,  406,  406,  406,
			  406,  676,  687,  681,  682,  685,  463,  463,  463,  463,

			  463,  463,  341,  342,  343,  344,  345,  341,  342,  343,
			  344,  345,  341,  342,  343,  344,  345,  341,  342,  343,
			  344,  345,  365,  366,  367,  368,  369,  365,  366,  367,
			  368,  369,  683,  684,  786,  786,  365,  366,  367,  368,
			  369,  365,  366,  367,  368,  369,  703,  341,  342,  343,
			  344,  345,  690,  690,  690,  690,  692,  692,  692,  692,
			  476,  476,  476,  476,  476,  476,  704,  365,  366,  367,
			  368,  369,  489,  489,  489,  365,  366,  367,  368,  369,
			  489,  489,  489,  705,  691,  502,  502,  502,  691,  502,
			  502,  502,  713,  686,  341,  342,  343,  344,  345,  706,

			  365,  366,  367,  368,  369,  365,  366,  367,  368,  369,
			  711,  714,  778,  778,  778,  341,  342,  343,  344,  345,
			  715,  679,  678,  712,  780,  780,  780,  365,  366,  367,
			  368,  369,  726,  341,  342,  343,  344,  345,  677,  675,
			  341,  342,  343,  344,  345,  341,  342,  343,  344,  345,
			  690,  690,  690,  690,  365,  366,  367,  368,  369,  365,
			  366,  367,  368,  369,  365,  366,  367,  368,  369,  692,
			  692,  692,  692,  341,  342,  343,  344,  345,  732,  733,
			  341,  342,  343,  344,  345,  727,  727,  727,  727,  670,
			  728,  728,  728,  728,  365,  366,  367,  368,  369,  365,

			  366,  367,  368,  369,  734,  739,  739,  739,  739,  341,
			  342,  343,  344,  345,  740,  740,  740,  740,  763,  365,
			  366,  367,  368,  369,  751,  753,  365,  366,  367,  368,
			  369,  727,  727,  727,  727,  740,  745,  769,  782,  782,
			  782,  746,  669,  365,  366,  367,  368,  369,  728,  728,
			  728,  728,  752,  747,  756,  756,  756,  756,  748,  365,
			  366,  367,  368,  369,  668,  365,  366,  367,  368,  369,
			  341,  342,  343,  344,  345,  341,  342,  343,  344,  345,
			  739,  739,  739,  739,  757,  790,  667,  365,  366,  367,
			  368,  369,  365,  366,  367,  368,  369,  657,  764,  765,

			  766,  767,  768,  365,  366,  367,  368,  369,  793,  656,
			  740,  655,  770,  771,  772,  773,  774,  365,  366,  367,
			  368,  369,  756,  756,  756,  756,  757,  757,  757,  757,
			  728,  728,  728,  728,  783,  783,  783,  785,  785,  785,
			  787,  787,  787,  788,  788,  788,  788,  778,  778,  778,
			  652,  651,  757,  778,  778,  778,  791,  791,  791,  792,
			  792,  792,  783,  783,  783,  764,  765,  766,  767,  768,
			  783,  783,  783,  789,  794,  794,  794,  795,  795,  795,
			  778,  778,  778,  770,  771,  772,  773,  774,  788,  788,
			  788,  788,  789,  789,  789,  789,  778,  778,  778,  783,

			  783,  783,  783,  783,  783,  650,  647,  646,  645,  644,
			  643,  640,  633,  632,  631,  625,  620,  617,  789,   40,
			   40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
			   40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
			   40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
			   40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
			   40,   40,   40,   40,   40,   40,   49,   49,   49,   49,
			   49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
			   49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
			   49,   49,   49,   49,   49,   49,   49,   49,   49,   49,

			   49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
			   49,   49,   49,   79,   79,   79,   79,   79,   79,   79,
			   79,   79,   79,   79,   79,   79,   79,   79,   79,   79,
			   79,   79,   79,   79,   79,   79,   79,   79,   79,   79,
			   79,   79,   79,   79,   79,   79,   79,   79,   79,   79,
			   79,   79,   79,   79,   79,   79,   79,   79,   79,   79,
			  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,
			  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,
			  106,  106,  106,  106,  106,  106,  106,  106,  106,  106,
			  106,  106,  106,  106,  106,  106,  106,  106,  106,  106>>,
			1, 3000, 0)
		end

	yy_nxt_template_2 (an_array: ARRAY [INTEGER]) is
		do
			yy_array_subcopy (an_array, <<
			  106,  106,  106,  106,  106,  106,  106,  121,  121,  121,
			  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,
			  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,
			  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,
			  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,
			  121,  121,  121,  121,  174,  174,  174,  174,  174,  174,
			  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,
			  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,
			  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,
			  174,  174,  174,  174,  174,  174,  174,  174,  174,  174,

			  174,  185,  185,  185,  185,  608,  185,  185,  185,  185,
			  185,  185,  185,  185,  185,  185,  185,  185,  185,  601,
			  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,
			  185,  185,  185,  600,  185,  185,  185,  185,  185,  185,
			  185,  185,  185,  192,  591,  550,  550,  550,  550,  550,
			  550,  550,  550,  587,  586,  585,  584,  192,  550,  583,
			  579,  574,  192,  192,  192,  192,  192,  192,  192,  192,
			  192,  192,  573,  572,  192,  192,  192,  192,  192,  192,
			  192,  192,  192,  211,  211,  211,  211,  211,  211,  211,
			  211,  211,  211,  565,  211,  211,  211,  211,  211,  211,

			  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,
			  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,
			  211,  211,  211,  211,  211,  211,  211,  211,  211,  224,
			  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,
			  224,  224,  224,  224,  224,  224,  224,  224,  224,  564,
			  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,
			  224,  224,  224,  224,  224,  224,  224,  224,  224,  224,
			  224,  230,  230,  230,  230,  230,  230,  230,  230,  230,
			  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,
			  230,  563,  230,  230,  230,  230,  230,  230,  230,  230,

			  230,  230,  230,  230,  230,  230,  230,  230,  230,  230,
			  230,  230,  230,  243,  559,  243,  243,  243,  243,  243,
			  243,  243,  243,  558,  557,  556,  555,  551,  243,  243,
			  243,  243,  243,  243,  243,  243,  243,  243,  546,  545,
			  538,  243,  243,  243,  243,  243,  243,  243,  251,  537,
			  536,  251,  251,  251,  251,  251,  251,  251,  251,  251,
			  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,
			  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,
			  251,  251,  251,  251,  528,  251,  251,  251,  251,  251,
			  251,  251,  251,  251,  268,  268,  268,  268,  268,  268,

			  268,  268,  268,  268,  524,  522,  519,  507,  503,  268,
			  268,  268,  268,  268,  268,  268,  268,  268,  268,  490,
			  477,  268,  268,  268,  268,  268,  268,  268,  268,  268,
			  275,  275,  275,  275,  275,  275,  275,  275,  275,  275,
			  329,  464,  462,  461,  460,  275,  275,  275,  275,  275,
			  275,  275,  275,  275,  275,  304,  446,  275,  275,  275,
			  275,  275,  275,  275,  275,  275,  287,  442,  287,  287,
			  274,  438,  287,  287,  287,  287,  287,  287,  287,  287,
			  287,  287,  287,  287,  260,  287,  287,  287,  287,  287,
			  287,  287,  287,  287,  287,  287,  287,  287,  287,  287,

			  287,  287,  287,  287,  287,  287,  287,  287,  293,  437,
			  436,  435,  434,  433,  427,  423,  419,  219,  416,  407,
			  405,  404,  293,  403,  207,  389,  387,  293,  293,  293,
			  293,  293,  293,  293,  293,  293,  293,  386,  373,  293,
			  293,  293,  293,  293,  293,  293,  293,  293,  309,  357,
			  309,  353,  351,  329,  309,  309,  309,  309,  309,  309,
			  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,
			  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,
			  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,
			  315,  308,  304,  286,  282,  315,  315,  315,  315,  315,

			  315,  315,  315,  315,  315,  274,  260,  315,  315,  315,
			  315,  315,  315,  315,  315,  315,  322,  258,  257,  250,
			  249,  248,  247,  246,  245,  244,  238,  236,  219,  217,
			  322,  207,  205,  184,  796,  322,  322,  322,  322,  322,
			  322,  322,  322,  322,  322,  796,  796,  322,  322,  322,
			  322,  322,  322,  322,  322,  322,  334,  796,  796,  796,
			  796,  334,  334,  334,  334,  334,  334,  334,  334,  334,
			  334,  796,  796,  334,  334,  334,  334,  334,  334,  334,
			  334,  334,  340,  340,  340,  340,  340,  340,  340,  340,
			  340,  340,  340,  796,  796,  796,  796,  340,  340,  340,

			  340,  340,  340,  340,  340,  340,  340,  796,  796,  340,
			  340,  340,  340,  340,  340,  340,  340,  340,  358,  358,
			  358,  358,  358,  358,  358,  358,  358,  358,  358,  796,
			  796,  796,  796,  358,  358,  358,  358,  358,  358,  358,
			  358,  358,  358,  796,  796,  358,  358,  358,  358,  358,
			  358,  358,  358,  358,  364,  364,  364,  364,  364,  364,
			  364,  364,  364,  364,  364,  796,  796,  796,  796,  364,
			  364,  364,  364,  364,  364,  364,  364,  364,  364,  796,
			  796,  364,  364,  364,  364,  364,  364,  364,  364,  364,
			  206,  206,  206,  206,  796,  206,  206,  206,  206,  206,

			  206,  206,  206,  206,  206,  206,  206,  206,  796,  206,
			  206,  206,  206,  206,  206,  206,  206,  206,  206,  206,
			  206,  206,  796,  206,  206,  206,  206,  206,  206,  206,
			  206,  206,  218,  218,  218,  218,  218,  218,  218,  218,
			  218,  218,  796,  218,  218,  218,  218,  218,  218,  218,
			  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,
			  218,  218,  218,  218,  218,  218,  218,  218,  218,  218,
			  218,  218,  218,  218,  218,  218,  218,  218,  237,  237,
			  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,
			  237,  237,  237,  237,  237,  237,  237,  237,  796,  237,

			  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,
			  237,  237,  237,  237,  237,  237,  237,  237,  237,  237,
			  259,  796,  796,  259,  259,  259,  259,  259,  259,  259,
			  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
			  259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
			  259,  259,  259,  259,  259,  259,  796,  259,  259,  259,
			  259,  259,  259,  259,  259,  259,  281,  281,  281,  281,
			  281,  281,  281,  281,  281,  281,  796,  796,  796,  796,
			  796,  281,  281,  281,  281,  281,  281,  281,  281,  281,
			  281,  796,  796,  281,  281,  281,  281,  281,  281,  281,

			  281,  281,  303,  796,  303,  303,  796,  796,  303,  303,
			  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
			  796,  303,  303,  303,  303,  303,  303,  303,  303,  303,
			  303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
			  303,  303,  303,  303,  328,  796,  328,  796,  796,  796,
			  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,
			  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,
			  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,
			  328,  328,  328,  328,  328,  328,  352,  352,  352,  352,
			  352,  352,  352,  352,  352,  352,  352,  796,  796,  796,

			  796,  352,  352,  352,  352,  352,  352,  352,  352,  352,
			  352,  796,  796,  352,  352,  352,  352,  352,  352,  352,
			  352,  352,  372,  372,  372,  372,  372,  372,  372,  372,
			  372,  372,  372,  796,  796,  796,  796,  372,  372,  372,
			  372,  372,  372,  372,  372,  372,  372,  796,  796,  372,
			  372,  372,  372,  372,  372,  372,  372,  372,  406,  406,
			  406,  406,  406,  406,  406,  406,  406,  406,  406,  406,
			  796,  796,  796,  406,  406,  406,  406,  406,  406,  406,
			  406,  406,  406,  796,  796,  406,  406,  406,  406,  406,
			  406,  406,  406,  406,  422,  422,  422,  422,  422,  422,

			  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,
			  422,  422,  422,  422,  796,  422,  422,  422,  422,  422,
			  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,
			  422,  422,  422,  422,  422,  422,  441,  441,  441,  441,
			  441,  441,  441,  441,  441,  441,  796,  796,  796,  796,
			  796,  441,  441,  441,  441,  441,  441,  441,  441,  441,
			  441,  796,  796,  441,  441,  441,  441,  441,  441,  441,
			  441,  441,  463,  463,  463,  463,  463,  463,  463,  463,
			  463,  463,  463,  463,  796,  796,  796,  463,  463,  463,
			  463,  463,  463,  463,  463,  463,  463,  796,  796,  463,

			  463,  463,  463,  463,  463,  463,  463,  463,  476,  476,
			  476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
			  796,  796,  796,  476,  476,  476,  476,  476,  476,  476,
			  476,  476,  476,  796,  796,  476,  476,  476,  476,  476,
			  476,  476,  476,  476,  489,  489,  489,  489,  489,  489,
			  489,  489,  489,  489,  489,  489,  796,  796,  796,  489,
			  489,  489,  489,  489,  489,  489,  489,  489,  489,  796,
			  796,  489,  489,  489,  489,  489,  489,  489,  489,  489,
			  502,  502,  502,  502,  502,  502,  502,  502,  502,  502,
			  502,  502,  796,  796,  796,  502,  502,  502,  502,  502,

			  502,  502,  502,  502,  502,  796,  796,  502,  502,  502,
			  502,  502,  502,  502,  502,  502,  523,  523,  523,  523,
			  523,  523,  523,  523,  523,  523,  523,  796,  796,  796,
			  796,  523,  523,  523,  523,  523,  523,  523,  523,  523,
			  523,  796,  796,  523,  523,  523,  523,  523,  523,  523,
			  523,  523,  745,  745,  745,  745,  745,  745,  745,  796,
			  745,  745,  745,  745,  745,  745,  745,  745,  745,  745,
			  745,  745,  745,  796,  796,  745,  745,  745,  745,  745,
			  745,  745,  745,  745,  745,  745,  796,  796,  745,  745,
			  745,  745,  745,  745,  745,  745,  746,  746,  746,  746,

			  796,  746,  746,  796,  746,  746,  746,  746,  746,  746,
			  746,  746,  746,  746,  746,  746,  746,  796,  796,  746,
			  746,  746,  746,  746,  746,  746,  746,  746,  746,  746,
			  796,  796,  746,  746,  746,  746,  746,  746,  746,  746,
			  747,  747,  747,  747,  747,  747,  747,  747,  747,  747,
			  747,  747,  747,  747,  747,  747,  747,  747,  747,  747,
			  747,  747,  747,  747,  747,  747,  747,  747,  747,  747,
			  747,  747,  747,  747,  747,  747,  747,  747,  747,  747,
			  747,  747,  747,  747,  747,  747,  748,  748,  748,  748,
			  748,  748,  748,  748,  748,  748,  748,  748,  748,  748,

			  748,  748,  748,  748,  748,  748,  748,  748,  748,  748,
			  748,  748,  748,  748,  748,  748,  748,  748,  748,  748,
			  748,  748,  748,  748,  748,  748,  748,  748,  748,  748,
			  748,  748,  778,  778,  778,  778,  778,  778,  778,  778,
			  778,  778,  778,  778,  778,  778,  778,  778,  778,  778,
			  778,  778,  778,  778,  778,  778,  778,  778,  778,  778,
			  778,  778,  778,  778,  778,  778,  778,  778,  778,  778,
			  778,  778,  778,  778,  778,  778,  778,  778,  783,  783,
			  783,  783,  783,  783,  783,  783,  783,  783,  783,  783,
			  783,  783,  783,  783,  783,  783,  783,  783,  783,  783,

			  783,  783,  783,  783,  783,  783,  783,  783,  783,  783,
			  783,  783,  783,  783,  783,  783,  783,  783,  783,  783,
			  783,  783,  783,  783,   35,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,

			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796>>,
			1, 1816, 3000)
		end

	yy_chk_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		local
			an_array: ARRAY [INTEGER]
		once
			create an_array.make (0, 4815)
			yy_chk_template_1 (an_array)
			yy_chk_template_2 (an_array)
			Result := yy_fixed_array (an_array)
		end

	yy_chk_template_1 (an_array: ARRAY [INTEGER]) is
		do
			yy_array_subcopy (an_array, <<
			    0,    1,    1,    1,    1,    1,   37,  183,  133,   37,
			  183,    1,    0,   23,   24,    0,    0,   31,   32,    0,
			    3,    0,    3,   57,   57,   57,   57,   42,    4,  202,
			    4,    1,    0,    0,   23,   24,  133,    3,   31,   32,
			    9,   42,    9,    9,    0,    4,   23,   24,  414,  202,
			   31,   32,  512,    0,  512,   42,   58,   58,   58,   58,
			    1,   23,   24,   23,   24,   31,   32,   31,   32,  202,
			    0,    0,   10,  414,   10,   10,   67,   67,   67,   67,
			   68,   68,   68,   68,    1,    1,    1,    1,    1,    1,
			    1,    1,    2,    2,    2,    2,    2,   47,   47,    9,

			   55,   55,    2,    3,    3,    3,    3,    3,    3,    3,
			    3,    4,    4,    4,    4,    4,    4,    4,    4,   44,
			   44,   44,    2,    9,    9,    9,    9,    9,    9,    9,
			    9,   10,   40,   40,   40,   40,   40,   46,   46,   46,
			   48,   48,   48,   49,   49,   49,   49,   49,   52,   52,
			   52,    2,   54,   54,   54,   10,   10,   10,   10,   10,
			   10,   10,   10,   50,   50,   50,   50,   50,   56,   56,
			   56,   62,   62,   62,  771,    2,    2,    2,    2,    2,
			    2,    2,    2,    5,    5,    5,    5,    5,    5,    5,
			    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,

			    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
			    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
			    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
			    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
			    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
			    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
			    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
			    5,    5,    5,    5,    7,    7,    7,    7,    7,    7,
			    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
			    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,

			    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
			    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
			    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
			    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
			    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
			    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
			    7,    7,    7,    7,    7,   11,   11,   11,   11,   11,
			   11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
			   11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
			   11,   11,   11,   11,   11,   11,   11,   11,   11,   11,

			   11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
			   11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
			   11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
			   11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
			   11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
			   11,   11,   11,   11,   11,   11,   13,   13,   13,   13,
			   13,  765,   13,   27,   27,  415,   13,   13,   27,  193,
			   28,   28,  193,   29,  761,   28,   29,   33,   29,   33,
			   30,   65,   65,   30,  758,   30,   13,   64,   64,   64,
			  415,   27,  750,   27,  746,   27,  745,   29,   28,   27,

			   28,  744,   28,   27,   30,  294,   28,   33,  294,   29,
			   28,   86,   86,   29,   41,  742,   30,   66,   66,   66,
			   30,   83,   83,   83,   29,   34,   29,   34,   85,   85,
			   85,   30,  741,   30,  101,  101,   33,  114,  114,   13,
			   13,   13,   13,   13,   13,   13,   13,   14,   14,   14,
			   14,   14,  600,   14,  738,   34,  600,   14,   14,  600,
			   33,   33,   33,   33,   33,   33,   33,   33,   41,   59,
			   59,   59,   59,   59,   41,  736,   41,   14,   87,   87,
			   87,   41,  127,  127,   34,   79,   79,   79,   79,   79,
			   98,   98,   98,   41,   41,   41,   41,   41,   88,   88,

			   88,   88,   92,   92,   92,   92,   92,  735,   34,   34,
			   34,   34,   34,   34,   34,   34,   88,   95,   95,   95,
			   95,   97,   97,   97,   97,   97,  108,  731,   88,   88,
			   14,   14,   14,   14,   14,   14,   14,   14,   15,   15,
			   15,   15,   15,  730,   15,  100,  100,  100,   15,   15,
			  725,   89,   89,   89,   89,  102,  102,  102,  106,  106,
			  106,  106,  106,  111,  111,  111,  123,  566,   15,   89,
			  113,  113,  113,  115,  115,  115,  124,  124,  124,  567,
			  108,   89,   89,  126,  126,  126,  108,  724,  108,  128,
			  128,  128,  566,  108,  121,  121,  121,  121,  121,  122,

			  122,  122,  122,  122,  567,  108,  108,  108,  108,  108,
			  129,  129,  129,  129,  130,  130,  130,  130,  140,  140,
			  140,   15,   15,   15,   15,   15,   15,   15,   15,   16,
			   16,   16,   16,   16,  136,   16,  135,  143,  143,   16,
			   16,  137,  135,  161,  161,  123,  123,  123,  123,  123,
			  131,  131,  131,  131,  131,  142,  142,  142,  155,   16,
			  132,  132,  132,  132,  132,  156,  723,  136,  136,  136,
			  136,  136,  137,  137,  137,  137,  137,  144,  144,  144,
			  181,  181,  135,  135,  135,  135,  135,  152,  152,  152,
			  152,  152,  153,  153,  153,  153,  153,  722,  155,  155,

			  155,  155,  155,  158,  158,  158,  156,  156,  156,  156,
			  156,  166,   16,   16,   16,   16,   16,   16,   16,   16,
			   17,   17,   17,   17,   17,  167,   17,  168,  720,   17,
			   17,   17,  160,  160,  160,  162,  162,  162,  164,  173,
			  169,  164,  169,  178,  178,  178,  180,  180,  180,  164,
			  182,  182,  182,  185,  185,  185,  185,  185,  189,  189,
			  166,  166,  166,  166,  166,  167,  167,  167,  167,  167,
			  186,  186,  186,  188,  188,  188,  168,  168,  168,  168,
			  168,  169,  169,  169,  169,  169,  200,  200,  173,  173,
			  173,  173,  173,  190,  190,  190,  197,  197,  197,  199,

			  199,  199,  719,   17,   17,   17,   17,   17,   17,   17,
			   17,   18,   18,   18,   18,   18,  204,   18,  215,  215,
			   18,   18,   18,  191,  191,  191,  191,  191,  191,  191,
			  191,  201,  201,  201,  206,  206,  206,  206,  206,  207,
			  207,  207,  204,  208,  208,  208,  209,  209,  209,  210,
			  210,  210,  211,  211,  211,  211,  211,  212,  212,  212,
			  214,  214,  214,  216,  216,  216,  218,  218,  218,  218,
			  218,  219,  219,  219,  220,  220,  220,  221,  221,  221,
			  222,  222,  222,  191,  223,  223,  223,  223,  224,  224,
			  224,  224,  224,  717,   18,   18,   18,   18,   18,   18,

			   18,   18,   19,   19,   19,   19,   19,  716,   19,  228,
			  228,   19,   19,   19,  225,  225,  225,  227,  227,  227,
			  229,  229,  229,  231,  231,  231,  233,  233,  233,  234,
			  234,  235,  235,  235,  238,  238,  238,  239,  239,  239,
			  240,  240,  240,  241,  241,  241,  242,  242,  242,  242,
			  251,  251,  251,  251,  251,  252,  252,  252,  254,  254,
			  254,  255,  255,  256,  256,  256,  259,  259,  259,  259,
			  259,  260,  260,  260,  261,  261,  261,  262,  262,  262,
			  263,  263,  263,  272,  272,   19,   19,   19,   19,   19,
			   19,   19,   19,   20,   20,   20,   20,   20,  710,   20,

			  279,  279,   20,   20,   20,  264,  264,  264,  264,  266,
			  266,  266,  266,  268,  268,  268,  268,  268,  269,  269,
			  269,  291,  291,  264,  271,  271,  271,  273,  273,  273,
			  275,  275,  275,  275,  275,  264,  264,  276,  276,  276,
			  278,  278,  278,  280,  280,  280,  281,  281,  281,  281,
			  281,  282,  282,  282,  283,  283,  283,  284,  284,  284,
			  285,  285,  285,  287,  287,  287,  287,  287,  288,  288,
			  288,  290,  290,  290,  301,  301,   20,   20,   20,   20,
			   20,   20,   20,   20,   21,   21,   21,   21,   21,   21,
			   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,

			   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
			   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
			   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
			   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
			   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
			   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
			   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
			   21,   21,   21,   21,   21,   25,   25,   25,   25,   25,
			   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
			   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,

			   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
			   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
			   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
			   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
			   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
			   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
			   25,   25,   25,   25,   25,   25,   60,   60,   60,   60,
			   60,   60,   60,   60,   60,   60,   60,   60,  313,  313,
			   60,  292,  292,  292,  298,  298,  298,  300,  300,  300,
			   60,   60,   60,   60,  302,  302,  302,  303,  303,  303,

			  303,  303,  304,  304,  304,  305,  305,  305,  306,  306,
			  306,  307,  307,  307,  310,  310,  310,  709,   60,   60,
			   60,  309,  309,  309,  309,  309,  312,  312,  312,  314,
			  314,  314,  316,  316,  316,  318,  318,  318,  319,  319,
			  320,  320,  320,   60,  323,  323,  323,   60,   60,   60,
			   60,   60,  192,  321,  321,  321,  321,  321,  321,  321,
			  321,  707,  192,  192,  702,  192,  192,  192,  192,  192,
			  192,  192,  192,  701,  192,  325,  325,  325,  326,  326,
			  327,  327,  327,  328,  328,  328,  328,  328,  329,  329,
			  329,  330,  330,  330,  331,  331,  331,  332,  332,  332,

			  333,  333,  333,  333,  335,  335,  335,  337,  337,  337,
			  338,  338,  700,  321,  339,  339,  339,  340,  340,  340,
			  340,  340,  341,  341,  341,  343,  343,  343,  344,  344,
			  350,  192,  192,  192,  192,  192,  230,  230,  230,  230,
			  230,  230,  230,  230,  230,  230,  230,  230,  699,  349,
			  230,  345,  345,  345,  346,  347,  348,  353,  353,  353,
			  230,  230,  230,  230,  695,  350,  350,  350,  350,  350,
			  694,  346,  354,  354,  354,  346,  352,  352,  352,  352,
			  352,  362,  362,  346,  355,  355,  355,  693,  230,  230,
			  230,  356,  356,  356,  346,  347,  347,  347,  347,  347,

			  349,  349,  349,  349,  349,  691,  348,  348,  348,  348,
			  348,  368,  368,  230,  359,  359,  359,  230,  230,  230,
			  230,  230,  237,  237,  237,  237,  237,  237,  237,  237,
			  237,  237,  237,  237,  399,  399,  237,  358,  358,  358,
			  358,  358,  361,  361,  361,  371,  237,  237,  237,  237,
			  363,  363,  363,  364,  364,  364,  364,  364,  365,  365,
			  365,  367,  367,  367,  369,  369,  369,  372,  372,  372,
			  372,  372,  456,  456,  237,  237,  237,  689,  370,  373,
			  373,  373,  380,  371,  371,  371,  371,  371,  374,  374,
			  374,  375,  375,  375,  376,  376,  376,  474,  474,  237,

			  389,  389,  389,  237,  237,  237,  237,  237,  293,  370,
			  370,  370,  370,  370,  381,  688,  385,  382,  293,  293,
			  679,  293,  293,  293,  293,  293,  293,  293,  293,  383,
			  293,  390,  390,  390,  380,  380,  380,  380,  380,  384,
			  391,  391,  391,  392,  392,  392,  487,  487,  381,  381,
			  381,  381,  381,  382,  382,  382,  382,  382,  396,  396,
			  396,  406,  678,  383,  383,  383,  383,  383,  385,  385,
			  385,  385,  385,  384,  384,  384,  384,  384,  398,  398,
			  398,  400,  400,  400,  407,  407,  407,  293,  293,  293,
			  293,  293,  315,  315,  677,  315,  315,  315,  315,  315,

			  315,  315,  315,  675,  315,  393,  393,  393,  393,  393,
			  393,  393,  393,  670,  393,  408,  408,  408,  406,  406,
			  406,  406,  406,  409,  409,  409,  410,  410,  410,  417,
			  417,  417,  418,  418,  418,  420,  420,  420,  421,  421,
			  421,  422,  422,  422,  422,  422,  423,  423,  423,  424,
			  424,  424,  425,  425,  425,  426,  426,  426,  427,  427,
			  427,  315,  315,  315,  315,  315,  322,  428,  428,  428,
			  429,  429,  429,  430,  430,  430,  322,  322,  669,  322,
			  322,  322,  322,  322,  322,  322,  322,  668,  322,  431,
			  431,  431,  432,  432,  432,  439,  439,  439,  440,  440,

			  440,  441,  441,  441,  441,  441,  442,  442,  442,  443,
			  443,  443,  444,  444,  444,  445,  445,  445,  446,  446,
			  446,  447,  447,  447,  448,  448,  448,  449,  449,  449,
			  450,  450,  450,  451,  451,  451,  453,  453,  453,  455,
			  455,  455,  457,  457,  457,  322,  322,  322,  322,  322,
			  334,  334,  463,  334,  334,  334,  334,  334,  334,  334,
			  334,  667,  334,  464,  464,  464,  465,  465,  465,  466,
			  466,  466,  467,  467,  467,  468,  468,  468,  469,  469,
			  469,  471,  471,  471,  473,  473,  473,  475,  475,  475,
			  476,  477,  477,  477,  478,  478,  478,  479,  479,  479,

			  480,  480,  480,  484,  484,  484,  486,  486,  486,  463,
			  463,  463,  463,  463,  488,  488,  488,  489,  662,  334,
			  334,  334,  334,  334,  481,  481,  481,  481,  481,  481,
			  481,  481,  502,  481,  490,  490,  490,  491,  491,  491,
			  492,  492,  492,  493,  493,  493,  661,  476,  476,  476,
			  476,  476,  494,  494,  494,  495,  495,  495,  497,  497,
			  497,  499,  499,  499,  500,  500,  501,  501,  501,  503,
			  503,  503,  515,  657,  489,  489,  489,  489,  489,  504,
			  504,  504,  505,  505,  505,  506,  506,  506,  516,  502,
			  502,  502,  502,  502,  507,  507,  507,  508,  508,  508,

			  509,  509,  509,  510,  510,  510,  517,  518,  520,  520,
			  520,  515,  515,  515,  515,  515,  521,  521,  521,  523,
			  523,  523,  523,  523,  524,  524,  524,  525,  525,  525,
			  516,  516,  516,  516,  516,  526,  526,  526,  527,  527,
			  527,  518,  518,  518,  518,  518,  533,  540,  517,  517,
			  517,  517,  517,  528,  528,  528,  529,  529,  529,  530,
			  530,  530,  531,  531,  531,  532,  532,  532,  532,  532,
			  534,  534,  534,  535,  535,  535,  539,  541,  542,  543,
			  533,  533,  533,  533,  533,  547,  547,  547,  548,  548,
			  548,  540,  540,  540,  540,  540,  551,  551,  551,  552,

			  552,  552,  544,  553,  553,  553,  554,  554,  554,  656,
			  539,  539,  539,  539,  539,  767,  767,  542,  542,  542,
			  542,  542,  561,  561,  561,  541,  541,  541,  541,  541,
			  652,  543,  543,  543,  543,  543,  544,  544,  544,  544,
			  544,  562,  562,  562,  568,  568,  568,  569,  569,  569,
			  570,  570,  570,  571,  571,  571,  575,  575,  575,  576,
			  576,  576,  577,  577,  577,  578,  578,  578,  579,  579,
			  579,  580,  580,  580,  581,  581,  581,  582,  582,  582,
			  589,  589,  589,  590,  590,  590,  591,  591,  591,  592,
			  592,  592,  593,  593,  593,  594,  594,  594,  596,  596,

			  596,  597,  597,  597,  598,  598,  598,  598,  598,  598,
			  598,  598,  651,  598,  599,  599,  599,  599,  599,  599,
			  599,  599,  650,  599,  601,  601,  601,  602,  602,  602,
			  603,  603,  603,  604,  604,  604,  606,  606,  606,  607,
			  607,  607,  608,  608,  608,  609,  609,  609,  610,  610,
			  610,  611,  611,  611,  613,  613,  613,  614,  614,  614,
			  615,  615,  615,  616,  616,  616,  621,  647,  623,  624,
			  626,  626,  626,  646,  622,  627,  627,  627,  628,  628,
			  628,  629,  629,  629,  634,  641,  641,  641,  642,  642,
			  642,  630,  645,  635,  636,  639,  653,  653,  653,  654,

			  654,  654,  621,  621,  621,  621,  621,  622,  622,  622,
			  622,  622,  623,  623,  623,  623,  623,  624,  624,  624,
			  624,  624,  630,  630,  630,  630,  630,  635,  635,  635,
			  635,  635,  637,  638,  773,  773,  634,  634,  634,  634,
			  634,  636,  636,  636,  636,  636,  671,  639,  639,  639,
			  639,  639,  648,  648,  648,  648,  649,  649,  649,  649,
			  658,  658,  658,  659,  659,  659,  672,  638,  638,  638,
			  638,  638,  663,  663,  663,  637,  637,  637,  637,  637,
			  664,  664,  664,  673,  648,  665,  665,  665,  649,  666,
			  666,  666,  682,  644,  671,  671,  671,  671,  671,  674,

			  676,  676,  676,  676,  676,  680,  680,  680,  680,  680,
			  681,  683,  764,  764,  764,  672,  672,  672,  672,  672,
			  684,  633,  632,  681,  766,  766,  766,  682,  682,  682,
			  682,  682,  704,  673,  673,  673,  673,  673,  631,  625,
			  674,  674,  674,  674,  674,  685,  685,  685,  685,  685,
			  690,  690,  690,  690,  681,  681,  681,  681,  681,  683,
			  683,  683,  683,  683,  684,  684,  684,  684,  684,  692,
			  692,  692,  692,  703,  703,  703,  703,  703,  711,  714,
			  704,  704,  704,  704,  704,  705,  705,  705,  705,  620,
			  706,  706,  706,  706,  712,  712,  712,  712,  712,  713,

			  713,  713,  713,  713,  715,  721,  721,  721,  721,  726,
			  726,  726,  726,  726,  740,  740,  740,  740,  747,  714,
			  714,  714,  714,  714,  732,  734,  711,  711,  711,  711,
			  711,  727,  727,  727,  727,  721,  727,  748,  768,  768,
			  768,  727,  619,  715,  715,  715,  715,  715,  728,  728,
			  728,  728,  733,  728,  737,  737,  737,  737,  728,  732,
			  732,  732,  732,  732,  618,  734,  734,  734,  734,  734,
			  705,  705,  705,  705,  705,  706,  706,  706,  706,  706,
			  739,  739,  739,  739,  737,  778,  617,  733,  733,  733,
			  733,  733,  751,  751,  751,  751,  751,  587,  747,  747,

			  747,  747,  747,  752,  752,  752,  752,  752,  783,  584,
			  739,  583,  748,  748,  748,  748,  748,  753,  753,  753,
			  753,  753,  756,  756,  756,  756,  757,  757,  757,  757,
			  762,  762,  762,  762,  770,  770,  770,  772,  772,  772,
			  774,  774,  774,  776,  776,  776,  776,  779,  779,  779,
			  574,  573,  756,  780,  780,  780,  781,  781,  781,  782,
			  782,  782,  784,  784,  784,  778,  778,  778,  778,  778,
			  785,  785,  785,  776,  786,  786,  786,  787,  787,  787,
			  791,  791,  791,  783,  783,  783,  783,  783,  788,  788,
			  788,  788,  789,  789,  789,  789,  792,  792,  792,  794,

			  794,  794,  795,  795,  795,  572,  565,  564,  559,  556,
			  555,  550,  538,  537,  536,  522,  513,  511,  788,  797,
			  797,  797,  797,  797,  797,  797,  797,  797,  797,  797,
			  797,  797,  797,  797,  797,  797,  797,  797,  797,  797,
			  797,  797,  797,  797,  797,  797,  797,  797,  797,  797,
			  797,  797,  797,  797,  797,  797,  797,  797,  797,  797,
			  797,  797,  797,  797,  797,  797,  798,  798,  798,  798,
			  798,  798,  798,  798,  798,  798,  798,  798,  798,  798,
			  798,  798,  798,  798,  798,  798,  798,  798,  798,  798,
			  798,  798,  798,  798,  798,  798,  798,  798,  798,  798,

			  798,  798,  798,  798,  798,  798,  798,  798,  798,  798,
			  798,  798,  798,  799,  799,  799,  799,  799,  799,  799,
			  799,  799,  799,  799,  799,  799,  799,  799,  799,  799,
			  799,  799,  799,  799,  799,  799,  799,  799,  799,  799,
			  799,  799,  799,  799,  799,  799,  799,  799,  799,  799,
			  799,  799,  799,  799,  799,  799,  799,  799,  799,  799,
			  800,  800,  800,  800,  800,  800,  800,  800,  800,  800,
			  800,  800,  800,  800,  800,  800,  800,  800,  800,  800,
			  800,  800,  800,  800,  800,  800,  800,  800,  800,  800,
			  800,  800,  800,  800,  800,  800,  800,  800,  800,  800>>,
			1, 3000, 0)
		end

	yy_chk_template_2 (an_array: ARRAY [INTEGER]) is
		do
			yy_array_subcopy (an_array, <<
			  800,  800,  800,  800,  800,  800,  800,  801,  801,  801,
			  801,  801,  801,  801,  801,  801,  801,  801,  801,  801,
			  801,  801,  801,  801,  801,  801,  801,  801,  801,  801,
			  801,  801,  801,  801,  801,  801,  801,  801,  801,  801,
			  801,  801,  801,  801,  801,  801,  801,  801,  801,  801,
			  801,  801,  801,  801,  802,  802,  802,  802,  802,  802,
			  802,  802,  802,  802,  802,  802,  802,  802,  802,  802,
			  802,  802,  802,  802,  802,  802,  802,  802,  802,  802,
			  802,  802,  802,  802,  802,  802,  802,  802,  802,  802,
			  802,  802,  802,  802,  802,  802,  802,  802,  802,  802,

			  802,  803,  803,  803,  803,  498,  803,  803,  803,  803,
			  803,  803,  803,  803,  803,  803,  803,  803,  803,  485,
			  803,  803,  803,  803,  803,  803,  803,  803,  803,  803,
			  803,  803,  803,  482,  803,  803,  803,  803,  803,  803,
			  803,  803,  803,  804,  472,  830,  830,  830,  830,  830,
			  830,  830,  830,  462,  461,  460,  459,  804,  830,  458,
			  454,  436,  804,  804,  804,  804,  804,  804,  804,  804,
			  804,  804,  435,  434,  804,  804,  804,  804,  804,  804,
			  804,  804,  804,  805,  805,  805,  805,  805,  805,  805,
			  805,  805,  805,  413,  805,  805,  805,  805,  805,  805,

			  805,  805,  805,  805,  805,  805,  805,  805,  805,  805,
			  805,  805,  805,  805,  805,  805,  805,  805,  805,  805,
			  805,  805,  805,  805,  805,  805,  805,  805,  805,  806,
			  806,  806,  806,  806,  806,  806,  806,  806,  806,  806,
			  806,  806,  806,  806,  806,  806,  806,  806,  806,  412,
			  806,  806,  806,  806,  806,  806,  806,  806,  806,  806,
			  806,  806,  806,  806,  806,  806,  806,  806,  806,  806,
			  806,  807,  807,  807,  807,  807,  807,  807,  807,  807,
			  807,  807,  807,  807,  807,  807,  807,  807,  807,  807,
			  807,  411,  807,  807,  807,  807,  807,  807,  807,  807,

			  807,  807,  807,  807,  807,  807,  807,  807,  807,  807,
			  807,  807,  807,  808,  405,  808,  808,  808,  808,  808,
			  808,  808,  808,  404,  403,  402,  401,  397,  808,  808,
			  808,  808,  808,  808,  808,  808,  808,  808,  387,  386,
			  379,  808,  808,  808,  808,  808,  808,  808,  809,  378,
			  377,  809,  809,  809,  809,  809,  809,  809,  809,  809,
			  809,  809,  809,  809,  809,  809,  809,  809,  809,  809,
			  809,  809,  809,  809,  809,  809,  809,  809,  809,  809,
			  809,  809,  809,  809,  366,  809,  809,  809,  809,  809,
			  809,  809,  809,  809,  810,  810,  810,  810,  810,  810,

			  810,  810,  810,  810,  360,  357,  351,  342,  336,  810,
			  810,  810,  810,  810,  810,  810,  810,  810,  810,  324,
			  317,  810,  810,  810,  810,  810,  810,  810,  810,  810,
			  811,  811,  811,  811,  811,  811,  811,  811,  811,  811,
			  311,  299,  297,  296,  295,  811,  811,  811,  811,  811,
			  811,  811,  811,  811,  811,  289,  277,  811,  811,  811,
			  811,  811,  811,  811,  811,  811,  812,  270,  812,  812,
			  265,  258,  812,  812,  812,  812,  812,  812,  812,  812,
			  812,  812,  812,  812,  253,  812,  812,  812,  812,  812,
			  812,  812,  812,  812,  812,  812,  812,  812,  812,  812,

			  812,  812,  812,  812,  812,  812,  812,  812,  813,  250,
			  249,  248,  246,  244,  232,  226,  217,  213,  205,  198,
			  196,  195,  813,  194,  187,  179,  177,  813,  813,  813,
			  813,  813,  813,  813,  813,  813,  813,  176,  159,  813,
			  813,  813,  813,  813,  813,  813,  813,  813,  814,  146,
			  814,  141,  139,  125,  814,  814,  814,  814,  814,  814,
			  814,  814,  814,  814,  814,  814,  814,  814,  814,  814,
			  814,  814,  814,  814,  814,  814,  814,  814,  814,  814,
			  814,  814,  814,  814,  814,  814,  814,  814,  814,  814,
			  815,  120,  112,  105,   99,  815,  815,  815,  815,  815,

			  815,  815,  815,  815,  815,   93,   84,  815,  815,  815,
			  815,  815,  815,  815,  815,  815,  816,   82,   81,   78,
			   77,   76,   75,   74,   73,   72,   63,   61,   53,   51,
			  816,   45,   43,   39,   35,  816,  816,  816,  816,  816,
			  816,  816,  816,  816,  816,    0,    0,  816,  816,  816,
			  816,  816,  816,  816,  816,  816,  817,    0,    0,    0,
			    0,  817,  817,  817,  817,  817,  817,  817,  817,  817,
			  817,    0,    0,  817,  817,  817,  817,  817,  817,  817,
			  817,  817,  818,  818,  818,  818,  818,  818,  818,  818,
			  818,  818,  818,    0,    0,    0,    0,  818,  818,  818,

			  818,  818,  818,  818,  818,  818,  818,    0,    0,  818,
			  818,  818,  818,  818,  818,  818,  818,  818,  819,  819,
			  819,  819,  819,  819,  819,  819,  819,  819,  819,    0,
			    0,    0,    0,  819,  819,  819,  819,  819,  819,  819,
			  819,  819,  819,    0,    0,  819,  819,  819,  819,  819,
			  819,  819,  819,  819,  820,  820,  820,  820,  820,  820,
			  820,  820,  820,  820,  820,    0,    0,    0,    0,  820,
			  820,  820,  820,  820,  820,  820,  820,  820,  820,    0,
			    0,  820,  820,  820,  820,  820,  820,  820,  820,  820,
			  821,  821,  821,  821,    0,  821,  821,  821,  821,  821,

			  821,  821,  821,  821,  821,  821,  821,  821,    0,  821,
			  821,  821,  821,  821,  821,  821,  821,  821,  821,  821,
			  821,  821,    0,  821,  821,  821,  821,  821,  821,  821,
			  821,  821,  822,  822,  822,  822,  822,  822,  822,  822,
			  822,  822,    0,  822,  822,  822,  822,  822,  822,  822,
			  822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
			  822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
			  822,  822,  822,  822,  822,  822,  822,  822,  823,  823,
			  823,  823,  823,  823,  823,  823,  823,  823,  823,  823,
			  823,  823,  823,  823,  823,  823,  823,  823,    0,  823,

			  823,  823,  823,  823,  823,  823,  823,  823,  823,  823,
			  823,  823,  823,  823,  823,  823,  823,  823,  823,  823,
			  824,    0,    0,  824,  824,  824,  824,  824,  824,  824,
			  824,  824,  824,  824,  824,  824,  824,  824,  824,  824,
			  824,  824,  824,  824,  824,  824,  824,  824,  824,  824,
			  824,  824,  824,  824,  824,  824,    0,  824,  824,  824,
			  824,  824,  824,  824,  824,  824,  825,  825,  825,  825,
			  825,  825,  825,  825,  825,  825,    0,    0,    0,    0,
			    0,  825,  825,  825,  825,  825,  825,  825,  825,  825,
			  825,    0,    0,  825,  825,  825,  825,  825,  825,  825,

			  825,  825,  826,    0,  826,  826,    0,    0,  826,  826,
			  826,  826,  826,  826,  826,  826,  826,  826,  826,  826,
			    0,  826,  826,  826,  826,  826,  826,  826,  826,  826,
			  826,  826,  826,  826,  826,  826,  826,  826,  826,  826,
			  826,  826,  826,  826,  827,    0,  827,    0,    0,    0,
			  827,  827,  827,  827,  827,  827,  827,  827,  827,  827,
			  827,  827,  827,  827,  827,  827,  827,  827,  827,  827,
			  827,  827,  827,  827,  827,  827,  827,  827,  827,  827,
			  827,  827,  827,  827,  827,  827,  828,  828,  828,  828,
			  828,  828,  828,  828,  828,  828,  828,    0,    0,    0,

			    0,  828,  828,  828,  828,  828,  828,  828,  828,  828,
			  828,    0,    0,  828,  828,  828,  828,  828,  828,  828,
			  828,  828,  829,  829,  829,  829,  829,  829,  829,  829,
			  829,  829,  829,    0,    0,    0,    0,  829,  829,  829,
			  829,  829,  829,  829,  829,  829,  829,    0,    0,  829,
			  829,  829,  829,  829,  829,  829,  829,  829,  831,  831,
			  831,  831,  831,  831,  831,  831,  831,  831,  831,  831,
			    0,    0,    0,  831,  831,  831,  831,  831,  831,  831,
			  831,  831,  831,    0,    0,  831,  831,  831,  831,  831,
			  831,  831,  831,  831,  832,  832,  832,  832,  832,  832,

			  832,  832,  832,  832,  832,  832,  832,  832,  832,  832,
			  832,  832,  832,  832,    0,  832,  832,  832,  832,  832,
			  832,  832,  832,  832,  832,  832,  832,  832,  832,  832,
			  832,  832,  832,  832,  832,  832,  833,  833,  833,  833,
			  833,  833,  833,  833,  833,  833,    0,    0,    0,    0,
			    0,  833,  833,  833,  833,  833,  833,  833,  833,  833,
			  833,    0,    0,  833,  833,  833,  833,  833,  833,  833,
			  833,  833,  834,  834,  834,  834,  834,  834,  834,  834,
			  834,  834,  834,  834,    0,    0,    0,  834,  834,  834,
			  834,  834,  834,  834,  834,  834,  834,    0,    0,  834,

			  834,  834,  834,  834,  834,  834,  834,  834,  835,  835,
			  835,  835,  835,  835,  835,  835,  835,  835,  835,  835,
			    0,    0,    0,  835,  835,  835,  835,  835,  835,  835,
			  835,  835,  835,    0,    0,  835,  835,  835,  835,  835,
			  835,  835,  835,  835,  836,  836,  836,  836,  836,  836,
			  836,  836,  836,  836,  836,  836,    0,    0,    0,  836,
			  836,  836,  836,  836,  836,  836,  836,  836,  836,    0,
			    0,  836,  836,  836,  836,  836,  836,  836,  836,  836,
			  837,  837,  837,  837,  837,  837,  837,  837,  837,  837,
			  837,  837,    0,    0,    0,  837,  837,  837,  837,  837,

			  837,  837,  837,  837,  837,    0,    0,  837,  837,  837,
			  837,  837,  837,  837,  837,  837,  838,  838,  838,  838,
			  838,  838,  838,  838,  838,  838,  838,    0,    0,    0,
			    0,  838,  838,  838,  838,  838,  838,  838,  838,  838,
			  838,    0,    0,  838,  838,  838,  838,  838,  838,  838,
			  838,  838,  839,  839,  839,  839,  839,  839,  839,    0,
			  839,  839,  839,  839,  839,  839,  839,  839,  839,  839,
			  839,  839,  839,    0,    0,  839,  839,  839,  839,  839,
			  839,  839,  839,  839,  839,  839,    0,    0,  839,  839,
			  839,  839,  839,  839,  839,  839,  840,  840,  840,  840,

			    0,  840,  840,    0,  840,  840,  840,  840,  840,  840,
			  840,  840,  840,  840,  840,  840,  840,    0,    0,  840,
			  840,  840,  840,  840,  840,  840,  840,  840,  840,  840,
			    0,    0,  840,  840,  840,  840,  840,  840,  840,  840,
			  841,  841,  841,  841,  841,  841,  841,  841,  841,  841,
			  841,  841,  841,  841,  841,  841,  841,  841,  841,  841,
			  841,  841,  841,  841,  841,  841,  841,  841,  841,  841,
			  841,  841,  841,  841,  841,  841,  841,  841,  841,  841,
			  841,  841,  841,  841,  841,  841,  842,  842,  842,  842,
			  842,  842,  842,  842,  842,  842,  842,  842,  842,  842,

			  842,  842,  842,  842,  842,  842,  842,  842,  842,  842,
			  842,  842,  842,  842,  842,  842,  842,  842,  842,  842,
			  842,  842,  842,  842,  842,  842,  842,  842,  842,  842,
			  842,  842,  843,  843,  843,  843,  843,  843,  843,  843,
			  843,  843,  843,  843,  843,  843,  843,  843,  843,  843,
			  843,  843,  843,  843,  843,  843,  843,  843,  843,  843,
			  843,  843,  843,  843,  843,  843,  843,  843,  843,  843,
			  843,  843,  843,  843,  843,  843,  843,  843,  844,  844,
			  844,  844,  844,  844,  844,  844,  844,  844,  844,  844,
			  844,  844,  844,  844,  844,  844,  844,  844,  844,  844,

			  844,  844,  844,  844,  844,  844,  844,  844,  844,  844,
			  844,  844,  844,  844,  844,  844,  844,  844,  844,  844,
			  844,  844,  844,  844,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,

			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796>>,
			1, 1816, 3000)
		end

	yy_base_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    0,   91,   19,   27,  182,    0,  273,    0,   39,
			   71,  364,    0,  455,  546,  637,  728,  819,  910, 1001,
			 1092, 1183,    0,    3,    4, 1274,    0,  456,  463,  466,
			  473,    7,    8,  476,  524, 3634, 4724,    4, 4724, 3630,
			   45,  506,   21, 3572,   35, 3545,   53,   12,   56,   56,
			   76, 3611,   64, 3542,   68,   15,   84,   21,   54,  482,
			 1360, 3594,   87, 3540,  403,  396,  433,   74,   78, 4724,
			 4724,    0, 3606, 3591, 3551, 3549, 3543, 3554, 3553,  498,
			 4724, 3615, 3557,  437, 3520,  444,  426,  494,  596,  649,
			 4724, 4724,  515, 3572, 4724,  615, 4724,  534,  506, 3508,

			  561,  449,  571, 4724, 4724, 3590,  571, 4724,  618, 4724,
			 4724,  579, 3506,  586,  452,  589, 4724, 4724, 4724, 4724,
			 3588,  607,  612,  658,  592, 3467,  599,  497,  605,  708,
			  712,  663,  673,    2, 4724,  695,  680,  685, 4724, 3492,
			  634, 3465,  671,  652,  693, 4724, 3500, 4724, 4724, 4724,
			 4724, 4724,  700,  705, 4724,  711,  719, 4724,  719, 3452,
			  748,  658,  751, 4724,  798, 4724,  773,  778,  789,  794,
			 4724, 4724, 4724,  801, 4724, 4724, 3531, 3466,  759, 3439,
			  762,  695,  766,    5, 4724,  766,  786, 3438,  789,  773,
			  809,  902, 1444,  398, 3445, 3443, 3441,  812, 3433,  815,

			  801,  847,   11, 4724,  861, 3485,  847,  855,  859,  862,
			  865,  865,  873, 3431,  876,  833,  879, 3483,  879,  887,
			  890,  893,  896,  982,  901,  930, 3429,  933,  924,  936,
			 1530,  939, 3428,  942,  944,  947, 4724, 1616,  950,  953,
			  956,  959, 1044,    0, 3492, 4724, 3448,    0, 3449, 3434,
			 3432,  963,  971, 3398,  974,  976,  979, 4724, 3438,  979,
			  987,  990,  993,  996, 1103, 3437, 1107, 4724, 1026, 1034,
			 3381, 1040,  998, 1043, 4724, 1043, 1053, 3370, 1056, 1015,
			 1059, 1059, 1067, 1070, 1073, 1076, 4724, 1076, 1084, 3369,
			 1087, 1036, 1297, 1700,  434, 3366, 3365, 3363, 1300, 3355,

			 1303, 1089, 1310, 1310, 1318, 1321, 1324, 1327, 4724, 1334,
			 1330, 3354, 1342, 1293, 1345, 1774, 1348, 3334, 1351, 1353,
			 1356, 1432, 1858, 1360, 3333, 1391, 1393, 1396, 1396, 1404,
			 1407, 1410, 1413, 1498, 1932, 1420, 3322, 1423, 1425, 1430,
			 1430, 1438, 3321, 1441, 1443, 1467, 1536, 1508, 1519, 1513,
			 1478, 3373, 1489, 1473, 1488, 1500, 1507, 3368, 1550, 1530,
			 3318, 1558, 1496, 1566, 1566, 1574, 3298, 1577, 1526, 1580,
			 1622, 1596, 1580, 1595, 1604, 1607, 1610, 3307, 3303, 3301,
			 1647, 1661, 1666, 1676, 1686, 1681, 3281, 3305, 4724, 1616,
			 1647, 1656, 1659, 1784,    0, 4724, 1674, 3241, 1694, 1549,

			 1697, 3252, 3252, 3294, 3293, 3241, 1731, 1700, 1731, 1739,
			 1742, 3273, 3201, 3156,    2,  419, 4724, 1745, 1748, 4724,
			 1751, 1754, 1754, 1762, 1765, 1768, 1771, 1774, 1783, 1786,
			 1789, 1805, 1808, 4724, 3100, 3100, 3084,    0, 4724, 1811,
			 1814, 1814, 1822, 1825, 1828, 1831, 1834, 1837, 1840, 1843,
			 1846, 1849, 4724, 1852, 3074, 1855, 1587, 1858, 3085, 3083,
			 3125, 3124, 3080, 1922, 1879, 1882, 1885, 1888, 1891, 1894,
			 4724, 1897, 3058, 1900, 1612, 1903, 1960, 1907, 1910, 1913,
			 1916, 2003, 3110, 4724, 1919, 3033, 1922, 1661, 1930, 1987,
			 1950, 1953, 1956, 1959, 1968, 1971, 4724, 1974, 3019, 1977,

			 1979, 1982, 2002, 1985, 1995, 1998, 2001, 2010, 2013, 2016,
			 2019, 2764,    7, 2768, 4724, 2024, 2043, 2061, 2054, 4724,
			 2024, 2032, 2777, 2032, 2040, 2043, 2051, 2054, 2069, 2072,
			 2075, 2078, 2078, 2093, 2086, 2089, 2759, 2764, 2762, 2123,
			 2104, 2138, 2130, 2144, 2149, 4724, 4724, 2101, 2104, 4724,
			 2781, 2112, 2115, 2119, 2122, 2780, 2732, 4724, 4724, 2730,
			 4724, 2138, 2157, 4724, 2770, 2768,  622,  634, 2160, 2163,
			 2166, 2169, 2740, 2686, 2681, 2172, 2175, 2178, 2181, 2184,
			 2187, 2190, 2193, 2681, 2632, 4724, 4724, 2619, 4724, 2196,
			 2199, 2202, 2205, 2208, 2211, 4724, 2214, 2217, 2283, 2293,

			  529, 2240, 2243, 2246, 2249, 4724, 2252, 2255, 2258, 2261,
			 2264, 2267, 4724, 2270, 2273, 2276, 2279, 2633, 2625, 2589,
			 2536, 2315, 2320, 2325, 2330, 2504, 2286, 2291, 2294, 2297,
			 2335, 2499, 2477, 2467, 2349, 2340, 2354, 2388, 2380, 2360,
			 4724, 2301, 2304, 4724, 2463, 2362, 2320, 2332, 2450, 2454,
			 2253, 2250, 2157, 2312, 2315, 4724, 2179, 2043, 2376, 2379,
			 4724, 2016, 1988, 2388, 2396, 2401, 2405, 1916, 1841, 1835,
			 1778, 2407, 2428, 2446, 2453, 1750, 2413, 1756, 1719, 1677,
			 2418, 2467, 2440, 2472, 2477, 2458, 4724, 4724, 1659, 1624,
			 2548, 1572, 2567, 1515, 1500, 1492, 4724, 4724, 4724, 1505,

			 1473, 1420, 1411, 2486, 2493, 2583, 2588, 1426, 4724, 1378,
			 1047, 2539, 2507, 2512, 2532, 2556,  958,  958, 4724,  834,
			  755, 2603,  745,  719,  631,  607, 2522, 2629, 2646, 4724,
			  605,  588, 2572, 2600, 2578,  568,  517, 2652,  482, 2678,
			 2612,  479,  462, 4724,  453,  489,  482, 2611, 2625, 4724,
			  454, 2605, 2616, 2630, 4724, 4724, 2720, 2724,  418, 4724,
			 4724,  427, 2728, 4724, 2428,  375, 2440, 2130, 2554, 4724,
			 2650,   88, 2653, 2349, 2656, 4724, 2741, 4724, 2678, 2663,
			 2669, 2672, 2675, 2696, 2678, 2686, 2690, 2693, 2786, 2790,
			 4724, 2696, 2712, 4724, 2715, 2718, 4724, 2818, 2865, 2912,

			 2959, 3006, 3053, 3095, 3135, 3181, 3223, 3265, 3301, 3346,
			 3382, 3418, 3460, 3500, 3542, 3568, 3608, 3634, 3670, 3706,
			 3742, 3784, 3830, 3872, 3918, 3954, 3996, 4038, 4074, 4110,
			 3131, 4146, 4188, 4224, 4260, 4296, 4332, 4368, 4404, 4449,
			 4493, 4538, 4584, 4630, 4676>>)
		end

	yy_def_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,  797,  797,  798,  798,  796,    5,  796,    7,  799,
			  799,  796,   11,  800,  800,  800,  800,  801,  801,  801,
			  801,  796,   21,   21,   21,  796,   25,   25,   25,   21,
			   21,   21,   21,  802,  802,  796,  796,  796,  796,  796,
			  803,  804,  796,  796,  796,  796,  796,  796,  796,  805,
			  805,  796,  796,  796,  796,  796,  796,  796,  796,  806,
			  807,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  808,  808,  796,  808,  808,  808,  808,  808,  809,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  810,  796,  796,  796,  796,  811,  796,  796,

			  796,  796,  796,  796,  796,  796,  812,  796,  813,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  814,  815,  816,  796,  796,  796,  796,  796,  796,
			  796,  817,  818,  796,  796,  818,  818,  818,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  819,  820,  796,  820,  820,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  820,  820,  820,  820,
			  796,  796,  796,  818,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  803,  796,  796,  796,  796,
			  796,  796,  804,  192,  192,  192,  192,  796,  796,  796,

			  796,  796,  796,  796,  796,  796,  821,  796,  796,  796,
			  796,  805,  796,  796,  796,  796,  796,  796,  822,  796,
			  796,  796,  796,  796,  806,  796,  796,  796,  796,  796,
			  807,  796,  796,  796,  796,  796,  796,  823,  796,  796,
			  796,  796,  796,  808,  796,  796,  808,  808,  808,  808,
			  808,  809,  796,  796,  796,  796,  796,  796,  796,  824,
			  796,  796,  796,  796,  796,  796,  796,  796,  810,  796,
			  796,  796,  796,  796,  796,  811,  796,  796,  796,  796,
			  796,  825,  796,  796,  796,  796,  796,  812,  796,  796,
			  796,  796,  796,  813,  293,  293,  293,  293,  796,  796,

			  796,  796,  796,  826,  796,  796,  796,  796,  796,  814,
			  796,  796,  796,  796,  796,  815,  796,  796,  796,  796,
			  796,  796,  816,  796,  796,  796,  796,  796,  827,  796,
			  796,  796,  796,  796,  817,  796,  796,  796,  796,  796,
			  818,  796,  796,  796,  796,  796,  796,  818,  818,  818,
			  818,  796,  828,  796,  796,  796,  796,  796,  819,  796,
			  796,  796,  796,  796,  820,  796,  796,  796,  796,  796,
			  820,  820,  829,  796,  796,  796,  796,  796,  796,  796,
			  820,  820,  820,  820,  820,  818,  796,  796,  796,  796,
			  796,  796,  796,  796,  830,  796,  796,  796,  796,  796,

			  796,  192,  192,  192,  192,  192,  831,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  832,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  808,  808,  808,  808,  796,  796,
			  796,  833,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  293,  293,
			  293,  293,  293,  834,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  835,  796,  796,  796,
			  796,  796,  830,  796,  796,  796,  796,  796,  796,  836,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,

			  796,  796,  837,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  818,  818,  818,  818,  796,
			  796,  796,  796,  838,  796,  796,  796,  796,  796,  796,
			  796,  796,  820,  820,  796,  796,  796,  796,  796,  820,
			  820,  820,  820,  820,  818,  796,  796,  796,  796,  796,
			  830,  796,  796,  796,  796,  192,  192,  796,  796,  192,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  808,  808,  808,  796,  796,  796,  796,  796,
			  796,  796,  796,  293,  293,  796,  796,  293,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,

			  830,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  818,  818,  818,  818,  796,  796,  796,  796,  796,
			  820,  796,  796,  796,  820,  820,  820,  820,  820,  818,
			  796,  796,  796,  796,  192,  192,  796,  796,  796,  796,
			  808,  808,  808,  796,  796,  796,  293,  293,  796,  796,
			  796,  830,  830,  796,  796,  796,  796,  796,  796,  796,
			  796,  818,  818,  818,  818,  796,  820,  796,  796,  796,
			  820,  820,  820,  820,  820,  818,  796,  796,  796,  796,
			  796,  796,  796,  808,  808,  808,  796,  796,  796,  796,

			  796,  796,  796,  818,  818,  818,  818,  796,  796,  796,
			  796,  820,  820,  820,  820,  820,  796,  796,  796,  808,
			  808,  808,  796,  796,  796,  796,  818,  796,  796,  796,
			  796,  796,  820,  820,  820,  796,  796,  808,  808,  796,
			  796,  796,  796,  796,  796,  839,  840,  841,  842,  796,
			  796,  820,  820,  820,  796,  796,  796,  796,  808,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  808,  796,  843,  796,
			  796,  796,  796,  844,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,    0,  796,  796,  796,

			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
			  796,  796,  796,  796,  796>>)
		end

	yy_ec_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    1,    1,    1,    1,    1,    1,    1,    2,
			    3,    1,    1,    4,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    5,    6,    7,    8,    9,   10,   11,   12,
			   13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
			   23,   24,   25,   26,   26,   27,   26,   28,   29,   30,
			   31,   32,   33,   34,    9,   35,   36,   37,   38,   39,
			   40,   41,   42,   43,   42,   44,   45,   46,   47,   48,
			   49,   50,   51,   52,   53,   54,   42,   42,   55,   56,
			   57,   58,   59,   60,   59,   61,   59,   62,   63,   64,

			   65,   66,   67,   68,   42,   69,   42,   42,   70,   71,
			   72,   73,   74,   75,   76,   77,   78,   79,   80,   42,
			   81,   82,   42,   59,   83,   59,   59,   59,   84,   84,
			   84,   84,   84,   84,   84,   84,   84,   84,   84,   84,
			   84,   84,   84,   84,   85,   85,   85,   85,   85,   85,
			   85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
			   86,   86,   86,   86,   86,   86,   86,   86,   86,   86,
			   86,   86,   86,   86,   86,   86,   86,   86,   86,   86,
			   86,   86,   86,   86,   86,   86,   86,   86,   86,   86,
			   86,   86,    1,    1,   87,   87,   87,   87,   87,   87,

			   87,   87,   87,   87,   87,   87,   87,   87,   87,   87,
			   87,   87,   87,   87,   87,   87,   87,   87,   87,   87,
			   87,   87,   87,   87,   88,   89,   89,   89,   89,   89,
			   89,   89,   89,   89,   89,   89,   89,   89,   89,   89,
			   90,   91,   91,   91,   91,   91,   91,   91,    1,    1,
			    1,    1,    1,    1,    1,    1,    1>>)
		end

	yy_meta_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    2,    3,    4,    5,    6,    7,    8,    6,
			    9,   10,   11,    6,    6,    6,    6,    6,   12,   13,
			    6,   14,   15,   16,   17,   18,   19,   20,   21,   22,
			   23,   24,    6,   25,   26,   27,   27,   27,   27,   27,
			   27,   28,   29,   28,   28,   28,   28,   28,   28,   28,
			   30,   28,   31,   32,   33,   34,   35,   36,   37,   25,
			   38,   39,   27,   27,   27,   27,   27,   27,   28,   28,
			   28,   28,   28,   28,   40,   41,   28,   42,   28,   43,
			   44,   45,   46,   25,    1,    1,    1,   47,   47,   47,
			   47,   47>>)
		end

	yy_accept_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
			    0,    0,    0,    0,    0,  144,  142,  138,  137,  136,
			  139,  125,   94,  141,  142,  142,  142,  142,  142,    4,
			    4,    6,  142,  142,  142,  142,  142,   24,   24,   25,
			   22,   27,  142,  142,  142,  142,  142,   20,   20,   19,
			   18,   17,   17,  142,   17,   17,   17,   17,   17,   31,
			   30,   30,   33,  142,  142,  142,  142,  142,  102,  102,
			  105,  104,  100,  142,   97,  103,   96,   98,  142,  142,

			  142,  142,  142,  120,  120,  120,  121,  131,  125,  130,
			  118,  142,  142,  142,  142,  142,  132,  133,  127,  126,
			  126,  128,   92,  125,  142,  142,  142,  142,  142,   70,
			   70,   89,   68,  142,   67,   68,   68,   68,   50,   51,
			  142,  142,  142,  142,  142,   49,  142,   77,   78,   80,
			   81,   76,   82,   68,   79,   68,   68,   75,  142,  142,
			  142,  142,  142,   48,  142,   47,   68,   68,   68,   68,
			   86,   84,   85,   68,   62,   62,   62,   62,  142,  142,
			  142,  142,  142,  138,  135,  139,    0,    0,    0,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

			    0,    0,    0,   93,    9,    0,  140,    0,    0,    0,
			    0,    4,    0,    0,    0,    0,    0,    3,    5,    0,
			    0,    0,    0,   24,   25,    0,    0,    0,    0,    0,
			   22,    0,    0,    0,    0,    0,   21,   23,    0,    0,
			    0,    0,   20,   17,    0,   10,   17,   15,   17,   17,
			   17,   31,    0,    0,    0,    0,    0,   30,    0,   32,
			    0,    0,    0,    0,  102,    0,  103,   96,  100,    0,
			    0,    0,    0,    0,   95,   98,    0,    0,    0,    0,
			    0,   99,    0,    0,    0,    0,  119,  121,    0,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

			    0,    0,    0,  122,    0,    0,    0,    0,  126,  128,
			    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,  129,    0,
			    0,    0,    0,   70,    0,    0,    0,    0,    0,    0,
			   68,    0,    0,    0,    0,    0,    0,   68,   68,   68,
			   68,    0,   69,    0,    0,    0,    0,    0,   82,    0,
			    0,    0,    0,    0,   68,    0,    0,    0,    0,    0,
			   68,   68,   69,    0,    0,    0,    0,    0,    0,    0,
			   68,   68,   39,   68,   68,   68,    0,    0,   62,    0,
			    0,    0,    0,    0,    0,  111,    0,    0,    0,    0,

			    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
			    0,    0,    0,    0,    0,    0,  134,    0,    0,    2,
			    0,    0,   26,    0,    0,    0,    0,    0,    0,    0,
			    0,    0,    0,   12,   17,   17,   17,   14,   29,    0,
			    0,  101,    0,    0,    0,    0,    0,    0,    0,    0,
			    0,    0,  116,    0,    0,    0,    0,    0,    0,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
			   90,    0,    0,    0,    0,    0,    0,    0,    0,    0,
			    0,    0,    0,  113,    0,    0,    0,    0,    0,    0,
			    0,    0,    0,    0,    0,    0,   87,    0,    0,    0,

			    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
			    0,    0,    0,    0,   58,   68,   68,   68,   68,   59,
			    0,    0,    0,   83,    0,    0,    0,    0,    0,    0,
			    0,    0,   65,   68,    0,    0,    0,    0,    0,   68,
			   68,   68,   68,   68,   68,   60,   61,    0,    0,  123,
			    0,    0,    0,    0,    0,    0,    0,  109,  108,    0,
			  112,    0,    0,    1,    0,    0,    0,    0,    0,    0,
			    0,    0,   17,   17,   17,    0,    0,    0,    0,    0,
			    0,    0,    0,    0,    0,  109,  108,    0,  117,    0,
			    0,    0,    0,    0,    0,   91,    0,    0,    0,    0,

			    0,    0,    0,    0,    0,  114,    0,    0,    0,    0,
			    0,    0,   88,    0,    0,    0,    0,    0,    0,    0,
			    0,   68,   68,   68,   68,    0,    0,    0,    0,    0,
			   68,    0,    0,    0,   68,   68,   68,   68,   68,   68,
			  124,    0,    0,  110,    0,    0,    0,    0,    0,    0,
			   17,   17,   17,    0,    0,  110,    0,    0,    0,    0,
			  115,    0,    0,    0,    0,    0,    0,    0,    0,    0,
			    0,   68,   68,   68,   68,    0,   64,    0,    0,    0,
			   38,   68,   40,   68,   68,   66,  106,  107,    0,    0,
			    8,    0,    7,   17,   17,   17,  106,  107,  115,    0,

			    0,    0,    0,   56,   68,   68,   68,    0,   37,    0,
			    0,   68,   42,   41,   68,   68,    0,    0,    8,   17,
			   17,   17,    0,    0,    0,    0,   57,    0,    0,   63,
			    0,    0,   68,   44,   68,    0,    0,   17,   17,    0,
			   11,    0,    0,   54,    0,    0,    0,    0,    0,   36,
			    0,   43,   45,   46,   34,   28,    0,   16,   17,   53,
			   52,    0,   74,   71,    0,    0,    0,    0,    0,   71,
			    0,    0,    0,    0,    0,   35,   17,   55,    0,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,    0,   13,
			   73,    0,    0,   72,    0,    0,    0>>)
		end

feature {NONE} -- Constants

	yyJam_base: INTEGER is 4724
			-- Position in `yy_nxt'/`yy_chk' tables
			-- where default jam table starts

	yyJam_state: INTEGER is 796
			-- State id corresponding to jam state

	yyTemplate_mark: INTEGER is 797
			-- Mark between normal states and templates

	yyNull_equiv_class: INTEGER is 1
			-- Equivalence code for NULL character

	yyReject_used: BOOLEAN is false
			-- Is `reject' called?

	yyVariable_trail_context: BOOLEAN is false
			-- Is there a regular expression with
			-- both leading and trailing parts having
			-- variable length?

	yyReject_or_variable_trail_context: BOOLEAN is false
			-- Is `reject' called or is there a
			-- regular expression with both leading
			-- and trailing parts having variable length?

	yyNb_rules: INTEGER is 143
			-- Number of rules

	yyEnd_of_buffer: INTEGER is 144
			-- End of buffer rule code

	yyLine_used: BOOLEAN is true
			-- Are line and column numbers used?

	yyPosition_used: BOOLEAN is true
			-- Is `position' used?

	INITIAL: INTEGER is 0
	comment_state: INTEGER is 1
	processinginstruction: INTEGER is 2
	xmldeclaration: INTEGER is 3
	cdata: INTEGER is 4
	tag: INTEGER is 5
	attribute_value_single: INTEGER is 6
	attribute_value_double: INTEGER is 7
	entity_value_single: INTEGER is 8
	entity_value_double: INTEGER is 9
	doctype: INTEGER is 10
	dtd_in: INTEGER is 11
	dtd_element: INTEGER is 12
	dtd_attlist: INTEGER is 13
	dtd_entity: INTEGER is 14
	dtd_notation: INTEGER is 15
	dtd_ignore: INTEGER is 16
			-- Start condition codes

feature -- User-defined features



feature -- Scanning

	read_token is
			-- (NOTE: THIS IS THE COPY/PASTE VERSION OF THE CODE IN
			-- THE YY_COMPRESSED_SCANNER_SKELETON CLASS, FOR OPTIMISATION
			-- WITH ISE EIFFEL (ALLOW INLINING NOT POSSIBLE IN
			-- YY_COMPRESSED_SCANNER_SKELETON).)

			-- Read a token from `input_buffer'.
			-- Make result available in `last_token'.
		local
			yy_cp, yy_bp: INTEGER
			yy_current_state: INTEGER
			yy_next_state: INTEGER
			yy_matched_count: INTEGER
			yy_act: INTEGER
			yy_goto: INTEGER
			yy_c: INTEGER
			yy_found: BOOLEAN
			yy_rejected_line: INTEGER
			yy_rejected_column: INTEGER
			yy_rejected_position: INTEGER
			yy_done: BOOLEAN
		do
				-- This routine is implemented with a loop whose body
				-- is a big inspect instruction. This is a mere
				-- translation of C gotos into Eiffel. Needless to
				-- say that I'm not very proud of this piece of code.
				-- However I performed some benchmarks and the results
				-- were that this implementation runs amazingly faster
				-- than an alternative implementation with no loop nor
				-- inspect instructions and where every branch of the
				-- old inspect instruction was written in a separate
				-- routine. I think that the performance penalty is due
				-- to the routine call overhead and the depth of the call
				-- stack. Anyway, I prefer to provide you with a big and
				-- ugly but fast scanning routine rather than a nice and
				-- slow version. I hope you won't blame me for that! :-)
			from
				last_token := yyUnknown_token
				yy_goto := yyNext_token
			until
				last_token /= yyUnknown_token
			loop
				inspect yy_goto
				when yyNext_token then
					if yy_more_flag then
						yy_more_len := yy_end - yy_start
						yy_more_flag := False
					else
						yy_more_len := 0
						line := yy_line
						column := yy_column
						position := yy_position
					end
					yy_cp := yy_end
						-- `yy_bp' is the position of the first
						-- character of the current token.
					yy_bp := yy_cp
						-- Find the start state.
					-- START INLINING 'yy_at_beginning_of_line'
					-- yy_current_state := yy_start_state + yy_at_beginning_of_line
					if input_buffer.beginning_of_line then
						yy_current_state := yy_start_state + 1
					else
						yy_current_state := yy_start_state
					end
					-- END INLINING 'yy_at_beginning_of_line'
					if yyReject_or_variable_trail_context then
							-- Set up for storing up states.
						yy_state_stack.put (yy_current_state, 0)
						yy_state_count := 1
					end
					yy_goto := yyMatch
				when yyMatch then
						-- Find the next match.
					from
						yy_done := False
					until
						yy_done
					loop
						if yy_ec /= Void then
							if yy_content_area /= Void then
								yy_c := yy_ec.item (yy_content_area.item (yy_cp - 1).code)
							else
								yy_c := yy_ec.item (yy_content.item (yy_cp).code)
							end
						else
							if yy_content_area /= Void then
								yy_c := yy_content_area.item (yy_cp - 1).code
							else
								yy_c := yy_content.item (yy_cp).code
							end
						end
						if
							not yyReject_or_variable_trail_context and then
							yy_accept.item (yy_current_state) /= 0
						then
								-- Save the backing-up info before computing
								-- the next state because we always compute one
								-- more state than needed - we always proceed
								-- until we reach a jam state.
							yy_last_accepting_state := yy_current_state
							yy_last_accepting_cpos := yy_cp
						end
						from until
							yy_chk.item (yy_base.item (yy_current_state) + yy_c) = yy_current_state
						loop
							yy_current_state := yy_def.item (yy_current_state)
							if
								yy_meta /= Void and then
								yy_current_state >= yyTemplate_mark
							then
									-- We've arranged it so that templates are
									-- never chained to one another. This means
									-- we can afford to make a very simple test
									-- to see if we need to convert to `yy_c''s
									-- meta-equivalence class without worrying
									-- about erroneously looking up the meta
									-- equivalence class twice.
								yy_c := yy_meta.item (yy_c)
							end
						end
						yy_current_state := yy_nxt.item (yy_base.item (yy_current_state) + yy_c)
						if yyReject_or_variable_trail_context then
							yy_state_stack.put (yy_current_state, yy_state_count)
							yy_state_count := yy_state_count + 1
						end
						yy_cp := yy_cp + 1
						yy_done := (yy_current_state = yyJam_state)
					end
					if not yyReject_or_variable_trail_context then
							-- Do the guaranteed-needed backing up
							-- to find out the match.
						yy_cp := yy_last_accepting_cpos
						yy_current_state := yy_last_accepting_state
					end
					yy_goto := yyFind_action
				when yyFind_action then
						-- Find the action number.
					if not yyReject_or_variable_trail_context then
						yy_act := yy_accept.item (yy_current_state)
						yy_goto := yyDo_action
					else
						yy_state_count := yy_state_count - 1
						yy_current_state := yy_state_stack.item (yy_state_count)
						yy_lp := yy_accept.item (yy_current_state)
						yy_goto := yyFind_rule
					end
				when yyFind_rule then
						-- We branch here when backing up.
					check reject_used: yyReject_or_variable_trail_context end
					from yy_found := False until yy_found loop
						if
							yy_lp /= 0 and
							yy_lp < yy_accept.item (yy_current_state + 1)
						then
							yy_act := yy_acclist.item (yy_lp)
							if yyVariable_trail_context then
								if
									yy_act < - yyNb_rules or
									yy_looking_for_trail_begin /= 0
								then
									if yy_act = yy_looking_for_trail_begin then
										yy_looking_for_trail_begin := 0
										yy_act := - yy_act - yyNb_rules
										yy_found := True
									else
										yy_lp := yy_lp + 1
									end
								elseif yy_act < 0 then
									yy_looking_for_trail_begin := yy_act - yyNb_rules
									if yyReject_used then
											-- Remember matched text in case
											-- we back up due to `reject'.
										yy_full_match := yy_cp
										yy_full_state := yy_state_count
										yy_full_lp := yy_lp
									end
									yy_lp := yy_lp + 1
								else
									yy_full_match := yy_cp
									yy_full_state := yy_state_count
									yy_full_lp := yy_lp
									yy_found := True
								end
							else
								yy_full_match := yy_cp
								yy_found := True
							end
						else
							yy_cp := yy_cp - 1
							yy_state_count := yy_state_count - 1
							yy_current_state := yy_state_stack.item (yy_state_count)
							yy_lp := yy_accept.item (yy_current_state)
						end
					end
					yy_rejected_line := yy_line
					yy_rejected_column := yy_column
					yy_rejected_position := yy_position
					yy_goto := yyDo_action
				when yyDo_action then
						-- Set up `text' before action.
					yy_bp := yy_bp - yy_more_len
					yy_start := yy_bp
					yy_end := yy_cp
					debug ("GELEX")
					end
					yy_goto := yyNext_token
						-- Semantic actions.
					if yy_act = 0 then
							-- Must back up.
						if not yyReject_or_variable_trail_context then
								-- Backing-up info for compressed tables is
								-- taken after `yy_cp' has been incremented
								-- for the next state.
							yy_cp := yy_last_accepting_cpos
							yy_bp := yy_bp + yy_more_len
							yy_current_state := yy_last_accepting_state
							yy_goto := yyFind_action
						else
							last_token := yyError_token
							fatal_error ("fatal scanner internal error: no action found")
						end
					elseif yy_act = yyEnd_of_buffer then
							-- Amount of text matched not including
							-- the EOB character.
						yy_matched_count := yy_cp - yy_bp - 1
							-- Note that here we test for `yy_end' "<="
							-- to the position of the first EOB in the buffer,
							-- since `yy_end' will already have been 
							-- incremented past the NULL character (since all
							-- states make transitions on EOB to the 
							-- end-of-buffer state). Contrast this with the
							-- test in `read_character'.
						if yy_end <= input_buffer.count + 1 then
								-- This was really a NULL character.
							yy_end := yy_bp + yy_matched_count
							yy_current_state := yy_previous_state
								-- We're now positioned to make the NULL
								-- transition. We couldn't have
								-- `yy_previous_state' go ahead and do it
								-- for us because it doesn't know how to deal
								-- with the possibility of jamming (and we
								-- don't want to build jamming into it because
								-- then it will run more slowly).
							yy_next_state := yy_null_trans_state (yy_current_state)
							yy_bp := yy_bp + yy_more_len
							if yy_next_state /= 0 then
									-- Consume the NULL character.
								yy_cp := yy_end + 1
								yy_end := yy_cp
								yy_current_state := yy_next_state
								yy_goto := yyMatch
							else
								if yyReject_or_variable_trail_context then
										-- Still need to initialize `yy_cp',
										-- though `yy_current_state' was set
										-- up by `yy_previous_state'.
									yy_cp := yy_end
										-- Remove the state which was inserted
										-- in `yy_state_stack' by the call to
										-- `yy_null_trans_state'.
									yy_state_count := yy_state_count - 1
								else
										-- Do the guaranteed-needed backing up
										-- then figure out the match.
									yy_cp := yy_last_accepting_cpos
									yy_current_state := yy_last_accepting_state
								end
								yy_goto := yyFind_action
							end
						else
								-- Do not take the EOB character
								-- into account.
							yy_end := yy_end - 1
							yy_refill_input_buffer
							if input_buffer.filled then
								yy_current_state := yy_previous_state
								yy_cp := yy_end
								yy_bp := yy_start + yy_more_len
								yy_goto := yyMatch
							elseif
								yy_end - yy_start - yy_more_len /= 0
							then
									-- Some text has been matched prior to
									-- the EOB. First process it.
								yy_current_state := yy_previous_state
								yy_cp := yy_end
								yy_bp := yy_start + yy_more_len
								yy_goto := yyFind_action
							else
									-- Only the EOB character has been matched, 
									-- so treat this as a final EOF.
								if wrap then
									yy_bp := yy_start
									yy_cp := yy_end
									yy_execute_eof_action ((yy_start_state - 1) // 2)
								end
							end
						end
					else
						yy_execute_action (yy_act)
						if yy_rejected then
							yy_rejected := False
							yy_line := yy_rejected_line
							yy_column := yy_rejected_column
							yy_position := yy_rejected_position
								-- Restore position backed-over text.
							yy_cp := yy_full_match
							if yyVariable_trail_context then
									-- Restore original accepting position.
								yy_lp := yy_full_lp
									-- Restore original state.
								yy_state_count := yy_full_state
									-- Restore current state.
								yy_current_state := yy_state_stack.item (yy_state_count - 1)
							end
							yy_lp := yy_lp + 1
							yy_goto := yyFind_rule
						end
					end
				end
			end
			debug ("GELEX")
				print_last_token
			end
		end

end
