// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package elbv2 provides a client for Elastic Load Balancing.
package elbv2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddTags = "AddTags"

// AddTagsRequest generates a "aws/request.Request" representing the
// client's request for the AddTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddTagsRequest method.
//    req, resp := client.AddTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) AddTagsRequest(input *AddTagsInput) (req *request.Request, output *AddTagsOutput) {
	op := &request.Operation{
		Name:       opAddTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddTagsOutput{}
	req.Data = output
	return
}

// AddTags API operation for Elastic Load Balancing.
//
// Adds the specified tags to the specified resource. You can tag your Application
// Load Balancers and your target groups.
//
// Each tag consists of a key and an optional value. If a resource already has
// a tag with the same key, AddTags updates its value.
//
// To list the current tags for your resources, use DescribeTags. To remove
// tags from your resources, use RemoveTags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation AddTags for usage and error information.
//
// Returned Error Codes:
//   * DuplicateTagKeys
//   A tag key was specified more than once.
//
//   * TooManyTags
//   You've reached the limit on the number of tags per load balancer.
//
//   * LoadBalancerNotFound
//   The specified load balancer does not exist.
//
//   * TargetGroupNotFound
//   The specified target group does not exist.
//
func (c *ELBV2) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	err := req.Send()
	return out, err
}

const opCreateListener = "CreateListener"

// CreateListenerRequest generates a "aws/request.Request" representing the
// client's request for the CreateListener operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateListener for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateListener method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateListenerRequest method.
//    req, resp := client.CreateListenerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) CreateListenerRequest(input *CreateListenerInput) (req *request.Request, output *CreateListenerOutput) {
	op := &request.Operation{
		Name:       opCreateListener,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateListenerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateListenerOutput{}
	req.Data = output
	return
}

// CreateListener API operation for Elastic Load Balancing.
//
// Creates a listener for the specified Application Load Balancer.
//
// You can create up to 10 listeners per load balancer.
//
// To update a listener, use ModifyListener. When you are finished with a listener,
// you can delete it using DeleteListener. If you are finished with both the
// listener and the load balancer, you can delete them both using DeleteLoadBalancer.
//
// For more information, see Listeners for Your Application Load Balancers (http://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html)
// in the Application Load Balancers Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation CreateListener for usage and error information.
//
// Returned Error Codes:
//   * DuplicateListener
//   A listener with the specified port already exists.
//
//   * TooManyListeners
//   You've reached the limit on the number of listeners per load balancer.
//
//   * TooManyCertificates
//   You've reached the limit on the number of certificates per listener.
//
//   * LoadBalancerNotFound
//   The specified load balancer does not exist.
//
//   * TargetGroupNotFound
//   The specified target group does not exist.
//
//   * TargetGroupAssociationLimit
//   You've reached the limit on the number of load balancers per target group.
//
//   * InvalidConfigurationRequest
//   The requested configuration is not valid.
//
//   * IncompatibleProtocols
//   The specified configuration is not valid with this protocol.
//
//   * SSLPolicyNotFound
//   The specified SSL policy does not exist.
//
//   * CertificateNotFound
//   The specified certificate does not exist.
//
//   * UnsupportedProtocol
//   The specified protocol is not supported.
//
//   * TooManyRegistrationsForTargetId
//   You've reached the limit on the number of times a target can be registered
//   with a load balancer.
//
func (c *ELBV2) CreateListener(input *CreateListenerInput) (*CreateListenerOutput, error) {
	req, out := c.CreateListenerRequest(input)
	err := req.Send()
	return out, err
}

const opCreateLoadBalancer = "CreateLoadBalancer"

// CreateLoadBalancerRequest generates a "aws/request.Request" representing the
// client's request for the CreateLoadBalancer operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateLoadBalancer for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateLoadBalancer method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateLoadBalancerRequest method.
//    req, resp := client.CreateLoadBalancerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) CreateLoadBalancerRequest(input *CreateLoadBalancerInput) (req *request.Request, output *CreateLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opCreateLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLoadBalancerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateLoadBalancerOutput{}
	req.Data = output
	return
}

// CreateLoadBalancer API operation for Elastic Load Balancing.
//
// Creates an Application Load Balancer.
//
// To create listeners for your load balancer, use CreateListener. You can add
// security groups, subnets, and tags when you create your load balancer, or
// you can add them later using SetSecurityGroups, SetSubnets, and AddTags.
//
// To describe your current load balancers, see DescribeLoadBalancers. When
// you are finished with a load balancer, you can delete it using DeleteLoadBalancer.
//
// You can create up to 20 load balancers per region per account. You can request
// an increase for the number of load balancers for your account. For more information,
// see Limits for Your Application Load Balancer (http://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html)
// in the Application Load Balancers Guide.
//
// For more information, see Application Load Balancers (http://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html)
// in the Application Load Balancers Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation CreateLoadBalancer for usage and error information.
//
// Returned Error Codes:
//   * DuplicateLoadBalancerName
//   A load balancer with the specified name already exists for this account.
//
//   * TooManyLoadBalancers
//   You've reached the limit on the number of load balancers for your AWS account.
//
//   * InvalidConfigurationRequest
//   The requested configuration is not valid.
//
//   * SubnetNotFound
//   The specified subnet does not exist.
//
//   * InvalidSubnet
//   The specified subnet is out of available addresses.
//
//   * InvalidSecurityGroup
//   The specified security group does not exist.
//
//   * InvalidScheme
//   The requested scheme is not valid.
//
//   * TooManyTags
//   You've reached the limit on the number of tags per load balancer.
//
//   * DuplicateTagKeys
//   A tag key was specified more than once.
//
func (c *ELBV2) CreateLoadBalancer(input *CreateLoadBalancerInput) (*CreateLoadBalancerOutput, error) {
	req, out := c.CreateLoadBalancerRequest(input)
	err := req.Send()
	return out, err
}

const opCreateRule = "CreateRule"

// CreateRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateRuleRequest method.
//    req, resp := client.CreateRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) CreateRuleRequest(input *CreateRuleInput) (req *request.Request, output *CreateRuleOutput) {
	op := &request.Operation{
		Name:       opCreateRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRuleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateRuleOutput{}
	req.Data = output
	return
}

// CreateRule API operation for Elastic Load Balancing.
//
// Creates a rule for the specified listener.
//
// Each rule can have one action and one condition. Rules are evaluated in priority
// order, from the lowest value to the highest value. When the condition for
// a rule is met, the specified action is taken. If no conditions are met, the
// default action for the default rule is taken. For more information, see Listener
// Rules (http://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#listener-rules)
// in the Application Load Balancers Guide.
//
// To view your current rules, use DescribeRules. To update a rule, use ModifyRule.
// To set the priorities of your rules, use SetRulePriorities. To delete a rule,
// use DeleteRule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation CreateRule for usage and error information.
//
// Returned Error Codes:
//   * PriorityInUse
//   The specified priority is in use.
//
//   * TooManyTargetGroups
//   You've reached the limit on the number of target groups for your AWS account.
//
//   * TooManyRules
//   You've reached the limit on the number of rules per load balancer.
//
//   * TargetGroupAssociationLimit
//   You've reached the limit on the number of load balancers per target group.
//
//   * ListenerNotFound
//   The specified listener does not exist.
//
//   * TargetGroupNotFound
//   The specified target group does not exist.
//
//   * InvalidConfigurationRequest
//   The requested configuration is not valid.
//
//   * TooManyRegistrationsForTargetId
//   You've reached the limit on the number of times a target can be registered
//   with a load balancer.
//
func (c *ELBV2) CreateRule(input *CreateRuleInput) (*CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	err := req.Send()
	return out, err
}

const opCreateTargetGroup = "CreateTargetGroup"

// CreateTargetGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateTargetGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateTargetGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateTargetGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateTargetGroupRequest method.
//    req, resp := client.CreateTargetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) CreateTargetGroupRequest(input *CreateTargetGroupInput) (req *request.Request, output *CreateTargetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateTargetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTargetGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateTargetGroupOutput{}
	req.Data = output
	return
}

// CreateTargetGroup API operation for Elastic Load Balancing.
//
// Creates a target group.
//
// To register targets with the target group, use RegisterTargets. To update
// the health check settings for the target group, use ModifyTargetGroup. To
// monitor the health of targets in the target group, use DescribeTargetHealth.
//
// To route traffic to the targets in a target group, specify the target group
// in an action using CreateListener or CreateRule.
//
// To delete a target group, use DeleteTargetGroup.
//
// For more information, see Target Groups for Your Application Load Balancers
// (http://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html)
// in the Application Load Balancers Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation CreateTargetGroup for usage and error information.
//
// Returned Error Codes:
//   * DuplicateTargetGroupName
//   A target group with the specified name already exists.
//
//   * TooManyTargetGroups
//   You've reached the limit on the number of target groups for your AWS account.
//
func (c *ELBV2) CreateTargetGroup(input *CreateTargetGroupInput) (*CreateTargetGroupOutput, error) {
	req, out := c.CreateTargetGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteListener = "DeleteListener"

// DeleteListenerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteListener operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteListener for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteListener method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteListenerRequest method.
//    req, resp := client.DeleteListenerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) DeleteListenerRequest(input *DeleteListenerInput) (req *request.Request, output *DeleteListenerOutput) {
	op := &request.Operation{
		Name:       opDeleteListener,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteListenerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteListenerOutput{}
	req.Data = output
	return
}

// DeleteListener API operation for Elastic Load Balancing.
//
// Deletes the specified listener.
//
// Alternatively, your listener is deleted when you delete the load balancer
// it is attached to using DeleteLoadBalancer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation DeleteListener for usage and error information.
//
// Returned Error Codes:
//   * ListenerNotFound
//   The specified listener does not exist.
//
func (c *ELBV2) DeleteListener(input *DeleteListenerInput) (*DeleteListenerOutput, error) {
	req, out := c.DeleteListenerRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteLoadBalancer = "DeleteLoadBalancer"

// DeleteLoadBalancerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLoadBalancer operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteLoadBalancer for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteLoadBalancer method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteLoadBalancerRequest method.
//    req, resp := client.DeleteLoadBalancerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) DeleteLoadBalancerRequest(input *DeleteLoadBalancerInput) (req *request.Request, output *DeleteLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opDeleteLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLoadBalancerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteLoadBalancerOutput{}
	req.Data = output
	return
}

// DeleteLoadBalancer API operation for Elastic Load Balancing.
//
// Deletes the specified Application Load Balancer and its attached listeners.
//
// You can't delete a load balancer if deletion protection is enabled. If the
// load balancer does not exist or has already been deleted, the call succeeds.
//
// Deleting a load balancer does not affect its registered targets. For example,
// your EC2 instances continue to run and are still registered to their target
// groups. If you no longer need these EC2 instances, you can stop or terminate
// them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation DeleteLoadBalancer for usage and error information.
//
// Returned Error Codes:
//   * LoadBalancerNotFound
//   The specified load balancer does not exist.
//
//   * OperationNotPermitted
//   This operation is not allowed.
//
func (c *ELBV2) DeleteLoadBalancer(input *DeleteLoadBalancerInput) (*DeleteLoadBalancerOutput, error) {
	req, out := c.DeleteLoadBalancerRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRule = "DeleteRule"

// DeleteRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteRuleRequest method.
//    req, resp := client.DeleteRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) DeleteRuleRequest(input *DeleteRuleInput) (req *request.Request, output *DeleteRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRuleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteRuleOutput{}
	req.Data = output
	return
}

// DeleteRule API operation for Elastic Load Balancing.
//
// Deletes the specified rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation DeleteRule for usage and error information.
//
// Returned Error Codes:
//   * RuleNotFound
//   The specified rule does not exist.
//
//   * OperationNotPermitted
//   This operation is not allowed.
//
func (c *ELBV2) DeleteRule(input *DeleteRuleInput) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTargetGroup = "DeleteTargetGroup"

// DeleteTargetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTargetGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteTargetGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteTargetGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteTargetGroupRequest method.
//    req, resp := client.DeleteTargetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) DeleteTargetGroupRequest(input *DeleteTargetGroupInput) (req *request.Request, output *DeleteTargetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteTargetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTargetGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteTargetGroupOutput{}
	req.Data = output
	return
}

// DeleteTargetGroup API operation for Elastic Load Balancing.
//
// Deletes the specified target group.
//
// You can delete a target group if it is not referenced by any actions. Deleting
// a target group also deletes any associated health checks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation DeleteTargetGroup for usage and error information.
//
// Returned Error Codes:
//   * ResourceInUse
//   A specified resource is in use.
//
func (c *ELBV2) DeleteTargetGroup(input *DeleteTargetGroupInput) (*DeleteTargetGroupOutput, error) {
	req, out := c.DeleteTargetGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeregisterTargets = "DeregisterTargets"

// DeregisterTargetsRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterTargets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeregisterTargets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeregisterTargets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeregisterTargetsRequest method.
//    req, resp := client.DeregisterTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) DeregisterTargetsRequest(input *DeregisterTargetsInput) (req *request.Request, output *DeregisterTargetsOutput) {
	op := &request.Operation{
		Name:       opDeregisterTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterTargetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeregisterTargetsOutput{}
	req.Data = output
	return
}

// DeregisterTargets API operation for Elastic Load Balancing.
//
// Deregisters the specified targets from the specified target group. After
// the targets are deregistered, they no longer receive traffic from the load
// balancer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation DeregisterTargets for usage and error information.
//
// Returned Error Codes:
//   * TargetGroupNotFound
//   The specified target group does not exist.
//
//   * InvalidTarget
//   The specified target does not exist or is not in the same VPC as the target
//   group.
//
func (c *ELBV2) DeregisterTargets(input *DeregisterTargetsInput) (*DeregisterTargetsOutput, error) {
	req, out := c.DeregisterTargetsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeListeners = "DescribeListeners"

// DescribeListenersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeListeners operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeListeners for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeListeners method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeListenersRequest method.
//    req, resp := client.DescribeListenersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) DescribeListenersRequest(input *DescribeListenersInput) (req *request.Request, output *DescribeListenersOutput) {
	op := &request.Operation{
		Name:       opDescribeListeners,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeListenersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeListenersOutput{}
	req.Data = output
	return
}

// DescribeListeners API operation for Elastic Load Balancing.
//
// Describes the specified listeners or the listeners for the specified Application
// Load Balancer. You must specify either a load balancer or one or more listeners.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation DescribeListeners for usage and error information.
//
// Returned Error Codes:
//   * ListenerNotFound
//   The specified listener does not exist.
//
//   * LoadBalancerNotFound
//   The specified load balancer does not exist.
//
func (c *ELBV2) DescribeListeners(input *DescribeListenersInput) (*DescribeListenersOutput, error) {
	req, out := c.DescribeListenersRequest(input)
	err := req.Send()
	return out, err
}

// DescribeListenersPages iterates over the pages of a DescribeListeners operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeListeners method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeListeners operation.
//    pageNum := 0
//    err := client.DescribeListenersPages(params,
//        func(page *DescribeListenersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ELBV2) DescribeListenersPages(input *DescribeListenersInput, fn func(p *DescribeListenersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeListenersRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeListenersOutput), lastPage)
	})
}

const opDescribeLoadBalancerAttributes = "DescribeLoadBalancerAttributes"

// DescribeLoadBalancerAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLoadBalancerAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeLoadBalancerAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeLoadBalancerAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeLoadBalancerAttributesRequest method.
//    req, resp := client.DescribeLoadBalancerAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) DescribeLoadBalancerAttributesRequest(input *DescribeLoadBalancerAttributesInput) (req *request.Request, output *DescribeLoadBalancerAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeLoadBalancerAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoadBalancerAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLoadBalancerAttributesOutput{}
	req.Data = output
	return
}

// DescribeLoadBalancerAttributes API operation for Elastic Load Balancing.
//
// Describes the attributes for the specified Application Load Balancer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation DescribeLoadBalancerAttributes for usage and error information.
//
// Returned Error Codes:
//   * LoadBalancerNotFound
//   The specified load balancer does not exist.
//
func (c *ELBV2) DescribeLoadBalancerAttributes(input *DescribeLoadBalancerAttributesInput) (*DescribeLoadBalancerAttributesOutput, error) {
	req, out := c.DescribeLoadBalancerAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeLoadBalancers = "DescribeLoadBalancers"

// DescribeLoadBalancersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLoadBalancers operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeLoadBalancers for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeLoadBalancers method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeLoadBalancersRequest method.
//    req, resp := client.DescribeLoadBalancersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) DescribeLoadBalancersRequest(input *DescribeLoadBalancersInput) (req *request.Request, output *DescribeLoadBalancersOutput) {
	op := &request.Operation{
		Name:       opDescribeLoadBalancers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeLoadBalancersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLoadBalancersOutput{}
	req.Data = output
	return
}

// DescribeLoadBalancers API operation for Elastic Load Balancing.
//
// Describes the specified Application Load Balancers or all of your Application
// Load Balancers.
//
// To describe the listeners for a load balancer, use DescribeListeners. To
// describe the attributes for a load balancer, use DescribeLoadBalancerAttributes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation DescribeLoadBalancers for usage and error information.
//
// Returned Error Codes:
//   * LoadBalancerNotFound
//   The specified load balancer does not exist.
//
func (c *ELBV2) DescribeLoadBalancers(input *DescribeLoadBalancersInput) (*DescribeLoadBalancersOutput, error) {
	req, out := c.DescribeLoadBalancersRequest(input)
	err := req.Send()
	return out, err
}

// DescribeLoadBalancersPages iterates over the pages of a DescribeLoadBalancers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeLoadBalancers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeLoadBalancers operation.
//    pageNum := 0
//    err := client.DescribeLoadBalancersPages(params,
//        func(page *DescribeLoadBalancersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ELBV2) DescribeLoadBalancersPages(input *DescribeLoadBalancersInput, fn func(p *DescribeLoadBalancersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeLoadBalancersRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeLoadBalancersOutput), lastPage)
	})
}

const opDescribeRules = "DescribeRules"

// DescribeRulesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRules operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeRules for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeRules method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeRulesRequest method.
//    req, resp := client.DescribeRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) DescribeRulesRequest(input *DescribeRulesInput) (req *request.Request, output *DescribeRulesOutput) {
	op := &request.Operation{
		Name:       opDescribeRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRulesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeRulesOutput{}
	req.Data = output
	return
}

// DescribeRules API operation for Elastic Load Balancing.
//
// Describes the specified rules or the rules for the specified listener. You
// must specify either a listener or one or more rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation DescribeRules for usage and error information.
//
// Returned Error Codes:
//   * ListenerNotFound
//   The specified listener does not exist.
//
//   * RuleNotFound
//   The specified rule does not exist.
//
func (c *ELBV2) DescribeRules(input *DescribeRulesInput) (*DescribeRulesOutput, error) {
	req, out := c.DescribeRulesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSSLPolicies = "DescribeSSLPolicies"

// DescribeSSLPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSSLPolicies operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSSLPolicies for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSSLPolicies method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSSLPoliciesRequest method.
//    req, resp := client.DescribeSSLPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) DescribeSSLPoliciesRequest(input *DescribeSSLPoliciesInput) (req *request.Request, output *DescribeSSLPoliciesOutput) {
	op := &request.Operation{
		Name:       opDescribeSSLPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSSLPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSSLPoliciesOutput{}
	req.Data = output
	return
}

// DescribeSSLPolicies API operation for Elastic Load Balancing.
//
// Describes the specified policies or all policies used for SSL negotiation.
//
// Note that the only supported policy at this time is ELBSecurityPolicy-2015-05.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation DescribeSSLPolicies for usage and error information.
//
// Returned Error Codes:
//   * SSLPolicyNotFound
//   The specified SSL policy does not exist.
//
func (c *ELBV2) DescribeSSLPolicies(input *DescribeSSLPoliciesInput) (*DescribeSSLPoliciesOutput, error) {
	req, out := c.DescribeSSLPoliciesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTagsRequest method.
//    req, resp := client.DescribeTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTagsOutput{}
	req.Data = output
	return
}

// DescribeTags API operation for Elastic Load Balancing.
//
// Describes the tags for the specified resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation DescribeTags for usage and error information.
//
// Returned Error Codes:
//   * LoadBalancerNotFound
//   The specified load balancer does not exist.
//
//   * TargetGroupNotFound
//   The specified target group does not exist.
//
//   * ListenerNotFound
//   The specified listener does not exist.
//
//   * RuleNotFound
//   The specified rule does not exist.
//
func (c *ELBV2) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTargetGroupAttributes = "DescribeTargetGroupAttributes"

// DescribeTargetGroupAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTargetGroupAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTargetGroupAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTargetGroupAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTargetGroupAttributesRequest method.
//    req, resp := client.DescribeTargetGroupAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) DescribeTargetGroupAttributesRequest(input *DescribeTargetGroupAttributesInput) (req *request.Request, output *DescribeTargetGroupAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeTargetGroupAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTargetGroupAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTargetGroupAttributesOutput{}
	req.Data = output
	return
}

// DescribeTargetGroupAttributes API operation for Elastic Load Balancing.
//
// Describes the attributes for the specified target group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation DescribeTargetGroupAttributes for usage and error information.
//
// Returned Error Codes:
//   * TargetGroupNotFound
//   The specified target group does not exist.
//
func (c *ELBV2) DescribeTargetGroupAttributes(input *DescribeTargetGroupAttributesInput) (*DescribeTargetGroupAttributesOutput, error) {
	req, out := c.DescribeTargetGroupAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTargetGroups = "DescribeTargetGroups"

// DescribeTargetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTargetGroups operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTargetGroups for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTargetGroups method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTargetGroupsRequest method.
//    req, resp := client.DescribeTargetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) DescribeTargetGroupsRequest(input *DescribeTargetGroupsInput) (req *request.Request, output *DescribeTargetGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeTargetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTargetGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTargetGroupsOutput{}
	req.Data = output
	return
}

// DescribeTargetGroups API operation for Elastic Load Balancing.
//
// Describes the specified target groups or all of your target groups. By default,
// all target groups are described. Alternatively, you can specify one of the
// following to filter the results: the ARN of the load balancer, the names
// of one or more target groups, or the ARNs of one or more target groups.
//
// To describe the targets for a target group, use DescribeTargetHealth. To
// describe the attributes of a target group, use DescribeTargetGroupAttributes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation DescribeTargetGroups for usage and error information.
//
// Returned Error Codes:
//   * LoadBalancerNotFound
//   The specified load balancer does not exist.
//
//   * TargetGroupNotFound
//   The specified target group does not exist.
//
func (c *ELBV2) DescribeTargetGroups(input *DescribeTargetGroupsInput) (*DescribeTargetGroupsOutput, error) {
	req, out := c.DescribeTargetGroupsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeTargetGroupsPages iterates over the pages of a DescribeTargetGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeTargetGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeTargetGroups operation.
//    pageNum := 0
//    err := client.DescribeTargetGroupsPages(params,
//        func(page *DescribeTargetGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ELBV2) DescribeTargetGroupsPages(input *DescribeTargetGroupsInput, fn func(p *DescribeTargetGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeTargetGroupsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeTargetGroupsOutput), lastPage)
	})
}

const opDescribeTargetHealth = "DescribeTargetHealth"

// DescribeTargetHealthRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTargetHealth operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTargetHealth for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTargetHealth method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTargetHealthRequest method.
//    req, resp := client.DescribeTargetHealthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) DescribeTargetHealthRequest(input *DescribeTargetHealthInput) (req *request.Request, output *DescribeTargetHealthOutput) {
	op := &request.Operation{
		Name:       opDescribeTargetHealth,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTargetHealthInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTargetHealthOutput{}
	req.Data = output
	return
}

// DescribeTargetHealth API operation for Elastic Load Balancing.
//
// Describes the health of the specified targets or all of your targets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation DescribeTargetHealth for usage and error information.
//
// Returned Error Codes:
//   * InvalidTarget
//   The specified target does not exist or is not in the same VPC as the target
//   group.
//
//   * TargetGroupNotFound
//   The specified target group does not exist.
//
//   * HealthUnavailable
//   The health of the specified targets could not be retrieved due to an internal
//   error.
//
func (c *ELBV2) DescribeTargetHealth(input *DescribeTargetHealthInput) (*DescribeTargetHealthOutput, error) {
	req, out := c.DescribeTargetHealthRequest(input)
	err := req.Send()
	return out, err
}

const opModifyListener = "ModifyListener"

// ModifyListenerRequest generates a "aws/request.Request" representing the
// client's request for the ModifyListener operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyListener for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyListener method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyListenerRequest method.
//    req, resp := client.ModifyListenerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) ModifyListenerRequest(input *ModifyListenerInput) (req *request.Request, output *ModifyListenerOutput) {
	op := &request.Operation{
		Name:       opModifyListener,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyListenerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyListenerOutput{}
	req.Data = output
	return
}

// ModifyListener API operation for Elastic Load Balancing.
//
// Modifies the specified properties of the specified listener.
//
// Any properties that you do not specify retain their current values. However,
// changing the protocol from HTTPS to HTTP removes the security policy and
// SSL certificate properties. If you change the protocol from HTTP to HTTPS,
// you must add the security policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation ModifyListener for usage and error information.
//
// Returned Error Codes:
//   * DuplicateListener
//   A listener with the specified port already exists.
//
//   * TooManyListeners
//   You've reached the limit on the number of listeners per load balancer.
//
//   * TooManyCertificates
//   You've reached the limit on the number of certificates per listener.
//
//   * ListenerNotFound
//   The specified listener does not exist.
//
//   * TargetGroupNotFound
//   The specified target group does not exist.
//
//   * TargetGroupAssociationLimit
//   You've reached the limit on the number of load balancers per target group.
//
//   * IncompatibleProtocols
//   The specified configuration is not valid with this protocol.
//
//   * SSLPolicyNotFound
//   The specified SSL policy does not exist.
//
//   * CertificateNotFound
//   The specified certificate does not exist.
//
//   * InvalidConfigurationRequest
//   The requested configuration is not valid.
//
//   * UnsupportedProtocol
//   The specified protocol is not supported.
//
//   * TooManyRegistrationsForTargetId
//   You've reached the limit on the number of times a target can be registered
//   with a load balancer.
//
func (c *ELBV2) ModifyListener(input *ModifyListenerInput) (*ModifyListenerOutput, error) {
	req, out := c.ModifyListenerRequest(input)
	err := req.Send()
	return out, err
}

const opModifyLoadBalancerAttributes = "ModifyLoadBalancerAttributes"

// ModifyLoadBalancerAttributesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyLoadBalancerAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyLoadBalancerAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyLoadBalancerAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyLoadBalancerAttributesRequest method.
//    req, resp := client.ModifyLoadBalancerAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) ModifyLoadBalancerAttributesRequest(input *ModifyLoadBalancerAttributesInput) (req *request.Request, output *ModifyLoadBalancerAttributesOutput) {
	op := &request.Operation{
		Name:       opModifyLoadBalancerAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyLoadBalancerAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyLoadBalancerAttributesOutput{}
	req.Data = output
	return
}

// ModifyLoadBalancerAttributes API operation for Elastic Load Balancing.
//
// Modifies the specified attributes of the specified Application Load Balancer.
//
// If any of the specified attributes can't be modified as requested, the call
// fails. Any existing attributes that you do not modify retain their current
// values.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation ModifyLoadBalancerAttributes for usage and error information.
//
// Returned Error Codes:
//   * LoadBalancerNotFound
//   The specified load balancer does not exist.
//
//   * InvalidConfigurationRequest
//   The requested configuration is not valid.
//
func (c *ELBV2) ModifyLoadBalancerAttributes(input *ModifyLoadBalancerAttributesInput) (*ModifyLoadBalancerAttributesOutput, error) {
	req, out := c.ModifyLoadBalancerAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opModifyRule = "ModifyRule"

// ModifyRuleRequest generates a "aws/request.Request" representing the
// client's request for the ModifyRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyRuleRequest method.
//    req, resp := client.ModifyRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) ModifyRuleRequest(input *ModifyRuleInput) (req *request.Request, output *ModifyRuleOutput) {
	op := &request.Operation{
		Name:       opModifyRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyRuleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyRuleOutput{}
	req.Data = output
	return
}

// ModifyRule API operation for Elastic Load Balancing.
//
// Modifies the specified rule.
//
// Any existing properties that you do not modify retain their current values.
//
// To modify the default action, use ModifyListener.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation ModifyRule for usage and error information.
//
// Returned Error Codes:
//   * TargetGroupAssociationLimit
//   You've reached the limit on the number of load balancers per target group.
//
//   * RuleNotFound
//   The specified rule does not exist.
//
//   * OperationNotPermitted
//   This operation is not allowed.
//
//   * TooManyRegistrationsForTargetId
//   You've reached the limit on the number of times a target can be registered
//   with a load balancer.
//
func (c *ELBV2) ModifyRule(input *ModifyRuleInput) (*ModifyRuleOutput, error) {
	req, out := c.ModifyRuleRequest(input)
	err := req.Send()
	return out, err
}

const opModifyTargetGroup = "ModifyTargetGroup"

// ModifyTargetGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyTargetGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyTargetGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyTargetGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyTargetGroupRequest method.
//    req, resp := client.ModifyTargetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) ModifyTargetGroupRequest(input *ModifyTargetGroupInput) (req *request.Request, output *ModifyTargetGroupOutput) {
	op := &request.Operation{
		Name:       opModifyTargetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyTargetGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyTargetGroupOutput{}
	req.Data = output
	return
}

// ModifyTargetGroup API operation for Elastic Load Balancing.
//
// Modifies the health checks used when evaluating the health state of the targets
// in the specified target group.
//
// To monitor the health of the targets, use DescribeTargetHealth.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation ModifyTargetGroup for usage and error information.
//
// Returned Error Codes:
//   * TargetGroupNotFound
//   The specified target group does not exist.
//
func (c *ELBV2) ModifyTargetGroup(input *ModifyTargetGroupInput) (*ModifyTargetGroupOutput, error) {
	req, out := c.ModifyTargetGroupRequest(input)
	err := req.Send()
	return out, err
}

const opModifyTargetGroupAttributes = "ModifyTargetGroupAttributes"

// ModifyTargetGroupAttributesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyTargetGroupAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyTargetGroupAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyTargetGroupAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyTargetGroupAttributesRequest method.
//    req, resp := client.ModifyTargetGroupAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) ModifyTargetGroupAttributesRequest(input *ModifyTargetGroupAttributesInput) (req *request.Request, output *ModifyTargetGroupAttributesOutput) {
	op := &request.Operation{
		Name:       opModifyTargetGroupAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyTargetGroupAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyTargetGroupAttributesOutput{}
	req.Data = output
	return
}

// ModifyTargetGroupAttributes API operation for Elastic Load Balancing.
//
// Modifies the specified attributes of the specified target group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation ModifyTargetGroupAttributes for usage and error information.
//
// Returned Error Codes:
//   * TargetGroupNotFound
//   The specified target group does not exist.
//
func (c *ELBV2) ModifyTargetGroupAttributes(input *ModifyTargetGroupAttributesInput) (*ModifyTargetGroupAttributesOutput, error) {
	req, out := c.ModifyTargetGroupAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterTargets = "RegisterTargets"

// RegisterTargetsRequest generates a "aws/request.Request" representing the
// client's request for the RegisterTargets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RegisterTargets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RegisterTargets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RegisterTargetsRequest method.
//    req, resp := client.RegisterTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) RegisterTargetsRequest(input *RegisterTargetsInput) (req *request.Request, output *RegisterTargetsOutput) {
	op := &request.Operation{
		Name:       opRegisterTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterTargetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RegisterTargetsOutput{}
	req.Data = output
	return
}

// RegisterTargets API operation for Elastic Load Balancing.
//
// Registers the specified targets with the specified target group.
//
// By default, the load balancer routes requests to registered targets using
// the protocol and port number for the target group. Alternatively, you can
// override the port for a target when you register it.
//
// The target must be in the virtual private cloud (VPC) that you specified
// for the target group. If the target is an EC2 instance, it can't be in the
// stopped or running state when you register it.
//
// To remove a target from a target group, use DeregisterTargets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation RegisterTargets for usage and error information.
//
// Returned Error Codes:
//   * TargetGroupNotFound
//   The specified target group does not exist.
//
//   * TooManyTargets
//   You've reached the limit on the number of targets.
//
//   * InvalidTarget
//   The specified target does not exist or is not in the same VPC as the target
//   group.
//
//   * TooManyRegistrationsForTargetId
//   You've reached the limit on the number of times a target can be registered
//   with a load balancer.
//
func (c *ELBV2) RegisterTargets(input *RegisterTargetsInput) (*RegisterTargetsOutput, error) {
	req, out := c.RegisterTargetsRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveTags = "RemoveTags"

// RemoveTagsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveTagsRequest method.
//    req, resp := client.RemoveTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) RemoveTagsRequest(input *RemoveTagsInput) (req *request.Request, output *RemoveTagsOutput) {
	op := &request.Operation{
		Name:       opRemoveTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RemoveTagsOutput{}
	req.Data = output
	return
}

// RemoveTags API operation for Elastic Load Balancing.
//
// Removes the specified tags from the specified resource.
//
// To list the current tags for your resources, use DescribeTags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation RemoveTags for usage and error information.
//
// Returned Error Codes:
//   * LoadBalancerNotFound
//   The specified load balancer does not exist.
//
//   * TargetGroupNotFound
//   The specified target group does not exist.
//
//   * ListenerNotFound
//   The specified listener does not exist.
//
//   * RuleNotFound
//   The specified rule does not exist.
//
//   * TooManyTags
//   You've reached the limit on the number of tags per load balancer.
//
func (c *ELBV2) RemoveTags(input *RemoveTagsInput) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	err := req.Send()
	return out, err
}

const opSetRulePriorities = "SetRulePriorities"

// SetRulePrioritiesRequest generates a "aws/request.Request" representing the
// client's request for the SetRulePriorities operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetRulePriorities for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetRulePriorities method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetRulePrioritiesRequest method.
//    req, resp := client.SetRulePrioritiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) SetRulePrioritiesRequest(input *SetRulePrioritiesInput) (req *request.Request, output *SetRulePrioritiesOutput) {
	op := &request.Operation{
		Name:       opSetRulePriorities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetRulePrioritiesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetRulePrioritiesOutput{}
	req.Data = output
	return
}

// SetRulePriorities API operation for Elastic Load Balancing.
//
// Sets the priorities of the specified rules.
//
// You can reorder the rules as long as there are no priority conflicts in the
// new order. Any existing rules that you do not specify retain their current
// priority.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation SetRulePriorities for usage and error information.
//
// Returned Error Codes:
//   * RuleNotFound
//   The specified rule does not exist.
//
//   * PriorityInUse
//   The specified priority is in use.
//
//   * OperationNotPermitted
//   This operation is not allowed.
//
func (c *ELBV2) SetRulePriorities(input *SetRulePrioritiesInput) (*SetRulePrioritiesOutput, error) {
	req, out := c.SetRulePrioritiesRequest(input)
	err := req.Send()
	return out, err
}

const opSetSecurityGroups = "SetSecurityGroups"

// SetSecurityGroupsRequest generates a "aws/request.Request" representing the
// client's request for the SetSecurityGroups operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetSecurityGroups for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetSecurityGroups method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetSecurityGroupsRequest method.
//    req, resp := client.SetSecurityGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) SetSecurityGroupsRequest(input *SetSecurityGroupsInput) (req *request.Request, output *SetSecurityGroupsOutput) {
	op := &request.Operation{
		Name:       opSetSecurityGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetSecurityGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetSecurityGroupsOutput{}
	req.Data = output
	return
}

// SetSecurityGroups API operation for Elastic Load Balancing.
//
// Associates the specified security groups with the specified load balancer.
// The specified security groups override the previously associated security
// groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation SetSecurityGroups for usage and error information.
//
// Returned Error Codes:
//   * LoadBalancerNotFound
//   The specified load balancer does not exist.
//
//   * InvalidConfigurationRequest
//   The requested configuration is not valid.
//
//   * InvalidSecurityGroup
//   The specified security group does not exist.
//
func (c *ELBV2) SetSecurityGroups(input *SetSecurityGroupsInput) (*SetSecurityGroupsOutput, error) {
	req, out := c.SetSecurityGroupsRequest(input)
	err := req.Send()
	return out, err
}

const opSetSubnets = "SetSubnets"

// SetSubnetsRequest generates a "aws/request.Request" representing the
// client's request for the SetSubnets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetSubnets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetSubnets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetSubnetsRequest method.
//    req, resp := client.SetSubnetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ELBV2) SetSubnetsRequest(input *SetSubnetsInput) (req *request.Request, output *SetSubnetsOutput) {
	op := &request.Operation{
		Name:       opSetSubnets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetSubnetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetSubnetsOutput{}
	req.Data = output
	return
}

// SetSubnets API operation for Elastic Load Balancing.
//
// Enables the Availability Zone for the specified subnets for the specified
// load balancer. The specified subnets replace the previously enabled subnets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Elastic Load Balancing's
// API operation SetSubnets for usage and error information.
//
// Returned Error Codes:
//   * LoadBalancerNotFound
//   The specified load balancer does not exist.
//
//   * InvalidConfigurationRequest
//   The requested configuration is not valid.
//
//   * SubnetNotFound
//   The specified subnet does not exist.
//
//   * InvalidSubnet
//   The specified subnet is out of available addresses.
//
func (c *ELBV2) SetSubnets(input *SetSubnetsInput) (*SetSubnetsOutput, error) {
	req, out := c.SetSubnetsRequest(input)
	err := req.Send()
	return out, err
}

// Information about an action.
type Action struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group.
	//
	// TargetGroupArn is a required field
	TargetGroupArn *string `type:"string" required:"true"`

	// The type of action.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ActionTypeEnum"`
}

// String returns the string representation
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Action) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Action) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Action"}
	if s.TargetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroupArn"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the parameters for AddTags.
type AddTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArns is a required field
	ResourceArns []*string `type:"list" required:"true"`

	// The tags. Each resource can have a maximum of 10 tags.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsInput"}
	if s.ResourceArns == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArns"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of AddTags.
type AddTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsOutput) GoString() string {
	return s.String()
}

// Information about an Availability Zone.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The ID of the subnet.
	SubnetId *string `type:"string"`

	// The name of the Availability Zone.
	ZoneName *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// Information about an SSL server certificate deployed on a load balancer.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificate.
	CertificateArn *string `type:"string"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Certificate) GoString() string {
	return s.String()
}

// Information about a cipher used in a policy.
type Cipher struct {
	_ struct{} `type:"structure"`

	// The name of the cipher.
	Name *string `type:"string"`

	// The priority of the cipher.
	Priority *int64 `type:"integer"`
}

// String returns the string representation
func (s Cipher) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Cipher) GoString() string {
	return s.String()
}

// Contains the parameters for CreateListener.
type CreateListenerInput struct {
	_ struct{} `type:"structure"`

	// The SSL server certificate. You must provide exactly one certificate if the
	// protocol is HTTPS.
	Certificates []*Certificate `type:"list"`

	// The default action for the listener.
	//
	// DefaultActions is a required field
	DefaultActions []*Action `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the load balancer.
	//
	// LoadBalancerArn is a required field
	LoadBalancerArn *string `type:"string" required:"true"`

	// The port on which the load balancer is listening.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`

	// The protocol for connections from clients to the load balancer.
	//
	// Protocol is a required field
	Protocol *string `type:"string" required:"true" enum:"ProtocolEnum"`

	// The security policy that defines which ciphers and protocols are supported.
	// The default is the current predefined security policy.
	SslPolicy *string `type:"string"`
}

// String returns the string representation
func (s CreateListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateListenerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateListenerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateListenerInput"}
	if s.DefaultActions == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultActions"))
	}
	if s.LoadBalancerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerArn"))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.DefaultActions != nil {
		for i, v := range s.DefaultActions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DefaultActions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of CreateListener.
type CreateListenerOutput struct {
	_ struct{} `type:"structure"`

	// Information about the listener.
	Listeners []*Listener `type:"list"`
}

// String returns the string representation
func (s CreateListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateListenerOutput) GoString() string {
	return s.String()
}

// Contains the parameters for CreateLoadBalancer.
type CreateLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	//
	// This name must be unique within your AWS account, can have a maximum of 32
	// characters, must contain only alphanumeric characters or hyphens, and must
	// not begin or end with a hyphen.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The nodes of an Internet-facing load balancer have public IP addresses. The
	// DNS name of an Internet-facing load balancer is publicly resolvable to the
	// public IP addresses of the nodes. Therefore, Internet-facing load balancers
	// can route requests from clients over the Internet.
	//
	// The nodes of an internal load balancer have only private IP addresses. The
	// DNS name of an internal load balancer is publicly resolvable to the private
	// IP addresses of the nodes. Therefore, internal load balancers can only route
	// requests from clients with access to the VPC for the load balancer.
	//
	// The default is an Internet-facing load balancer.
	Scheme *string `type:"string" enum:"LoadBalancerSchemeEnum"`

	// The IDs of the security groups to assign to the load balancer.
	SecurityGroups []*string `type:"list"`

	// The IDs of the subnets to attach to the load balancer. You can specify only
	// one subnet per Availability Zone. You must specify subnets from at least
	// two Availability Zones.
	//
	// Subnets is a required field
	Subnets []*string `type:"list" required:"true"`

	// One or more tags to assign to the load balancer.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoadBalancerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLoadBalancerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLoadBalancerInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Subnets == nil {
		invalidParams.Add(request.NewErrParamRequired("Subnets"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of CreateLoadBalancer.
type CreateLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// Information about the load balancer.
	LoadBalancers []*LoadBalancer `type:"list"`
}

// String returns the string representation
func (s CreateLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoadBalancerOutput) GoString() string {
	return s.String()
}

// Contains the parameters for CreateRule.
type CreateRuleInput struct {
	_ struct{} `type:"structure"`

	// An action. Each action has the type forward and specifies a target group.
	//
	// Actions is a required field
	Actions []*Action `type:"list" required:"true"`

	// A condition. Each condition has the field path-pattern and specifies one
	// path pattern. A path pattern is case sensitive, can be up to 255 characters
	// in length, and can contain any of the following characters:
	//
	//    * A-Z, a-z, 0-9
	//
	//    * _ - . $ / ~ " ' @ : +
	//
	//    * & (using &)
	//
	//    * * (matches 0 or more characters)
	//
	//    * ? (matches exactly 1 character)
	//
	// Conditions is a required field
	Conditions []*RuleCondition `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the listener.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`

	// The priority for the rule. A listener can't have multiple rules with the
	// same priority.
	//
	// Priority is a required field
	Priority *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s CreateRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRuleInput"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Conditions == nil {
		invalidParams.Add(request.NewErrParamRequired("Conditions"))
	}
	if s.ListenerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerArn"))
	}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Priority", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of CreateRule.
type CreateRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the rule.
	Rules []*Rule `type:"list"`
}

// String returns the string representation
func (s CreateRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRuleOutput) GoString() string {
	return s.String()
}

// Contains the parameters for CreateTargetGroup.
type CreateTargetGroupInput struct {
	_ struct{} `type:"structure"`

	// The approximate amount of time, in seconds, between health checks of an individual
	// target. The default is 30 seconds.
	HealthCheckIntervalSeconds *int64 `min:"5" type:"integer"`

	// The ping path that is the destination on the targets for health checks. The
	// default is /.
	HealthCheckPath *string `min:"1" type:"string"`

	// The port the load balancer uses when performing health checks on targets.
	// The default is traffic-port, which indicates the port on which each target
	// receives traffic from the load balancer.
	HealthCheckPort *string `type:"string"`

	// The protocol the load balancer uses when performing health checks on targets.
	// The default is the HTTP protocol.
	HealthCheckProtocol *string `type:"string" enum:"ProtocolEnum"`

	// The amount of time, in seconds, during which no response from a target means
	// a failed health check. The default is 5 seconds.
	HealthCheckTimeoutSeconds *int64 `min:"2" type:"integer"`

	// The number of consecutive health checks successes required before considering
	// an unhealthy target healthy. The default is 5.
	HealthyThresholdCount *int64 `min:"2" type:"integer"`

	// The HTTP codes to use when checking for a successful response from a target.
	// The default is 200.
	Matcher *Matcher `type:"structure"`

	// The name of the target group.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The port on which the targets receive traffic. This port is used unless you
	// specify a port override when registering the target.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`

	// The protocol to use for routing traffic to the targets.
	//
	// Protocol is a required field
	Protocol *string `type:"string" required:"true" enum:"ProtocolEnum"`

	// The number of consecutive health check failures required before considering
	// a target unhealthy. The default is 2.
	UnhealthyThresholdCount *int64 `min:"2" type:"integer"`

	// The identifier of the virtual private cloud (VPC).
	//
	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTargetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTargetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTargetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTargetGroupInput"}
	if s.HealthCheckIntervalSeconds != nil && *s.HealthCheckIntervalSeconds < 5 {
		invalidParams.Add(request.NewErrParamMinValue("HealthCheckIntervalSeconds", 5))
	}
	if s.HealthCheckPath != nil && len(*s.HealthCheckPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HealthCheckPath", 1))
	}
	if s.HealthCheckTimeoutSeconds != nil && *s.HealthCheckTimeoutSeconds < 2 {
		invalidParams.Add(request.NewErrParamMinValue("HealthCheckTimeoutSeconds", 2))
	}
	if s.HealthyThresholdCount != nil && *s.HealthyThresholdCount < 2 {
		invalidParams.Add(request.NewErrParamMinValue("HealthyThresholdCount", 2))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.UnhealthyThresholdCount != nil && *s.UnhealthyThresholdCount < 2 {
		invalidParams.Add(request.NewErrParamMinValue("UnhealthyThresholdCount", 2))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}
	if s.Matcher != nil {
		if err := s.Matcher.Validate(); err != nil {
			invalidParams.AddNested("Matcher", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of CreateTargetGroup.
type CreateTargetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Information about the target group.
	TargetGroups []*TargetGroup `type:"list"`
}

// String returns the string representation
func (s CreateTargetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTargetGroupOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteListener.
type DeleteListenerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteListenerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteListenerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteListenerInput"}
	if s.ListenerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DeleteListener.
type DeleteListenerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteListenerOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteLoadBalancer.
type DeleteLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the load balancer.
	//
	// LoadBalancerArn is a required field
	LoadBalancerArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoadBalancerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLoadBalancerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLoadBalancerInput"}
	if s.LoadBalancerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DeleteLoadBalancer.
type DeleteLoadBalancerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoadBalancerOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteRule.
type DeleteRuleInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule.
	//
	// RuleArn is a required field
	RuleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRuleInput"}
	if s.RuleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DeleteRule.
type DeleteRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRuleOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteTargetGroup.
type DeleteTargetGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group.
	//
	// TargetGroupArn is a required field
	TargetGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTargetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTargetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTargetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTargetGroupInput"}
	if s.TargetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DeleteTargetGroup.
type DeleteTargetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTargetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTargetGroupOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeregisterTargets.
type DeregisterTargetsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group.
	//
	// TargetGroupArn is a required field
	TargetGroupArn *string `type:"string" required:"true"`

	// The targets. If you specified a port override when you registered a target,
	// you must specify both the target ID and the port when you deregister it.
	//
	// Targets is a required field
	Targets []*TargetDescription `type:"list" required:"true"`
}

// String returns the string representation
func (s DeregisterTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterTargetsInput"}
	if s.TargetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroupArn"))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DeregisterTargets.
type DeregisterTargetsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterTargetsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeListeners.
type DescribeListenersInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARN) of the listeners.
	ListenerArns []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the load balancer.
	LoadBalancerArn *string `type:"string"`

	// The marker for the next set of results. (You received this marker from a
	// previous call.)
	Marker *string `type:"string"`

	// The maximum number of results to return with this call.
	PageSize *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s DescribeListenersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeListenersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeListenersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeListenersInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DescribeListeners.
type DescribeListenersOutput struct {
	_ struct{} `type:"structure"`

	// Information about the listeners.
	Listeners []*Listener `type:"list"`

	// The marker to use when requesting the next set of results. If there are no
	// additional results, the string is empty.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s DescribeListenersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeListenersOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeLoadBalancerAttributes.
type DescribeLoadBalancerAttributesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the load balancer.
	//
	// LoadBalancerArn is a required field
	LoadBalancerArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeLoadBalancerAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBalancerAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLoadBalancerAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLoadBalancerAttributesInput"}
	if s.LoadBalancerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DescribeLoadBalancerAttributes.
type DescribeLoadBalancerAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the load balancer attributes.
	Attributes []*LoadBalancerAttribute `type:"list"`
}

// String returns the string representation
func (s DescribeLoadBalancerAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBalancerAttributesOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeLoadBalancers.
type DescribeLoadBalancersInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARN) of the load balancers.
	LoadBalancerArns []*string `type:"list"`

	// The marker for the next set of results. (You received this marker from a
	// previous call.)
	Marker *string `type:"string"`

	// The names of the load balancers.
	Names []*string `type:"list"`

	// The maximum number of results to return with this call.
	PageSize *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s DescribeLoadBalancersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBalancersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLoadBalancersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLoadBalancersInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DescribeLoadBalancers.
type DescribeLoadBalancersOutput struct {
	_ struct{} `type:"structure"`

	// Information about the load balancers.
	LoadBalancers []*LoadBalancer `type:"list"`

	// The marker to use when requesting the next set of results. If there are no
	// additional results, the string is empty.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s DescribeLoadBalancersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBalancersOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeRules.
type DescribeRulesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener.
	ListenerArn *string `type:"string"`

	// The Amazon Resource Names (ARN) of the rules.
	RuleArns []*string `type:"list"`
}

// String returns the string representation
func (s DescribeRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRulesInput) GoString() string {
	return s.String()
}

// Contains the output of DescribeRules.
type DescribeRulesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the rules.
	Rules []*Rule `type:"list"`
}

// String returns the string representation
func (s DescribeRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRulesOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeSSLPolicies.
type DescribeSSLPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The marker for the next set of results. (You received this marker from a
	// previous call.)
	Marker *string `type:"string"`

	// The names of the policies.
	Names []*string `type:"list"`

	// The maximum number of results to return with this call.
	PageSize *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s DescribeSSLPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSSLPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSSLPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSSLPoliciesInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DescribeSSLPolicies.
type DescribeSSLPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The marker to use when requesting the next set of results. If there are no
	// additional results, the string is empty.
	NextMarker *string `type:"string"`

	// Information about the policies.
	SslPolicies []*SslPolicy `type:"list"`
}

// String returns the string representation
func (s DescribeSSLPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSSLPoliciesOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeTags.
type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARN) of the resources.
	//
	// ResourceArns is a required field
	ResourceArns []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTagsInput"}
	if s.ResourceArns == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArns"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DescribeTags.
type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the tags.
	TagDescriptions []*TagDescription `type:"list"`
}

// String returns the string representation
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeTargetGroupAttributes.
type DescribeTargetGroupAttributesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group.
	//
	// TargetGroupArn is a required field
	TargetGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTargetGroupAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTargetGroupAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTargetGroupAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTargetGroupAttributesInput"}
	if s.TargetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DescribeTargetGroupAttributes.
type DescribeTargetGroupAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the target group attributes
	Attributes []*TargetGroupAttribute `type:"list"`
}

// String returns the string representation
func (s DescribeTargetGroupAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTargetGroupAttributesOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeTargetGroups.
type DescribeTargetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the load balancer.
	LoadBalancerArn *string `type:"string"`

	// The marker for the next set of results. (You received this marker from a
	// previous call.)
	Marker *string `type:"string"`

	// The names of the target groups.
	Names []*string `type:"list"`

	// The maximum number of results to return with this call.
	PageSize *int64 `min:"1" type:"integer"`

	// The Amazon Resource Names (ARN) of the target groups.
	TargetGroupArns []*string `type:"list"`
}

// String returns the string representation
func (s DescribeTargetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTargetGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTargetGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTargetGroupsInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DescribeTargetGroups.
type DescribeTargetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The marker to use when requesting the next set of results. If there are no
	// additional results, the string is empty.
	NextMarker *string `type:"string"`

	// Information about the target groups.
	TargetGroups []*TargetGroup `type:"list"`
}

// String returns the string representation
func (s DescribeTargetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTargetGroupsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeTargetHealth.
type DescribeTargetHealthInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group.
	//
	// TargetGroupArn is a required field
	TargetGroupArn *string `type:"string" required:"true"`

	// The targets.
	Targets []*TargetDescription `type:"list"`
}

// String returns the string representation
func (s DescribeTargetHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTargetHealthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTargetHealthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTargetHealthInput"}
	if s.TargetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroupArn"))
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DescribeTargetHealth.
type DescribeTargetHealthOutput struct {
	_ struct{} `type:"structure"`

	// Information about the health of the targets.
	TargetHealthDescriptions []*TargetHealthDescription `type:"list"`
}

// String returns the string representation
func (s DescribeTargetHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTargetHealthOutput) GoString() string {
	return s.String()
}

// Information about a listener.
type Listener struct {
	_ struct{} `type:"structure"`

	// The SSL server certificate. You must provide a certificate if the protocol
	// is HTTPS.
	Certificates []*Certificate `type:"list"`

	// The default actions for the listener.
	DefaultActions []*Action `type:"list"`

	// The Amazon Resource Name (ARN) of the listener.
	ListenerArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the load balancer.
	LoadBalancerArn *string `type:"string"`

	// The port on which the load balancer is listening.
	Port *int64 `min:"1" type:"integer"`

	// The protocol for connections from clients to the load balancer.
	Protocol *string `type:"string" enum:"ProtocolEnum"`

	// The security policy that defines which ciphers and protocols are supported.
	// The default is the current predefined security policy.
	SslPolicy *string `type:"string"`
}

// String returns the string representation
func (s Listener) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Listener) GoString() string {
	return s.String()
}

// Information about a load balancer.
type LoadBalancer struct {
	_ struct{} `type:"structure"`

	// The Availability Zones for the load balancer.
	AvailabilityZones []*AvailabilityZone `type:"list"`

	// The ID of the Amazon Route 53 hosted zone associated with the load balancer.
	CanonicalHostedZoneId *string `type:"string"`

	// The date and time the load balancer was created.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The public DNS name of the load balancer.
	DNSName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the load balancer.
	LoadBalancerArn *string `type:"string"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string"`

	// The nodes of an Internet-facing load balancer have public IP addresses. The
	// DNS name of an Internet-facing load balancer is publicly resolvable to the
	// public IP addresses of the nodes. Therefore, Internet-facing load balancers
	// can route requests from clients over the Internet.
	//
	// The nodes of an internal load balancer have only private IP addresses. The
	// DNS name of an internal load balancer is publicly resolvable to the private
	// IP addresses of the nodes. Therefore, internal load balancers can only route
	// requests from clients with access to the VPC for the load balancer.
	Scheme *string `type:"string" enum:"LoadBalancerSchemeEnum"`

	// The IDs of the security groups for the load balancer.
	SecurityGroups []*string `type:"list"`

	// The state of the load balancer.
	State *LoadBalancerState `type:"structure"`

	// The type of load balancer.
	Type *string `type:"string" enum:"LoadBalancerTypeEnum"`

	// The ID of the VPC for the load balancer.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s LoadBalancer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancer) GoString() string {
	return s.String()
}

// Information about a load balancer attribute.
type LoadBalancerAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	//
	//    * access_logs.s3.enabled - Indicates whether access logs stored in Amazon
	//    S3 are enabled. The value is true or false.
	//
	//    * access_logs.s3.bucket - The name of the S3 bucket for the access logs.
	//    This attribute is required if access logs in Amazon S3 are enabled. The
	//    bucket must exist in the same region as the load balancer and have a bucket
	//    policy that grants Elastic Load Balancing permission to write to the bucket.
	//
	//    * access_logs.s3.prefix - The prefix for the location in the S3 bucket.
	//    If you don't specify a prefix, the access logs are stored in the root
	//    of the bucket.
	//
	//    * deletion_protection.enabled - Indicates whether deletion protection
	//    is enabled. The value is true or false.
	//
	//    * idle_timeout.timeout_seconds - The idle timeout value, in seconds. The
	//    valid range is 1-3600. The default is 60 seconds.
	Key *string `type:"string"`

	// The value of the attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s LoadBalancerAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancerAttribute) GoString() string {
	return s.String()
}

// Information about the state of the load balancer.
type LoadBalancerState struct {
	_ struct{} `type:"structure"`

	// The state code. The initial state of the load balancer is provisioning. After
	// the load balancer is fully set up and ready to route traffic, its state is
	// active. If the load balancer could not be set up, its state is failed.
	Code *string `type:"string" enum:"LoadBalancerStateEnum"`

	// A description of the state.
	Reason *string `type:"string"`
}

// String returns the string representation
func (s LoadBalancerState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancerState) GoString() string {
	return s.String()
}

// Information to use when checking for a successful response from a target.
type Matcher struct {
	_ struct{} `type:"structure"`

	// The HTTP codes. The default value is 200. You can specify multiple values
	// (for example, "200,202") or a range of values (for example, "200-299").
	//
	// HttpCode is a required field
	HttpCode *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Matcher) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Matcher) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Matcher) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Matcher"}
	if s.HttpCode == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpCode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the parameters for ModifyListener.
type ModifyListenerInput struct {
	_ struct{} `type:"structure"`

	// The SSL server certificate.
	Certificates []*Certificate `type:"list"`

	// The default actions.
	DefaultActions []*Action `type:"list"`

	// The Amazon Resource Name (ARN) of the listener.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`

	// The port for connections from clients to the load balancer.
	Port *int64 `min:"1" type:"integer"`

	// The protocol for connections from clients to the load balancer.
	Protocol *string `type:"string" enum:"ProtocolEnum"`

	// The security policy that defines which ciphers and protocols are supported.
	SslPolicy *string `type:"string"`
}

// String returns the string representation
func (s ModifyListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyListenerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyListenerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyListenerInput"}
	if s.ListenerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerArn"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.DefaultActions != nil {
		for i, v := range s.DefaultActions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DefaultActions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of ModifyListener.
type ModifyListenerOutput struct {
	_ struct{} `type:"structure"`

	// Information about the modified listeners.
	Listeners []*Listener `type:"list"`
}

// String returns the string representation
func (s ModifyListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyListenerOutput) GoString() string {
	return s.String()
}

// Contains the parameters for ModifyLoadBalancerAttributes.
type ModifyLoadBalancerAttributesInput struct {
	_ struct{} `type:"structure"`

	// The load balancer attributes.
	//
	// Attributes is a required field
	Attributes []*LoadBalancerAttribute `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the load balancer.
	//
	// LoadBalancerArn is a required field
	LoadBalancerArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyLoadBalancerAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyLoadBalancerAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyLoadBalancerAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyLoadBalancerAttributesInput"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.LoadBalancerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of ModifyLoadBalancerAttributes.
type ModifyLoadBalancerAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the load balancer attributes.
	Attributes []*LoadBalancerAttribute `type:"list"`
}

// String returns the string representation
func (s ModifyLoadBalancerAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyLoadBalancerAttributesOutput) GoString() string {
	return s.String()
}

// Contains the parameters for ModifyRules.
type ModifyRuleInput struct {
	_ struct{} `type:"structure"`

	// The actions.
	Actions []*Action `type:"list"`

	// The conditions.
	Conditions []*RuleCondition `type:"list"`

	// The Amazon Resource Name (ARN) of the rule.
	//
	// RuleArn is a required field
	RuleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyRuleInput"}
	if s.RuleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleArn"))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of ModifyRules.
type ModifyRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the rule.
	Rules []*Rule `type:"list"`
}

// String returns the string representation
func (s ModifyRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyRuleOutput) GoString() string {
	return s.String()
}

// Contains the parameters for ModifyTargetGroupAttributes.
type ModifyTargetGroupAttributesInput struct {
	_ struct{} `type:"structure"`

	// The attributes.
	//
	// Attributes is a required field
	Attributes []*TargetGroupAttribute `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the target group.
	//
	// TargetGroupArn is a required field
	TargetGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyTargetGroupAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyTargetGroupAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyTargetGroupAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyTargetGroupAttributesInput"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.TargetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of ModifyTargetGroupAttributes.
type ModifyTargetGroupAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the attributes.
	Attributes []*TargetGroupAttribute `type:"list"`
}

// String returns the string representation
func (s ModifyTargetGroupAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyTargetGroupAttributesOutput) GoString() string {
	return s.String()
}

// Contains the parameters for ModifyTargetGroup.
type ModifyTargetGroupInput struct {
	_ struct{} `type:"structure"`

	// The approximate amount of time, in seconds, between health checks of an individual
	// target.
	HealthCheckIntervalSeconds *int64 `min:"5" type:"integer"`

	// The ping path that is the destination for the health check request.
	HealthCheckPath *string `min:"1" type:"string"`

	// The port to use to connect with the target.
	HealthCheckPort *string `type:"string"`

	// The protocol to use to connect with the target.
	HealthCheckProtocol *string `type:"string" enum:"ProtocolEnum"`

	// The amount of time, in seconds, during which no response means a failed health
	// check.
	HealthCheckTimeoutSeconds *int64 `min:"2" type:"integer"`

	// The number of consecutive health checks successes required before considering
	// an unhealthy target healthy.
	HealthyThresholdCount *int64 `min:"2" type:"integer"`

	// The HTTP codes to use when checking for a successful response from a target.
	Matcher *Matcher `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group.
	//
	// TargetGroupArn is a required field
	TargetGroupArn *string `type:"string" required:"true"`

	// The number of consecutive health check failures required before considering
	// the target unhealthy.
	UnhealthyThresholdCount *int64 `min:"2" type:"integer"`
}

// String returns the string representation
func (s ModifyTargetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyTargetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyTargetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyTargetGroupInput"}
	if s.HealthCheckIntervalSeconds != nil && *s.HealthCheckIntervalSeconds < 5 {
		invalidParams.Add(request.NewErrParamMinValue("HealthCheckIntervalSeconds", 5))
	}
	if s.HealthCheckPath != nil && len(*s.HealthCheckPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HealthCheckPath", 1))
	}
	if s.HealthCheckTimeoutSeconds != nil && *s.HealthCheckTimeoutSeconds < 2 {
		invalidParams.Add(request.NewErrParamMinValue("HealthCheckTimeoutSeconds", 2))
	}
	if s.HealthyThresholdCount != nil && *s.HealthyThresholdCount < 2 {
		invalidParams.Add(request.NewErrParamMinValue("HealthyThresholdCount", 2))
	}
	if s.TargetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroupArn"))
	}
	if s.UnhealthyThresholdCount != nil && *s.UnhealthyThresholdCount < 2 {
		invalidParams.Add(request.NewErrParamMinValue("UnhealthyThresholdCount", 2))
	}
	if s.Matcher != nil {
		if err := s.Matcher.Validate(); err != nil {
			invalidParams.AddNested("Matcher", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of ModifyTargetGroup.
type ModifyTargetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Information about the target group.
	TargetGroups []*TargetGroup `type:"list"`
}

// String returns the string representation
func (s ModifyTargetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyTargetGroupOutput) GoString() string {
	return s.String()
}

// Contains the parameters for RegisterTargets.
type RegisterTargetsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group.
	//
	// TargetGroupArn is a required field
	TargetGroupArn *string `type:"string" required:"true"`

	// The targets. The default port for a target is the port for the target group.
	// You can specify a port override. If a target is already registered, you can
	// register it again using a different port.
	//
	// Targets is a required field
	Targets []*TargetDescription `type:"list" required:"true"`
}

// String returns the string representation
func (s RegisterTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterTargetsInput"}
	if s.TargetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroupArn"))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of RegisterTargets.
type RegisterTargetsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterTargetsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for RemoveTags.
type RemoveTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArns is a required field
	ResourceArns []*string `type:"list" required:"true"`

	// The tag keys for the tags to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsInput"}
	if s.ResourceArns == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArns"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of RemoveTags.
type RemoveTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsOutput) GoString() string {
	return s.String()
}

// Information about a rule.
type Rule struct {
	_ struct{} `type:"structure"`

	// The actions.
	Actions []*Action `type:"list"`

	// The conditions.
	Conditions []*RuleCondition `type:"list"`

	// Indicates whether this is the default rule.
	IsDefault *bool `type:"boolean"`

	// The priority.
	Priority *string `type:"string"`

	// The Amazon Resource Name (ARN) of the rule.
	RuleArn *string `type:"string"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Rule) GoString() string {
	return s.String()
}

// Information about a condition for a rule.
type RuleCondition struct {
	_ struct{} `type:"structure"`

	// The only possible value is path-pattern.
	Field *string `type:"string"`

	// The path pattern. You can specify a single path pattern.
	//
	// A path pattern is case sensitive, can be up to 255 characters in length,
	// and can contain any of the following characters:
	//
	//    * A-Z, a-z, 0-9
	//
	//    * _ - . $ / ~ " ' @ : +
	//
	//    * & (using &)
	//
	//    * * (matches 0 or more characters)
	//
	//    * ? (matches exactly 1 character)
	Values []*string `type:"list"`
}

// String returns the string representation
func (s RuleCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleCondition) GoString() string {
	return s.String()
}

// Information about the priorities for the rules for a listener.
type RulePriorityPair struct {
	_ struct{} `type:"structure"`

	// The rule priority.
	Priority *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the rule.
	RuleArn *string `type:"string"`
}

// String returns the string representation
func (s RulePriorityPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RulePriorityPair) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RulePriorityPair) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RulePriorityPair"}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Priority", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the parameters for SetRulePriorities.
type SetRulePrioritiesInput struct {
	_ struct{} `type:"structure"`

	// The rule priorities.
	//
	// RulePriorities is a required field
	RulePriorities []*RulePriorityPair `type:"list" required:"true"`
}

// String returns the string representation
func (s SetRulePrioritiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetRulePrioritiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetRulePrioritiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetRulePrioritiesInput"}
	if s.RulePriorities == nil {
		invalidParams.Add(request.NewErrParamRequired("RulePriorities"))
	}
	if s.RulePriorities != nil {
		for i, v := range s.RulePriorities {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RulePriorities", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of SetRulePriorities.
type SetRulePrioritiesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the rules.
	Rules []*Rule `type:"list"`
}

// String returns the string representation
func (s SetRulePrioritiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetRulePrioritiesOutput) GoString() string {
	return s.String()
}

// Contains the parameters for SetSecurityGroups.
type SetSecurityGroupsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the load balancer.
	//
	// LoadBalancerArn is a required field
	LoadBalancerArn *string `type:"string" required:"true"`

	// The IDs of the security groups.
	//
	// SecurityGroups is a required field
	SecurityGroups []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s SetSecurityGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetSecurityGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetSecurityGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetSecurityGroupsInput"}
	if s.LoadBalancerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerArn"))
	}
	if s.SecurityGroups == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroups"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of SetSecurityGroups.
type SetSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The IDs of the security groups associated with the load balancer.
	SecurityGroupIds []*string `type:"list"`
}

// String returns the string representation
func (s SetSecurityGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetSecurityGroupsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for SetSubnets.
type SetSubnetsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the load balancer.
	//
	// LoadBalancerArn is a required field
	LoadBalancerArn *string `type:"string" required:"true"`

	// The IDs of the subnets. You must specify at least two subnets. You can add
	// only one subnet per Availability Zone.
	//
	// Subnets is a required field
	Subnets []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s SetSubnetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetSubnetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetSubnetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetSubnetsInput"}
	if s.LoadBalancerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerArn"))
	}
	if s.Subnets == nil {
		invalidParams.Add(request.NewErrParamRequired("Subnets"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of SetSubnets.
type SetSubnetsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the subnet and Availability Zone.
	AvailabilityZones []*AvailabilityZone `type:"list"`
}

// String returns the string representation
func (s SetSubnetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetSubnetsOutput) GoString() string {
	return s.String()
}

// Information about a policy used for SSL negotiation.
type SslPolicy struct {
	_ struct{} `type:"structure"`

	// The ciphers.
	Ciphers []*Cipher `type:"list"`

	// The name of the policy.
	Name *string `type:"string"`

	// The protocols.
	SslProtocols []*string `type:"list"`
}

// String returns the string representation
func (s SslPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SslPolicy) GoString() string {
	return s.String()
}

// Information about a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The tags associated with a resource.
type TagDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	ResourceArn *string `type:"string"`

	// Information about the tags.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s TagDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagDescription) GoString() string {
	return s.String()
}

// Information about a target.
type TargetDescription struct {
	_ struct{} `type:"structure"`

	// The ID of the target.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The port on which the target is listening.
	Port *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s TargetDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetDescription) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetDescription) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetDescription"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a target group.
type TargetGroup struct {
	_ struct{} `type:"structure"`

	// The approximate amount of time, in seconds, between health checks of an individual
	// target.
	HealthCheckIntervalSeconds *int64 `min:"5" type:"integer"`

	// The destination for the health check request.
	HealthCheckPath *string `min:"1" type:"string"`

	// The port to use to connect with the target.
	HealthCheckPort *string `type:"string"`

	// The protocol to use to connect with the target.
	HealthCheckProtocol *string `type:"string" enum:"ProtocolEnum"`

	// The amount of time, in seconds, during which no response means a failed health
	// check.
	HealthCheckTimeoutSeconds *int64 `min:"2" type:"integer"`

	// The number of consecutive health checks successes required before considering
	// an unhealthy target healthy.
	HealthyThresholdCount *int64 `min:"2" type:"integer"`

	// The Amazon Resource Names (ARN) of the load balancers that route traffic
	// to this target group.
	LoadBalancerArns []*string `type:"list"`

	// The HTTP codes to use when checking for a successful response from a target.
	Matcher *Matcher `type:"structure"`

	// The port on which the targets are listening.
	Port *int64 `min:"1" type:"integer"`

	// The protocol to use for routing traffic to the targets.
	Protocol *string `type:"string" enum:"ProtocolEnum"`

	// The Amazon Resource Name (ARN) of the target group.
	TargetGroupArn *string `type:"string"`

	// The name of the target group.
	TargetGroupName *string `type:"string"`

	// The number of consecutive health check failures required before considering
	// the target unhealthy.
	UnhealthyThresholdCount *int64 `min:"2" type:"integer"`

	// The ID of the VPC for the targets.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s TargetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetGroup) GoString() string {
	return s.String()
}

// Information about a target group attribute.
type TargetGroupAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	//
	//    * deregistration_delay.timeout_seconds - The amount time for Elastic Load
	//    Balancing to wait before changing the state of a deregistering target
	//    from draining to unused. The range is 0-3600 seconds. The default value
	//    is 300 seconds.
	//
	//    * stickiness.enabled - Indicates whether sticky sessions are enabled.
	//    The value is true or false.
	//
	//    * stickiness.type - The type of sticky sessions. The possible value is
	//    lb_cookie.
	//
	//    * stickiness.lb_cookie.duration_seconds - The time period, in seconds,
	//    during which requests from a client should be routed to the same target.
	//    After this time period expires, the load balancer-generated cookie is
	//    considered stale. The range is 1 second to 1 week (604800 seconds). The
	//    default value is 1 day (86400 seconds).
	Key *string `type:"string"`

	// The value of the attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s TargetGroupAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetGroupAttribute) GoString() string {
	return s.String()
}

// Information about the current health of a target.
type TargetHealth struct {
	_ struct{} `type:"structure"`

	// A description of the target health that provides additional details. If the
	// state is healthy, a description is not provided.
	Description *string `type:"string"`

	// The reason code. If the target state is healthy, a reason code is not provided.
	//
	// If the target state is initial, the reason code can be one of the following
	// values:
	//
	//    * Elb.RegistrationInProgress - The target is in the process of being registered
	//    with the load balancer.
	//
	//    * Elb.InitialHealthChecking - The load balancer is still sending the target
	//    the minimum number of health checks required to determine its health status.
	//
	// If the target state is unhealthy, the reason code can be one of the following
	// values:
	//
	//    * Target.ResponseCodeMismatch - The health checks did not return an expected
	//    HTTP code.
	//
	//    * Target.Timeout - The health check requests timed out.
	//
	//    * Target.FailedHealthChecks - The health checks failed because the connection
	//    to the target timed out, the target response was malformed, or the target
	//    failed the health check for an unknown reason.
	//
	//    * Elb.InternalError - The health checks failed due to an internal error.
	//
	// If the target state is unused, the reason code can be one of the following
	// values:
	//
	//    * Target.NotRegistered - The target is not registered with the target
	//    group.
	//
	//    * Target.NotInUse - The target group is not used by any load balancer
	//    or the target is in an Availability Zone that is not enabled for its load
	//    balancer.
	//
	//    * Target.InvalidState - The target is in the stopped or terminated state.
	//
	// If the target state is draining, the reason code can be the following value:
	//
	//    * Target.DeregistrationInProgress - The target is in the process of being
	//    deregistered and the deregistration delay period has not expired.
	Reason *string `type:"string" enum:"TargetHealthReasonEnum"`

	// The state of the target.
	State *string `type:"string" enum:"TargetHealthStateEnum"`
}

// String returns the string representation
func (s TargetHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetHealth) GoString() string {
	return s.String()
}

// Information about the health of a target.
type TargetHealthDescription struct {
	_ struct{} `type:"structure"`

	// The port to use to connect with the target.
	HealthCheckPort *string `type:"string"`

	// The description of the target.
	Target *TargetDescription `type:"structure"`

	// The health information for the target.
	TargetHealth *TargetHealth `type:"structure"`
}

// String returns the string representation
func (s TargetHealthDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetHealthDescription) GoString() string {
	return s.String()
}

const (
	// ActionTypeEnumForward is a ActionTypeEnum enum value
	ActionTypeEnumForward = "forward"
)

const (
	// LoadBalancerSchemeEnumInternetFacing is a LoadBalancerSchemeEnum enum value
	LoadBalancerSchemeEnumInternetFacing = "internet-facing"

	// LoadBalancerSchemeEnumInternal is a LoadBalancerSchemeEnum enum value
	LoadBalancerSchemeEnumInternal = "internal"
)

const (
	// LoadBalancerStateEnumActive is a LoadBalancerStateEnum enum value
	LoadBalancerStateEnumActive = "active"

	// LoadBalancerStateEnumProvisioning is a LoadBalancerStateEnum enum value
	LoadBalancerStateEnumProvisioning = "provisioning"

	// LoadBalancerStateEnumFailed is a LoadBalancerStateEnum enum value
	LoadBalancerStateEnumFailed = "failed"
)

const (
	// LoadBalancerTypeEnumApplication is a LoadBalancerTypeEnum enum value
	LoadBalancerTypeEnumApplication = "application"
)

const (
	// ProtocolEnumHttp is a ProtocolEnum enum value
	ProtocolEnumHttp = "HTTP"

	// ProtocolEnumHttps is a ProtocolEnum enum value
	ProtocolEnumHttps = "HTTPS"
)

const (
	// TargetHealthReasonEnumElbRegistrationInProgress is a TargetHealthReasonEnum enum value
	TargetHealthReasonEnumElbRegistrationInProgress = "Elb.RegistrationInProgress"

	// TargetHealthReasonEnumElbInitialHealthChecking is a TargetHealthReasonEnum enum value
	TargetHealthReasonEnumElbInitialHealthChecking = "Elb.InitialHealthChecking"

	// TargetHealthReasonEnumTargetResponseCodeMismatch is a TargetHealthReasonEnum enum value
	TargetHealthReasonEnumTargetResponseCodeMismatch = "Target.ResponseCodeMismatch"

	// TargetHealthReasonEnumTargetTimeout is a TargetHealthReasonEnum enum value
	TargetHealthReasonEnumTargetTimeout = "Target.Timeout"

	// TargetHealthReasonEnumTargetFailedHealthChecks is a TargetHealthReasonEnum enum value
	TargetHealthReasonEnumTargetFailedHealthChecks = "Target.FailedHealthChecks"

	// TargetHealthReasonEnumTargetNotRegistered is a TargetHealthReasonEnum enum value
	TargetHealthReasonEnumTargetNotRegistered = "Target.NotRegistered"

	// TargetHealthReasonEnumTargetNotInUse is a TargetHealthReasonEnum enum value
	TargetHealthReasonEnumTargetNotInUse = "Target.NotInUse"

	// TargetHealthReasonEnumTargetDeregistrationInProgress is a TargetHealthReasonEnum enum value
	TargetHealthReasonEnumTargetDeregistrationInProgress = "Target.DeregistrationInProgress"

	// TargetHealthReasonEnumTargetInvalidState is a TargetHealthReasonEnum enum value
	TargetHealthReasonEnumTargetInvalidState = "Target.InvalidState"

	// TargetHealthReasonEnumElbInternalError is a TargetHealthReasonEnum enum value
	TargetHealthReasonEnumElbInternalError = "Elb.InternalError"
)

const (
	// TargetHealthStateEnumInitial is a TargetHealthStateEnum enum value
	TargetHealthStateEnumInitial = "initial"

	// TargetHealthStateEnumHealthy is a TargetHealthStateEnum enum value
	TargetHealthStateEnumHealthy = "healthy"

	// TargetHealthStateEnumUnhealthy is a TargetHealthStateEnum enum value
	TargetHealthStateEnumUnhealthy = "unhealthy"

	// TargetHealthStateEnumUnused is a TargetHealthStateEnum enum value
	TargetHealthStateEnumUnused = "unused"

	// TargetHealthStateEnumDraining is a TargetHealthStateEnum enum value
	TargetHealthStateEnumDraining = "draining"
)
