# gozerbot/monitor.py
#
#

""" monitors .. call callback on bot output """

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import rlog, handle_exception
from gozerbot.ircevent import Ircevent
from gozerbot.config import config
if config['jabberenable']:
    from gozerbot.jabbermsg import Jabbermsg
    from gozerbot.jabberpresence import Jabberpresence
from gozerbot.threadloop import ThreadLoop
from gozerbot.runner import runner
import gozerbot.thr as thr
import Queue

class Monitor(ThreadLoop):

    """ monitor base class """

    def __init__(self, name="monitor"):
        ThreadLoop.__init__(self, name)        
        self.outs = []

    def add(self, name, callback, pre, threaded=False):
        """ add a say monitoring callback """
        name = name.lower()
        self.outs.append((name, callback, pre, threaded))
        rlog(0, self.name, 'added %s (%s)' % (name, str(callback)))

    def unload(self, name):
        """ delete monitor item """
        name = name.lower()
        for i in range(len(self.outs)-1, -1, -1):
            if self.outs[i][0] == name:
                del self.outs[i]

class Saymonitor(Monitor):

    """ monitor bot output (bot.say) """

    def handle(self, botname, printto, txt, who, how, fromm):
        """ fire saymonitor callbacks """
        for i in self.outs:
            # check if precondition is met
            try:
                if i[2]:
                    doit = i[2](botname, printto, txt, who, how, fromm)
                else:
                    doit = 1
            except Exception, ex:
                handle_exception()
                doit = 0
            if doit:
                # run monitor callback in its own thread
                rlog(0, 'saymonitor', 'excecuting saymonitor callback %s' \
% i[0])
                if not i[3]:
                    runner.put("monitor-%s" % i[0], i[1], botname, printto, \
txt, who, how, fromm)
                else:
                    thr.start_new_thread(i[1], (botname, printto, txt, who, \
how, fromm))

class Outmonitor(Monitor):

    """ monitor for bot output (bot.send) """

    def handle(self, bot, txt):
        """ fire outmonitor callbacks """
        ievent = Ircevent().parse(bot, txt)
        if not ievent:
            rlog(10, 'monitor', "can't make ircevent: %s" % txt)
            return
        ievent.nick = bot.nick
        try:
            ievent.userhost = bot.userhosts[bot.nick]
        except KeyError:
            ievent.userhost = "bot@bot"
        for i in self.outs:
            # check if precondition is met
            try:
                if i[2]:
                    doit = i[2](bot, ievent)
                else:
                    doit = 1
            except Exception, ex:
                handle_exception()
                doit = 0
            if doit:
                # run monitor callback in thread
                rlog(0, 'outmonitor', 'excecuting outmonitor callback \
%s' % i[0])
                if not i[3]:
                    runner.put("monitor-%s" % i[0], i[1], bot, ievent)
                else:
                    thr.start_new_thread(i[1], (bot, ievent))

class Jabbermonitor(Monitor):

    """ monitor jabber output """

    def handle(self, bot, msg):
        """ fire jabber monitor callbacks """
        if not config['jabberenable']:
            return
        try:
            if msg.startswith('<presence'):
                jmsg = Jabberpresence(msg)
            else:
                jmsg = Jabbermsg(msg)
            jmsg.toirc(bot)
            jmsg.botoutput = True
        except AttributeError:
            return
        for i in self.outs:
            # check if precondition is met
            try:
                if i[2]:
                    rlog(0, 'jabbermonitor', 'checking inloop %s' % str(i[2]))
                    doit = i[2](bot, jmsg)
                else:
                    doit = 1
            except Exception, ex:
                handle_exception()
                doit = 0
            if doit:
                # run monitor callback in its own thread
                rlog(0, 'jabbermonitor', 'excecuting jabbermonitor callback \
%s' % i[0])
                if not i[3]:
                    runner.put("monitor-%s" % i[0], i[1], bot, jmsg)
                else:
                    thr.start_new_thread(i[1], (bot, jmsg))

# bot.send() monitor
outmonitor = Outmonitor('outmonitor') 

# bot.say() monitor
saymonitor = Saymonitor('saymonitor')

# jabber monitor
jabbermonitor = Jabbermonitor('jabbermonitor')
