/*
  Gnome-o-Phone - A program for internet telephony
  Copyright (C) 1999  Roland Dreier
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  $Id: gphone-lib.h 1.8 Sat, 11 Dec 1999 23:53:26 -0600 dreier $
*/

#ifndef _GPHONE_LIB_H
#define _GPHONE_LIB_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <netinet/in.h>
#include <glib.h>

int short_sleep(double sleep_time);
void gphone_perror_exit(char *message, int status);
void gphone_print_exit(char *message, int status);

void term_setup(void);
void term_cleanup(void);

int find_host(char *host_name, struct in_addr *address);
int recv_fd(int sock);
void send_fd(int sock, int fd);
char *gphone_getpeername(int sock);

guint32 random32(int type);

#endif /* gphone-lib.h */
