#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <lockdev.h>

int vrfy_devname(char *name){
  return 1;
}

void error(char *msg)
{
  fprintf(stderr,"%s\n",msg);
  exit(0);
}

main(int argc, char *argv[])
{
  int UNDO=0;
  char devname[255];
  uid_t uid;
  gid_t gid;
  pid_t pid;

  if(argc<2) error("Number of arguments");
  if(!strcmp(argv[1],"-u")){
    UNDO=1;
    if(argc != 4) error("Number of arguments");
    strncpy(devname,argv[2],254);
    uid = atoi(argv[3]);
  } else strncpy(devname,argv[1],254);
  
  if(!vrfy_devname(devname)) error("Bad device name");
  
  if(!UNDO){
    uid = getuid();
    dev_lock(devname);
  } else {
    pid = dev_testlock(devname);
    dev_unlock(devname,pid);
  }
  chown(devname,uid,-1);
  exit(0);
}
  
