#include "config.h"

#include <stdlib.h>

#include <iostream>
#include <string>

#include "gql++/driver-manager.h"
#include "gql++/exception.h"
#include "gql++/result-set.h"
#include "gql++/statement.h"
#include "gql++/database-metadata.h"
#include "gql++/result-set-metadata.h"

using namespace GQL;
using namespace std;

static void usage();

int main(int argc, char *argv[])
{
  DriverManager man;
  string driver, db, user, passwd, tablename;
  
  if (argc != 6)
  {
    usage();
    exit(EXIT_FAILURE);
  }

  driver = argv[1];
  db = argv[2];
  user = argv[3];
  passwd = argv[4];
  tablename = argv[5];
  
  try
  {
    Connection *conn = man.get_connection("gql:" + driver + ":" + db,
                                          user, passwd);
    DatabaseMetaData *dbmd;
    SQLObject *str_obj = conn->create_object();
    ResultSet *rs;
    vector<string> types(1);
    
    dbmd = conn->get_meta_data();
    types[0] = "TABLE";
    rs = dbmd->get_tables("", "", "", types);

    while (rs->next())
    {
      rs->get(2, str_obj);
      if (str_obj->to_string() == tablename)
        break;
    }
    delete rs;
    
    if (str_obj->to_string() == tablename)
    {
      Statement *stmt = conn->create_statement();
      SQLObject *obj = conn->create_object();
      ResultSetMetaData *rsmd;
      
      rs = stmt->execute_query("SELECT * FROM " + tablename + " WHERE FALSE");
      rsmd = rs->get_meta_data();

      for (int i = 0; i < rsmd->column_count(); i++)
      {
	obj->from_type(rsmd->get_column_type(i));
	
        cout << rsmd->get_column_label(i) << "\t| "
             << obj->to_string() << " " 
	     << rsmd->get_column_type(i).typecode() << endl;
      }
      delete rsmd;
      delete rs;
    }
    else
      cerr << "No Table '" << tablename << "' found" << endl;

    delete conn;
  }

  catch (SQLException e)
  {
    cout << "SQLException: " << e.what() << endl;
    return(EXIT_FAILURE);
  }
  
  
  man.deregister_driver(driver);
}

static void usage()
{
  cout << "usage: show-table <driver> <database> <username> <passwd> <tablename>" << endl;
}
