/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_GDBI_DATASET_H)
#define __INC_GDBI_DATASET_H

#include <gql++/result-set.h>

#include "gdbi++/table.h"
#include "uc++/error-handler.h"

namespace gdbi
{

class DataSet : public uC::ErrorHandler
{
    friend class Table;
  public:
    class Row
    {
      public:
        GQL::SQLObject& operator[](int i);
        const GQL::SQLObject& operator[](int i) const;
    };
    
    DataSet();
    virtual ~DataSet();

    const std::vector<Table::Column *>& columns();
    
    GQL::SQLObject *get_object(int row, int col);

    int rows();
    
    Table *table() { return(table_); }
  protected:
    DataSet(GQL::ResultSet *rs, Table *table = 0);
  private:
    GQL::ResultSet *result_set_;
    GQL::ResultSetMetaData *rsmd_;
    GQL::Connection *conn_;
    Table *table_;
    std::vector<Table::Column *> *columns_;
    std::vector<GQL::SQLObject **> rows_;
    bool rs_empty_;
    int colno_;
};

}

#endif
