#include "property.h"

using namespace std;

Property Property::the_empty_property_;

Property::Property(const PropertySchema *schema)
{
  schema_ = schema;

  if (schema_)
  {
    value_ = schema_->default_value();
    for (PropertySchema::const_iterator it = schema_->subschemata().begin();
         it != schema_->subschemata().end(); ++it)
      set_subproperty(*it, Property(schema_->subschema(*it)));
  }
}

Property::~Property()
{
}

bool Property::set_subproperty(const string& name, const Property& property)
{
  if (schema_ && schema_->readonly())
    return false;
  
  map<string, Property>::iterator it = subproperties_.find(name);
  if (it != subproperties_.end())
    (*it).second = property;
  else
  {
    subproperties_.insert(pair<string, Property>(name, property));
    subproperty_list_.push_back(name);
  }
  return true;
}

const Property& Property::subproperty(const string& name) const
{
  map<string, Property>::const_iterator it = subproperties_.find(name);

  return it == subproperties_.end() ? the_empty_property_ : (*it).second;
}

PropertySchema::PropertySchema(const string& descr, bool rdonly = false)
{
  description_ = descr;
  readonly_ = rdonly;
}

PropertySchema::~PropertySchema()
{
}

bool PropertySchema::set_subschema(const string& name, PropertySchema *schema)
{
  map<string, PropertySchema *>::iterator it = subschemata_.find(name);
  if (it != subschemata_.end())
  {
    (*it).second->unreference();
    (*it).second = schema;
  }
  else
  {
    subschemata_.insert(pair<string, PropertySchema *>(name, schema));
    subschema_list_.push_back(name);
  }
  schema->reference();
  return true;
}

const PropertySchema *PropertySchema::subschema(const string& name) const
{
  map<string, PropertySchema *>::const_iterator it = subschemata_.find(name);

  return it == subschemata_.end() ? 0 : (*it).second;
}

