/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_PROPERTY_H)
#define __INC_PROPERTY_H

#include <sigc++/object.h>

#include <string>
#include <map>
#include <list>

class PropertySchema;

class Property
{
  public:
    typedef std::list<std::string>::iterator iterator;
    typedef std::list<std::string>::const_iterator const_iterator;
    
    Property(const PropertySchema *schema = 0);
    ~Property();
    
    const std::string& value();
    const PropertySchema *schema() const { return schema_; }
    bool set_subproperty(const std::string& name, const Property& prop);
    const Property& subproperty(const std::string& name) const;
    const std::list<std::string>& subproperties() const { 
      return subproperty_list_; 
    }
  private:
    static Property the_empty_property_;
    
    const PropertySchema *schema_;
    std::string value_;
    std::map<std::string, Property> subproperties_;
    std::list<std::string> subproperty_list_;
};

class PropertySchema : public SigC::Object
{
  public:
    typedef std::list<std::string>::iterator iterator;
    typedef std::list<std::string>::const_iterator const_iterator;
    
    PropertySchema(const std::string& description, bool rdonly = false);
    ~PropertySchema();
    
    const std::string& description() const { return description_; }
    const std::string& default_value() const { return default_val_; }
    bool readonly() const { return readonly_; }

    bool set_subschema(const std::string& name, PropertySchema *schema);
    const PropertySchema *subschema(const std::string& name) const;
    const std::list<std::string>& subschemata() const { 
      return subschema_list_; 
    }
  private:
    std::string description_;
    std::list<std::string> subschema_list_;
    std::map<std::string, PropertySchema *> subschemata_;
    std::string default_val_;
    bool readonly_;
};

#endif
