/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_CONNECTION_H)
#define __INC_CONNECTION_H

#include "gql++/warnable.h"
#include "gql++/object.h"

/** @name GQL
    @memo The namespace all classes live in
 */
namespace GQL {

class Statement;
class PreparedStatement;
class CallableStatement;
class DatabaseMetaData;

/** Connection.
    This is the base class of the various connections
    provided by the database drivers.
*/
class Connection : public Warnable
{
  public:
    Connection() { }
    virtual ~Connection();

    /// Create a empty statement
    virtual Statement *create_statement() = 0;

    /// Create a prepared statement
    virtual PreparedStatement *prepare_statement(const string& sql) = 0;

    /// Create a callable statement
    virtual CallableStatement *prepare_call(const string& sql) = 0;

    /// Commit the current transaction
    virtual void commit() = 0;

    /// Return true if automatic commitment is enabled
    virtual bool get_auto_commit() const = 0;

    /// Return set automatic commitment
    virtual void set_auto_commit(bool auto_commit = true) = 0;

    /// Rollback current transaction
    virtual void rollback() = 0;
    
    virtual string get_catalog() const = 0;

    /// Returns a string with the native SQL grammar of the database
    virtual string native_sql(const string& sql) const = 0;
    
    virtual DatabaseMetaData *get_meta_data() = 0;

    virtual void set_read_only(bool read_only = true) = 0;
    virtual bool is_read_only() const = 0;

    virtual SQLObject *create_object();
    
    virtual SQLObject *create_blob();
    virtual void destroy_blob(SQLObject *blob);
    
    // Signals
    SigC::Signal0<void> destroy;
};

}

#endif
