/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_DRIVER_MANAGER_H)
#define __INC_DRIVER_MANAGER_H

#include <string>
#include <list>

#include <uc++/plugin.h>

#include "gql++/connection.h"
#include "gql++/driver.h"

namespace GQL
{

/** The DriverManager class.
    
 *  The DriverManager is responsible for opening connections and
 *   managing the drivers.
*/
class DriverManager : public SigC::Object
{
  public:
    DriverManager(uC::PluginManager *mgr = 0, const string& area = "gql");

    ~DriverManager();
    Connection *get_connection(const string &url,
                               const string &name = string(),
                               const string &passwd = string());

    bool register_driver(const string& id);
    void deregister_driver(const string& id);
    list<string> get_registered_drivers() const;
    const uC::PluginNode& get_drivers() const { return(drivers_); }
    Driver *get_driver(const string& id);

    static Driver *load_driver(const string& path, const string& id);
    bool is_auto_load() const { return(auto_load_); }
    void set_auto_load(bool do_auto) { auto_load_ = do_auto; }

    uC::PluginManager *plugin_manager() { return(pm_); }
  private:
    uC::PluginManager *pm_;
    uC::PluginNode drivers_;
    string area_name_;
    bool auto_load_;
};

}

#endif
