/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_DRIVER_H)
#define __INC_DRIVER_H

#include <vector>
#include <map>
#include <string>

#include <sigc++/signal_system.h>

#include <uc++/plugin.h>
#include "gql++/connection.h"

namespace GQL
{

class DriverPropertyInfo
{
  public:
    DriverPropertyInfo(const string& nam,
                       const string& descr = string(),
                       const string& val = string(),
                       bool req = false,
                       const vector<string>& cs = vector<string>())
        : choices_(cs), description_(descr), name_(nam),
          required_(req), value_(val) { }
      
    const vector<string>& choices() const { return(choices_); }
    const string& description() const { return(description_); }
    const string& name() const { return(description_); }
    bool required() const { return(required_); }
    const string& value() const { return(value_); }
  private:
    vector<string> choices_;
    string description_;
    string name_;
    bool required_;
    string value_;
};

class Driver : public uC::Plugin
{
  public:
    Driver(uC::PluginManager *mgr,const string& id, const string& name)
        : uC::Plugin(mgr), id_(id), name_(name) {
    }
    virtual ~Driver();
    
    const string& get_id() const { return(id_); }
    const string& get_name() const { return(name_); }
    int get_major_version() const { return(major_); }
    int get_minor_version() const { return(minor_); }
    virtual vector<DriverPropertyInfo> get_property_info(
            const string& url,
            const map<string, string>& props) const = 0;
    
    virtual bool accept_url(const string& str) const = 0;
    virtual Connection *connect(const string& url, 
                                const map<string, string>& prop) = 0;
    
    SigC::Signal0<void> destroy;

    // From uC::Plugin
    virtual string name() const { return(id_); }
    virtual string description() const { return(name_); }
  protected:
    void set_version(int maj, int min) {
      minor_ = min;
      major_ = maj;
    }
  private:
    int minor_, major_;
    string id_, name_;
};


}

#endif
