#include "database-metadata.h"
#include "result-set.h"

#include "gql++/mod-result-set.h"

namespace GQL
{

namespace MySQL
{

ResultSet *MyDatabaseMetaData::get_tables(
        const string& catalog,
        const string& schema_pattern,
        const string& table_name_pattern,
        const vector<string>& types)
{
  MYSQL_RES *r;
  ModResultSet *result;

  conn_->lock();
  r = mysql_list_tables(conn_->mysql_connection(), "%");
  conn_->unlock();
  
  result = new ModResultSet(5);

  for (int i = 0; i < (int)mysql_num_rows(r); i++)
  {
    string s;
    string name;
    MYSQL_ROW row;
    const string *tuple[5];

    row = mysql_fetch_row(r);

    if (!row)
      continue;
    
    // Table name
    tuple[0] = 0;
    tuple[1] = 0;
    tuple[2] = new string(row[0]);
    tuple[3] = 0;
    tuple[4] = 0;
    
    result->append(tuple);
  }

  mysql_free_result(r);

  destroy.connect(result->destroy.slot());

  return(result);
}

}

}
