#include "statement.h"

namespace GQL
{

namespace PG
{

PGStatement::~PGStatement()
{
  if (result_set_)
    result_set_->unreference();
}

bool PGStatement::execute(const string& sql)
{
  clear_warnings();
  
  if (result_set_)
    result_set_->unreference();
  
  PGConnection *conn = &dynamic_cast<PGConnection&>(*get_connection());
  PGresult *res = conn->exec_sql(sql);

  if (PQresultStatus(res) == PGRES_TUPLES_OK)
  {
    result_set_ = manage(new PGResultSet(conn, res));
    result_set_->reference();
    update_count_ = -1;
  }
  else // must be update count
  {
    result_set_ = 0;
    char *tail, *ntuple_str = PQcmdTuples(res);
    update_count_ = strtol(ntuple_str, &tail, 10);
    if (tail == ntuple_str || *tail != '\0')
      update_count_ = -1;
    PQclear(res);
  }

  return result_set_ != 0;
}

ResultSet *PGStatement::execute_query(const string& sql)
{
  execute(sql);
  
  return result_set_;
}

int PGStatement::execute_update(const string& sql)
{
  execute(sql);
  
  return update_count_;
}

}
}
