#include "statement.h"

namespace GQL
{

namespace SQLite
{

using namespace std;

SQLiteStatement::~SQLiteStatement()
{
  if (result_set_)
    result_set_->unreference();
}

bool SQLiteStatement::execute(const string& sql)
{
  clear_warnings();

  if (result_set_)
    result_set_->unreference();
  
  SQLiteConnection *conn = &dynamic_cast<SQLiteConnection&>(*get_connection());
  result_set_ = conn->exec_sql(sql);
  
  if (result_set_)
  {
    result_set_->reference();
    update_count_ = -1;
  }
  else
    update_count_ = sqlite_changes(conn->sqlite_connection());
  
  return result_set_ != 0;
}

ResultSet *SQLiteStatement::execute_query(const string& sql)
{
  execute(sql);
  
  return(result_set_);
}

int SQLiteStatement::execute_update(const string& sql)
{
  execute(sql);
  
  return(0);
}

}
}
