# $Id: HelpWindow.pm,v 1.2 2003/02/01 17:26:10 jodrell Exp $
package Greenwich::HelpWindow;

use strict;

my $help_screen = "bold:THE WHOIS PROTOCOL

From the Whois RFC (954):

italic:        \"The WHOIS Protocol is a TCP transaction based query/response protocol
italic:        that provides netwide directory service to internet users. The service
italic:        is designed to be user-friendly and the information is delivered in
italic:        human-readable format.\"

Greenwich provides an easy-to-use interface to whois servers around the
Internet.

bold:1.0 USING GREENWICH

bold:1.0.1 Setting a whois server

There are a number of ways of setting the server you wish to query. You can
directly enter the servername into the input box provided. You can also select
from a list of pre-defined servers, including any of the servers in your server
list, by clicking on the arrow button to show a popup menu.

You can also use the 'auto-detect' feature that attempts to guess the whois
server to use. Greenwich knows about almost all the whois servers for global TLDs,
ccTLDs and IP addresses.

bold:1.0.2 Sending a query

You need to specify a whois server to connect to before you can make a query.
You can either enter a specific server in the entry box provided, or pick one
from the drop-down list (see CUSTOMISING for information about extending this
list). You can now enter a query string into the query field, and press the
'Query' button. The response from the whois server is shown in the box below.

bold:1.0.3 Saving a query

If you wish to save the result of a query, use the \"Save\" option from the
File menu, and select a destination file. The output from the server will be
saved to that file.

bold:2.0 CUSTOMISING

bold:2.0.1 The Preferences Dialog

You can customise a Greenwich's behaviour from the Preferences dialog. The
following behaviours are currently configurable:

bold:	1.	Use an external program to make request
		if you need to use an external whois server, you can
		enter the path and arguments for this program here.

bold:	2.	Custom display font
		Click the Font button to open a font selection
		dialog to select a custom font to display whois output.

bold:	3.	Network timeout
		You can enter a different network timeout here. This is
		the time in seconds that Greenwich will wait for a
		connection. If the server has not responded in this
		time, Greenwich will return an error.

bold:2.0.2 Recursive Lookups

The 'recursive lookups' feature of Greenwich behaves in the same way as the
-r flag of the command-line whois client. When recursive lookups are enabled,
Greenwich will look for a string similar to the following:

fixed:	Whois Server: whois.tucows.com

This string is usually found in Registry whois servers and indicates that
further whois information is available from the Registrar whois server.
Greenwich will then query the registrar whois server and append the response
to the output.

Recursive lookups will not work when using an external program. If you wish
to enable recursive lookups while using an external program, simply add the
-r switch to the program call, ie:

fixed:	/usr/local/bin/whois -r -h %h %q

bold:2.0.3 Using the Server List

If you wish to add your own list of servers to those in the drop down list,
use the Server List editor to add and remove servers to the list.

bold:3.0 COPYRIGHT

Copyright (c) 2002 Gavin Brown. All rights reserved. This program is
free software; you can redistribute it and/or modify it under the same
terms as Perl itself.";

# a simple dialogue window for printing the helpfile.
sub new {
	my $package = shift;
	my $self = {};
	$self->{window} = Gtk::Dialog->new();
	$self->{window}->set_default_size(600, 500);
	$self->{ok_button} = Gnome::Stock->button("Button_Ok");
	$self->{ok_button}->signal_connect('clicked', sub{ $self->{window}->destroy() }),
	$self->{text_area} = Gtk::Text->new();
	$self->{text_area}->set_editable(0);
	# load any helvetica:
	$self->{fonts}{normal} = Gtk::Gdk::Font->load("-*-helvetica-medium-r-normal-*-*-140-*-*-*-*-*-*");
	# load any italic helvetica:
	$self->{fonts}{italic} = Gtk::Gdk::Font->load("-*-helvetica-medium-o-normal-*-*-140-*-*-*-*-*-*");
	# load any bold helvetica:
	$self->{fonts}{bold} = Gtk::Gdk::Font->load("-*-helvetica-bold-r-normal-*-*-140-*-*-*-*-*-*");
	# load any courier:
	$self->{fonts}{fixed} = Gtk::Gdk::Font->load("-*-courier-medium-r-normal-*-*-140-*-*-*-*-*-*");
	# parse the help file, the format is trivial:
	foreach (split(/\n/, $help_screen)) {
		$_ .= "\n";
		my ($fmt, $txt) = split(/:/, $_, 2);
		if ($fmt eq 'fixed') {
			$self->{text_area}->insert($self->{fonts}{fixed}, undef, undef, $txt);
		} elsif ($fmt eq 'bold') {
			$self->{text_area}->insert($self->{fonts}{bold}, undef, undef, $txt);
		} elsif ($fmt eq 'italic') {
			$self->{text_area}->insert($self->{fonts}{italic}, undef, undef, $txt);
		} else {
			$self->{text_area}->insert($self->{fonts}{normal}, undef, undef, $_);
		}
	}
	$self->{scrollbar} = Gtk::VScrollbar->new($self->{text_area}->vadj);
	$self->{text_box} = Gtk::HBox->new();
	$self->{text_box}->pack_start($self->{text_area}, 1, 1, 0);
	$self->{text_box}->pack_start($self->{scrollbar}, 0, 0, 0);
	$self->{text_box}->border_width(12);
	$self->{window}->vbox->pack_start($self->{text_box}, 1, 1, 0);
	$self->{window}->action_area->pack_start($self->{ok_button}, 1, 1, 0);
	$self->{window}->show_all();
	$self->{ok_button}->grab_focus();
	return;
}

1;
