# $Id: WhoisMap.pm,v 1.2 2005/06/17 10:57:28 jodrell Exp $

use vars qw(%MAPPINGS %IP_MAPPINGS $TOPLEVEL $AUTHORITY $ADDRESS_LOOKUP_ENABLED);

$^W = 0;
@ISA = qw(Exporter);
@EXPORT = qw(&whois_server &ip_auth);
@EXPORT_OK = qw(%MAPPINGS);
$TOPLEVEL = 'whois.iana.org';

use strict;

our $ADDRESS_LOOKUP_ENABLED = 0;
eval 'use IP::Authority ; $ADDRESS_LOOKUP_ENABLED = 1';

if ($ADDRESS_LOOKUP_ENABLED == 1) {
	$AUTHORITY = IP::Authority->new();
}

# most of this list is taken from the whois client by Marco d'Itri <md@linux.it>:

our %MAPPINGS = (
	'br.com' 	=> 'whois.centralnic.net',
	'cn.com' 	=> 'whois.centralnic.net',
	'eu.com' 	=> 'whois.centralnic.net',
	'gb.com' 	=> 'whois.centralnic.net',
	'gb.net' 	=> 'whois.centralnic.net',
	'hu.com' 	=> 'whois.centralnic.net',
	'no.com' 	=> 'whois.centralnic.net',
	'qc.com' 	=> 'whois.centralnic.net',
	'sa.com' 	=> 'whois.centralnic.net',
	'se.com' 	=> 'whois.centralnic.net',
	'se.net' 	=> 'whois.centralnic.net',
	'uk.com' 	=> 'whois.centralnic.net',
	'uk.net' 	=> 'whois.centralnic.net',
	'us.com' 	=> 'whois.centralnic.net',
	'uy.com' 	=> 'whois.centralnic.net',
	'web.com' 	=> 'whois.centralnic.net',
	'za.com' 	=> 'whois.centralnic.net',
	'eu.org' 	=> 'whois.eu.org',
	'com' 		=> 'whois.crsnic.net',
	'net' 		=> 'whois.crsnic.net',
	'org' 		=> 'whois.publicinterestregistry.net',
	'edu' 		=> 'whois.educause.net',
	'gov' 		=> 'whois.nic.gov',
	'int' 		=> 'whois.icann.org',
	'mil' 		=> 'whois.nic.mil',
	'biz' 		=> 'whois.nic.biz',
	'coop' 		=> 'whois.nic.coop',
	'info' 		=> 'whois.afilias.info',
	'museum' 	=> 'whois.museum',
	'name' 		=> 'whois.nic.name',
	'pro' 		=> 'whois.nic.pro',
	'ac' 		=> 'whois.nic.ac',
	'ag' 		=> 'whois.nic.ag',
	'am' 		=> 'whois.amnic.net',
	'as' 		=> 'whois.nic.as',
	'at' 		=> 'whois.aco.net',
	'net.au' 	=> 'whois.connect.com.au',
	'au' 		=> 'whois.aunic.net',
	'be' 		=> 'whois.dns.be',
	'bg' 		=> 'whois.ripe.net',
	'br' 		=> 'whois.nic.br',
	'bt' 		=> 'whois.nic.tm',
	'bz' 		=> 'whois.belizenic.bz',
	'ca' 		=> 'whois.cira.ca',
	'cc' 		=> 'whois.nic.cc',
	'cd' 		=> 'whois.nic.cd',
	'ch' 		=> 'whois.nic.ch',
	'ci' 		=> 'www.nic.ci',
	'ck' 		=> 'whois.nic.ck',
	'cl' 		=> 'whois.nic.cl',
	'ac.cn' 	=> 'whois.cnc.ac.cn',
	'edu.cn' 	=> 'whois.edu.cn',
	'cn' 		=> 'whois.cnnic.net.cn',
	'uk.co' 	=> 'whois.uk.co',
	'cx' 		=> 'whois.nic.cx',
	'cz' 		=> 'whois.nic.cz',
	'de' 		=> 'whois.denic.de',
	'dk' 		=> 'whois.dk-hostmaster.dk',
	'ee' 		=> 'whois.eenet.ee',
	'fj' 		=> 'whois.usp.ac.fj',
	'fo' 		=> 'whois.ripe.net',
	'fr' 		=> 'whois.nic.fr',
	'gf' 		=> 'whois.nplus.gf',
	'gg' 		=> 'whois.channelisles.net',
	'gl' 		=> 'whois.ripe.net',
	'gm' 		=> 'whois.ripe.net',
	'gs' 		=> 'whois.adamsnames.tc',
	'hm' 		=> 'whois.registry.hm',
	'hu' 		=> 'whois.nic.hu',
	'id' 		=> 'whois.idnic.net.id',
	'ie' 		=> 'whois.domainregistry.ie',
	'il' 		=> 'whois.isoc.org.il',
	'ir' 		=> 'whois.nic.ir',
	'is' 		=> 'whois.isnet.is',
	'it' 		=> 'whois.nic.it',
	'je' 		=> 'whois.channelisles.net',
	'jp' 		=> 'whois.nic.ad.jp',
	'kg' 		=> 'whois.domain.kg',
	'kr' 		=> 'whois.krnic.net',
	'kz' 		=> 'whois.domain.kz',
	'la' 		=> 'whois.nic.la',
	'li' 		=> 'whois.nic.li',
	'lk' 		=> 'whois.nic.lk',
	'lt' 		=> 'whois.ripe.net',
	'lu' 		=> 'whois.restena.lu',
	'lv' 		=> 'whois.ripe.net',
	'mc' 		=> 'whois.ripe.net',
	'mm' 		=> 'whois.nic.mm',
	'ms' 		=> 'whois.adamsnames.tc',
	'mx' 		=> 'whois.nic.mx',
	'nc' 		=> 'whois.cctld.nc',
	'ng' 		=> 'whois.rg.net',
	'nl' 		=> 'whois.domain-registry.nl',
	'no' 		=> 'whois.norid.no',
	'nu' 		=> 'whois.nic.nu',
	'nz' 		=> 'whois.domainz.net.nz',
	'pe' 		=> 'whois.nic.pe',
	'pl' 		=> 'whois.dns.pl',
	'pm' 		=> 'whois.nic.fr',
	'pw' 		=> 'whois.nic.pw',
	're' 		=> 'whois.nic.fr',
	'ro' 		=> 'whois.rotld.ro',
	'ru' 		=> 'whois.ripn.net',
	'se' 		=> 'whois.nic-se.se',
	'sg' 		=> 'whois.nic.net.sg',
	'sh' 		=> 'whois.nic.sh',
	'si' 		=> 'whois.arnes.si',
	'sk' 		=> 'whois.ripe.net',
	'sm' 		=> 'whois.ripe.net',
	'sr' 		=> 'whois.register.sr',
	'st' 		=> 'whois.nic.st',
	'su' 		=> 'whois.ripn.net',
	'tc' 		=> 'whois.adamsnames.tc',
	'tf' 		=> 'whois.adamsnames.tc',
	'th' 		=> 'whois.thnic.net',
	'tj' 		=> 'whois.nic.tj',
	'tk' 		=> 'whois.dot.tk',
	'tm' 		=> 'whois.nic.tm',
	'to' 		=> 'whois.tonic.to',
	'tr' 		=> 'whois.metu.edu.tr',
	'tv' 		=> 'whois.tv',
	'tw' 		=> 'whois.twnic.net',
	'ua' 		=> 'whois.com.ua',
	'ug' 		=> 'www.registry.co.ug',
	'gov.uk' 	=> 'whois.ja.net',
	'ac.uk' 	=> 'whois.ja.net',
	'uk' 		=> 'whois.nic.uk',
	'fed.us' 	=> 'whois.nic.gov',
	'us' 		=> 'whois.nic.us',
	'va' 		=> 'whois.ripe.net',
	'vc' 		=> 'whois.opensrs.net',
	'vg' 		=> 'whois.adamsnames.tc',
	'ws' 		=> 'whois.samoanic.ws',
	'ac.za' 	=> 'whois.ac.za',
	'net.za' 	=> 'whois.net.za',
);

our %IP_MAPPINGS = (
	AR	=> 'whois.arin.net',
	RI	=> 'whois.ripe.net',
	LA	=> 'whois.lacnic.net',
	AP	=> 'whois.apnic.net',
	IA	=> $TOPLEVEL
);

sub whois_server {
	my $domain = shift;
	my ($prefix, $suffix) = split(/\./, $domain, 2);
	return $MAPPINGS{$suffix} if (defined($MAPPINGS{$suffix}));
	# we're reversing the array because (for example) we want to catch uk.nets before .nets:
	my @matches = reverse grep { $domain =~ /\.$_$/i } sort keys %MAPPINGS;
	if (scalar @matches > 0) {
		return $MAPPINGS{$matches[0]};
	} elsif ($ADDRESS_LOOKUP_ENABLED == 1) {
		my $rir_server = ip_auth($domain);
		if (defined($rir_server)) {
			return $rir_server;
		} else {
			return $TOPLEVEL;
		}
	} else {
		return $TOPLEVEL;
	}
}

sub ip_auth {
	my $domain = shift;
	return $IP_MAPPINGS{$AUTHORITY->inet_atoauth($domain)};
}

1;
