#!/bin/sh
# Copyright 2005-2007 ECMWF
# 
# Licensed under the GNU Lesser General Public License which
# incorporates the terms and conditions of version 3 of the GNU
# General Public License.
# See LICENSE and gpl-3.0.txt for details.

# --- test grib edition 2 to 1 conversions with tigge data
# ---   using the new features of grib_compare that allows
# ---   namespace comparison

. ./include.sh

#set -eax 

dir="${data_dir}/tigge/"
temp="temp.grib1_"

# --- Do I want to exclude any file pattern from
# --- comparison ?
exclusion_pattern="tcw|ssr|str|skt|cap|ci|ttr|st|tp"

for file in `ls ${dir}/tigge_*.grib`
do

exclude=`echo $file | awk " /$exclusion_pattern/ {print \"found\";} "`

if [ -z "$exclude" ]; then

	rm -f ${temp} || true

	${tools_dir}grib_set -s editionNumber=1 ${file} ${temp} 2> /dev/null > /dev/null

    # comparing on the data and geography namespace 
    # wanted to do directly -e for edition independent comparison, 
    # but had some problems with the mars namespace, and trying to 
    # blacklist it while -e was on generated a segmentation fault
    # in grib_compare
	${tools_dir}grib_compare -P -c data:n,geography:n ${temp} ${file} 2> /dev/null > /dev/null

	rm -f ${temp} || true
fi

done

