/*
 * This file is part of the GROMACS molecular simulation package.
 *
 * Copyright (c) 2012,2013, by the GROMACS development team, led by
 * Mark Abraham, David van der Spoel, Berk Hess, and Erik Lindahl,
 * and including many others, as listed in the AUTHORS file in the
 * top-level source directory and at http://www.gromacs.org.
 *
 * GROMACS is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * GROMACS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GROMACS; if not, see
 * http://www.gnu.org/licenses, or write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * If you want to redistribute modifications to GROMACS, please
 * consider that scientific software is very special. Version
 * control is crucial - bugs must be traceable. We will be happy to
 * consider code for inclusion in the official distribution, but
 * derived work must not be called official GROMACS. Details are found
 * in the README & COPYING files - if they are missing, get the
 * official version at http://www.gromacs.org.
 *
 * To help us fund GROMACS development, we humbly ask that you cite
 * the research papers on the package. Check out http://www.gromacs.org.
 */
/*
 * Note: this file was generated by the GROMACS avx_256_double kernel generator.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <math.h>

#include "../nb_kernel.h"
#include "types/simple.h"
#include "vec.h"
#include "nrnb.h"

#include "gromacs/simd/math_x86_avx_256_double.h"
#include "kernelutil_x86_avx_256_double.h"

/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecEwSw_VdwLJSw_GeomW3P1_VF_avx_256_double
 * Electrostatics interaction: Ewald
 * VdW interaction:            LennardJones
 * Geometry:                   Water3-Particle
 * Calculate force/pot:        PotentialAndForce
 */
void
nb_kernel_ElecEwSw_VdwLJSw_GeomW3P1_VF_avx_256_double
                    (t_nblist                    * gmx_restrict       nlist,
                     rvec                        * gmx_restrict          xx,
                     rvec                        * gmx_restrict          ff,
                     t_forcerec                  * gmx_restrict          fr,
                     t_mdatoms                   * gmx_restrict     mdatoms,
                     nb_kernel_data_t gmx_unused * gmx_restrict kernel_data,
                     t_nrnb                      * gmx_restrict        nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or 
     * just 0 for non-waters.
     * Suffixes A,B,C,D refer to j loop unrolling done with AVX, e.g. for the four different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB,jnrC,jnrD;
    int              jnrlistA,jnrlistB,jnrlistC,jnrlistD;
    int              jnrlistE,jnrlistF,jnrlistG,jnrlistH;
    int              j_coord_offsetA,j_coord_offsetB,j_coord_offsetC,j_coord_offsetD;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    real             *fjptrA,*fjptrB,*fjptrC,*fjptrD;
    real             scratch[4*DIM];
    __m256d          tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    real *           vdwioffsetptr0;
    __m256d          ix0,iy0,iz0,fix0,fiy0,fiz0,iq0,isai0;
    real *           vdwioffsetptr1;
    __m256d          ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    real *           vdwioffsetptr2;
    __m256d          ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    int              vdwjidx0A,vdwjidx0B,vdwjidx0C,vdwjidx0D;
    __m256d          jx0,jy0,jz0,fjx0,fjy0,fjz0,jq0,isaj0;
    __m256d          dx00,dy00,dz00,rsq00,rinv00,rinvsq00,r00,qq00,c6_00,c12_00;
    __m256d          dx10,dy10,dz10,rsq10,rinv10,rinvsq10,r10,qq10,c6_10,c12_10;
    __m256d          dx20,dy20,dz20,rsq20,rinv20,rinvsq20,r20,qq20,c6_20,c12_20;
    __m256d          velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    int              nvdwtype;
    __m256d          rinvsix,rvdw,vvdw,vvdw6,vvdw12,fvdw,fvdw6,fvdw12,vvdwsum,sh_vdw_invrcut6;
    int              *vdwtype;
    real             *vdwparam;
    __m256d          one_sixth   = _mm256_set1_pd(1.0/6.0);
    __m256d          one_twelfth = _mm256_set1_pd(1.0/12.0);
    __m128i          ewitab;
    __m256d          ewtabscale,eweps,sh_ewald,ewrt,ewtabhalfspace,ewtabF,ewtabFn,ewtabD,ewtabV;
    __m256d          beta,beta2,beta3,zeta2,pmecorrF,pmecorrV,rinv3;
    real             *ewtab;
    __m256d          rswitch,swV3,swV4,swV5,swF2,swF3,swF4,d,d2,sw,dsw;
    real             rswitch_scalar,d_scalar;
    __m256d          dummy_mask,cutoff_mask;
    __m128           tmpmask0,tmpmask1;
    __m256d          signbit = _mm256_castsi256_pd( _mm256_set1_epi32(0x80000000) );
    __m256d          one     = _mm256_set1_pd(1.0);
    __m256d          two     = _mm256_set1_pd(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm256_set1_pd(fr->epsfac);
    charge           = mdatoms->chargeA;
    nvdwtype         = fr->ntype;
    vdwparam         = fr->nbfp;
    vdwtype          = mdatoms->typeA;

    sh_ewald         = _mm256_set1_pd(fr->ic->sh_ewald);
    beta             = _mm256_set1_pd(fr->ic->ewaldcoeff_q);
    beta2            = _mm256_mul_pd(beta,beta);
    beta3            = _mm256_mul_pd(beta,beta2);

    ewtab            = fr->ic->tabq_coul_FDV0;
    ewtabscale       = _mm256_set1_pd(fr->ic->tabq_scale);
    ewtabhalfspace   = _mm256_set1_pd(0.5/fr->ic->tabq_scale);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq0              = _mm256_mul_pd(facel,_mm256_set1_pd(charge[inr+0]));
    iq1              = _mm256_mul_pd(facel,_mm256_set1_pd(charge[inr+1]));
    iq2              = _mm256_mul_pd(facel,_mm256_set1_pd(charge[inr+2]));
    vdwioffsetptr0   = vdwparam+2*nvdwtype*vdwtype[inr+0];

    /* When we use explicit cutoffs the value must be identical for elec and VdW, so use elec as an arbitrary choice */
    rcutoff_scalar   = fr->rcoulomb;
    rcutoff          = _mm256_set1_pd(rcutoff_scalar);
    rcutoff2         = _mm256_mul_pd(rcutoff,rcutoff);

    rswitch_scalar   = fr->rcoulomb_switch;
    rswitch          = _mm256_set1_pd(rswitch_scalar);
    /* Setup switch parameters */
    d_scalar         = rcutoff_scalar-rswitch_scalar;
    d                = _mm256_set1_pd(d_scalar);
    swV3             = _mm256_set1_pd(-10.0/(d_scalar*d_scalar*d_scalar));
    swV4             = _mm256_set1_pd( 15.0/(d_scalar*d_scalar*d_scalar*d_scalar));
    swV5             = _mm256_set1_pd( -6.0/(d_scalar*d_scalar*d_scalar*d_scalar*d_scalar));
    swF2             = _mm256_set1_pd(-30.0/(d_scalar*d_scalar*d_scalar));
    swF3             = _mm256_set1_pd( 60.0/(d_scalar*d_scalar*d_scalar*d_scalar));
    swF4             = _mm256_set1_pd(-30.0/(d_scalar*d_scalar*d_scalar*d_scalar*d_scalar));

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = jnrC = jnrD = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;
    j_coord_offsetC = 0;
    j_coord_offsetD = 0;

    outeriter        = 0;
    inneriter        = 0;

    for(iidx=0;iidx<4*DIM;iidx++)
    {
        scratch[iidx] = 0.0;
    }

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm256_load_shift_and_3rvec_broadcast_pd(shiftvec+i_shift_offset,x+i_coord_offset,
                                                    &ix0,&iy0,&iz0,&ix1,&iy1,&iz1,&ix2,&iy2,&iz2);

        fix0             = _mm256_setzero_pd();
        fiy0             = _mm256_setzero_pd();
        fiz0             = _mm256_setzero_pd();
        fix1             = _mm256_setzero_pd();
        fiy1             = _mm256_setzero_pd();
        fiz1             = _mm256_setzero_pd();
        fix2             = _mm256_setzero_pd();
        fiy2             = _mm256_setzero_pd();
        fiz2             = _mm256_setzero_pd();

        /* Reset potential sums */
        velecsum         = _mm256_setzero_pd();
        vvdwsum          = _mm256_setzero_pd();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end && jjnr[jidx+3]>=0; jidx+=4)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            jnrC             = jjnr[jidx+2];
            jnrD             = jjnr[jidx+3];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;

            /* load j atom coordinates */
            gmx_mm256_load_1rvec_4ptr_swizzle_pd(x+j_coord_offsetA,x+j_coord_offsetB,
                                                 x+j_coord_offsetC,x+j_coord_offsetD,
                                                 &jx0,&jy0,&jz0);

            /* Calculate displacement vector */
            dx00             = _mm256_sub_pd(ix0,jx0);
            dy00             = _mm256_sub_pd(iy0,jy0);
            dz00             = _mm256_sub_pd(iz0,jz0);
            dx10             = _mm256_sub_pd(ix1,jx0);
            dy10             = _mm256_sub_pd(iy1,jy0);
            dz10             = _mm256_sub_pd(iz1,jz0);
            dx20             = _mm256_sub_pd(ix2,jx0);
            dy20             = _mm256_sub_pd(iy2,jy0);
            dz20             = _mm256_sub_pd(iz2,jz0);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm256_calc_rsq_pd(dx00,dy00,dz00);
            rsq10            = gmx_mm256_calc_rsq_pd(dx10,dy10,dz10);
            rsq20            = gmx_mm256_calc_rsq_pd(dx20,dy20,dz20);

            rinv00           = gmx_mm256_invsqrt_pd(rsq00);
            rinv10           = gmx_mm256_invsqrt_pd(rsq10);
            rinv20           = gmx_mm256_invsqrt_pd(rsq20);

            rinvsq00         = _mm256_mul_pd(rinv00,rinv00);
            rinvsq10         = _mm256_mul_pd(rinv10,rinv10);
            rinvsq20         = _mm256_mul_pd(rinv20,rinv20);

            /* Load parameters for j particles */
            jq0              = gmx_mm256_load_4real_swizzle_pd(charge+jnrA+0,charge+jnrB+0,
                                                                 charge+jnrC+0,charge+jnrD+0);
            vdwjidx0A        = 2*vdwtype[jnrA+0];
            vdwjidx0B        = 2*vdwtype[jnrB+0];
            vdwjidx0C        = 2*vdwtype[jnrC+0];
            vdwjidx0D        = 2*vdwtype[jnrD+0];

            fjx0             = _mm256_setzero_pd();
            fjy0             = _mm256_setzero_pd();
            fjz0             = _mm256_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq00,rcutoff2))
            {

            r00              = _mm256_mul_pd(rsq00,rinv00);

            /* Compute parameters for interactions between i and j atoms */
            qq00             = _mm256_mul_pd(iq0,jq0);
            gmx_mm256_load_4pair_swizzle_pd(vdwioffsetptr0+vdwjidx0A,
                                            vdwioffsetptr0+vdwjidx0B,
                                            vdwioffsetptr0+vdwjidx0C,
                                            vdwioffsetptr0+vdwjidx0D,
                                            &c6_00,&c12_00);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm256_mul_pd(r00,ewtabscale);
            ewitab           = _mm256_cvttpd_epi32(ewrt);
            eweps            = _mm256_sub_pd(ewrt,_mm256_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            ewtabV           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,2) );
            ewtabFn          = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,3) );
            GMX_MM256_FULLTRANSPOSE4_PD(ewtabF,ewtabD,ewtabV,ewtabFn);
            felec            = _mm256_add_pd(ewtabF,_mm256_mul_pd(eweps,ewtabD));
            velec            = _mm256_sub_pd(ewtabV,_mm256_mul_pd(_mm256_mul_pd(ewtabhalfspace,eweps),_mm256_add_pd(ewtabF,felec)));
            velec            = _mm256_mul_pd(qq00,_mm256_sub_pd(rinv00,velec));
            felec            = _mm256_mul_pd(_mm256_mul_pd(qq00,rinv00),_mm256_sub_pd(rinvsq00,felec));

            /* LENNARD-JONES DISPERSION/REPULSION */

            rinvsix          = _mm256_mul_pd(_mm256_mul_pd(rinvsq00,rinvsq00),rinvsq00);
            vvdw6            = _mm256_mul_pd(c6_00,rinvsix);
            vvdw12           = _mm256_mul_pd(c12_00,_mm256_mul_pd(rinvsix,rinvsix));
            vvdw             = _mm256_sub_pd( _mm256_mul_pd(vvdw12,one_twelfth) , _mm256_mul_pd(vvdw6,one_sixth) );
            fvdw             = _mm256_mul_pd(_mm256_sub_pd(vvdw12,vvdw6),rinvsq00);

            d                = _mm256_sub_pd(r00,rswitch);
            d                = _mm256_max_pd(d,_mm256_setzero_pd());
            d2               = _mm256_mul_pd(d,d);
            sw               = _mm256_add_pd(one,_mm256_mul_pd(d2,_mm256_mul_pd(d,_mm256_add_pd(swV3,_mm256_mul_pd(d,_mm256_add_pd(swV4,_mm256_mul_pd(d,swV5)))))));

            dsw              = _mm256_mul_pd(d2,_mm256_add_pd(swF2,_mm256_mul_pd(d,_mm256_add_pd(swF3,_mm256_mul_pd(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_pd( _mm256_mul_pd(felec,sw) , _mm256_mul_pd(rinv00,_mm256_mul_pd(velec,dsw)) );
            fvdw             = _mm256_sub_pd( _mm256_mul_pd(fvdw,sw) , _mm256_mul_pd(rinv00,_mm256_mul_pd(vvdw,dsw)) );
            velec            = _mm256_mul_pd(velec,sw);
            vvdw             = _mm256_mul_pd(vvdw,sw);
            cutoff_mask      = _mm256_cmp_pd(rsq00,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_pd(velec,cutoff_mask);
            velecsum         = _mm256_add_pd(velecsum,velec);
            vvdw             = _mm256_and_pd(vvdw,cutoff_mask);
            vvdwsum          = _mm256_add_pd(vvdwsum,vvdw);

            fscal            = _mm256_add_pd(felec,fvdw);

            fscal            = _mm256_and_pd(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_pd(fscal,dx00);
            ty               = _mm256_mul_pd(fscal,dy00);
            tz               = _mm256_mul_pd(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm256_add_pd(fix0,tx);
            fiy0             = _mm256_add_pd(fiy0,ty);
            fiz0             = _mm256_add_pd(fiz0,tz);

            fjx0             = _mm256_add_pd(fjx0,tx);
            fjy0             = _mm256_add_pd(fjy0,ty);
            fjz0             = _mm256_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq10,rcutoff2))
            {

            r10              = _mm256_mul_pd(rsq10,rinv10);

            /* Compute parameters for interactions between i and j atoms */
            qq10             = _mm256_mul_pd(iq1,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm256_mul_pd(r10,ewtabscale);
            ewitab           = _mm256_cvttpd_epi32(ewrt);
            eweps            = _mm256_sub_pd(ewrt,_mm256_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            ewtabV           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,2) );
            ewtabFn          = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,3) );
            GMX_MM256_FULLTRANSPOSE4_PD(ewtabF,ewtabD,ewtabV,ewtabFn);
            felec            = _mm256_add_pd(ewtabF,_mm256_mul_pd(eweps,ewtabD));
            velec            = _mm256_sub_pd(ewtabV,_mm256_mul_pd(_mm256_mul_pd(ewtabhalfspace,eweps),_mm256_add_pd(ewtabF,felec)));
            velec            = _mm256_mul_pd(qq10,_mm256_sub_pd(rinv10,velec));
            felec            = _mm256_mul_pd(_mm256_mul_pd(qq10,rinv10),_mm256_sub_pd(rinvsq10,felec));

            d                = _mm256_sub_pd(r10,rswitch);
            d                = _mm256_max_pd(d,_mm256_setzero_pd());
            d2               = _mm256_mul_pd(d,d);
            sw               = _mm256_add_pd(one,_mm256_mul_pd(d2,_mm256_mul_pd(d,_mm256_add_pd(swV3,_mm256_mul_pd(d,_mm256_add_pd(swV4,_mm256_mul_pd(d,swV5)))))));

            dsw              = _mm256_mul_pd(d2,_mm256_add_pd(swF2,_mm256_mul_pd(d,_mm256_add_pd(swF3,_mm256_mul_pd(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_pd( _mm256_mul_pd(felec,sw) , _mm256_mul_pd(rinv10,_mm256_mul_pd(velec,dsw)) );
            velec            = _mm256_mul_pd(velec,sw);
            cutoff_mask      = _mm256_cmp_pd(rsq10,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_pd(velec,cutoff_mask);
            velecsum         = _mm256_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_pd(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_pd(fscal,dx10);
            ty               = _mm256_mul_pd(fscal,dy10);
            tz               = _mm256_mul_pd(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm256_add_pd(fix1,tx);
            fiy1             = _mm256_add_pd(fiy1,ty);
            fiz1             = _mm256_add_pd(fiz1,tz);

            fjx0             = _mm256_add_pd(fjx0,tx);
            fjy0             = _mm256_add_pd(fjy0,ty);
            fjz0             = _mm256_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq20,rcutoff2))
            {

            r20              = _mm256_mul_pd(rsq20,rinv20);

            /* Compute parameters for interactions between i and j atoms */
            qq20             = _mm256_mul_pd(iq2,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm256_mul_pd(r20,ewtabscale);
            ewitab           = _mm256_cvttpd_epi32(ewrt);
            eweps            = _mm256_sub_pd(ewrt,_mm256_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            ewtabV           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,2) );
            ewtabFn          = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,3) );
            GMX_MM256_FULLTRANSPOSE4_PD(ewtabF,ewtabD,ewtabV,ewtabFn);
            felec            = _mm256_add_pd(ewtabF,_mm256_mul_pd(eweps,ewtabD));
            velec            = _mm256_sub_pd(ewtabV,_mm256_mul_pd(_mm256_mul_pd(ewtabhalfspace,eweps),_mm256_add_pd(ewtabF,felec)));
            velec            = _mm256_mul_pd(qq20,_mm256_sub_pd(rinv20,velec));
            felec            = _mm256_mul_pd(_mm256_mul_pd(qq20,rinv20),_mm256_sub_pd(rinvsq20,felec));

            d                = _mm256_sub_pd(r20,rswitch);
            d                = _mm256_max_pd(d,_mm256_setzero_pd());
            d2               = _mm256_mul_pd(d,d);
            sw               = _mm256_add_pd(one,_mm256_mul_pd(d2,_mm256_mul_pd(d,_mm256_add_pd(swV3,_mm256_mul_pd(d,_mm256_add_pd(swV4,_mm256_mul_pd(d,swV5)))))));

            dsw              = _mm256_mul_pd(d2,_mm256_add_pd(swF2,_mm256_mul_pd(d,_mm256_add_pd(swF3,_mm256_mul_pd(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_pd( _mm256_mul_pd(felec,sw) , _mm256_mul_pd(rinv20,_mm256_mul_pd(velec,dsw)) );
            velec            = _mm256_mul_pd(velec,sw);
            cutoff_mask      = _mm256_cmp_pd(rsq20,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_pd(velec,cutoff_mask);
            velecsum         = _mm256_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_pd(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_pd(fscal,dx20);
            ty               = _mm256_mul_pd(fscal,dy20);
            tz               = _mm256_mul_pd(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm256_add_pd(fix2,tx);
            fiy2             = _mm256_add_pd(fiy2,ty);
            fiz2             = _mm256_add_pd(fiz2,tz);

            fjx0             = _mm256_add_pd(fjx0,tx);
            fjy0             = _mm256_add_pd(fjy0,ty);
            fjz0             = _mm256_add_pd(fjz0,tz);

            }

            fjptrA             = f+j_coord_offsetA;
            fjptrB             = f+j_coord_offsetB;
            fjptrC             = f+j_coord_offsetC;
            fjptrD             = f+j_coord_offsetD;

            gmx_mm256_decrement_1rvec_4ptr_swizzle_pd(fjptrA,fjptrB,fjptrC,fjptrD,fjx0,fjy0,fjz0);

            /* Inner loop uses 216 flops */
        }

        if(jidx<j_index_end)
        {

            /* Get j neighbor index, and coordinate index */
            jnrlistA         = jjnr[jidx];
            jnrlistB         = jjnr[jidx+1];
            jnrlistC         = jjnr[jidx+2];
            jnrlistD         = jjnr[jidx+3];
            /* Sign of each element will be negative for non-real atoms.
             * This mask will be 0xFFFFFFFF for dummy entries and 0x0 for real ones,
             * so use it as val = _mm_andnot_pd(mask,val) to clear dummy entries.
             */
            tmpmask0 = gmx_mm_castsi128_ps(_mm_cmplt_epi32(_mm_loadu_si128((const __m128i *)(jjnr+jidx)),_mm_setzero_si128()));

            tmpmask1 = _mm_permute_ps(tmpmask0,_GMX_MM_PERMUTE(3,3,2,2));
            tmpmask0 = _mm_permute_ps(tmpmask0,_GMX_MM_PERMUTE(1,1,0,0));
            dummy_mask = _mm256_castps_pd(gmx_mm256_set_m128(tmpmask1,tmpmask0));

            jnrA       = (jnrlistA>=0) ? jnrlistA : 0;
            jnrB       = (jnrlistB>=0) ? jnrlistB : 0;
            jnrC       = (jnrlistC>=0) ? jnrlistC : 0;
            jnrD       = (jnrlistD>=0) ? jnrlistD : 0;
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;

            /* load j atom coordinates */
            gmx_mm256_load_1rvec_4ptr_swizzle_pd(x+j_coord_offsetA,x+j_coord_offsetB,
                                                 x+j_coord_offsetC,x+j_coord_offsetD,
                                                 &jx0,&jy0,&jz0);

            /* Calculate displacement vector */
            dx00             = _mm256_sub_pd(ix0,jx0);
            dy00             = _mm256_sub_pd(iy0,jy0);
            dz00             = _mm256_sub_pd(iz0,jz0);
            dx10             = _mm256_sub_pd(ix1,jx0);
            dy10             = _mm256_sub_pd(iy1,jy0);
            dz10             = _mm256_sub_pd(iz1,jz0);
            dx20             = _mm256_sub_pd(ix2,jx0);
            dy20             = _mm256_sub_pd(iy2,jy0);
            dz20             = _mm256_sub_pd(iz2,jz0);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm256_calc_rsq_pd(dx00,dy00,dz00);
            rsq10            = gmx_mm256_calc_rsq_pd(dx10,dy10,dz10);
            rsq20            = gmx_mm256_calc_rsq_pd(dx20,dy20,dz20);

            rinv00           = gmx_mm256_invsqrt_pd(rsq00);
            rinv10           = gmx_mm256_invsqrt_pd(rsq10);
            rinv20           = gmx_mm256_invsqrt_pd(rsq20);

            rinvsq00         = _mm256_mul_pd(rinv00,rinv00);
            rinvsq10         = _mm256_mul_pd(rinv10,rinv10);
            rinvsq20         = _mm256_mul_pd(rinv20,rinv20);

            /* Load parameters for j particles */
            jq0              = gmx_mm256_load_4real_swizzle_pd(charge+jnrA+0,charge+jnrB+0,
                                                                 charge+jnrC+0,charge+jnrD+0);
            vdwjidx0A        = 2*vdwtype[jnrA+0];
            vdwjidx0B        = 2*vdwtype[jnrB+0];
            vdwjidx0C        = 2*vdwtype[jnrC+0];
            vdwjidx0D        = 2*vdwtype[jnrD+0];

            fjx0             = _mm256_setzero_pd();
            fjy0             = _mm256_setzero_pd();
            fjz0             = _mm256_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq00,rcutoff2))
            {

            r00              = _mm256_mul_pd(rsq00,rinv00);
            r00              = _mm256_andnot_pd(dummy_mask,r00);

            /* Compute parameters for interactions between i and j atoms */
            qq00             = _mm256_mul_pd(iq0,jq0);
            gmx_mm256_load_4pair_swizzle_pd(vdwioffsetptr0+vdwjidx0A,
                                            vdwioffsetptr0+vdwjidx0B,
                                            vdwioffsetptr0+vdwjidx0C,
                                            vdwioffsetptr0+vdwjidx0D,
                                            &c6_00,&c12_00);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm256_mul_pd(r00,ewtabscale);
            ewitab           = _mm256_cvttpd_epi32(ewrt);
            eweps            = _mm256_sub_pd(ewrt,_mm256_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            ewtabV           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,2) );
            ewtabFn          = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,3) );
            GMX_MM256_FULLTRANSPOSE4_PD(ewtabF,ewtabD,ewtabV,ewtabFn);
            felec            = _mm256_add_pd(ewtabF,_mm256_mul_pd(eweps,ewtabD));
            velec            = _mm256_sub_pd(ewtabV,_mm256_mul_pd(_mm256_mul_pd(ewtabhalfspace,eweps),_mm256_add_pd(ewtabF,felec)));
            velec            = _mm256_mul_pd(qq00,_mm256_sub_pd(rinv00,velec));
            felec            = _mm256_mul_pd(_mm256_mul_pd(qq00,rinv00),_mm256_sub_pd(rinvsq00,felec));

            /* LENNARD-JONES DISPERSION/REPULSION */

            rinvsix          = _mm256_mul_pd(_mm256_mul_pd(rinvsq00,rinvsq00),rinvsq00);
            vvdw6            = _mm256_mul_pd(c6_00,rinvsix);
            vvdw12           = _mm256_mul_pd(c12_00,_mm256_mul_pd(rinvsix,rinvsix));
            vvdw             = _mm256_sub_pd( _mm256_mul_pd(vvdw12,one_twelfth) , _mm256_mul_pd(vvdw6,one_sixth) );
            fvdw             = _mm256_mul_pd(_mm256_sub_pd(vvdw12,vvdw6),rinvsq00);

            d                = _mm256_sub_pd(r00,rswitch);
            d                = _mm256_max_pd(d,_mm256_setzero_pd());
            d2               = _mm256_mul_pd(d,d);
            sw               = _mm256_add_pd(one,_mm256_mul_pd(d2,_mm256_mul_pd(d,_mm256_add_pd(swV3,_mm256_mul_pd(d,_mm256_add_pd(swV4,_mm256_mul_pd(d,swV5)))))));

            dsw              = _mm256_mul_pd(d2,_mm256_add_pd(swF2,_mm256_mul_pd(d,_mm256_add_pd(swF3,_mm256_mul_pd(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_pd( _mm256_mul_pd(felec,sw) , _mm256_mul_pd(rinv00,_mm256_mul_pd(velec,dsw)) );
            fvdw             = _mm256_sub_pd( _mm256_mul_pd(fvdw,sw) , _mm256_mul_pd(rinv00,_mm256_mul_pd(vvdw,dsw)) );
            velec            = _mm256_mul_pd(velec,sw);
            vvdw             = _mm256_mul_pd(vvdw,sw);
            cutoff_mask      = _mm256_cmp_pd(rsq00,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_pd(velec,cutoff_mask);
            velec            = _mm256_andnot_pd(dummy_mask,velec);
            velecsum         = _mm256_add_pd(velecsum,velec);
            vvdw             = _mm256_and_pd(vvdw,cutoff_mask);
            vvdw             = _mm256_andnot_pd(dummy_mask,vvdw);
            vvdwsum          = _mm256_add_pd(vvdwsum,vvdw);

            fscal            = _mm256_add_pd(felec,fvdw);

            fscal            = _mm256_and_pd(fscal,cutoff_mask);

            fscal            = _mm256_andnot_pd(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_pd(fscal,dx00);
            ty               = _mm256_mul_pd(fscal,dy00);
            tz               = _mm256_mul_pd(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm256_add_pd(fix0,tx);
            fiy0             = _mm256_add_pd(fiy0,ty);
            fiz0             = _mm256_add_pd(fiz0,tz);

            fjx0             = _mm256_add_pd(fjx0,tx);
            fjy0             = _mm256_add_pd(fjy0,ty);
            fjz0             = _mm256_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq10,rcutoff2))
            {

            r10              = _mm256_mul_pd(rsq10,rinv10);
            r10              = _mm256_andnot_pd(dummy_mask,r10);

            /* Compute parameters for interactions between i and j atoms */
            qq10             = _mm256_mul_pd(iq1,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm256_mul_pd(r10,ewtabscale);
            ewitab           = _mm256_cvttpd_epi32(ewrt);
            eweps            = _mm256_sub_pd(ewrt,_mm256_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            ewtabV           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,2) );
            ewtabFn          = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,3) );
            GMX_MM256_FULLTRANSPOSE4_PD(ewtabF,ewtabD,ewtabV,ewtabFn);
            felec            = _mm256_add_pd(ewtabF,_mm256_mul_pd(eweps,ewtabD));
            velec            = _mm256_sub_pd(ewtabV,_mm256_mul_pd(_mm256_mul_pd(ewtabhalfspace,eweps),_mm256_add_pd(ewtabF,felec)));
            velec            = _mm256_mul_pd(qq10,_mm256_sub_pd(rinv10,velec));
            felec            = _mm256_mul_pd(_mm256_mul_pd(qq10,rinv10),_mm256_sub_pd(rinvsq10,felec));

            d                = _mm256_sub_pd(r10,rswitch);
            d                = _mm256_max_pd(d,_mm256_setzero_pd());
            d2               = _mm256_mul_pd(d,d);
            sw               = _mm256_add_pd(one,_mm256_mul_pd(d2,_mm256_mul_pd(d,_mm256_add_pd(swV3,_mm256_mul_pd(d,_mm256_add_pd(swV4,_mm256_mul_pd(d,swV5)))))));

            dsw              = _mm256_mul_pd(d2,_mm256_add_pd(swF2,_mm256_mul_pd(d,_mm256_add_pd(swF3,_mm256_mul_pd(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_pd( _mm256_mul_pd(felec,sw) , _mm256_mul_pd(rinv10,_mm256_mul_pd(velec,dsw)) );
            velec            = _mm256_mul_pd(velec,sw);
            cutoff_mask      = _mm256_cmp_pd(rsq10,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_pd(velec,cutoff_mask);
            velec            = _mm256_andnot_pd(dummy_mask,velec);
            velecsum         = _mm256_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_pd(fscal,cutoff_mask);

            fscal            = _mm256_andnot_pd(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_pd(fscal,dx10);
            ty               = _mm256_mul_pd(fscal,dy10);
            tz               = _mm256_mul_pd(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm256_add_pd(fix1,tx);
            fiy1             = _mm256_add_pd(fiy1,ty);
            fiz1             = _mm256_add_pd(fiz1,tz);

            fjx0             = _mm256_add_pd(fjx0,tx);
            fjy0             = _mm256_add_pd(fjy0,ty);
            fjz0             = _mm256_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq20,rcutoff2))
            {

            r20              = _mm256_mul_pd(rsq20,rinv20);
            r20              = _mm256_andnot_pd(dummy_mask,r20);

            /* Compute parameters for interactions between i and j atoms */
            qq20             = _mm256_mul_pd(iq2,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm256_mul_pd(r20,ewtabscale);
            ewitab           = _mm256_cvttpd_epi32(ewrt);
            eweps            = _mm256_sub_pd(ewrt,_mm256_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            ewtabV           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,2) );
            ewtabFn          = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,3) );
            GMX_MM256_FULLTRANSPOSE4_PD(ewtabF,ewtabD,ewtabV,ewtabFn);
            felec            = _mm256_add_pd(ewtabF,_mm256_mul_pd(eweps,ewtabD));
            velec            = _mm256_sub_pd(ewtabV,_mm256_mul_pd(_mm256_mul_pd(ewtabhalfspace,eweps),_mm256_add_pd(ewtabF,felec)));
            velec            = _mm256_mul_pd(qq20,_mm256_sub_pd(rinv20,velec));
            felec            = _mm256_mul_pd(_mm256_mul_pd(qq20,rinv20),_mm256_sub_pd(rinvsq20,felec));

            d                = _mm256_sub_pd(r20,rswitch);
            d                = _mm256_max_pd(d,_mm256_setzero_pd());
            d2               = _mm256_mul_pd(d,d);
            sw               = _mm256_add_pd(one,_mm256_mul_pd(d2,_mm256_mul_pd(d,_mm256_add_pd(swV3,_mm256_mul_pd(d,_mm256_add_pd(swV4,_mm256_mul_pd(d,swV5)))))));

            dsw              = _mm256_mul_pd(d2,_mm256_add_pd(swF2,_mm256_mul_pd(d,_mm256_add_pd(swF3,_mm256_mul_pd(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_pd( _mm256_mul_pd(felec,sw) , _mm256_mul_pd(rinv20,_mm256_mul_pd(velec,dsw)) );
            velec            = _mm256_mul_pd(velec,sw);
            cutoff_mask      = _mm256_cmp_pd(rsq20,rcutoff2,_CMP_LT_OQ);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm256_and_pd(velec,cutoff_mask);
            velec            = _mm256_andnot_pd(dummy_mask,velec);
            velecsum         = _mm256_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm256_and_pd(fscal,cutoff_mask);

            fscal            = _mm256_andnot_pd(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_pd(fscal,dx20);
            ty               = _mm256_mul_pd(fscal,dy20);
            tz               = _mm256_mul_pd(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm256_add_pd(fix2,tx);
            fiy2             = _mm256_add_pd(fiy2,ty);
            fiz2             = _mm256_add_pd(fiz2,tz);

            fjx0             = _mm256_add_pd(fjx0,tx);
            fjy0             = _mm256_add_pd(fjy0,ty);
            fjz0             = _mm256_add_pd(fjz0,tz);

            }

            fjptrA             = (jnrlistA>=0) ? f+j_coord_offsetA : scratch;
            fjptrB             = (jnrlistB>=0) ? f+j_coord_offsetB : scratch;
            fjptrC             = (jnrlistC>=0) ? f+j_coord_offsetC : scratch;
            fjptrD             = (jnrlistD>=0) ? f+j_coord_offsetD : scratch;

            gmx_mm256_decrement_1rvec_4ptr_swizzle_pd(fjptrA,fjptrB,fjptrC,fjptrD,fjx0,fjy0,fjz0);

            /* Inner loop uses 219 flops */
        }

        /* End of innermost loop */

        gmx_mm256_update_iforce_3atom_swizzle_pd(fix0,fiy0,fiz0,fix1,fiy1,fiz1,fix2,fiy2,fiz2,
                                                 f+i_coord_offset,fshift+i_shift_offset);

        ggid                        = gid[iidx];
        /* Update potential energies */
        gmx_mm256_update_1pot_pd(velecsum,kernel_data->energygrp_elec+ggid);
        gmx_mm256_update_1pot_pd(vvdwsum,kernel_data->energygrp_vdw+ggid);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 20 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_VDW_W3_VF,outeriter*20 + inneriter*219);
}
/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecEwSw_VdwLJSw_GeomW3P1_F_avx_256_double
 * Electrostatics interaction: Ewald
 * VdW interaction:            LennardJones
 * Geometry:                   Water3-Particle
 * Calculate force/pot:        Force
 */
void
nb_kernel_ElecEwSw_VdwLJSw_GeomW3P1_F_avx_256_double
                    (t_nblist                    * gmx_restrict       nlist,
                     rvec                        * gmx_restrict          xx,
                     rvec                        * gmx_restrict          ff,
                     t_forcerec                  * gmx_restrict          fr,
                     t_mdatoms                   * gmx_restrict     mdatoms,
                     nb_kernel_data_t gmx_unused * gmx_restrict kernel_data,
                     t_nrnb                      * gmx_restrict        nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or 
     * just 0 for non-waters.
     * Suffixes A,B,C,D refer to j loop unrolling done with AVX, e.g. for the four different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB,jnrC,jnrD;
    int              jnrlistA,jnrlistB,jnrlistC,jnrlistD;
    int              jnrlistE,jnrlistF,jnrlistG,jnrlistH;
    int              j_coord_offsetA,j_coord_offsetB,j_coord_offsetC,j_coord_offsetD;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    real             *fjptrA,*fjptrB,*fjptrC,*fjptrD;
    real             scratch[4*DIM];
    __m256d          tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    real *           vdwioffsetptr0;
    __m256d          ix0,iy0,iz0,fix0,fiy0,fiz0,iq0,isai0;
    real *           vdwioffsetptr1;
    __m256d          ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    real *           vdwioffsetptr2;
    __m256d          ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    int              vdwjidx0A,vdwjidx0B,vdwjidx0C,vdwjidx0D;
    __m256d          jx0,jy0,jz0,fjx0,fjy0,fjz0,jq0,isaj0;
    __m256d          dx00,dy00,dz00,rsq00,rinv00,rinvsq00,r00,qq00,c6_00,c12_00;
    __m256d          dx10,dy10,dz10,rsq10,rinv10,rinvsq10,r10,qq10,c6_10,c12_10;
    __m256d          dx20,dy20,dz20,rsq20,rinv20,rinvsq20,r20,qq20,c6_20,c12_20;
    __m256d          velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    int              nvdwtype;
    __m256d          rinvsix,rvdw,vvdw,vvdw6,vvdw12,fvdw,fvdw6,fvdw12,vvdwsum,sh_vdw_invrcut6;
    int              *vdwtype;
    real             *vdwparam;
    __m256d          one_sixth   = _mm256_set1_pd(1.0/6.0);
    __m256d          one_twelfth = _mm256_set1_pd(1.0/12.0);
    __m128i          ewitab;
    __m256d          ewtabscale,eweps,sh_ewald,ewrt,ewtabhalfspace,ewtabF,ewtabFn,ewtabD,ewtabV;
    __m256d          beta,beta2,beta3,zeta2,pmecorrF,pmecorrV,rinv3;
    real             *ewtab;
    __m256d          rswitch,swV3,swV4,swV5,swF2,swF3,swF4,d,d2,sw,dsw;
    real             rswitch_scalar,d_scalar;
    __m256d          dummy_mask,cutoff_mask;
    __m128           tmpmask0,tmpmask1;
    __m256d          signbit = _mm256_castsi256_pd( _mm256_set1_epi32(0x80000000) );
    __m256d          one     = _mm256_set1_pd(1.0);
    __m256d          two     = _mm256_set1_pd(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm256_set1_pd(fr->epsfac);
    charge           = mdatoms->chargeA;
    nvdwtype         = fr->ntype;
    vdwparam         = fr->nbfp;
    vdwtype          = mdatoms->typeA;

    sh_ewald         = _mm256_set1_pd(fr->ic->sh_ewald);
    beta             = _mm256_set1_pd(fr->ic->ewaldcoeff_q);
    beta2            = _mm256_mul_pd(beta,beta);
    beta3            = _mm256_mul_pd(beta,beta2);

    ewtab            = fr->ic->tabq_coul_FDV0;
    ewtabscale       = _mm256_set1_pd(fr->ic->tabq_scale);
    ewtabhalfspace   = _mm256_set1_pd(0.5/fr->ic->tabq_scale);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq0              = _mm256_mul_pd(facel,_mm256_set1_pd(charge[inr+0]));
    iq1              = _mm256_mul_pd(facel,_mm256_set1_pd(charge[inr+1]));
    iq2              = _mm256_mul_pd(facel,_mm256_set1_pd(charge[inr+2]));
    vdwioffsetptr0   = vdwparam+2*nvdwtype*vdwtype[inr+0];

    /* When we use explicit cutoffs the value must be identical for elec and VdW, so use elec as an arbitrary choice */
    rcutoff_scalar   = fr->rcoulomb;
    rcutoff          = _mm256_set1_pd(rcutoff_scalar);
    rcutoff2         = _mm256_mul_pd(rcutoff,rcutoff);

    rswitch_scalar   = fr->rcoulomb_switch;
    rswitch          = _mm256_set1_pd(rswitch_scalar);
    /* Setup switch parameters */
    d_scalar         = rcutoff_scalar-rswitch_scalar;
    d                = _mm256_set1_pd(d_scalar);
    swV3             = _mm256_set1_pd(-10.0/(d_scalar*d_scalar*d_scalar));
    swV4             = _mm256_set1_pd( 15.0/(d_scalar*d_scalar*d_scalar*d_scalar));
    swV5             = _mm256_set1_pd( -6.0/(d_scalar*d_scalar*d_scalar*d_scalar*d_scalar));
    swF2             = _mm256_set1_pd(-30.0/(d_scalar*d_scalar*d_scalar));
    swF3             = _mm256_set1_pd( 60.0/(d_scalar*d_scalar*d_scalar*d_scalar));
    swF4             = _mm256_set1_pd(-30.0/(d_scalar*d_scalar*d_scalar*d_scalar*d_scalar));

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = jnrC = jnrD = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;
    j_coord_offsetC = 0;
    j_coord_offsetD = 0;

    outeriter        = 0;
    inneriter        = 0;

    for(iidx=0;iidx<4*DIM;iidx++)
    {
        scratch[iidx] = 0.0;
    }

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm256_load_shift_and_3rvec_broadcast_pd(shiftvec+i_shift_offset,x+i_coord_offset,
                                                    &ix0,&iy0,&iz0,&ix1,&iy1,&iz1,&ix2,&iy2,&iz2);

        fix0             = _mm256_setzero_pd();
        fiy0             = _mm256_setzero_pd();
        fiz0             = _mm256_setzero_pd();
        fix1             = _mm256_setzero_pd();
        fiy1             = _mm256_setzero_pd();
        fiz1             = _mm256_setzero_pd();
        fix2             = _mm256_setzero_pd();
        fiy2             = _mm256_setzero_pd();
        fiz2             = _mm256_setzero_pd();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end && jjnr[jidx+3]>=0; jidx+=4)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            jnrC             = jjnr[jidx+2];
            jnrD             = jjnr[jidx+3];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;

            /* load j atom coordinates */
            gmx_mm256_load_1rvec_4ptr_swizzle_pd(x+j_coord_offsetA,x+j_coord_offsetB,
                                                 x+j_coord_offsetC,x+j_coord_offsetD,
                                                 &jx0,&jy0,&jz0);

            /* Calculate displacement vector */
            dx00             = _mm256_sub_pd(ix0,jx0);
            dy00             = _mm256_sub_pd(iy0,jy0);
            dz00             = _mm256_sub_pd(iz0,jz0);
            dx10             = _mm256_sub_pd(ix1,jx0);
            dy10             = _mm256_sub_pd(iy1,jy0);
            dz10             = _mm256_sub_pd(iz1,jz0);
            dx20             = _mm256_sub_pd(ix2,jx0);
            dy20             = _mm256_sub_pd(iy2,jy0);
            dz20             = _mm256_sub_pd(iz2,jz0);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm256_calc_rsq_pd(dx00,dy00,dz00);
            rsq10            = gmx_mm256_calc_rsq_pd(dx10,dy10,dz10);
            rsq20            = gmx_mm256_calc_rsq_pd(dx20,dy20,dz20);

            rinv00           = gmx_mm256_invsqrt_pd(rsq00);
            rinv10           = gmx_mm256_invsqrt_pd(rsq10);
            rinv20           = gmx_mm256_invsqrt_pd(rsq20);

            rinvsq00         = _mm256_mul_pd(rinv00,rinv00);
            rinvsq10         = _mm256_mul_pd(rinv10,rinv10);
            rinvsq20         = _mm256_mul_pd(rinv20,rinv20);

            /* Load parameters for j particles */
            jq0              = gmx_mm256_load_4real_swizzle_pd(charge+jnrA+0,charge+jnrB+0,
                                                                 charge+jnrC+0,charge+jnrD+0);
            vdwjidx0A        = 2*vdwtype[jnrA+0];
            vdwjidx0B        = 2*vdwtype[jnrB+0];
            vdwjidx0C        = 2*vdwtype[jnrC+0];
            vdwjidx0D        = 2*vdwtype[jnrD+0];

            fjx0             = _mm256_setzero_pd();
            fjy0             = _mm256_setzero_pd();
            fjz0             = _mm256_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq00,rcutoff2))
            {

            r00              = _mm256_mul_pd(rsq00,rinv00);

            /* Compute parameters for interactions between i and j atoms */
            qq00             = _mm256_mul_pd(iq0,jq0);
            gmx_mm256_load_4pair_swizzle_pd(vdwioffsetptr0+vdwjidx0A,
                                            vdwioffsetptr0+vdwjidx0B,
                                            vdwioffsetptr0+vdwjidx0C,
                                            vdwioffsetptr0+vdwjidx0D,
                                            &c6_00,&c12_00);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm256_mul_pd(r00,ewtabscale);
            ewitab           = _mm256_cvttpd_epi32(ewrt);
            eweps            = _mm256_sub_pd(ewrt,_mm256_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            ewtabV           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,2) );
            ewtabFn          = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,3) );
            GMX_MM256_FULLTRANSPOSE4_PD(ewtabF,ewtabD,ewtabV,ewtabFn);
            felec            = _mm256_add_pd(ewtabF,_mm256_mul_pd(eweps,ewtabD));
            velec            = _mm256_sub_pd(ewtabV,_mm256_mul_pd(_mm256_mul_pd(ewtabhalfspace,eweps),_mm256_add_pd(ewtabF,felec)));
            velec            = _mm256_mul_pd(qq00,_mm256_sub_pd(rinv00,velec));
            felec            = _mm256_mul_pd(_mm256_mul_pd(qq00,rinv00),_mm256_sub_pd(rinvsq00,felec));

            /* LENNARD-JONES DISPERSION/REPULSION */

            rinvsix          = _mm256_mul_pd(_mm256_mul_pd(rinvsq00,rinvsq00),rinvsq00);
            vvdw6            = _mm256_mul_pd(c6_00,rinvsix);
            vvdw12           = _mm256_mul_pd(c12_00,_mm256_mul_pd(rinvsix,rinvsix));
            vvdw             = _mm256_sub_pd( _mm256_mul_pd(vvdw12,one_twelfth) , _mm256_mul_pd(vvdw6,one_sixth) );
            fvdw             = _mm256_mul_pd(_mm256_sub_pd(vvdw12,vvdw6),rinvsq00);

            d                = _mm256_sub_pd(r00,rswitch);
            d                = _mm256_max_pd(d,_mm256_setzero_pd());
            d2               = _mm256_mul_pd(d,d);
            sw               = _mm256_add_pd(one,_mm256_mul_pd(d2,_mm256_mul_pd(d,_mm256_add_pd(swV3,_mm256_mul_pd(d,_mm256_add_pd(swV4,_mm256_mul_pd(d,swV5)))))));

            dsw              = _mm256_mul_pd(d2,_mm256_add_pd(swF2,_mm256_mul_pd(d,_mm256_add_pd(swF3,_mm256_mul_pd(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_pd( _mm256_mul_pd(felec,sw) , _mm256_mul_pd(rinv00,_mm256_mul_pd(velec,dsw)) );
            fvdw             = _mm256_sub_pd( _mm256_mul_pd(fvdw,sw) , _mm256_mul_pd(rinv00,_mm256_mul_pd(vvdw,dsw)) );
            cutoff_mask      = _mm256_cmp_pd(rsq00,rcutoff2,_CMP_LT_OQ);

            fscal            = _mm256_add_pd(felec,fvdw);

            fscal            = _mm256_and_pd(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_pd(fscal,dx00);
            ty               = _mm256_mul_pd(fscal,dy00);
            tz               = _mm256_mul_pd(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm256_add_pd(fix0,tx);
            fiy0             = _mm256_add_pd(fiy0,ty);
            fiz0             = _mm256_add_pd(fiz0,tz);

            fjx0             = _mm256_add_pd(fjx0,tx);
            fjy0             = _mm256_add_pd(fjy0,ty);
            fjz0             = _mm256_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq10,rcutoff2))
            {

            r10              = _mm256_mul_pd(rsq10,rinv10);

            /* Compute parameters for interactions between i and j atoms */
            qq10             = _mm256_mul_pd(iq1,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm256_mul_pd(r10,ewtabscale);
            ewitab           = _mm256_cvttpd_epi32(ewrt);
            eweps            = _mm256_sub_pd(ewrt,_mm256_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            ewtabV           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,2) );
            ewtabFn          = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,3) );
            GMX_MM256_FULLTRANSPOSE4_PD(ewtabF,ewtabD,ewtabV,ewtabFn);
            felec            = _mm256_add_pd(ewtabF,_mm256_mul_pd(eweps,ewtabD));
            velec            = _mm256_sub_pd(ewtabV,_mm256_mul_pd(_mm256_mul_pd(ewtabhalfspace,eweps),_mm256_add_pd(ewtabF,felec)));
            velec            = _mm256_mul_pd(qq10,_mm256_sub_pd(rinv10,velec));
            felec            = _mm256_mul_pd(_mm256_mul_pd(qq10,rinv10),_mm256_sub_pd(rinvsq10,felec));

            d                = _mm256_sub_pd(r10,rswitch);
            d                = _mm256_max_pd(d,_mm256_setzero_pd());
            d2               = _mm256_mul_pd(d,d);
            sw               = _mm256_add_pd(one,_mm256_mul_pd(d2,_mm256_mul_pd(d,_mm256_add_pd(swV3,_mm256_mul_pd(d,_mm256_add_pd(swV4,_mm256_mul_pd(d,swV5)))))));

            dsw              = _mm256_mul_pd(d2,_mm256_add_pd(swF2,_mm256_mul_pd(d,_mm256_add_pd(swF3,_mm256_mul_pd(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_pd( _mm256_mul_pd(felec,sw) , _mm256_mul_pd(rinv10,_mm256_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_pd(rsq10,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_pd(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_pd(fscal,dx10);
            ty               = _mm256_mul_pd(fscal,dy10);
            tz               = _mm256_mul_pd(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm256_add_pd(fix1,tx);
            fiy1             = _mm256_add_pd(fiy1,ty);
            fiz1             = _mm256_add_pd(fiz1,tz);

            fjx0             = _mm256_add_pd(fjx0,tx);
            fjy0             = _mm256_add_pd(fjy0,ty);
            fjz0             = _mm256_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq20,rcutoff2))
            {

            r20              = _mm256_mul_pd(rsq20,rinv20);

            /* Compute parameters for interactions between i and j atoms */
            qq20             = _mm256_mul_pd(iq2,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm256_mul_pd(r20,ewtabscale);
            ewitab           = _mm256_cvttpd_epi32(ewrt);
            eweps            = _mm256_sub_pd(ewrt,_mm256_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            ewtabV           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,2) );
            ewtabFn          = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,3) );
            GMX_MM256_FULLTRANSPOSE4_PD(ewtabF,ewtabD,ewtabV,ewtabFn);
            felec            = _mm256_add_pd(ewtabF,_mm256_mul_pd(eweps,ewtabD));
            velec            = _mm256_sub_pd(ewtabV,_mm256_mul_pd(_mm256_mul_pd(ewtabhalfspace,eweps),_mm256_add_pd(ewtabF,felec)));
            velec            = _mm256_mul_pd(qq20,_mm256_sub_pd(rinv20,velec));
            felec            = _mm256_mul_pd(_mm256_mul_pd(qq20,rinv20),_mm256_sub_pd(rinvsq20,felec));

            d                = _mm256_sub_pd(r20,rswitch);
            d                = _mm256_max_pd(d,_mm256_setzero_pd());
            d2               = _mm256_mul_pd(d,d);
            sw               = _mm256_add_pd(one,_mm256_mul_pd(d2,_mm256_mul_pd(d,_mm256_add_pd(swV3,_mm256_mul_pd(d,_mm256_add_pd(swV4,_mm256_mul_pd(d,swV5)))))));

            dsw              = _mm256_mul_pd(d2,_mm256_add_pd(swF2,_mm256_mul_pd(d,_mm256_add_pd(swF3,_mm256_mul_pd(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_pd( _mm256_mul_pd(felec,sw) , _mm256_mul_pd(rinv20,_mm256_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_pd(rsq20,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_pd(fscal,cutoff_mask);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_pd(fscal,dx20);
            ty               = _mm256_mul_pd(fscal,dy20);
            tz               = _mm256_mul_pd(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm256_add_pd(fix2,tx);
            fiy2             = _mm256_add_pd(fiy2,ty);
            fiz2             = _mm256_add_pd(fiz2,tz);

            fjx0             = _mm256_add_pd(fjx0,tx);
            fjy0             = _mm256_add_pd(fjy0,ty);
            fjz0             = _mm256_add_pd(fjz0,tz);

            }

            fjptrA             = f+j_coord_offsetA;
            fjptrB             = f+j_coord_offsetB;
            fjptrC             = f+j_coord_offsetC;
            fjptrD             = f+j_coord_offsetD;

            gmx_mm256_decrement_1rvec_4ptr_swizzle_pd(fjptrA,fjptrB,fjptrC,fjptrD,fjx0,fjy0,fjz0);

            /* Inner loop uses 204 flops */
        }

        if(jidx<j_index_end)
        {

            /* Get j neighbor index, and coordinate index */
            jnrlistA         = jjnr[jidx];
            jnrlistB         = jjnr[jidx+1];
            jnrlistC         = jjnr[jidx+2];
            jnrlistD         = jjnr[jidx+3];
            /* Sign of each element will be negative for non-real atoms.
             * This mask will be 0xFFFFFFFF for dummy entries and 0x0 for real ones,
             * so use it as val = _mm_andnot_pd(mask,val) to clear dummy entries.
             */
            tmpmask0 = gmx_mm_castsi128_ps(_mm_cmplt_epi32(_mm_loadu_si128((const __m128i *)(jjnr+jidx)),_mm_setzero_si128()));

            tmpmask1 = _mm_permute_ps(tmpmask0,_GMX_MM_PERMUTE(3,3,2,2));
            tmpmask0 = _mm_permute_ps(tmpmask0,_GMX_MM_PERMUTE(1,1,0,0));
            dummy_mask = _mm256_castps_pd(gmx_mm256_set_m128(tmpmask1,tmpmask0));

            jnrA       = (jnrlistA>=0) ? jnrlistA : 0;
            jnrB       = (jnrlistB>=0) ? jnrlistB : 0;
            jnrC       = (jnrlistC>=0) ? jnrlistC : 0;
            jnrD       = (jnrlistD>=0) ? jnrlistD : 0;
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;

            /* load j atom coordinates */
            gmx_mm256_load_1rvec_4ptr_swizzle_pd(x+j_coord_offsetA,x+j_coord_offsetB,
                                                 x+j_coord_offsetC,x+j_coord_offsetD,
                                                 &jx0,&jy0,&jz0);

            /* Calculate displacement vector */
            dx00             = _mm256_sub_pd(ix0,jx0);
            dy00             = _mm256_sub_pd(iy0,jy0);
            dz00             = _mm256_sub_pd(iz0,jz0);
            dx10             = _mm256_sub_pd(ix1,jx0);
            dy10             = _mm256_sub_pd(iy1,jy0);
            dz10             = _mm256_sub_pd(iz1,jz0);
            dx20             = _mm256_sub_pd(ix2,jx0);
            dy20             = _mm256_sub_pd(iy2,jy0);
            dz20             = _mm256_sub_pd(iz2,jz0);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_mm256_calc_rsq_pd(dx00,dy00,dz00);
            rsq10            = gmx_mm256_calc_rsq_pd(dx10,dy10,dz10);
            rsq20            = gmx_mm256_calc_rsq_pd(dx20,dy20,dz20);

            rinv00           = gmx_mm256_invsqrt_pd(rsq00);
            rinv10           = gmx_mm256_invsqrt_pd(rsq10);
            rinv20           = gmx_mm256_invsqrt_pd(rsq20);

            rinvsq00         = _mm256_mul_pd(rinv00,rinv00);
            rinvsq10         = _mm256_mul_pd(rinv10,rinv10);
            rinvsq20         = _mm256_mul_pd(rinv20,rinv20);

            /* Load parameters for j particles */
            jq0              = gmx_mm256_load_4real_swizzle_pd(charge+jnrA+0,charge+jnrB+0,
                                                                 charge+jnrC+0,charge+jnrD+0);
            vdwjidx0A        = 2*vdwtype[jnrA+0];
            vdwjidx0B        = 2*vdwtype[jnrB+0];
            vdwjidx0C        = 2*vdwtype[jnrC+0];
            vdwjidx0D        = 2*vdwtype[jnrD+0];

            fjx0             = _mm256_setzero_pd();
            fjy0             = _mm256_setzero_pd();
            fjz0             = _mm256_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq00,rcutoff2))
            {

            r00              = _mm256_mul_pd(rsq00,rinv00);
            r00              = _mm256_andnot_pd(dummy_mask,r00);

            /* Compute parameters for interactions between i and j atoms */
            qq00             = _mm256_mul_pd(iq0,jq0);
            gmx_mm256_load_4pair_swizzle_pd(vdwioffsetptr0+vdwjidx0A,
                                            vdwioffsetptr0+vdwjidx0B,
                                            vdwioffsetptr0+vdwjidx0C,
                                            vdwioffsetptr0+vdwjidx0D,
                                            &c6_00,&c12_00);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm256_mul_pd(r00,ewtabscale);
            ewitab           = _mm256_cvttpd_epi32(ewrt);
            eweps            = _mm256_sub_pd(ewrt,_mm256_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            ewtabV           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,2) );
            ewtabFn          = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,3) );
            GMX_MM256_FULLTRANSPOSE4_PD(ewtabF,ewtabD,ewtabV,ewtabFn);
            felec            = _mm256_add_pd(ewtabF,_mm256_mul_pd(eweps,ewtabD));
            velec            = _mm256_sub_pd(ewtabV,_mm256_mul_pd(_mm256_mul_pd(ewtabhalfspace,eweps),_mm256_add_pd(ewtabF,felec)));
            velec            = _mm256_mul_pd(qq00,_mm256_sub_pd(rinv00,velec));
            felec            = _mm256_mul_pd(_mm256_mul_pd(qq00,rinv00),_mm256_sub_pd(rinvsq00,felec));

            /* LENNARD-JONES DISPERSION/REPULSION */

            rinvsix          = _mm256_mul_pd(_mm256_mul_pd(rinvsq00,rinvsq00),rinvsq00);
            vvdw6            = _mm256_mul_pd(c6_00,rinvsix);
            vvdw12           = _mm256_mul_pd(c12_00,_mm256_mul_pd(rinvsix,rinvsix));
            vvdw             = _mm256_sub_pd( _mm256_mul_pd(vvdw12,one_twelfth) , _mm256_mul_pd(vvdw6,one_sixth) );
            fvdw             = _mm256_mul_pd(_mm256_sub_pd(vvdw12,vvdw6),rinvsq00);

            d                = _mm256_sub_pd(r00,rswitch);
            d                = _mm256_max_pd(d,_mm256_setzero_pd());
            d2               = _mm256_mul_pd(d,d);
            sw               = _mm256_add_pd(one,_mm256_mul_pd(d2,_mm256_mul_pd(d,_mm256_add_pd(swV3,_mm256_mul_pd(d,_mm256_add_pd(swV4,_mm256_mul_pd(d,swV5)))))));

            dsw              = _mm256_mul_pd(d2,_mm256_add_pd(swF2,_mm256_mul_pd(d,_mm256_add_pd(swF3,_mm256_mul_pd(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_pd( _mm256_mul_pd(felec,sw) , _mm256_mul_pd(rinv00,_mm256_mul_pd(velec,dsw)) );
            fvdw             = _mm256_sub_pd( _mm256_mul_pd(fvdw,sw) , _mm256_mul_pd(rinv00,_mm256_mul_pd(vvdw,dsw)) );
            cutoff_mask      = _mm256_cmp_pd(rsq00,rcutoff2,_CMP_LT_OQ);

            fscal            = _mm256_add_pd(felec,fvdw);

            fscal            = _mm256_and_pd(fscal,cutoff_mask);

            fscal            = _mm256_andnot_pd(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_pd(fscal,dx00);
            ty               = _mm256_mul_pd(fscal,dy00);
            tz               = _mm256_mul_pd(fscal,dz00);

            /* Update vectorial force */
            fix0             = _mm256_add_pd(fix0,tx);
            fiy0             = _mm256_add_pd(fiy0,ty);
            fiz0             = _mm256_add_pd(fiz0,tz);

            fjx0             = _mm256_add_pd(fjx0,tx);
            fjy0             = _mm256_add_pd(fjy0,ty);
            fjz0             = _mm256_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq10,rcutoff2))
            {

            r10              = _mm256_mul_pd(rsq10,rinv10);
            r10              = _mm256_andnot_pd(dummy_mask,r10);

            /* Compute parameters for interactions between i and j atoms */
            qq10             = _mm256_mul_pd(iq1,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm256_mul_pd(r10,ewtabscale);
            ewitab           = _mm256_cvttpd_epi32(ewrt);
            eweps            = _mm256_sub_pd(ewrt,_mm256_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            ewtabV           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,2) );
            ewtabFn          = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,3) );
            GMX_MM256_FULLTRANSPOSE4_PD(ewtabF,ewtabD,ewtabV,ewtabFn);
            felec            = _mm256_add_pd(ewtabF,_mm256_mul_pd(eweps,ewtabD));
            velec            = _mm256_sub_pd(ewtabV,_mm256_mul_pd(_mm256_mul_pd(ewtabhalfspace,eweps),_mm256_add_pd(ewtabF,felec)));
            velec            = _mm256_mul_pd(qq10,_mm256_sub_pd(rinv10,velec));
            felec            = _mm256_mul_pd(_mm256_mul_pd(qq10,rinv10),_mm256_sub_pd(rinvsq10,felec));

            d                = _mm256_sub_pd(r10,rswitch);
            d                = _mm256_max_pd(d,_mm256_setzero_pd());
            d2               = _mm256_mul_pd(d,d);
            sw               = _mm256_add_pd(one,_mm256_mul_pd(d2,_mm256_mul_pd(d,_mm256_add_pd(swV3,_mm256_mul_pd(d,_mm256_add_pd(swV4,_mm256_mul_pd(d,swV5)))))));

            dsw              = _mm256_mul_pd(d2,_mm256_add_pd(swF2,_mm256_mul_pd(d,_mm256_add_pd(swF3,_mm256_mul_pd(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_pd( _mm256_mul_pd(felec,sw) , _mm256_mul_pd(rinv10,_mm256_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_pd(rsq10,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_pd(fscal,cutoff_mask);

            fscal            = _mm256_andnot_pd(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_pd(fscal,dx10);
            ty               = _mm256_mul_pd(fscal,dy10);
            tz               = _mm256_mul_pd(fscal,dz10);

            /* Update vectorial force */
            fix1             = _mm256_add_pd(fix1,tx);
            fiy1             = _mm256_add_pd(fiy1,ty);
            fiz1             = _mm256_add_pd(fiz1,tz);

            fjx0             = _mm256_add_pd(fjx0,tx);
            fjy0             = _mm256_add_pd(fjy0,ty);
            fjz0             = _mm256_add_pd(fjz0,tz);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm256_any_lt(rsq20,rcutoff2))
            {

            r20              = _mm256_mul_pd(rsq20,rinv20);
            r20              = _mm256_andnot_pd(dummy_mask,r20);

            /* Compute parameters for interactions between i and j atoms */
            qq20             = _mm256_mul_pd(iq2,jq0);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm256_mul_pd(r20,ewtabscale);
            ewitab           = _mm256_cvttpd_epi32(ewrt);
            eweps            = _mm256_sub_pd(ewrt,_mm256_round_pd(ewrt, _MM_FROUND_FLOOR));
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            ewtabV           = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,2) );
            ewtabFn          = _mm256_load_pd( ewtab + _mm_extract_epi32(ewitab,3) );
            GMX_MM256_FULLTRANSPOSE4_PD(ewtabF,ewtabD,ewtabV,ewtabFn);
            felec            = _mm256_add_pd(ewtabF,_mm256_mul_pd(eweps,ewtabD));
            velec            = _mm256_sub_pd(ewtabV,_mm256_mul_pd(_mm256_mul_pd(ewtabhalfspace,eweps),_mm256_add_pd(ewtabF,felec)));
            velec            = _mm256_mul_pd(qq20,_mm256_sub_pd(rinv20,velec));
            felec            = _mm256_mul_pd(_mm256_mul_pd(qq20,rinv20),_mm256_sub_pd(rinvsq20,felec));

            d                = _mm256_sub_pd(r20,rswitch);
            d                = _mm256_max_pd(d,_mm256_setzero_pd());
            d2               = _mm256_mul_pd(d,d);
            sw               = _mm256_add_pd(one,_mm256_mul_pd(d2,_mm256_mul_pd(d,_mm256_add_pd(swV3,_mm256_mul_pd(d,_mm256_add_pd(swV4,_mm256_mul_pd(d,swV5)))))));

            dsw              = _mm256_mul_pd(d2,_mm256_add_pd(swF2,_mm256_mul_pd(d,_mm256_add_pd(swF3,_mm256_mul_pd(d,swF4)))));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm256_sub_pd( _mm256_mul_pd(felec,sw) , _mm256_mul_pd(rinv20,_mm256_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm256_cmp_pd(rsq20,rcutoff2,_CMP_LT_OQ);

            fscal            = felec;

            fscal            = _mm256_and_pd(fscal,cutoff_mask);

            fscal            = _mm256_andnot_pd(dummy_mask,fscal);

            /* Calculate temporary vectorial force */
            tx               = _mm256_mul_pd(fscal,dx20);
            ty               = _mm256_mul_pd(fscal,dy20);
            tz               = _mm256_mul_pd(fscal,dz20);

            /* Update vectorial force */
            fix2             = _mm256_add_pd(fix2,tx);
            fiy2             = _mm256_add_pd(fiy2,ty);
            fiz2             = _mm256_add_pd(fiz2,tz);

            fjx0             = _mm256_add_pd(fjx0,tx);
            fjy0             = _mm256_add_pd(fjy0,ty);
            fjz0             = _mm256_add_pd(fjz0,tz);

            }

            fjptrA             = (jnrlistA>=0) ? f+j_coord_offsetA : scratch;
            fjptrB             = (jnrlistB>=0) ? f+j_coord_offsetB : scratch;
            fjptrC             = (jnrlistC>=0) ? f+j_coord_offsetC : scratch;
            fjptrD             = (jnrlistD>=0) ? f+j_coord_offsetD : scratch;

            gmx_mm256_decrement_1rvec_4ptr_swizzle_pd(fjptrA,fjptrB,fjptrC,fjptrD,fjx0,fjy0,fjz0);

            /* Inner loop uses 207 flops */
        }

        /* End of innermost loop */

        gmx_mm256_update_iforce_3atom_swizzle_pd(fix0,fiy0,fiz0,fix1,fiy1,fiz1,fix2,fiy2,fiz2,
                                                 f+i_coord_offset,fshift+i_shift_offset);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 18 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_VDW_W3_F,outeriter*18 + inneriter*207);
}
