/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * This class exists to separate error messages from the code that
 * raises them, so that generating error messages and raising exceptions
 * does not have to clutter other code.
 */

#import <Grouch/GrouchException.h>
#import <Grouch/GrouchStringTool.h>

#import <Foundation/NSBundle.h>

@implementation GrouchException

+ (NSString*)memoryException
{
	return NSMallocException;
}

+ (void)raiseMemoryException
{
	NSString *s = [GrouchString getString:@"mem"];
	[[NSException exceptionWithName:[GrouchException memoryException]
		      reason:s userInfo:nil] raise];
}

+ (NSString*)socketException
{
	return @"OscarSocketException";
}

+ (void)raiseSocketExceptionForHost:(NSString*)host withReason:(NSString*)why
{
	NSString *s = [GrouchString getString:@"sock"];
	[[NSException exceptionWithName:[GrouchException socketException]
		      reason:[s createUserString:2,host,why] userInfo:nil]
		      raise];
}

@end
