/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * User structure.  This also involves UI code for IM windows.
 */

#import <Grouch/GrouchClient.h>
#import <AppKit/AppKit.h>

@class User;
@class ClientInstance;

// The user class.  We have one of these for every user we are even
// vaguely aware of.  Some of them have windows and some of them are
// sitting in "purgatory".
@interface User : NSObject <GrouchUser>
{
	NSString *name, *alias, *originalWindowTitle;
	ClientInstance *cli;

	BOOL online, lastOnlineStatus;
	time_t onlineSince, idle;
	BOOL away;
	int warn;

	NSWindow *window;
	NSScrollView *scroll;
	NSTextView *output;
	NSTextView *input;

	NSMutableDictionary *chatRooms;
}

// autoreleased
+ userWithName:(NSString*)name forClient:(ClientInstance*)c;
- initWithName:(NSString*)name forClient:(ClientInstance*)c;
- (void)dealloc;
- (void)setNick:(NSString*)str;
- (void)setAlias:(NSString*)alias;

- (void)createWindow;
- (void)message:(NSString*)str withFlags:(GrouchMessageFlags)flags;
- (void)append:(NSAttributedString*)str;
- (BOOL)mayRelease;
- (void)joinChat:(NSString*)chat;
- (void)partChat:(NSString*)chat;

- (NSString*)name;
- (NSString*)alias;
- (BOOL)online;
- (void)online:(BOOL)on;
- (time_t)onlineSince;
- (void)onlineSince:(time_t)t;
- (void)idle:(time_t)t;
- (void)away:(BOOL)a;
- (void)warn:(int)warn;
- (void)reloadData;

- (ClientInstance*)instance;

- (NSAttributedString*)attributedStringValue;
@end

